% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kms_operations.R
\name{kms_decrypt}
\alias{kms_decrypt}
\title{Decrypts ciphertext that was encrypted by a AWS KMS customer master key
(CMK) using any of the following operations: - Encrypt - GenerateDataKey
\itemize{
\item GenerateDataKeyPair - GenerateDataKeyWithoutPlaintext -
GenerateDataKeyPairWithoutPlaintext You can use this operation to
decrypt ciphertext that was encrypted under a symmetric or asymmetric
CMK
}}
\usage{
kms_decrypt(CiphertextBlob, EncryptionContext, GrantTokens, KeyId,
  EncryptionAlgorithm)
}
\arguments{
\item{CiphertextBlob}{[required] Ciphertext to be decrypted. The blob includes metadata.}

\item{EncryptionContext}{Specifies the encryption context to use when decrypting the data. An
encryption context is valid only for cryptographic operations with a
symmetric CMK. The standard asymmetric encryption algorithms that AWS
KMS uses do not support an encryption context.

An \emph{encryption context} is a collection of non-secret key-value pairs
that represents additional authenticated data. When you use an
encryption context to encrypt data, you must specify the same (an exact
case-sensitive match) encryption context to decrypt the data. An
encryption context is optional when encrypting with a symmetric CMK, but
it is highly recommended.

For more information, see \href{https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#encrypt_context}{Encryption Context}
in the \emph{AWS Key Management Service Developer Guide}.}

\item{GrantTokens}{A list of grant tokens.

For more information, see \href{https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#grant_token}{Grant Tokens}
in the \emph{AWS Key Management Service Developer Guide}.}

\item{KeyId}{Specifies the customer master key (CMK) that AWS KMS will use to decrypt
the ciphertext. Enter a key ID of the CMK that was used to encrypt the
ciphertext.

If you specify a \code{KeyId} value, the \code{Decrypt} operation succeeds only if
the specified CMK was used to encrypt the ciphertext.

This parameter is required only when the ciphertext was encrypted under
an asymmetric CMK. Otherwise, AWS KMS uses the metadata that it adds to
the ciphertext blob to determine which CMK was used to encrypt the
ciphertext. However, you can use this parameter to ensure that a
particular CMK (of any kind) is used to decrypt the ciphertext.

To specify a CMK, use its key ID, Amazon Resource Name (ARN), alias
name, or alias ARN. When using an alias name, prefix it with \code{"alias/"}.

For example:
\itemize{
\item Key ID: \verb{1234abcd-12ab-34cd-56ef-1234567890ab}
\item Key ARN:
\verb{arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab}
\item Alias name: \code{alias/ExampleAlias}
\item Alias ARN: \code{arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias}
}

To get the key ID and key ARN for a CMK, use ListKeys or DescribeKey. To
get the alias name and alias ARN, use ListAliases.}

\item{EncryptionAlgorithm}{Specifies the encryption algorithm that will be used to decrypt the
ciphertext. Specify the same algorithm that was used to encrypt the
data. If you specify a different algorithm, the \code{Decrypt} operation
fails.

This parameter is required only when the ciphertext was encrypted under
an asymmetric CMK. The default value, \code{SYMMETRIC_DEFAULT}, represents
the only supported algorithm that is valid for symmetric CMKs.}
}
\description{
Decrypts ciphertext that was encrypted by a AWS KMS customer master key
(CMK) using any of the following operations:
}
\details{
\itemize{
\item Encrypt
\item GenerateDataKey
\item GenerateDataKeyPair
\item GenerateDataKeyWithoutPlaintext
\item GenerateDataKeyPairWithoutPlaintext
}

You can use this operation to decrypt ciphertext that was encrypted
under a symmetric or asymmetric CMK. When the CMK is asymmetric, you
must specify the CMK and the encryption algorithm that was used to
encrypt the ciphertext. For information about symmetric and asymmetric
CMKs, see \href{https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html}{Using Symmetric and Asymmetric CMKs}
in the \emph{AWS Key Management Service Developer Guide}.

The Decrypt operation also decrypts ciphertext that was encrypted
outside of AWS KMS by the public key in an AWS KMS asymmetric CMK.
However, it cannot decrypt ciphertext produced by other libraries, such
as the \href{https://docs.aws.amazon.com/encryption-sdk/latest/developer-guide/}{AWS Encryption SDK}
or \href{https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingClientSideEncryption.html}{Amazon S3 client-side encryption}.
These libraries return a ciphertext format that is incompatible with AWS
KMS.

If the ciphertext was encrypted under a symmetric CMK, you do not need
to specify the CMK or the encryption algorithm. AWS KMS can get this
information from metadata that it adds to the symmetric ciphertext blob.
However, if you prefer, you can specify the \code{KeyId} to ensure that a
particular CMK is used to decrypt the ciphertext. If you specify a
different CMK than the one used to encrypt the ciphertext, the \code{Decrypt}
operation fails.

Whenever possible, use key policies to give users permission to call the
Decrypt operation on a particular CMK, instead of using IAM policies.
Otherwise, you might create an IAM user policy that gives the user
Decrypt permission on all CMKs. This user could decrypt ciphertext that
was encrypted by CMKs in other accounts if the key policy for the
cross-account CMK permits it. If you must use an IAM policy for
\code{Decrypt} permissions, limit the user to particular CMKs or particular
trusted accounts.

The CMK that you use for this operation must be in a compatible key
state. For details, see \href{https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html}{How Key State Affects Use of a Customer Master Key}
in the \emph{AWS Key Management Service Developer Guide}.
}
\section{Request syntax}{
\preformatted{svc$decrypt(
  CiphertextBlob = raw,
  EncryptionContext = list(
    "string"
  ),
  GrantTokens = list(
    "string"
  ),
  KeyId = "string",
  EncryptionAlgorithm = "SYMMETRIC_DEFAULT"|"RSAES_OAEP_SHA_1"|"RSAES_OAEP_SHA_256"
)
}
}

\examples{
# The following example decrypts data that was encrypted with a customer
# master key (CMK) in AWS KMS.
\dontrun{svc$decrypt(
  CiphertextBlob = "<binary data>"
)}

}
\keyword{internal}
