% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kms_operations.R
\name{kms_list_keys}
\alias{kms_list_keys}
\title{Gets a list of all customer master keys (CMKs) in the caller's AWS
account and Region}
\usage{
kms_list_keys(Limit, Marker)
}
\arguments{
\item{Limit}{Use this parameter to specify the maximum number of items to return.
When this value is present, AWS KMS does not return more than the
specified number of items, but it might return fewer.

This value is optional. If you include a value, it must be between 1 and
1000, inclusive. If you do not include a value, it defaults to 100.}

\item{Marker}{Use this parameter in a subsequent request after you receive a response
with truncated results. Set it to the value of \code{NextMarker} from the
truncated response you just received.}
}
\description{
Gets a list of all customer master keys (CMKs) in the caller\'s AWS
account and Region.
}
\section{Request syntax}{
\preformatted{svc$list_keys(
  Limit = 123,
  Marker = "string"
)
}
}

\examples{
# The following example lists CMKs.
\dontrun{svc$list_keys()}

}
\keyword{internal}
