% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/waf_operations.R
\name{waf_list_sql_injection_match_sets}
\alias{waf_list_sql_injection_match_sets}
\title{Returns an array of SqlInjectionMatchSet objects}
\usage{
waf_list_sql_injection_match_sets(NextMarker, Limit)
}
\arguments{
\item{NextMarker}{If you specify a value for \code{Limit} and you have more
SqlInjectionMatchSet objects than the value of \code{Limit}, AWS WAF returns
a \code{NextMarker} value in the response that allows you to list another
group of \code{SqlInjectionMatchSets}. For the second and subsequent
\code{ListSqlInjectionMatchSets} requests, specify the value of \code{NextMarker}
from the previous response to get information about another batch of
\code{SqlInjectionMatchSets}.}

\item{Limit}{Specifies the number of SqlInjectionMatchSet objects that you want AWS
WAF to return for this request. If you have more \code{SqlInjectionMatchSet}
objects than the number you specify for \code{Limit}, the response includes a
\code{NextMarker} value that you can use to get another batch of \code{Rules}.}
}
\description{
Returns an array of SqlInjectionMatchSet objects.
}
\section{Request syntax}{
\preformatted{svc$list_sql_injection_match_sets(
  NextMarker = "string",
  Limit = 123
)
}
}

\examples{
\dontrun{
# The following example returns an array of up to 100 SQL injection match
# sets.
svc$list_sql_injection_match_sets(
  Limit = 100L
)
}

}
\keyword{internal}
