% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wafregional_operations.R
\name{wafregional_get_web_acl_for_resource}
\alias{wafregional_get_web_acl_for_resource}
\title{Returns the web ACL for the specified resource, either an application
load balancer or Amazon API Gateway stage}
\usage{
wafregional_get_web_acl_for_resource(ResourceArn)
}
\arguments{
\item{ResourceArn}{[required] The ARN (Amazon Resource Name) of the resource for which to get the web
ACL, either an application load balancer or Amazon API Gateway stage.

The ARN should be in one of the following formats:
\itemize{
\item For an Application Load Balancer:
\verb{arn:aws:elasticloadbalancing:<i>region</i>:<i>account-id</i>:loadbalancer/app/<i>load-balancer-name</i>/<i>load-balancer-id</i> }
\item For an Amazon API Gateway stage:
\verb{arn:aws:apigateway:<i>region</i>::/restapis/<i>api-id</i>/stages/<i>stage-name</i> }
}}
}
\description{
Returns the web ACL for the specified resource, either an application
load balancer or Amazon API Gateway stage.
}
\section{Request syntax}{
\preformatted{svc$get_web_acl_for_resource(
  ResourceArn = "string"
)
}
}

\keyword{internal}
