# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config
NULL

#' AWS CloudHSM V2
#'
#' @description
#' For more information about AWS CloudHSM, see [AWS
#' CloudHSM](https://aws.amazon.com/cloudhsm/) and the [AWS CloudHSM User
#' Guide](https://docs.aws.amazon.com/cloudhsm/latest/userguide/).
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#' \itemize{
#' \item{\strong{access_key_id}:} {AWS access key ID}
#' \item{\strong{secret_access_key}:} {AWS secret access key}
#' \item{\strong{session_token}:} {AWS temporary session token}
#' \item{\strong{profile}:} {The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}:} {Set anonymous credentials.}
#' \item{\strong{endpoint}:} {The complete URL to use for the constructed client.}
#' \item{\strong{region}:} {The AWS Region used in instantiating the client.}
#' \item{\strong{close_connection}:} {Immediately close all HTTP connections.}
#' \item{\strong{timeout}:} {The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
#' \item{\strong{s3_force_path_style}:} {Set this to `true` to force the request to use path-style addressing, i.e., `http://s3.amazonaws.com/BUCKET/KEY`.}
#' }
#'
#' @section Service syntax:
#' ```
#' svc <- cloudhsmv2(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string",
#'       anonymous = "logical"
#'     ),
#'     endpoint = "string",
#'     region = "string",
#'     close_connection = "logical",
#'     timeout = "numeric",
#'     s3_force_path_style = "logical"
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' svc <- cloudhsmv2()
#' svc$copy_backup_to_region(
#'   Foo = 123
#' )
#' }
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=cloudhsmv2_copy_backup_to_region]{copy_backup_to_region} \tab Copy an AWS CloudHSM cluster backup to a different region\cr
#'  \link[=cloudhsmv2_create_cluster]{create_cluster} \tab Creates a new AWS CloudHSM cluster\cr
#'  \link[=cloudhsmv2_create_hsm]{create_hsm} \tab Creates a new hardware security module (HSM) in the specified AWS CloudHSM cluster\cr
#'  \link[=cloudhsmv2_delete_backup]{delete_backup} \tab Deletes a specified AWS CloudHSM backup\cr
#'  \link[=cloudhsmv2_delete_cluster]{delete_cluster} \tab Deletes the specified AWS CloudHSM cluster\cr
#'  \link[=cloudhsmv2_delete_hsm]{delete_hsm} \tab Deletes the specified HSM\cr
#'  \link[=cloudhsmv2_describe_backups]{describe_backups} \tab Gets information about backups of AWS CloudHSM clusters\cr
#'  \link[=cloudhsmv2_describe_clusters]{describe_clusters} \tab Gets information about AWS CloudHSM clusters\cr
#'  \link[=cloudhsmv2_initialize_cluster]{initialize_cluster} \tab Claims an AWS CloudHSM cluster by submitting the cluster certificate issued by your issuing certificate authority (CA) and the CA's root certificate\cr
#'  \link[=cloudhsmv2_list_tags]{list_tags} \tab Gets a list of tags for the specified AWS CloudHSM cluster\cr
#'  \link[=cloudhsmv2_modify_backup_attributes]{modify_backup_attributes} \tab Modifies attributes for AWS CloudHSM backup\cr
#'  \link[=cloudhsmv2_modify_cluster]{modify_cluster} \tab Modifies AWS CloudHSM cluster\cr
#'  \link[=cloudhsmv2_restore_backup]{restore_backup} \tab Restores a specified AWS CloudHSM backup that is in the PENDING_DELETION state\cr
#'  \link[=cloudhsmv2_tag_resource]{tag_resource} \tab Adds or overwrites one or more tags for the specified AWS CloudHSM cluster\cr
#'  \link[=cloudhsmv2_untag_resource]{untag_resource} \tab Removes the specified tag or tags from the specified AWS CloudHSM cluster
#' }
#'
#' @return
#' A client for the service. You can call the service's operations using
#' syntax like `svc$operation(...)`, where `svc` is the name you've assigned
#' to the client. The available operations are listed in the
#' Operations section.
#'
#' @rdname cloudhsmv2
#' @export
cloudhsmv2 <- function(config = list()) {
  svc <- .cloudhsmv2$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.cloudhsmv2 <- list()

.cloudhsmv2$operations <- list()

.cloudhsmv2$metadata <- list(
  service_name = "cloudhsmv2",
  endpoints = list("*" = list(endpoint = "cloudhsmv2.{region}.amazonaws.com", global = FALSE), "cn-*" = list(endpoint = "cloudhsmv2.{region}.amazonaws.com.cn", global = FALSE), "us-iso-*" = list(endpoint = "cloudhsmv2.{region}.c2s.ic.gov", global = FALSE), "us-isob-*" = list(endpoint = "cloudhsmv2.{region}.sc2s.sgov.gov", global = FALSE)),
  service_id = "CloudHSM V2",
  api_version = "2017-04-28",
  signing_name = "cloudhsm",
  json_version = "1.1",
  target_prefix = "BaldrApiService"
)

.cloudhsmv2$service <- function(config = list()) {
  handlers <- new_handlers("jsonrpc", "v4")
  new_service(.cloudhsmv2$metadata, handlers, config)
}
