# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include kms_service.R
NULL

#' Cancels the deletion of a KMS key
#'
#' @description
#' Cancels the deletion of a KMS key. When this operation succeeds, the key state of the KMS key is `Disabled`. To enable the KMS key, use [`enable_key`][kms_enable_key].
#'
#' See [https://paws-r.github.io/docs/kms/cancel_key_deletion.html](https://paws-r.github.io/docs/kms/cancel_key_deletion.html) for full documentation.
#'
#' @param KeyId &#91;required&#93; Identifies the KMS key whose deletion is being canceled.
#' 
#' Specify the key ID or key ARN of the KMS key.
#' 
#' For example:
#' 
#' -   Key ID: `1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' -   Key ARN:
#'     `arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' To get the key ID and key ARN for a KMS key, use
#' [`list_keys`][kms_list_keys] or [`describe_key`][kms_describe_key].
#'
#' @keywords internal
#'
#' @rdname kms_cancel_key_deletion
kms_cancel_key_deletion <- function(KeyId) {
  op <- new_operation(
    name = "CancelKeyDeletion",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kms$cancel_key_deletion_input(KeyId = KeyId)
  output <- .kms$cancel_key_deletion_output()
  config <- get_config()
  svc <- .kms$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kms$operations$cancel_key_deletion <- kms_cancel_key_deletion

#' Connects or reconnects a custom key store to its associated CloudHSM
#' cluster
#'
#' @description
#' Connects or reconnects a [custom key store](https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html) to its associated CloudHSM cluster.
#'
#' See [https://paws-r.github.io/docs/kms/connect_custom_key_store.html](https://paws-r.github.io/docs/kms/connect_custom_key_store.html) for full documentation.
#'
#' @param CustomKeyStoreId &#91;required&#93; Enter the key store ID of the custom key store that you want to connect.
#' To find the ID of a custom key store, use the
#' [`describe_custom_key_stores`][kms_describe_custom_key_stores]
#' operation.
#'
#' @keywords internal
#'
#' @rdname kms_connect_custom_key_store
kms_connect_custom_key_store <- function(CustomKeyStoreId) {
  op <- new_operation(
    name = "ConnectCustomKeyStore",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kms$connect_custom_key_store_input(CustomKeyStoreId = CustomKeyStoreId)
  output <- .kms$connect_custom_key_store_output()
  config <- get_config()
  svc <- .kms$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kms$operations$connect_custom_key_store <- kms_connect_custom_key_store

#' Creates a friendly name for a KMS key
#'
#' @description
#' Creates a friendly name for a KMS key.
#'
#' See [https://paws-r.github.io/docs/kms/create_alias.html](https://paws-r.github.io/docs/kms/create_alias.html) for full documentation.
#'
#' @param AliasName &#91;required&#93; Specifies the alias name. This value must begin with `alias/` followed
#' by a name, such as `alias/ExampleAlias`.
#' 
#' The `AliasName` value must be string of 1-256 characters. It can contain
#' only alphanumeric characters, forward slashes (/), underscores (_), and
#' dashes (-). The alias name cannot begin with `alias/aws/`. The
#' `alias/aws/` prefix is reserved for [Amazon Web Services managed
#' keys](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#aws-managed-cmk).
#' @param TargetKeyId &#91;required&#93; Associates the alias with the specified [customer managed
#' key](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#customer-cmk).
#' The KMS key must be in the same Amazon Web Services Region.
#' 
#' A valid key ID is required. If you supply a null or empty string value,
#' this operation returns an error.
#' 
#' For help finding the key ID and ARN, see [Finding the Key ID and
#' ARN](https://docs.aws.amazon.com/kms/latest/developerguide/viewing-keys.html#find-cmk-id-arn)
#' in the *Key Management Service Developer Guide* .
#' 
#' Specify the key ID or key ARN of the KMS key.
#' 
#' For example:
#' 
#' -   Key ID: `1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' -   Key ARN:
#'     `arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' To get the key ID and key ARN for a KMS key, use
#' [`list_keys`][kms_list_keys] or [`describe_key`][kms_describe_key].
#'
#' @keywords internal
#'
#' @rdname kms_create_alias
kms_create_alias <- function(AliasName, TargetKeyId) {
  op <- new_operation(
    name = "CreateAlias",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kms$create_alias_input(AliasName = AliasName, TargetKeyId = TargetKeyId)
  output <- .kms$create_alias_output()
  config <- get_config()
  svc <- .kms$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kms$operations$create_alias <- kms_create_alias

#' Creates a custom key store that is associated with an CloudHSM cluster
#' that you own and manage
#'
#' @description
#' Creates a [custom key store](https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html) that is associated with an [CloudHSM cluster](https://docs.aws.amazon.com/cloudhsm/latest/userguide/clusters.html) that you own and manage.
#'
#' See [https://paws-r.github.io/docs/kms/create_custom_key_store.html](https://paws-r.github.io/docs/kms/create_custom_key_store.html) for full documentation.
#'
#' @param CustomKeyStoreName &#91;required&#93; Specifies a friendly name for the custom key store. The name must be
#' unique in your Amazon Web Services account.
#' @param CloudHsmClusterId Identifies the CloudHSM cluster for the custom key store. Enter the
#' cluster ID of any active CloudHSM cluster that is not already associated
#' with a custom key store. To find the cluster ID, use the
#' [DescribeClusters](https://docs.aws.amazon.com/cloudhsm/latest/APIReference/API_DescribeClusters.html)
#' operation.
#' @param TrustAnchorCertificate Enter the content of the trust anchor certificate for the cluster. This
#' is the content of the `customerCA.crt` file that you created when you
#' [initialized the
#' cluster](https://docs.aws.amazon.com/cloudhsm/latest/userguide/initialize-cluster.html).
#' @param KeyStorePassword Enter the password of the [`kmsuser` crypto user (CU)
#' account](https://docs.aws.amazon.com/kms/latest/developerguide/#concept-kmsuser)
#' in the specified CloudHSM cluster. KMS logs into the cluster as this
#' user to manage key material on your behalf.
#' 
#' The password must be a string of 7 to 32 characters. Its value is case
#' sensitive.
#' 
#' This parameter tells KMS the `kmsuser` account password; it does not
#' change the password in the CloudHSM cluster.
#'
#' @keywords internal
#'
#' @rdname kms_create_custom_key_store
kms_create_custom_key_store <- function(CustomKeyStoreName, CloudHsmClusterId = NULL, TrustAnchorCertificate = NULL, KeyStorePassword = NULL) {
  op <- new_operation(
    name = "CreateCustomKeyStore",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kms$create_custom_key_store_input(CustomKeyStoreName = CustomKeyStoreName, CloudHsmClusterId = CloudHsmClusterId, TrustAnchorCertificate = TrustAnchorCertificate, KeyStorePassword = KeyStorePassword)
  output <- .kms$create_custom_key_store_output()
  config <- get_config()
  svc <- .kms$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kms$operations$create_custom_key_store <- kms_create_custom_key_store

#' Adds a grant to a KMS key
#'
#' @description
#' Adds a grant to a KMS key.
#'
#' See [https://paws-r.github.io/docs/kms/create_grant.html](https://paws-r.github.io/docs/kms/create_grant.html) for full documentation.
#'
#' @param KeyId &#91;required&#93; Identifies the KMS key for the grant. The grant gives principals
#' permission to use this KMS key.
#' 
#' Specify the key ID or key ARN of the KMS key. To specify a KMS key in a
#' different Amazon Web Services account, you must use the key ARN.
#' 
#' For example:
#' 
#' -   Key ID: `1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' -   Key ARN:
#'     `arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' To get the key ID and key ARN for a KMS key, use
#' [`list_keys`][kms_list_keys] or [`describe_key`][kms_describe_key].
#' @param GranteePrincipal &#91;required&#93; The identity that gets the permissions specified in the grant.
#' 
#' To specify the principal, use the [Amazon Resource Name
#' (ARN)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
#' of an Amazon Web Services principal. Valid Amazon Web Services
#' principals include Amazon Web Services accounts (root), IAM users, IAM
#' roles, federated users, and assumed role users. For examples of the ARN
#' syntax to use for specifying a principal, see [Amazon Web Services
#' Identity and Access Management
#' (IAM)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-iam)
#' in the Example ARNs section of the *Amazon Web Services General
#' Reference*.
#' @param RetiringPrincipal The principal that has permission to use the
#' [`retire_grant`][kms_retire_grant] operation to retire the grant.
#' 
#' To specify the principal, use the [Amazon Resource Name
#' (ARN)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
#' of an Amazon Web Services principal. Valid Amazon Web Services
#' principals include Amazon Web Services accounts (root), IAM users,
#' federated users, and assumed role users. For examples of the ARN syntax
#' to use for specifying a principal, see [Amazon Web Services Identity and
#' Access Management
#' (IAM)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-iam)
#' in the Example ARNs section of the *Amazon Web Services General
#' Reference*.
#' 
#' The grant determines the retiring principal. Other principals might have
#' permission to retire the grant or revoke the grant. For details, see
#' [`revoke_grant`][kms_revoke_grant] and [Retiring and revoking
#' grants](https://docs.aws.amazon.com/kms/latest/developerguide/grant-manage.html#grant-delete)
#' in the *Key Management Service Developer Guide*.
#' @param Operations &#91;required&#93; A list of operations that the grant permits.
#' 
#' This list must include only operations that are permitted in a grant.
#' Also, the operation must be supported on the KMS key. For example, you
#' cannot create a grant for a symmetric encryption KMS key that allows the
#' [`sign`][kms_sign] operation, or a grant for an asymmetric KMS key that
#' allows the [`generate_data_key`][kms_generate_data_key] operation. If
#' you try, KMS returns a `ValidationError` exception. For details, see
#' [Grant
#' operations](https://docs.aws.amazon.com/kms/latest/developerguide/grants.html#terms-grant-operations)
#' in the *Key Management Service Developer Guide*.
#' @param Constraints Specifies a grant constraint.
#' 
#' KMS supports the `EncryptionContextEquals` and `EncryptionContextSubset`
#' grant constraints. Each constraint value can include up to 8 encryption
#' context pairs. The encryption context value in each constraint cannot
#' exceed 384 characters. For information about grant constraints, see
#' [Using grant
#' constraints](https://docs.aws.amazon.com/kms/latest/developerguide/create-grant-overview.html#grant-constraints)
#' in the *Key Management Service Developer Guide*. For more information
#' about encryption context, see [Encryption
#' context](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#encrypt_context)
#' in the *Key Management Service Developer Guide* .
#' 
#' The encryption context grant constraints allow the permissions in the
#' grant only when the encryption context in the request matches
#' (`EncryptionContextEquals`) or includes (`EncryptionContextSubset`) the
#' encryption context specified in this structure.
#' 
#' The encryption context grant constraints are supported only on [grant
#' operations](https://docs.aws.amazon.com/kms/latest/developerguide/grants.html#terms-grant-operations)
#' that include an `EncryptionContext` parameter, such as cryptographic
#' operations on symmetric encryption KMS keys. Grants with grant
#' constraints can include the [`describe_key`][kms_describe_key] and
#' [`retire_grant`][kms_retire_grant] operations, but the constraint
#' doesn't apply to these operations. If a grant with a grant constraint
#' includes the [`create_grant`][kms_create_grant] operation, the
#' constraint requires that any grants created with the
#' [`create_grant`][kms_create_grant] permission have an equally strict or
#' stricter encryption context constraint.
#' 
#' You cannot use an encryption context grant constraint for cryptographic
#' operations with asymmetric KMS keys or HMAC KMS keys. These keys don't
#' support an encryption context.
#' @param GrantTokens A list of grant tokens.
#' 
#' Use a grant token when your permission to call this operation comes from
#' a new grant that has not yet achieved *eventual consistency*. For more
#' information, see [Grant
#' token](https://docs.aws.amazon.com/kms/latest/developerguide/grants.html#grant_token)
#' and [Using a grant
#' token](https://docs.aws.amazon.com/kms/latest/developerguide/grant-manage.html#using-grant-token)
#' in the *Key Management Service Developer Guide*.
#' @param Name A friendly name for the grant. Use this value to prevent the unintended
#' creation of duplicate grants when retrying this request.
#' 
#' When this value is absent, all [`create_grant`][kms_create_grant]
#' requests result in a new grant with a unique `GrantId` even if all the
#' supplied parameters are identical. This can result in unintended
#' duplicates when you retry the [`create_grant`][kms_create_grant]
#' request.
#' 
#' When this value is present, you can retry a
#' [`create_grant`][kms_create_grant] request with identical parameters; if
#' the grant already exists, the original `GrantId` is returned without
#' creating a new grant. Note that the returned grant token is unique with
#' every [`create_grant`][kms_create_grant] request, even when a duplicate
#' `GrantId` is returned. All grant tokens for the same grant ID can be
#' used interchangeably.
#'
#' @keywords internal
#'
#' @rdname kms_create_grant
kms_create_grant <- function(KeyId, GranteePrincipal, RetiringPrincipal = NULL, Operations, Constraints = NULL, GrantTokens = NULL, Name = NULL) {
  op <- new_operation(
    name = "CreateGrant",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kms$create_grant_input(KeyId = KeyId, GranteePrincipal = GranteePrincipal, RetiringPrincipal = RetiringPrincipal, Operations = Operations, Constraints = Constraints, GrantTokens = GrantTokens, Name = Name)
  output <- .kms$create_grant_output()
  config <- get_config()
  svc <- .kms$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kms$operations$create_grant <- kms_create_grant

#' Creates a unique customer managed KMS key in your Amazon Web Services
#' account and Region
#'
#' @description
#' Creates a unique customer managed [KMS key](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#kms-keys) in your Amazon Web Services account and Region.
#'
#' See [https://paws-r.github.io/docs/kms/create_key.html](https://paws-r.github.io/docs/kms/create_key.html) for full documentation.
#'
#' @param Policy The key policy to attach to the KMS key. If you do not specify a key
#' policy, KMS attaches a default key policy to the KMS key. For more
#' information, see [Default key
#' policy](https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default)
#' in the *Key Management Service Developer Guide*.
#' 
#' If you provide a key policy, it must meet the following criteria:
#' 
#' -   If you don't set `BypassPolicyLockoutSafetyCheck` to `True`, the key
#'     policy must allow the principal that is making the
#'     [`create_key`][kms_create_key] request to make a subsequent
#'     [`put_key_policy`][kms_put_key_policy] request on the KMS key. This
#'     reduces the risk that the KMS key becomes unmanageable. For more
#'     information, refer to the scenario in the [Default Key
#'     Policy](https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default-allow-root-enable-iam)
#'     section of the *Key Management Service Developer Guide* .
#' 
#' -   Each statement in the key policy must contain one or more
#'     principals. The principals in the key policy must exist and be
#'     visible to KMS. When you create a new Amazon Web Services principal
#'     (for example, an IAM user or role), you might need to enforce a
#'     delay before including the new principal in a key policy because the
#'     new principal might not be immediately visible to KMS. For more
#'     information, see [Changes that I make are not always immediately
#'     visible](https://docs.aws.amazon.com/IAM/latest/UserGuide/troubleshoot_general.html#troubleshoot_general_eventual-consistency)
#'     in the *Amazon Web Services Identity and Access Management User
#'     Guide*.
#' 
#' A key policy document can include only the following characters:
#' 
#' -   Printable ASCII characters from the space character (``U+0020``)
#'     through the end of the ASCII character range.
#' 
#' -   Printable characters in the Basic Latin and Latin-1 Supplement
#'     character set (through ``U+00FF``).
#' 
#' -   The tab (``U+0009``), line feed (``U+000A``), and carriage return
#'     (``U+000D``) special characters
#' 
#' For information about key policies, see [Key policies in
#' KMS](https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html)
#' in the *Key Management Service Developer Guide*. For help writing and
#' formatting a JSON policy document, see the [IAM JSON Policy
#' Reference](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies.html)
#' in the *Identity and Access Management User Guide* .
#' @param Description A description of the KMS key.
#' 
#' Use a description that helps you decide whether the KMS key is
#' appropriate for a task. The default value is an empty string (no
#' description).
#' 
#' To set or change the description after the key is created, use
#' [`update_key_description`][kms_update_key_description].
#' @param KeyUsage Determines the [cryptographic
#' operations](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#cryptographic-operations)
#' for which you can use the KMS key. The default value is
#' `ENCRYPT_DECRYPT`. This parameter is optional when you are creating a
#' symmetric encryption KMS key; otherwise, it is required. You can't
#' change the `KeyUsage` value after the KMS key is created.
#' 
#' Select only one valid value.
#' 
#' -   For symmetric encryption KMS keys, omit the parameter or specify
#'     `ENCRYPT_DECRYPT`.
#' 
#' -   For HMAC KMS keys (symmetric), specify `GENERATE_VERIFY_MAC`.
#' 
#' -   For asymmetric KMS keys with RSA key material, specify
#'     `ENCRYPT_DECRYPT` or `SIGN_VERIFY`.
#' 
#' -   For asymmetric KMS keys with ECC key material, specify
#'     `SIGN_VERIFY`.
#' 
#' -   For asymmetric KMS keys with SM2 key material (China Regions only),
#'     specify `ENCRYPT_DECRYPT` or `SIGN_VERIFY`.
#' @param CustomerMasterKeySpec Instead, use the `KeySpec` parameter.
#' 
#' The `KeySpec` and `CustomerMasterKeySpec` parameters work the same way.
#' Only the names differ. We recommend that you use `KeySpec` parameter in
#' your code. However, to avoid breaking changes, KMS will support both
#' parameters.
#' @param KeySpec Specifies the type of KMS key to create. The default value,
#' `SYMMETRIC_DEFAULT`, creates a KMS key with a 256-bit AES-GCM key that
#' is used for encryption and decryption, except in China Regions, where it
#' creates a 128-bit symmetric key that uses SM4 encryption. For help
#' choosing a key spec for your KMS key, see [Choosing a KMS key
#' type](https://docs.aws.amazon.com/kms/latest/developerguide/key-types.html#symm-asymm-choose)
#' in the *Key Management Service Developer Guide* .
#' 
#' The `KeySpec` determines whether the KMS key contains a symmetric key or
#' an asymmetric key pair. It also determines the cryptographic algorithms
#' that the KMS key supports. You can't change the `KeySpec` after the KMS
#' key is created. To further restrict the algorithms that can be used with
#' the KMS key, use a condition key in its key policy or IAM policy. For
#' more information, see
#' [kms:EncryptionAlgorithm](https://docs.aws.amazon.com/kms/latest/developerguide/policy-conditions.html#conditions-kms-encryption-algorithm),
#' [kms:MacAlgorithm](https://docs.aws.amazon.com/kms/latest/developerguide/policy-conditions.html#conditions-kms-mac-algorithm)
#' or [kms:Signing
#' Algorithm](https://docs.aws.amazon.com/kms/latest/developerguide/policy-conditions.html#conditions-kms-signing-algorithm)
#' in the *Key Management Service Developer Guide* .
#' 
#' [Amazon Web Services services that are integrated with
#' KMS](https://aws.amazon.com/kms/features/#AWS_Service_Integration) use
#' symmetric encryption KMS keys to protect your data. These services do
#' not support asymmetric KMS keys or HMAC KMS keys.
#' 
#' KMS supports the following key specs for KMS keys:
#' 
#' -   Symmetric encryption key (default)
#' 
#'     -   `SYMMETRIC_DEFAULT`
#' 
#' -   HMAC keys (symmetric)
#' 
#'     -   `HMAC_224`
#' 
#'     -   `HMAC_256`
#' 
#'     -   `HMAC_384`
#' 
#'     -   `HMAC_512`
#' 
#' -   Asymmetric RSA key pairs
#' 
#'     -   `RSA_2048`
#' 
#'     -   `RSA_3072`
#' 
#'     -   `RSA_4096`
#' 
#' -   Asymmetric NIST-recommended elliptic curve key pairs
#' 
#'     -   `ECC_NIST_P256` (secp256r1)
#' 
#'     -   `ECC_NIST_P384` (secp384r1)
#' 
#'     -   `ECC_NIST_P521` (secp521r1)
#' 
#' -   Other asymmetric elliptic curve key pairs
#' 
#'     -   `ECC_SECG_P256K1` (secp256k1), commonly used for
#'         cryptocurrencies.
#' 
#' -   SM2 key pairs (China Regions only)
#' 
#'     -   `SM2`
#' @param Origin The source of the key material for the KMS key. You cannot change the
#' origin after you create the KMS key. The default is `AWS_KMS`, which
#' means that KMS creates the key material.
#' 
#' To create a KMS key with no key material (for imported key material),
#' set the value to `EXTERNAL`. For more information about importing key
#' material into KMS, see [Importing Key
#' Material](https://docs.aws.amazon.com/kms/latest/developerguide/importing-keys.html)
#' in the *Key Management Service Developer Guide*. This value is valid
#' only for symmetric encryption KMS keys.
#' 
#' To create a KMS key in an KMS [custom key
#' store](https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html)
#' and create its key material in the associated CloudHSM cluster, set this
#' value to `AWS_CLOUDHSM`. You must also use the `CustomKeyStoreId`
#' parameter to identify the custom key store. This value is valid only for
#' symmetric encryption KMS keys.
#' @param CustomKeyStoreId Creates the KMS key in the specified [custom key
#' store](https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html)
#' and the key material in its associated CloudHSM cluster. To create a KMS
#' key in a custom key store, you must also specify the `Origin` parameter
#' with a value of `AWS_CLOUDHSM`. The CloudHSM cluster that is associated
#' with the custom key store must have at least two active HSMs, each in a
#' different Availability Zone in the Region.
#' 
#' This parameter is valid only for symmetric encryption KMS keys in a
#' single Region. You cannot create any other type of KMS key in a custom
#' key store.
#' 
#' To find the ID of a custom key store, use the
#' [`describe_custom_key_stores`][kms_describe_custom_key_stores]
#' operation.
#' 
#' The response includes the custom key store ID and the ID of the CloudHSM
#' cluster.
#' 
#' This operation is part of the [custom key store
#' feature](https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html)
#' feature in KMS, which combines the convenience and extensive integration
#' of KMS with the isolation and control of a single-tenant key store.
#' @param BypassPolicyLockoutSafetyCheck A flag to indicate whether to bypass the key policy lockout safety
#' check.
#' 
#' Setting this value to true increases the risk that the KMS key becomes
#' unmanageable. Do not set this value to true indiscriminately.
#' 
#' For more information, refer to the scenario in the [Default Key
#' Policy](https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default-allow-root-enable-iam)
#' section in the *Key Management Service Developer Guide* .
#' 
#' Use this parameter only when you include a policy in the request and you
#' intend to prevent the principal that is making the request from making a
#' subsequent [`put_key_policy`][kms_put_key_policy] request on the KMS
#' key.
#' 
#' The default value is false.
#' @param Tags Assigns one or more tags to the KMS key. Use this parameter to tag the
#' KMS key when it is created. To tag an existing KMS key, use the
#' [`tag_resource`][kms_tag_resource] operation.
#' 
#' Tagging or untagging a KMS key can allow or deny permission to the KMS
#' key. For details, see [ABAC in
#' KMS](https://docs.aws.amazon.com/kms/latest/developerguide/abac.html) in
#' the *Key Management Service Developer Guide*.
#' 
#' To use this parameter, you must have
#' [kms:TagResource](https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html)
#' permission in an IAM policy.
#' 
#' Each tag consists of a tag key and a tag value. Both the tag key and the
#' tag value are required, but the tag value can be an empty (null) string.
#' You cannot have more than one tag on a KMS key with the same tag key. If
#' you specify an existing tag key with a different tag value, KMS replaces
#' the current tag value with the specified one.
#' 
#' When you add tags to an Amazon Web Services resource, Amazon Web
#' Services generates a cost allocation report with usage and costs
#' aggregated by tags. Tags can also be used to control access to a KMS
#' key. For details, see [Tagging
#' Keys](https://docs.aws.amazon.com/kms/latest/developerguide/tagging-keys.html).
#' @param MultiRegion Creates a multi-Region primary key that you can replicate into other
#' Amazon Web Services Regions. You cannot change this value after you
#' create the KMS key.
#' 
#' For a multi-Region key, set this parameter to `True`. For a
#' single-Region KMS key, omit this parameter or set it to `False`. The
#' default value is `False`.
#' 
#' This operation supports *multi-Region keys*, an KMS feature that lets
#' you create multiple interoperable KMS keys in different Amazon Web
#' Services Regions. Because these KMS keys have the same key ID, key
#' material, and other metadata, you can use them interchangeably to
#' encrypt data in one Amazon Web Services Region and decrypt it in a
#' different Amazon Web Services Region without re-encrypting the data or
#' making a cross-Region call. For more information about multi-Region
#' keys, see [Multi-Region keys in
#' KMS](https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-overview.html)
#' in the *Key Management Service Developer Guide*.
#' 
#' This value creates a *primary key*, not a replica. To create a *replica
#' key*, use the [`replicate_key`][kms_replicate_key] operation.
#' 
#' You can create a multi-Region version of a symmetric encryption KMS key,
#' an HMAC KMS key, an asymmetric KMS key, or a KMS key with imported key
#' material. However, you cannot create a multi-Region key in a custom key
#' store.
#'
#' @keywords internal
#'
#' @rdname kms_create_key
kms_create_key <- function(Policy = NULL, Description = NULL, KeyUsage = NULL, CustomerMasterKeySpec = NULL, KeySpec = NULL, Origin = NULL, CustomKeyStoreId = NULL, BypassPolicyLockoutSafetyCheck = NULL, Tags = NULL, MultiRegion = NULL) {
  op <- new_operation(
    name = "CreateKey",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kms$create_key_input(Policy = Policy, Description = Description, KeyUsage = KeyUsage, CustomerMasterKeySpec = CustomerMasterKeySpec, KeySpec = KeySpec, Origin = Origin, CustomKeyStoreId = CustomKeyStoreId, BypassPolicyLockoutSafetyCheck = BypassPolicyLockoutSafetyCheck, Tags = Tags, MultiRegion = MultiRegion)
  output <- .kms$create_key_output()
  config <- get_config()
  svc <- .kms$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kms$operations$create_key <- kms_create_key

#' Decrypts ciphertext that was encrypted by a KMS key using any of the
#' following operations:
#'
#' @description
#' Decrypts ciphertext that was encrypted by a KMS key using any of the following operations:
#'
#' See [https://paws-r.github.io/docs/kms/decrypt.html](https://paws-r.github.io/docs/kms/decrypt.html) for full documentation.
#'
#' @param CiphertextBlob &#91;required&#93; Ciphertext to be decrypted. The blob includes metadata.
#' @param EncryptionContext Specifies the encryption context to use when decrypting the data. An
#' encryption context is valid only for [cryptographic
#' operations](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#cryptographic-operations)
#' with a symmetric encryption KMS key. The standard asymmetric encryption
#' algorithms and HMAC algorithms that KMS uses do not support an
#' encryption context.
#' 
#' An *encryption context* is a collection of non-secret key-value pairs
#' that represent additional authenticated data. When you use an encryption
#' context to encrypt data, you must specify the same (an exact
#' case-sensitive match) encryption context to decrypt the data. An
#' encryption context is supported only on operations with symmetric
#' encryption KMS keys. On operations with symmetric encryption KMS keys,
#' an encryption context is optional, but it is strongly recommended.
#' 
#' For more information, see [Encryption
#' context](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#encrypt_context)
#' in the *Key Management Service Developer Guide*.
#' @param GrantTokens A list of grant tokens.
#' 
#' Use a grant token when your permission to call this operation comes from
#' a new grant that has not yet achieved *eventual consistency*. For more
#' information, see [Grant
#' token](https://docs.aws.amazon.com/kms/latest/developerguide/grants.html#grant_token)
#' and [Using a grant
#' token](https://docs.aws.amazon.com/kms/latest/developerguide/grant-manage.html#using-grant-token)
#' in the *Key Management Service Developer Guide*.
#' @param KeyId Specifies the KMS key that KMS uses to decrypt the ciphertext.
#' 
#' Enter a key ID of the KMS key that was used to encrypt the ciphertext.
#' If you identify a different KMS key, the [`decrypt`][kms_decrypt]
#' operation throws an `IncorrectKeyException`.
#' 
#' This parameter is required only when the ciphertext was encrypted under
#' an asymmetric KMS key. If you used a symmetric encryption KMS key, KMS
#' can get the KMS key from metadata that it adds to the symmetric
#' ciphertext blob. However, it is always recommended as a best practice.
#' This practice ensures that you use the KMS key that you intend.
#' 
#' To specify a KMS key, use its key ID, key ARN, alias name, or alias ARN.
#' When using an alias name, prefix it with `"alias/"`. To specify a KMS
#' key in a different Amazon Web Services account, you must use the key ARN
#' or alias ARN.
#' 
#' For example:
#' 
#' -   Key ID: `1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' -   Key ARN:
#'     `arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' -   Alias name: `alias/ExampleAlias`
#' 
#' -   Alias ARN: `arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias`
#' 
#' To get the key ID and key ARN for a KMS key, use
#' [`list_keys`][kms_list_keys] or [`describe_key`][kms_describe_key]. To
#' get the alias name and alias ARN, use
#' [`list_aliases`][kms_list_aliases].
#' @param EncryptionAlgorithm Specifies the encryption algorithm that will be used to decrypt the
#' ciphertext. Specify the same algorithm that was used to encrypt the
#' data. If you specify a different algorithm, the [`decrypt`][kms_decrypt]
#' operation fails.
#' 
#' This parameter is required only when the ciphertext was encrypted under
#' an asymmetric KMS key. The default value, `SYMMETRIC_DEFAULT`,
#' represents the only supported algorithm that is valid for symmetric
#' encryption KMS keys.
#'
#' @keywords internal
#'
#' @rdname kms_decrypt
kms_decrypt <- function(CiphertextBlob, EncryptionContext = NULL, GrantTokens = NULL, KeyId = NULL, EncryptionAlgorithm = NULL) {
  op <- new_operation(
    name = "Decrypt",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kms$decrypt_input(CiphertextBlob = CiphertextBlob, EncryptionContext = EncryptionContext, GrantTokens = GrantTokens, KeyId = KeyId, EncryptionAlgorithm = EncryptionAlgorithm)
  output <- .kms$decrypt_output()
  config <- get_config()
  svc <- .kms$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kms$operations$decrypt <- kms_decrypt

#' Deletes the specified alias
#'
#' @description
#' Deletes the specified alias.
#'
#' See [https://paws-r.github.io/docs/kms/delete_alias.html](https://paws-r.github.io/docs/kms/delete_alias.html) for full documentation.
#'
#' @param AliasName &#91;required&#93; The alias to be deleted. The alias name must begin with `alias/`
#' followed by the alias name, such as `alias/ExampleAlias`.
#'
#' @keywords internal
#'
#' @rdname kms_delete_alias
kms_delete_alias <- function(AliasName) {
  op <- new_operation(
    name = "DeleteAlias",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kms$delete_alias_input(AliasName = AliasName)
  output <- .kms$delete_alias_output()
  config <- get_config()
  svc <- .kms$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kms$operations$delete_alias <- kms_delete_alias

#' Deletes a custom key store
#'
#' @description
#' Deletes a [custom key store](https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html). This operation does not delete the CloudHSM cluster that is associated with the custom key store, or affect any users or keys in the cluster.
#'
#' See [https://paws-r.github.io/docs/kms/delete_custom_key_store.html](https://paws-r.github.io/docs/kms/delete_custom_key_store.html) for full documentation.
#'
#' @param CustomKeyStoreId &#91;required&#93; Enter the ID of the custom key store you want to delete. To find the ID
#' of a custom key store, use the
#' [`describe_custom_key_stores`][kms_describe_custom_key_stores]
#' operation.
#'
#' @keywords internal
#'
#' @rdname kms_delete_custom_key_store
kms_delete_custom_key_store <- function(CustomKeyStoreId) {
  op <- new_operation(
    name = "DeleteCustomKeyStore",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kms$delete_custom_key_store_input(CustomKeyStoreId = CustomKeyStoreId)
  output <- .kms$delete_custom_key_store_output()
  config <- get_config()
  svc <- .kms$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kms$operations$delete_custom_key_store <- kms_delete_custom_key_store

#' Deletes key material that you previously imported
#'
#' @description
#' Deletes key material that you previously imported. This operation makes the specified KMS key unusable. For more information about importing key material into KMS, see [Importing Key Material](https://docs.aws.amazon.com/kms/latest/developerguide/importing-keys.html) in the *Key Management Service Developer Guide*.
#'
#' See [https://paws-r.github.io/docs/kms/delete_imported_key_material.html](https://paws-r.github.io/docs/kms/delete_imported_key_material.html) for full documentation.
#'
#' @param KeyId &#91;required&#93; Identifies the KMS key from which you are deleting imported key
#' material. The `Origin` of the KMS key must be `EXTERNAL`.
#' 
#' Specify the key ID or key ARN of the KMS key.
#' 
#' For example:
#' 
#' -   Key ID: `1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' -   Key ARN:
#'     `arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' To get the key ID and key ARN for a KMS key, use
#' [`list_keys`][kms_list_keys] or [`describe_key`][kms_describe_key].
#'
#' @keywords internal
#'
#' @rdname kms_delete_imported_key_material
kms_delete_imported_key_material <- function(KeyId) {
  op <- new_operation(
    name = "DeleteImportedKeyMaterial",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kms$delete_imported_key_material_input(KeyId = KeyId)
  output <- .kms$delete_imported_key_material_output()
  config <- get_config()
  svc <- .kms$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kms$operations$delete_imported_key_material <- kms_delete_imported_key_material

#' Gets information about custom key stores in the account and Region
#'
#' @description
#' Gets information about [custom key stores](https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html) in the account and Region.
#'
#' See [https://paws-r.github.io/docs/kms/describe_custom_key_stores.html](https://paws-r.github.io/docs/kms/describe_custom_key_stores.html) for full documentation.
#'
#' @param CustomKeyStoreId Gets only information about the specified custom key store. Enter the
#' key store ID.
#' 
#' By default, this operation gets information about all custom key stores
#' in the account and Region. To limit the output to a particular custom
#' key store, you can use either the `CustomKeyStoreId` or
#' `CustomKeyStoreName` parameter, but not both.
#' @param CustomKeyStoreName Gets only information about the specified custom key store. Enter the
#' friendly name of the custom key store.
#' 
#' By default, this operation gets information about all custom key stores
#' in the account and Region. To limit the output to a particular custom
#' key store, you can use either the `CustomKeyStoreId` or
#' `CustomKeyStoreName` parameter, but not both.
#' @param Limit Use this parameter to specify the maximum number of items to return.
#' When this value is present, KMS does not return more than the specified
#' number of items, but it might return fewer.
#' @param Marker Use this parameter in a subsequent request after you receive a response
#' with truncated results. Set it to the value of `NextMarker` from the
#' truncated response you just received.
#'
#' @keywords internal
#'
#' @rdname kms_describe_custom_key_stores
kms_describe_custom_key_stores <- function(CustomKeyStoreId = NULL, CustomKeyStoreName = NULL, Limit = NULL, Marker = NULL) {
  op <- new_operation(
    name = "DescribeCustomKeyStores",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kms$describe_custom_key_stores_input(CustomKeyStoreId = CustomKeyStoreId, CustomKeyStoreName = CustomKeyStoreName, Limit = Limit, Marker = Marker)
  output <- .kms$describe_custom_key_stores_output()
  config <- get_config()
  svc <- .kms$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kms$operations$describe_custom_key_stores <- kms_describe_custom_key_stores

#' Provides detailed information about a KMS key
#'
#' @description
#' Provides detailed information about a KMS key. You can run [`describe_key`][kms_describe_key] on a [customer managed key](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#customer-cmk) or an [Amazon Web Services managed key](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#aws-managed-cmk).
#'
#' See [https://paws-r.github.io/docs/kms/describe_key.html](https://paws-r.github.io/docs/kms/describe_key.html) for full documentation.
#'
#' @param KeyId &#91;required&#93; Describes the specified KMS key.
#' 
#' If you specify a predefined Amazon Web Services alias (an Amazon Web
#' Services alias with no key ID), KMS associates the alias with an [Amazon
#' Web Services managed
#' key](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html##aws-managed-cmk)
#' and returns its `KeyId` and `Arn` in the response.
#' 
#' To specify a KMS key, use its key ID, key ARN, alias name, or alias ARN.
#' When using an alias name, prefix it with `"alias/"`. To specify a KMS
#' key in a different Amazon Web Services account, you must use the key ARN
#' or alias ARN.
#' 
#' For example:
#' 
#' -   Key ID: `1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' -   Key ARN:
#'     `arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' -   Alias name: `alias/ExampleAlias`
#' 
#' -   Alias ARN: `arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias`
#' 
#' To get the key ID and key ARN for a KMS key, use
#' [`list_keys`][kms_list_keys] or [`describe_key`][kms_describe_key]. To
#' get the alias name and alias ARN, use
#' [`list_aliases`][kms_list_aliases].
#' @param GrantTokens A list of grant tokens.
#' 
#' Use a grant token when your permission to call this operation comes from
#' a new grant that has not yet achieved *eventual consistency*. For more
#' information, see [Grant
#' token](https://docs.aws.amazon.com/kms/latest/developerguide/grants.html#grant_token)
#' and [Using a grant
#' token](https://docs.aws.amazon.com/kms/latest/developerguide/grant-manage.html#using-grant-token)
#' in the *Key Management Service Developer Guide*.
#'
#' @keywords internal
#'
#' @rdname kms_describe_key
kms_describe_key <- function(KeyId, GrantTokens = NULL) {
  op <- new_operation(
    name = "DescribeKey",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kms$describe_key_input(KeyId = KeyId, GrantTokens = GrantTokens)
  output <- .kms$describe_key_output()
  config <- get_config()
  svc <- .kms$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kms$operations$describe_key <- kms_describe_key

#' Sets the state of a KMS key to disabled
#'
#' @description
#' Sets the state of a KMS key to disabled. This change temporarily prevents use of the KMS key for [cryptographic operations](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#cryptographic-operations).
#'
#' See [https://paws-r.github.io/docs/kms/disable_key.html](https://paws-r.github.io/docs/kms/disable_key.html) for full documentation.
#'
#' @param KeyId &#91;required&#93; Identifies the KMS key to disable.
#' 
#' Specify the key ID or key ARN of the KMS key.
#' 
#' For example:
#' 
#' -   Key ID: `1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' -   Key ARN:
#'     `arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' To get the key ID and key ARN for a KMS key, use
#' [`list_keys`][kms_list_keys] or [`describe_key`][kms_describe_key].
#'
#' @keywords internal
#'
#' @rdname kms_disable_key
kms_disable_key <- function(KeyId) {
  op <- new_operation(
    name = "DisableKey",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kms$disable_key_input(KeyId = KeyId)
  output <- .kms$disable_key_output()
  config <- get_config()
  svc <- .kms$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kms$operations$disable_key <- kms_disable_key

#' Disables automatic rotation of the key material of the specified
#' symmetric encryption KMS key
#'
#' @description
#' Disables [automatic rotation of the key material](https://docs.aws.amazon.com/kms/latest/developerguide/rotate-keys.html) of the specified symmetric encryption KMS key.
#'
#' See [https://paws-r.github.io/docs/kms/disable_key_rotation.html](https://paws-r.github.io/docs/kms/disable_key_rotation.html) for full documentation.
#'
#' @param KeyId &#91;required&#93; Identifies a symmetric encryption KMS key. You cannot enable or disable
#' automatic rotation of [asymmetric KMS
#' keys](https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html#asymmetric-cmks),
#' [HMAC KMS
#' keys](https://docs.aws.amazon.com/kms/latest/developerguide/hmac.html),
#' KMS keys with [imported key
#' material](https://docs.aws.amazon.com/kms/latest/developerguide/importing-keys.html),
#' or KMS keys in a [custom key
#' store](https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html).
#' 
#' Specify the key ID or key ARN of the KMS key.
#' 
#' For example:
#' 
#' -   Key ID: `1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' -   Key ARN:
#'     `arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' To get the key ID and key ARN for a KMS key, use
#' [`list_keys`][kms_list_keys] or [`describe_key`][kms_describe_key].
#'
#' @keywords internal
#'
#' @rdname kms_disable_key_rotation
kms_disable_key_rotation <- function(KeyId) {
  op <- new_operation(
    name = "DisableKeyRotation",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kms$disable_key_rotation_input(KeyId = KeyId)
  output <- .kms$disable_key_rotation_output()
  config <- get_config()
  svc <- .kms$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kms$operations$disable_key_rotation <- kms_disable_key_rotation

#' Disconnects the custom key store from its associated CloudHSM cluster
#'
#' @description
#' Disconnects the [custom key store](https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html) from its associated CloudHSM cluster. While a custom key store is disconnected, you can manage the custom key store and its KMS keys, but you cannot create or use KMS keys in the custom key store. You can reconnect the custom key store at any time.
#'
#' See [https://paws-r.github.io/docs/kms/disconnect_custom_key_store.html](https://paws-r.github.io/docs/kms/disconnect_custom_key_store.html) for full documentation.
#'
#' @param CustomKeyStoreId &#91;required&#93; Enter the ID of the custom key store you want to disconnect. To find the
#' ID of a custom key store, use the
#' [`describe_custom_key_stores`][kms_describe_custom_key_stores]
#' operation.
#'
#' @keywords internal
#'
#' @rdname kms_disconnect_custom_key_store
kms_disconnect_custom_key_store <- function(CustomKeyStoreId) {
  op <- new_operation(
    name = "DisconnectCustomKeyStore",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kms$disconnect_custom_key_store_input(CustomKeyStoreId = CustomKeyStoreId)
  output <- .kms$disconnect_custom_key_store_output()
  config <- get_config()
  svc <- .kms$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kms$operations$disconnect_custom_key_store <- kms_disconnect_custom_key_store

#' Sets the key state of a KMS key to enabled
#'
#' @description
#' Sets the key state of a KMS key to enabled. This allows you to use the KMS key for [cryptographic operations](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#cryptographic-operations).
#'
#' See [https://paws-r.github.io/docs/kms/enable_key.html](https://paws-r.github.io/docs/kms/enable_key.html) for full documentation.
#'
#' @param KeyId &#91;required&#93; Identifies the KMS key to enable.
#' 
#' Specify the key ID or key ARN of the KMS key.
#' 
#' For example:
#' 
#' -   Key ID: `1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' -   Key ARN:
#'     `arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' To get the key ID and key ARN for a KMS key, use
#' [`list_keys`][kms_list_keys] or [`describe_key`][kms_describe_key].
#'
#' @keywords internal
#'
#' @rdname kms_enable_key
kms_enable_key <- function(KeyId) {
  op <- new_operation(
    name = "EnableKey",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kms$enable_key_input(KeyId = KeyId)
  output <- .kms$enable_key_output()
  config <- get_config()
  svc <- .kms$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kms$operations$enable_key <- kms_enable_key

#' Enables automatic rotation of the key material of the specified
#' symmetric encryption KMS key
#'
#' @description
#' Enables [automatic rotation of the key material](https://docs.aws.amazon.com/kms/latest/developerguide/rotate-keys.html) of the specified symmetric encryption KMS key.
#'
#' See [https://paws-r.github.io/docs/kms/enable_key_rotation.html](https://paws-r.github.io/docs/kms/enable_key_rotation.html) for full documentation.
#'
#' @param KeyId &#91;required&#93; Identifies a symmetric encryption KMS key. You cannot enable or disable
#' automatic rotation of [asymmetric KMS
#' keys](https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html),
#' [HMAC KMS
#' keys](https://docs.aws.amazon.com/kms/latest/developerguide/hmac.html),
#' KMS keys with [imported key
#' material](https://docs.aws.amazon.com/kms/latest/developerguide/importing-keys.html),
#' or KMS keys in a [custom key
#' store](https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html).
#' The key rotation status of these KMS keys is always `false`. To enable
#' or disable automatic rotation of a set of related [multi-Region
#' keys](https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-manage.html#multi-region-rotate),
#' set the property on the primary key.
#' 
#' Specify the key ID or key ARN of the KMS key.
#' 
#' For example:
#' 
#' -   Key ID: `1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' -   Key ARN:
#'     `arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' To get the key ID and key ARN for a KMS key, use
#' [`list_keys`][kms_list_keys] or [`describe_key`][kms_describe_key].
#'
#' @keywords internal
#'
#' @rdname kms_enable_key_rotation
kms_enable_key_rotation <- function(KeyId) {
  op <- new_operation(
    name = "EnableKeyRotation",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kms$enable_key_rotation_input(KeyId = KeyId)
  output <- .kms$enable_key_rotation_output()
  config <- get_config()
  svc <- .kms$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kms$operations$enable_key_rotation <- kms_enable_key_rotation

#' Encrypts plaintext of up to 4,096 bytes using a KMS key
#'
#' @description
#' Encrypts plaintext of up to 4,096 bytes using a KMS key. You can use a symmetric or asymmetric KMS key with a `KeyUsage` of `ENCRYPT_DECRYPT`.
#'
#' See [https://paws-r.github.io/docs/kms/encrypt.html](https://paws-r.github.io/docs/kms/encrypt.html) for full documentation.
#'
#' @param KeyId &#91;required&#93; Identifies the KMS key to use in the encryption operation. The KMS key
#' must have a `KeyUsage` of `ENCRYPT_DECRYPT`. To find the `KeyUsage` of a
#' KMS key, use the [`describe_key`][kms_describe_key] operation.
#' 
#' To specify a KMS key, use its key ID, key ARN, alias name, or alias ARN.
#' When using an alias name, prefix it with `"alias/"`. To specify a KMS
#' key in a different Amazon Web Services account, you must use the key ARN
#' or alias ARN.
#' 
#' For example:
#' 
#' -   Key ID: `1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' -   Key ARN:
#'     `arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' -   Alias name: `alias/ExampleAlias`
#' 
#' -   Alias ARN: `arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias`
#' 
#' To get the key ID and key ARN for a KMS key, use
#' [`list_keys`][kms_list_keys] or [`describe_key`][kms_describe_key]. To
#' get the alias name and alias ARN, use
#' [`list_aliases`][kms_list_aliases].
#' @param Plaintext &#91;required&#93; Data to be encrypted.
#' @param EncryptionContext Specifies the encryption context that will be used to encrypt the data.
#' An encryption context is valid only for [cryptographic
#' operations](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#cryptographic-operations)
#' with a symmetric encryption KMS key. The standard asymmetric encryption
#' algorithms and HMAC algorithms that KMS uses do not support an
#' encryption context.
#' 
#' An *encryption context* is a collection of non-secret key-value pairs
#' that represent additional authenticated data. When you use an encryption
#' context to encrypt data, you must specify the same (an exact
#' case-sensitive match) encryption context to decrypt the data. An
#' encryption context is supported only on operations with symmetric
#' encryption KMS keys. On operations with symmetric encryption KMS keys,
#' an encryption context is optional, but it is strongly recommended.
#' 
#' For more information, see [Encryption
#' context](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#encrypt_context)
#' in the *Key Management Service Developer Guide*.
#' @param GrantTokens A list of grant tokens.
#' 
#' Use a grant token when your permission to call this operation comes from
#' a new grant that has not yet achieved *eventual consistency*. For more
#' information, see [Grant
#' token](https://docs.aws.amazon.com/kms/latest/developerguide/grants.html#grant_token)
#' and [Using a grant
#' token](https://docs.aws.amazon.com/kms/latest/developerguide/grant-manage.html#using-grant-token)
#' in the *Key Management Service Developer Guide*.
#' @param EncryptionAlgorithm Specifies the encryption algorithm that KMS will use to encrypt the
#' plaintext message. The algorithm must be compatible with the KMS key
#' that you specify.
#' 
#' This parameter is required only for asymmetric KMS keys. The default
#' value, `SYMMETRIC_DEFAULT`, is the algorithm used for symmetric
#' encryption KMS keys. If you are using an asymmetric KMS key, we
#' recommend RSAES_OAEP_SHA_256.
#'
#' @keywords internal
#'
#' @rdname kms_encrypt
kms_encrypt <- function(KeyId, Plaintext, EncryptionContext = NULL, GrantTokens = NULL, EncryptionAlgorithm = NULL) {
  op <- new_operation(
    name = "Encrypt",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kms$encrypt_input(KeyId = KeyId, Plaintext = Plaintext, EncryptionContext = EncryptionContext, GrantTokens = GrantTokens, EncryptionAlgorithm = EncryptionAlgorithm)
  output <- .kms$encrypt_output()
  config <- get_config()
  svc <- .kms$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kms$operations$encrypt <- kms_encrypt

#' Returns a unique symmetric data key for use outside of KMS
#'
#' @description
#' Returns a unique symmetric data key for use outside of KMS. This operation returns a plaintext copy of the data key and a copy that is encrypted under a symmetric encryption KMS key that you specify. The bytes in the plaintext key are random; they are not related to the caller or the KMS key. You can use the plaintext key to encrypt your data outside of KMS and store the encrypted data key with the encrypted data.
#'
#' See [https://paws-r.github.io/docs/kms/generate_data_key.html](https://paws-r.github.io/docs/kms/generate_data_key.html) for full documentation.
#'
#' @param KeyId &#91;required&#93; Specifies the symmetric encryption KMS key that encrypts the data key.
#' You cannot specify an asymmetric KMS key or a KMS key in a custom key
#' store. To get the type and origin of your KMS key, use the
#' [`describe_key`][kms_describe_key] operation.
#' 
#' To specify a KMS key, use its key ID, key ARN, alias name, or alias ARN.
#' When using an alias name, prefix it with `"alias/"`. To specify a KMS
#' key in a different Amazon Web Services account, you must use the key ARN
#' or alias ARN.
#' 
#' For example:
#' 
#' -   Key ID: `1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' -   Key ARN:
#'     `arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' -   Alias name: `alias/ExampleAlias`
#' 
#' -   Alias ARN: `arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias`
#' 
#' To get the key ID and key ARN for a KMS key, use
#' [`list_keys`][kms_list_keys] or [`describe_key`][kms_describe_key]. To
#' get the alias name and alias ARN, use
#' [`list_aliases`][kms_list_aliases].
#' @param EncryptionContext Specifies the encryption context that will be used when encrypting the
#' data key.
#' 
#' An *encryption context* is a collection of non-secret key-value pairs
#' that represent additional authenticated data. When you use an encryption
#' context to encrypt data, you must specify the same (an exact
#' case-sensitive match) encryption context to decrypt the data. An
#' encryption context is supported only on operations with symmetric
#' encryption KMS keys. On operations with symmetric encryption KMS keys,
#' an encryption context is optional, but it is strongly recommended.
#' 
#' For more information, see [Encryption
#' context](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#encrypt_context)
#' in the *Key Management Service Developer Guide*.
#' @param NumberOfBytes Specifies the length of the data key in bytes. For example, use the
#' value 64 to generate a 512-bit data key (64 bytes is 512 bits). For
#' 128-bit (16-byte) and 256-bit (32-byte) data keys, use the `KeySpec`
#' parameter.
#' 
#' You must specify either the `KeySpec` or the `NumberOfBytes` parameter
#' (but not both) in every [`generate_data_key`][kms_generate_data_key]
#' request.
#' @param KeySpec Specifies the length of the data key. Use `AES_128` to generate a
#' 128-bit symmetric key, or `AES_256` to generate a 256-bit symmetric key.
#' 
#' You must specify either the `KeySpec` or the `NumberOfBytes` parameter
#' (but not both) in every [`generate_data_key`][kms_generate_data_key]
#' request.
#' @param GrantTokens A list of grant tokens.
#' 
#' Use a grant token when your permission to call this operation comes from
#' a new grant that has not yet achieved *eventual consistency*. For more
#' information, see [Grant
#' token](https://docs.aws.amazon.com/kms/latest/developerguide/grants.html#grant_token)
#' and [Using a grant
#' token](https://docs.aws.amazon.com/kms/latest/developerguide/grant-manage.html#using-grant-token)
#' in the *Key Management Service Developer Guide*.
#'
#' @keywords internal
#'
#' @rdname kms_generate_data_key
kms_generate_data_key <- function(KeyId, EncryptionContext = NULL, NumberOfBytes = NULL, KeySpec = NULL, GrantTokens = NULL) {
  op <- new_operation(
    name = "GenerateDataKey",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kms$generate_data_key_input(KeyId = KeyId, EncryptionContext = EncryptionContext, NumberOfBytes = NumberOfBytes, KeySpec = KeySpec, GrantTokens = GrantTokens)
  output <- .kms$generate_data_key_output()
  config <- get_config()
  svc <- .kms$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kms$operations$generate_data_key <- kms_generate_data_key

#' Returns a unique asymmetric data key pair for use outside of KMS
#'
#' @description
#' Returns a unique asymmetric data key pair for use outside of KMS. This operation returns a plaintext public key, a plaintext private key, and a copy of the private key that is encrypted under the symmetric encryption KMS key you specify. You can use the data key pair to perform asymmetric cryptography and implement digital signatures outside of KMS. The bytes in the keys are random; they not related to the caller or to the KMS key that is used to encrypt the private key.
#'
#' See [https://paws-r.github.io/docs/kms/generate_data_key_pair.html](https://paws-r.github.io/docs/kms/generate_data_key_pair.html) for full documentation.
#'
#' @param EncryptionContext Specifies the encryption context that will be used when encrypting the
#' private key in the data key pair.
#' 
#' An *encryption context* is a collection of non-secret key-value pairs
#' that represent additional authenticated data. When you use an encryption
#' context to encrypt data, you must specify the same (an exact
#' case-sensitive match) encryption context to decrypt the data. An
#' encryption context is supported only on operations with symmetric
#' encryption KMS keys. On operations with symmetric encryption KMS keys,
#' an encryption context is optional, but it is strongly recommended.
#' 
#' For more information, see [Encryption
#' context](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#encrypt_context)
#' in the *Key Management Service Developer Guide*.
#' @param KeyId &#91;required&#93; Specifies the symmetric encryption KMS key that encrypts the private key
#' in the data key pair. You cannot specify an asymmetric KMS key or a KMS
#' key in a custom key store. To get the type and origin of your KMS key,
#' use the [`describe_key`][kms_describe_key] operation.
#' 
#' To specify a KMS key, use its key ID, key ARN, alias name, or alias ARN.
#' When using an alias name, prefix it with `"alias/"`. To specify a KMS
#' key in a different Amazon Web Services account, you must use the key ARN
#' or alias ARN.
#' 
#' For example:
#' 
#' -   Key ID: `1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' -   Key ARN:
#'     `arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' -   Alias name: `alias/ExampleAlias`
#' 
#' -   Alias ARN: `arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias`
#' 
#' To get the key ID and key ARN for a KMS key, use
#' [`list_keys`][kms_list_keys] or [`describe_key`][kms_describe_key]. To
#' get the alias name and alias ARN, use
#' [`list_aliases`][kms_list_aliases].
#' @param KeyPairSpec &#91;required&#93; Determines the type of data key pair that is generated.
#' 
#' The KMS rule that restricts the use of asymmetric RSA and SM2 KMS keys
#' to encrypt and decrypt or to sign and verify (but not both), and the
#' rule that permits you to use ECC KMS keys only to sign and verify, are
#' not effective on data key pairs, which are used outside of KMS. The SM2
#' key spec is only available in China Regions. RSA and ECC asymmetric key
#' pairs are also available in China Regions.
#' @param GrantTokens A list of grant tokens.
#' 
#' Use a grant token when your permission to call this operation comes from
#' a new grant that has not yet achieved *eventual consistency*. For more
#' information, see [Grant
#' token](https://docs.aws.amazon.com/kms/latest/developerguide/grants.html#grant_token)
#' and [Using a grant
#' token](https://docs.aws.amazon.com/kms/latest/developerguide/grant-manage.html#using-grant-token)
#' in the *Key Management Service Developer Guide*.
#'
#' @keywords internal
#'
#' @rdname kms_generate_data_key_pair
kms_generate_data_key_pair <- function(EncryptionContext = NULL, KeyId, KeyPairSpec, GrantTokens = NULL) {
  op <- new_operation(
    name = "GenerateDataKeyPair",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kms$generate_data_key_pair_input(EncryptionContext = EncryptionContext, KeyId = KeyId, KeyPairSpec = KeyPairSpec, GrantTokens = GrantTokens)
  output <- .kms$generate_data_key_pair_output()
  config <- get_config()
  svc <- .kms$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kms$operations$generate_data_key_pair <- kms_generate_data_key_pair

#' Returns a unique asymmetric data key pair for use outside of KMS
#'
#' @description
#' Returns a unique asymmetric data key pair for use outside of KMS. This operation returns a plaintext public key and a copy of the private key that is encrypted under the symmetric encryption KMS key you specify. Unlike [`generate_data_key_pair`][kms_generate_data_key_pair], this operation does not return a plaintext private key. The bytes in the keys are random; they are not related to the caller or to the KMS key that is used to encrypt the private key.
#'
#' See [https://paws-r.github.io/docs/kms/generate_data_key_pair_without_plaintext.html](https://paws-r.github.io/docs/kms/generate_data_key_pair_without_plaintext.html) for full documentation.
#'
#' @param EncryptionContext Specifies the encryption context that will be used when encrypting the
#' private key in the data key pair.
#' 
#' An *encryption context* is a collection of non-secret key-value pairs
#' that represent additional authenticated data. When you use an encryption
#' context to encrypt data, you must specify the same (an exact
#' case-sensitive match) encryption context to decrypt the data. An
#' encryption context is supported only on operations with symmetric
#' encryption KMS keys. On operations with symmetric encryption KMS keys,
#' an encryption context is optional, but it is strongly recommended.
#' 
#' For more information, see [Encryption
#' context](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#encrypt_context)
#' in the *Key Management Service Developer Guide*.
#' @param KeyId &#91;required&#93; Specifies the symmetric encryption KMS key that encrypts the private key
#' in the data key pair. You cannot specify an asymmetric KMS key or a KMS
#' key in a custom key store. To get the type and origin of your KMS key,
#' use the [`describe_key`][kms_describe_key] operation.
#' 
#' To specify a KMS key, use its key ID, key ARN, alias name, or alias ARN.
#' When using an alias name, prefix it with `"alias/"`. To specify a KMS
#' key in a different Amazon Web Services account, you must use the key ARN
#' or alias ARN.
#' 
#' For example:
#' 
#' -   Key ID: `1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' -   Key ARN:
#'     `arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' -   Alias name: `alias/ExampleAlias`
#' 
#' -   Alias ARN: `arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias`
#' 
#' To get the key ID and key ARN for a KMS key, use
#' [`list_keys`][kms_list_keys] or [`describe_key`][kms_describe_key]. To
#' get the alias name and alias ARN, use
#' [`list_aliases`][kms_list_aliases].
#' @param KeyPairSpec &#91;required&#93; Determines the type of data key pair that is generated.
#' 
#' The KMS rule that restricts the use of asymmetric RSA and SM2 KMS keys
#' to encrypt and decrypt or to sign and verify (but not both), and the
#' rule that permits you to use ECC KMS keys only to sign and verify, are
#' not effective on data key pairs, which are used outside of KMS. The SM2
#' key spec is only available in China Regions. RSA and ECC asymmetric key
#' pairs are also available in China Regions.
#' @param GrantTokens A list of grant tokens.
#' 
#' Use a grant token when your permission to call this operation comes from
#' a new grant that has not yet achieved *eventual consistency*. For more
#' information, see [Grant
#' token](https://docs.aws.amazon.com/kms/latest/developerguide/grants.html#grant_token)
#' and [Using a grant
#' token](https://docs.aws.amazon.com/kms/latest/developerguide/grant-manage.html#using-grant-token)
#' in the *Key Management Service Developer Guide*.
#'
#' @keywords internal
#'
#' @rdname kms_generate_data_key_pair_without_plaintext
kms_generate_data_key_pair_without_plaintext <- function(EncryptionContext = NULL, KeyId, KeyPairSpec, GrantTokens = NULL) {
  op <- new_operation(
    name = "GenerateDataKeyPairWithoutPlaintext",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kms$generate_data_key_pair_without_plaintext_input(EncryptionContext = EncryptionContext, KeyId = KeyId, KeyPairSpec = KeyPairSpec, GrantTokens = GrantTokens)
  output <- .kms$generate_data_key_pair_without_plaintext_output()
  config <- get_config()
  svc <- .kms$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kms$operations$generate_data_key_pair_without_plaintext <- kms_generate_data_key_pair_without_plaintext

#' Returns a unique symmetric data key for use outside of KMS
#'
#' @description
#' Returns a unique symmetric data key for use outside of KMS. This operation returns a data key that is encrypted under a symmetric encryption KMS key that you specify. The bytes in the key are random; they are not related to the caller or to the KMS key.
#'
#' See [https://paws-r.github.io/docs/kms/generate_data_key_without_plaintext.html](https://paws-r.github.io/docs/kms/generate_data_key_without_plaintext.html) for full documentation.
#'
#' @param KeyId &#91;required&#93; Specifies the symmetric encryption KMS key that encrypts the data key.
#' You cannot specify an asymmetric KMS key or a KMS key in a custom key
#' store. To get the type and origin of your KMS key, use the
#' [`describe_key`][kms_describe_key] operation.
#' 
#' To specify a KMS key, use its key ID, key ARN, alias name, or alias ARN.
#' When using an alias name, prefix it with `"alias/"`. To specify a KMS
#' key in a different Amazon Web Services account, you must use the key ARN
#' or alias ARN.
#' 
#' For example:
#' 
#' -   Key ID: `1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' -   Key ARN:
#'     `arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' -   Alias name: `alias/ExampleAlias`
#' 
#' -   Alias ARN: `arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias`
#' 
#' To get the key ID and key ARN for a KMS key, use
#' [`list_keys`][kms_list_keys] or [`describe_key`][kms_describe_key]. To
#' get the alias name and alias ARN, use
#' [`list_aliases`][kms_list_aliases].
#' @param EncryptionContext Specifies the encryption context that will be used when encrypting the
#' data key.
#' 
#' An *encryption context* is a collection of non-secret key-value pairs
#' that represent additional authenticated data. When you use an encryption
#' context to encrypt data, you must specify the same (an exact
#' case-sensitive match) encryption context to decrypt the data. An
#' encryption context is supported only on operations with symmetric
#' encryption KMS keys. On operations with symmetric encryption KMS keys,
#' an encryption context is optional, but it is strongly recommended.
#' 
#' For more information, see [Encryption
#' context](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#encrypt_context)
#' in the *Key Management Service Developer Guide*.
#' @param KeySpec The length of the data key. Use `AES_128` to generate a 128-bit
#' symmetric key, or `AES_256` to generate a 256-bit symmetric key.
#' @param NumberOfBytes The length of the data key in bytes. For example, use the value 64 to
#' generate a 512-bit data key (64 bytes is 512 bits). For common key
#' lengths (128-bit and 256-bit symmetric keys), we recommend that you use
#' the `KeySpec` field instead of this one.
#' @param GrantTokens A list of grant tokens.
#' 
#' Use a grant token when your permission to call this operation comes from
#' a new grant that has not yet achieved *eventual consistency*. For more
#' information, see [Grant
#' token](https://docs.aws.amazon.com/kms/latest/developerguide/grants.html#grant_token)
#' and [Using a grant
#' token](https://docs.aws.amazon.com/kms/latest/developerguide/grant-manage.html#using-grant-token)
#' in the *Key Management Service Developer Guide*.
#'
#' @keywords internal
#'
#' @rdname kms_generate_data_key_without_plaintext
kms_generate_data_key_without_plaintext <- function(KeyId, EncryptionContext = NULL, KeySpec = NULL, NumberOfBytes = NULL, GrantTokens = NULL) {
  op <- new_operation(
    name = "GenerateDataKeyWithoutPlaintext",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kms$generate_data_key_without_plaintext_input(KeyId = KeyId, EncryptionContext = EncryptionContext, KeySpec = KeySpec, NumberOfBytes = NumberOfBytes, GrantTokens = GrantTokens)
  output <- .kms$generate_data_key_without_plaintext_output()
  config <- get_config()
  svc <- .kms$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kms$operations$generate_data_key_without_plaintext <- kms_generate_data_key_without_plaintext

#' Generates a hash-based message authentication code (HMAC) for a message
#' using an HMAC KMS key and a MAC algorithm that the key supports
#'
#' @description
#' Generates a hash-based message authentication code (HMAC) for a message using an HMAC KMS key and a MAC algorithm that the key supports. The MAC algorithm computes the HMAC for the message and the key as described in [RFC 2104](https://datatracker.ietf.org/doc/html/rfc2104).
#'
#' See [https://paws-r.github.io/docs/kms/generate_mac.html](https://paws-r.github.io/docs/kms/generate_mac.html) for full documentation.
#'
#' @param Message &#91;required&#93; The message to be hashed. Specify a message of up to 4,096 bytes.
#' 
#' [`generate_mac`][kms_generate_mac] and [`verify_mac`][kms_verify_mac] do
#' not provide special handling for message digests. If you generate an
#' HMAC for a hash digest of a message, you must verify the HMAC of the
#' same hash digest.
#' @param KeyId &#91;required&#93; The HMAC KMS key to use in the operation. The MAC algorithm computes the
#' HMAC for the message and the key as described in [RFC
#' 2104](https://datatracker.ietf.org/doc/html/rfc2104).
#' 
#' To identify an HMAC KMS key, use the [`describe_key`][kms_describe_key]
#' operation and see the `KeySpec` field in the response.
#' @param MacAlgorithm &#91;required&#93; The MAC algorithm used in the operation.
#' 
#' The algorithm must be compatible with the HMAC KMS key that you specify.
#' To find the MAC algorithms that your HMAC KMS key supports, use the
#' [`describe_key`][kms_describe_key] operation and see the `MacAlgorithms`
#' field in the [`describe_key`][kms_describe_key] response.
#' @param GrantTokens A list of grant tokens.
#' 
#' Use a grant token when your permission to call this operation comes from
#' a new grant that has not yet achieved *eventual consistency*. For more
#' information, see [Grant
#' token](https://docs.aws.amazon.com/kms/latest/developerguide/grants.html#grant_token)
#' and [Using a grant
#' token](https://docs.aws.amazon.com/kms/latest/developerguide/grant-manage.html#using-grant-token)
#' in the *Key Management Service Developer Guide*.
#'
#' @keywords internal
#'
#' @rdname kms_generate_mac
kms_generate_mac <- function(Message, KeyId, MacAlgorithm, GrantTokens = NULL) {
  op <- new_operation(
    name = "GenerateMac",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kms$generate_mac_input(Message = Message, KeyId = KeyId, MacAlgorithm = MacAlgorithm, GrantTokens = GrantTokens)
  output <- .kms$generate_mac_output()
  config <- get_config()
  svc <- .kms$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kms$operations$generate_mac <- kms_generate_mac

#' Returns a random byte string that is cryptographically secure
#'
#' @description
#' Returns a random byte string that is cryptographically secure.
#'
#' See [https://paws-r.github.io/docs/kms/generate_random.html](https://paws-r.github.io/docs/kms/generate_random.html) for full documentation.
#'
#' @param NumberOfBytes The length of the random byte string. This parameter is required.
#' @param CustomKeyStoreId Generates the random byte string in the CloudHSM cluster that is
#' associated with the specified [custom key
#' store](https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html).
#' To find the ID of a custom key store, use the
#' [`describe_custom_key_stores`][kms_describe_custom_key_stores]
#' operation.
#'
#' @keywords internal
#'
#' @rdname kms_generate_random
kms_generate_random <- function(NumberOfBytes = NULL, CustomKeyStoreId = NULL) {
  op <- new_operation(
    name = "GenerateRandom",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kms$generate_random_input(NumberOfBytes = NumberOfBytes, CustomKeyStoreId = CustomKeyStoreId)
  output <- .kms$generate_random_output()
  config <- get_config()
  svc <- .kms$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kms$operations$generate_random <- kms_generate_random

#' Gets a key policy attached to the specified KMS key
#'
#' @description
#' Gets a key policy attached to the specified KMS key.
#'
#' See [https://paws-r.github.io/docs/kms/get_key_policy.html](https://paws-r.github.io/docs/kms/get_key_policy.html) for full documentation.
#'
#' @param KeyId &#91;required&#93; Gets the key policy for the specified KMS key.
#' 
#' Specify the key ID or key ARN of the KMS key.
#' 
#' For example:
#' 
#' -   Key ID: `1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' -   Key ARN:
#'     `arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' To get the key ID and key ARN for a KMS key, use
#' [`list_keys`][kms_list_keys] or [`describe_key`][kms_describe_key].
#' @param PolicyName &#91;required&#93; Specifies the name of the key policy. The only valid name is `default`.
#' To get the names of key policies, use
#' [`list_key_policies`][kms_list_key_policies].
#'
#' @keywords internal
#'
#' @rdname kms_get_key_policy
kms_get_key_policy <- function(KeyId, PolicyName) {
  op <- new_operation(
    name = "GetKeyPolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kms$get_key_policy_input(KeyId = KeyId, PolicyName = PolicyName)
  output <- .kms$get_key_policy_output()
  config <- get_config()
  svc <- .kms$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kms$operations$get_key_policy <- kms_get_key_policy

#' Gets a Boolean value that indicates whether automatic rotation of the
#' key material is enabled for the specified KMS key
#'
#' @description
#' Gets a Boolean value that indicates whether [automatic rotation of the key material](https://docs.aws.amazon.com/kms/latest/developerguide/rotate-keys.html) is enabled for the specified KMS key.
#'
#' See [https://paws-r.github.io/docs/kms/get_key_rotation_status.html](https://paws-r.github.io/docs/kms/get_key_rotation_status.html) for full documentation.
#'
#' @param KeyId &#91;required&#93; Gets the rotation status for the specified KMS key.
#' 
#' Specify the key ID or key ARN of the KMS key. To specify a KMS key in a
#' different Amazon Web Services account, you must use the key ARN.
#' 
#' For example:
#' 
#' -   Key ID: `1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' -   Key ARN:
#'     `arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' To get the key ID and key ARN for a KMS key, use
#' [`list_keys`][kms_list_keys] or [`describe_key`][kms_describe_key].
#'
#' @keywords internal
#'
#' @rdname kms_get_key_rotation_status
kms_get_key_rotation_status <- function(KeyId) {
  op <- new_operation(
    name = "GetKeyRotationStatus",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kms$get_key_rotation_status_input(KeyId = KeyId)
  output <- .kms$get_key_rotation_status_output()
  config <- get_config()
  svc <- .kms$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kms$operations$get_key_rotation_status <- kms_get_key_rotation_status

#' Returns the items you need to import key material into a symmetric
#' encryption KMS key
#'
#' @description
#' Returns the items you need to import key material into a symmetric encryption KMS key. For more information about importing key material into KMS, see [Importing key material](https://docs.aws.amazon.com/kms/latest/developerguide/importing-keys.html) in the *Key Management Service Developer Guide*.
#'
#' See [https://paws-r.github.io/docs/kms/get_parameters_for_import.html](https://paws-r.github.io/docs/kms/get_parameters_for_import.html) for full documentation.
#'
#' @param KeyId &#91;required&#93; The identifier of the symmetric encryption KMS key into which you will
#' import key material. The `Origin` of the KMS key must be `EXTERNAL`.
#' 
#' Specify the key ID or key ARN of the KMS key.
#' 
#' For example:
#' 
#' -   Key ID: `1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' -   Key ARN:
#'     `arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' To get the key ID and key ARN for a KMS key, use
#' [`list_keys`][kms_list_keys] or [`describe_key`][kms_describe_key].
#' @param WrappingAlgorithm &#91;required&#93; The algorithm you will use to encrypt the key material before importing
#' it with [`import_key_material`][kms_import_key_material]. For more
#' information, see [Encrypt the Key
#' Material](https://docs.aws.amazon.com/kms/latest/developerguide/importing-keys-encrypt-key-material.html)
#' in the *Key Management Service Developer Guide*.
#' @param WrappingKeySpec &#91;required&#93; The type of wrapping key (public key) to return in the response. Only
#' 2048-bit RSA public keys are supported.
#'
#' @keywords internal
#'
#' @rdname kms_get_parameters_for_import
kms_get_parameters_for_import <- function(KeyId, WrappingAlgorithm, WrappingKeySpec) {
  op <- new_operation(
    name = "GetParametersForImport",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kms$get_parameters_for_import_input(KeyId = KeyId, WrappingAlgorithm = WrappingAlgorithm, WrappingKeySpec = WrappingKeySpec)
  output <- .kms$get_parameters_for_import_output()
  config <- get_config()
  svc <- .kms$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kms$operations$get_parameters_for_import <- kms_get_parameters_for_import

#' Returns the public key of an asymmetric KMS key
#'
#' @description
#' Returns the public key of an asymmetric KMS key. Unlike the private key of a asymmetric KMS key, which never leaves KMS unencrypted, callers with `kms:GetPublicKey` permission can download the public key of an asymmetric KMS key. You can share the public key to allow others to encrypt messages and verify signatures outside of KMS. For information about asymmetric KMS keys, see [Asymmetric KMS keys](https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html) in the *Key Management Service Developer Guide*.
#'
#' See [https://paws-r.github.io/docs/kms/get_public_key.html](https://paws-r.github.io/docs/kms/get_public_key.html) for full documentation.
#'
#' @param KeyId &#91;required&#93; Identifies the asymmetric KMS key that includes the public key.
#' 
#' To specify a KMS key, use its key ID, key ARN, alias name, or alias ARN.
#' When using an alias name, prefix it with `"alias/"`. To specify a KMS
#' key in a different Amazon Web Services account, you must use the key ARN
#' or alias ARN.
#' 
#' For example:
#' 
#' -   Key ID: `1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' -   Key ARN:
#'     `arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' -   Alias name: `alias/ExampleAlias`
#' 
#' -   Alias ARN: `arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias`
#' 
#' To get the key ID and key ARN for a KMS key, use
#' [`list_keys`][kms_list_keys] or [`describe_key`][kms_describe_key]. To
#' get the alias name and alias ARN, use
#' [`list_aliases`][kms_list_aliases].
#' @param GrantTokens A list of grant tokens.
#' 
#' Use a grant token when your permission to call this operation comes from
#' a new grant that has not yet achieved *eventual consistency*. For more
#' information, see [Grant
#' token](https://docs.aws.amazon.com/kms/latest/developerguide/grants.html#grant_token)
#' and [Using a grant
#' token](https://docs.aws.amazon.com/kms/latest/developerguide/grant-manage.html#using-grant-token)
#' in the *Key Management Service Developer Guide*.
#'
#' @keywords internal
#'
#' @rdname kms_get_public_key
kms_get_public_key <- function(KeyId, GrantTokens = NULL) {
  op <- new_operation(
    name = "GetPublicKey",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kms$get_public_key_input(KeyId = KeyId, GrantTokens = GrantTokens)
  output <- .kms$get_public_key_output()
  config <- get_config()
  svc <- .kms$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kms$operations$get_public_key <- kms_get_public_key

#' Imports key material into an existing symmetric encryption KMS key that
#' was created without key material
#'
#' @description
#' Imports key material into an existing symmetric encryption KMS key that was created without key material. After you successfully import key material into a KMS key, you can [reimport the same key material](https://docs.aws.amazon.com/kms/latest/developerguide/importing-keys.html#reimport-key-material) into that KMS key, but you cannot import different key material.
#'
#' See [https://paws-r.github.io/docs/kms/import_key_material.html](https://paws-r.github.io/docs/kms/import_key_material.html) for full documentation.
#'
#' @param KeyId &#91;required&#93; The identifier of the symmetric encryption KMS key that receives the
#' imported key material. This must be the same KMS key specified in the
#' `KeyID` parameter of the corresponding
#' [`get_parameters_for_import`][kms_get_parameters_for_import] request.
#' The `Origin` of the KMS key must be `EXTERNAL`. You cannot perform this
#' operation on an asymmetric KMS key, an HMAC KMS key, a KMS key in a
#' custom key store, or on a KMS key in a different Amazon Web Services
#' account
#' 
#' Specify the key ID or key ARN of the KMS key.
#' 
#' For example:
#' 
#' -   Key ID: `1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' -   Key ARN:
#'     `arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' To get the key ID and key ARN for a KMS key, use
#' [`list_keys`][kms_list_keys] or [`describe_key`][kms_describe_key].
#' @param ImportToken &#91;required&#93; The import token that you received in the response to a previous
#' [`get_parameters_for_import`][kms_get_parameters_for_import] request. It
#' must be from the same response that contained the public key that you
#' used to encrypt the key material.
#' @param EncryptedKeyMaterial &#91;required&#93; The encrypted key material to import. The key material must be encrypted
#' with the public wrapping key that
#' [`get_parameters_for_import`][kms_get_parameters_for_import] returned,
#' using the wrapping algorithm that you specified in the same
#' [`get_parameters_for_import`][kms_get_parameters_for_import] request.
#' @param ValidTo The time at which the imported key material expires. When the key
#' material expires, KMS deletes the key material and the KMS key becomes
#' unusable. You must omit this parameter when the `ExpirationModel`
#' parameter is set to `KEY_MATERIAL_DOES_NOT_EXPIRE`. Otherwise it is
#' required.
#' @param ExpirationModel Specifies whether the key material expires. The default is
#' `KEY_MATERIAL_EXPIRES`, in which case you must include the `ValidTo`
#' parameter. When this parameter is set to `KEY_MATERIAL_DOES_NOT_EXPIRE`,
#' you must omit the `ValidTo` parameter.
#'
#' @keywords internal
#'
#' @rdname kms_import_key_material
kms_import_key_material <- function(KeyId, ImportToken, EncryptedKeyMaterial, ValidTo = NULL, ExpirationModel = NULL) {
  op <- new_operation(
    name = "ImportKeyMaterial",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kms$import_key_material_input(KeyId = KeyId, ImportToken = ImportToken, EncryptedKeyMaterial = EncryptedKeyMaterial, ValidTo = ValidTo, ExpirationModel = ExpirationModel)
  output <- .kms$import_key_material_output()
  config <- get_config()
  svc <- .kms$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kms$operations$import_key_material <- kms_import_key_material

#' Gets a list of aliases in the caller's Amazon Web Services account and
#' region
#'
#' @description
#' Gets a list of aliases in the caller's Amazon Web Services account and region. For more information about aliases, see [`create_alias`][kms_create_alias].
#'
#' See [https://paws-r.github.io/docs/kms/list_aliases.html](https://paws-r.github.io/docs/kms/list_aliases.html) for full documentation.
#'
#' @param KeyId Lists only aliases that are associated with the specified KMS key. Enter
#' a KMS key in your Amazon Web Services account.
#' 
#' This parameter is optional. If you omit it,
#' [`list_aliases`][kms_list_aliases] returns all aliases in the account
#' and Region.
#' 
#' Specify the key ID or key ARN of the KMS key.
#' 
#' For example:
#' 
#' -   Key ID: `1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' -   Key ARN:
#'     `arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' To get the key ID and key ARN for a KMS key, use
#' [`list_keys`][kms_list_keys] or [`describe_key`][kms_describe_key].
#' @param Limit Use this parameter to specify the maximum number of items to return.
#' When this value is present, KMS does not return more than the specified
#' number of items, but it might return fewer.
#' 
#' This value is optional. If you include a value, it must be between 1 and
#' 100, inclusive. If you do not include a value, it defaults to 50.
#' @param Marker Use this parameter in a subsequent request after you receive a response
#' with truncated results. Set it to the value of `NextMarker` from the
#' truncated response you just received.
#'
#' @keywords internal
#'
#' @rdname kms_list_aliases
kms_list_aliases <- function(KeyId = NULL, Limit = NULL, Marker = NULL) {
  op <- new_operation(
    name = "ListAliases",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kms$list_aliases_input(KeyId = KeyId, Limit = Limit, Marker = Marker)
  output <- .kms$list_aliases_output()
  config <- get_config()
  svc <- .kms$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kms$operations$list_aliases <- kms_list_aliases

#' Gets a list of all grants for the specified KMS key
#'
#' @description
#' Gets a list of all grants for the specified KMS key.
#'
#' See [https://paws-r.github.io/docs/kms/list_grants.html](https://paws-r.github.io/docs/kms/list_grants.html) for full documentation.
#'
#' @param Limit Use this parameter to specify the maximum number of items to return.
#' When this value is present, KMS does not return more than the specified
#' number of items, but it might return fewer.
#' 
#' This value is optional. If you include a value, it must be between 1 and
#' 100, inclusive. If you do not include a value, it defaults to 50.
#' @param Marker Use this parameter in a subsequent request after you receive a response
#' with truncated results. Set it to the value of `NextMarker` from the
#' truncated response you just received.
#' @param KeyId &#91;required&#93; Returns only grants for the specified KMS key. This parameter is
#' required.
#' 
#' Specify the key ID or key ARN of the KMS key. To specify a KMS key in a
#' different Amazon Web Services account, you must use the key ARN.
#' 
#' For example:
#' 
#' -   Key ID: `1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' -   Key ARN:
#'     `arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' To get the key ID and key ARN for a KMS key, use
#' [`list_keys`][kms_list_keys] or [`describe_key`][kms_describe_key].
#' @param GrantId Returns only the grant with the specified grant ID. The grant ID
#' uniquely identifies the grant.
#' @param GranteePrincipal Returns only grants where the specified principal is the grantee
#' principal for the grant.
#'
#' @keywords internal
#'
#' @rdname kms_list_grants
kms_list_grants <- function(Limit = NULL, Marker = NULL, KeyId, GrantId = NULL, GranteePrincipal = NULL) {
  op <- new_operation(
    name = "ListGrants",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kms$list_grants_input(Limit = Limit, Marker = Marker, KeyId = KeyId, GrantId = GrantId, GranteePrincipal = GranteePrincipal)
  output <- .kms$list_grants_output()
  config <- get_config()
  svc <- .kms$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kms$operations$list_grants <- kms_list_grants

#' Gets the names of the key policies that are attached to a KMS key
#'
#' @description
#' Gets the names of the key policies that are attached to a KMS key. This operation is designed to get policy names that you can use in a [`get_key_policy`][kms_get_key_policy] operation. However, the only valid policy name is `default`.
#'
#' See [https://paws-r.github.io/docs/kms/list_key_policies.html](https://paws-r.github.io/docs/kms/list_key_policies.html) for full documentation.
#'
#' @param KeyId &#91;required&#93; Gets the names of key policies for the specified KMS key.
#' 
#' Specify the key ID or key ARN of the KMS key.
#' 
#' For example:
#' 
#' -   Key ID: `1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' -   Key ARN:
#'     `arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' To get the key ID and key ARN for a KMS key, use
#' [`list_keys`][kms_list_keys] or [`describe_key`][kms_describe_key].
#' @param Limit Use this parameter to specify the maximum number of items to return.
#' When this value is present, KMS does not return more than the specified
#' number of items, but it might return fewer.
#' 
#' This value is optional. If you include a value, it must be between 1 and
#' 1000, inclusive. If you do not include a value, it defaults to 100.
#' 
#' Only one policy can be attached to a key.
#' @param Marker Use this parameter in a subsequent request after you receive a response
#' with truncated results. Set it to the value of `NextMarker` from the
#' truncated response you just received.
#'
#' @keywords internal
#'
#' @rdname kms_list_key_policies
kms_list_key_policies <- function(KeyId, Limit = NULL, Marker = NULL) {
  op <- new_operation(
    name = "ListKeyPolicies",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kms$list_key_policies_input(KeyId = KeyId, Limit = Limit, Marker = Marker)
  output <- .kms$list_key_policies_output()
  config <- get_config()
  svc <- .kms$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kms$operations$list_key_policies <- kms_list_key_policies

#' Gets a list of all KMS keys in the caller's Amazon Web Services account
#' and Region
#'
#' @description
#' Gets a list of all KMS keys in the caller's Amazon Web Services account and Region.
#'
#' See [https://paws-r.github.io/docs/kms/list_keys.html](https://paws-r.github.io/docs/kms/list_keys.html) for full documentation.
#'
#' @param Limit Use this parameter to specify the maximum number of items to return.
#' When this value is present, KMS does not return more than the specified
#' number of items, but it might return fewer.
#' 
#' This value is optional. If you include a value, it must be between 1 and
#' 1000, inclusive. If you do not include a value, it defaults to 100.
#' @param Marker Use this parameter in a subsequent request after you receive a response
#' with truncated results. Set it to the value of `NextMarker` from the
#' truncated response you just received.
#'
#' @keywords internal
#'
#' @rdname kms_list_keys
kms_list_keys <- function(Limit = NULL, Marker = NULL) {
  op <- new_operation(
    name = "ListKeys",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kms$list_keys_input(Limit = Limit, Marker = Marker)
  output <- .kms$list_keys_output()
  config <- get_config()
  svc <- .kms$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kms$operations$list_keys <- kms_list_keys

#' Returns all tags on the specified KMS key
#'
#' @description
#' Returns all tags on the specified KMS key.
#'
#' See [https://paws-r.github.io/docs/kms/list_resource_tags.html](https://paws-r.github.io/docs/kms/list_resource_tags.html) for full documentation.
#'
#' @param KeyId &#91;required&#93; Gets tags on the specified KMS key.
#' 
#' Specify the key ID or key ARN of the KMS key.
#' 
#' For example:
#' 
#' -   Key ID: `1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' -   Key ARN:
#'     `arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' To get the key ID and key ARN for a KMS key, use
#' [`list_keys`][kms_list_keys] or [`describe_key`][kms_describe_key].
#' @param Limit Use this parameter to specify the maximum number of items to return.
#' When this value is present, KMS does not return more than the specified
#' number of items, but it might return fewer.
#' 
#' This value is optional. If you include a value, it must be between 1 and
#' 50, inclusive. If you do not include a value, it defaults to 50.
#' @param Marker Use this parameter in a subsequent request after you receive a response
#' with truncated results. Set it to the value of `NextMarker` from the
#' truncated response you just received.
#' 
#' Do not attempt to construct this value. Use only the value of
#' `NextMarker` from the truncated response you just received.
#'
#' @keywords internal
#'
#' @rdname kms_list_resource_tags
kms_list_resource_tags <- function(KeyId, Limit = NULL, Marker = NULL) {
  op <- new_operation(
    name = "ListResourceTags",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kms$list_resource_tags_input(KeyId = KeyId, Limit = Limit, Marker = Marker)
  output <- .kms$list_resource_tags_output()
  config <- get_config()
  svc <- .kms$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kms$operations$list_resource_tags <- kms_list_resource_tags

#' Returns information about all grants in the Amazon Web Services account
#' and Region that have the specified retiring principal
#'
#' @description
#' Returns information about all grants in the Amazon Web Services account and Region that have the specified retiring principal.
#'
#' See [https://paws-r.github.io/docs/kms/list_retirable_grants.html](https://paws-r.github.io/docs/kms/list_retirable_grants.html) for full documentation.
#'
#' @param Limit Use this parameter to specify the maximum number of items to return.
#' When this value is present, KMS does not return more than the specified
#' number of items, but it might return fewer.
#' 
#' This value is optional. If you include a value, it must be between 1 and
#' 100, inclusive. If you do not include a value, it defaults to 50.
#' @param Marker Use this parameter in a subsequent request after you receive a response
#' with truncated results. Set it to the value of `NextMarker` from the
#' truncated response you just received.
#' @param RetiringPrincipal &#91;required&#93; The retiring principal for which to list grants. Enter a principal in
#' your Amazon Web Services account.
#' 
#' To specify the retiring principal, use the [Amazon Resource Name
#' (ARN)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
#' of an Amazon Web Services principal. Valid Amazon Web Services
#' principals include Amazon Web Services accounts (root), IAM users,
#' federated users, and assumed role users. For examples of the ARN syntax
#' for specifying a principal, see [Amazon Web Services Identity and Access
#' Management
#' (IAM)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-iam)
#' in the Example ARNs section of the *Amazon Web Services General
#' Reference*.
#'
#' @keywords internal
#'
#' @rdname kms_list_retirable_grants
kms_list_retirable_grants <- function(Limit = NULL, Marker = NULL, RetiringPrincipal) {
  op <- new_operation(
    name = "ListRetirableGrants",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kms$list_retirable_grants_input(Limit = Limit, Marker = Marker, RetiringPrincipal = RetiringPrincipal)
  output <- .kms$list_retirable_grants_output()
  config <- get_config()
  svc <- .kms$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kms$operations$list_retirable_grants <- kms_list_retirable_grants

#' Attaches a key policy to the specified KMS key
#'
#' @description
#' Attaches a key policy to the specified KMS key.
#'
#' See [https://paws-r.github.io/docs/kms/put_key_policy.html](https://paws-r.github.io/docs/kms/put_key_policy.html) for full documentation.
#'
#' @param KeyId &#91;required&#93; Sets the key policy on the specified KMS key.
#' 
#' Specify the key ID or key ARN of the KMS key.
#' 
#' For example:
#' 
#' -   Key ID: `1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' -   Key ARN:
#'     `arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' To get the key ID and key ARN for a KMS key, use
#' [`list_keys`][kms_list_keys] or [`describe_key`][kms_describe_key].
#' @param PolicyName &#91;required&#93; The name of the key policy. The only valid value is `default`.
#' @param Policy &#91;required&#93; The key policy to attach to the KMS key.
#' 
#' The key policy must meet the following criteria:
#' 
#' -   If you don't set `BypassPolicyLockoutSafetyCheck` to true, the key
#'     policy must allow the principal that is making the
#'     [`put_key_policy`][kms_put_key_policy] request to make a subsequent
#'     [`put_key_policy`][kms_put_key_policy] request on the KMS key. This
#'     reduces the risk that the KMS key becomes unmanageable. For more
#'     information, refer to the scenario in the [Default Key
#'     Policy](https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default-allow-root-enable-iam)
#'     section of the *Key Management Service Developer Guide*.
#' 
#' -   Each statement in the key policy must contain one or more
#'     principals. The principals in the key policy must exist and be
#'     visible to KMS. When you create a new Amazon Web Services principal
#'     (for example, an IAM user or role), you might need to enforce a
#'     delay before including the new principal in a key policy because the
#'     new principal might not be immediately visible to KMS. For more
#'     information, see [Changes that I make are not always immediately
#'     visible](https://docs.aws.amazon.com/IAM/latest/UserGuide/troubleshoot_general.html#troubleshoot_general_eventual-consistency)
#'     in the *Amazon Web Services Identity and Access Management User
#'     Guide*.
#' 
#' A key policy document can include only the following characters:
#' 
#' -   Printable ASCII characters from the space character (``U+0020``)
#'     through the end of the ASCII character range.
#' 
#' -   Printable characters in the Basic Latin and Latin-1 Supplement
#'     character set (through ``U+00FF``).
#' 
#' -   The tab (``U+0009``), line feed (``U+000A``), and carriage return
#'     (``U+000D``) special characters
#' 
#' For information about key policies, see [Key policies in
#' KMS](https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html)
#' in the *Key Management Service Developer Guide*. For help writing and
#' formatting a JSON policy document, see the [IAM JSON Policy
#' Reference](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies.html)
#' in the *Identity and Access Management User Guide* .
#' @param BypassPolicyLockoutSafetyCheck A flag to indicate whether to bypass the key policy lockout safety
#' check.
#' 
#' Setting this value to true increases the risk that the KMS key becomes
#' unmanageable. Do not set this value to true indiscriminately.
#' 
#' For more information, refer to the scenario in the [Default Key
#' Policy](https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default-allow-root-enable-iam)
#' section in the *Key Management Service Developer Guide*.
#' 
#' Use this parameter only when you intend to prevent the principal that is
#' making the request from making a subsequent
#' [`put_key_policy`][kms_put_key_policy] request on the KMS key.
#' 
#' The default value is false.
#'
#' @keywords internal
#'
#' @rdname kms_put_key_policy
kms_put_key_policy <- function(KeyId, PolicyName, Policy, BypassPolicyLockoutSafetyCheck = NULL) {
  op <- new_operation(
    name = "PutKeyPolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kms$put_key_policy_input(KeyId = KeyId, PolicyName = PolicyName, Policy = Policy, BypassPolicyLockoutSafetyCheck = BypassPolicyLockoutSafetyCheck)
  output <- .kms$put_key_policy_output()
  config <- get_config()
  svc <- .kms$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kms$operations$put_key_policy <- kms_put_key_policy

#' Decrypts ciphertext and then reencrypts it entirely within KMS
#'
#' @description
#' Decrypts ciphertext and then reencrypts it entirely within KMS. You can use this operation to change the KMS key under which data is encrypted, such as when you [manually rotate](https://docs.aws.amazon.com/kms/latest/developerguide/rotate-keys.html#rotate-keys-manually) a KMS key or change the KMS key that protects a ciphertext. You can also use it to reencrypt ciphertext under the same KMS key, such as to change the [encryption context](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#encrypt_context) of a ciphertext.
#'
#' See [https://paws-r.github.io/docs/kms/re_encrypt.html](https://paws-r.github.io/docs/kms/re_encrypt.html) for full documentation.
#'
#' @param CiphertextBlob &#91;required&#93; Ciphertext of the data to reencrypt.
#' @param SourceEncryptionContext Specifies the encryption context to use to decrypt the ciphertext. Enter
#' the same encryption context that was used to encrypt the ciphertext.
#' 
#' An *encryption context* is a collection of non-secret key-value pairs
#' that represent additional authenticated data. When you use an encryption
#' context to encrypt data, you must specify the same (an exact
#' case-sensitive match) encryption context to decrypt the data. An
#' encryption context is supported only on operations with symmetric
#' encryption KMS keys. On operations with symmetric encryption KMS keys,
#' an encryption context is optional, but it is strongly recommended.
#' 
#' For more information, see [Encryption
#' context](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#encrypt_context)
#' in the *Key Management Service Developer Guide*.
#' @param SourceKeyId Specifies the KMS key that KMS will use to decrypt the ciphertext before
#' it is re-encrypted.
#' 
#' Enter a key ID of the KMS key that was used to encrypt the ciphertext.
#' If you identify a different KMS key, the [`re_encrypt`][kms_re_encrypt]
#' operation throws an `IncorrectKeyException`.
#' 
#' This parameter is required only when the ciphertext was encrypted under
#' an asymmetric KMS key. If you used a symmetric encryption KMS key, KMS
#' can get the KMS key from metadata that it adds to the symmetric
#' ciphertext blob. However, it is always recommended as a best practice.
#' This practice ensures that you use the KMS key that you intend.
#' 
#' To specify a KMS key, use its key ID, key ARN, alias name, or alias ARN.
#' When using an alias name, prefix it with `"alias/"`. To specify a KMS
#' key in a different Amazon Web Services account, you must use the key ARN
#' or alias ARN.
#' 
#' For example:
#' 
#' -   Key ID: `1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' -   Key ARN:
#'     `arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' -   Alias name: `alias/ExampleAlias`
#' 
#' -   Alias ARN: `arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias`
#' 
#' To get the key ID and key ARN for a KMS key, use
#' [`list_keys`][kms_list_keys] or [`describe_key`][kms_describe_key]. To
#' get the alias name and alias ARN, use
#' [`list_aliases`][kms_list_aliases].
#' @param DestinationKeyId &#91;required&#93; A unique identifier for the KMS key that is used to reencrypt the data.
#' Specify a symmetric encryption KMS key or an asymmetric KMS key with a
#' `KeyUsage` value of `ENCRYPT_DECRYPT`. To find the `KeyUsage` value of a
#' KMS key, use the [`describe_key`][kms_describe_key] operation.
#' 
#' To specify a KMS key, use its key ID, key ARN, alias name, or alias ARN.
#' When using an alias name, prefix it with `"alias/"`. To specify a KMS
#' key in a different Amazon Web Services account, you must use the key ARN
#' or alias ARN.
#' 
#' For example:
#' 
#' -   Key ID: `1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' -   Key ARN:
#'     `arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' -   Alias name: `alias/ExampleAlias`
#' 
#' -   Alias ARN: `arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias`
#' 
#' To get the key ID and key ARN for a KMS key, use
#' [`list_keys`][kms_list_keys] or [`describe_key`][kms_describe_key]. To
#' get the alias name and alias ARN, use
#' [`list_aliases`][kms_list_aliases].
#' @param DestinationEncryptionContext Specifies that encryption context to use when the reencrypting the data.
#' 
#' A destination encryption context is valid only when the destination KMS
#' key is a symmetric encryption KMS key. The standard ciphertext format
#' for asymmetric KMS keys does not include fields for metadata.
#' 
#' An *encryption context* is a collection of non-secret key-value pairs
#' that represent additional authenticated data. When you use an encryption
#' context to encrypt data, you must specify the same (an exact
#' case-sensitive match) encryption context to decrypt the data. An
#' encryption context is supported only on operations with symmetric
#' encryption KMS keys. On operations with symmetric encryption KMS keys,
#' an encryption context is optional, but it is strongly recommended.
#' 
#' For more information, see [Encryption
#' context](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#encrypt_context)
#' in the *Key Management Service Developer Guide*.
#' @param SourceEncryptionAlgorithm Specifies the encryption algorithm that KMS will use to decrypt the
#' ciphertext before it is reencrypted. The default value,
#' `SYMMETRIC_DEFAULT`, represents the algorithm used for symmetric
#' encryption KMS keys.
#' 
#' Specify the same algorithm that was used to encrypt the ciphertext. If
#' you specify a different algorithm, the decrypt attempt fails.
#' 
#' This parameter is required only when the ciphertext was encrypted under
#' an asymmetric KMS key.
#' @param DestinationEncryptionAlgorithm Specifies the encryption algorithm that KMS will use to reecrypt the
#' data after it has decrypted it. The default value, `SYMMETRIC_DEFAULT`,
#' represents the encryption algorithm used for symmetric encryption KMS
#' keys.
#' 
#' This parameter is required only when the destination KMS key is an
#' asymmetric KMS key.
#' @param GrantTokens A list of grant tokens.
#' 
#' Use a grant token when your permission to call this operation comes from
#' a new grant that has not yet achieved *eventual consistency*. For more
#' information, see [Grant
#' token](https://docs.aws.amazon.com/kms/latest/developerguide/grants.html#grant_token)
#' and [Using a grant
#' token](https://docs.aws.amazon.com/kms/latest/developerguide/grant-manage.html#using-grant-token)
#' in the *Key Management Service Developer Guide*.
#'
#' @keywords internal
#'
#' @rdname kms_re_encrypt
kms_re_encrypt <- function(CiphertextBlob, SourceEncryptionContext = NULL, SourceKeyId = NULL, DestinationKeyId, DestinationEncryptionContext = NULL, SourceEncryptionAlgorithm = NULL, DestinationEncryptionAlgorithm = NULL, GrantTokens = NULL) {
  op <- new_operation(
    name = "ReEncrypt",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kms$re_encrypt_input(CiphertextBlob = CiphertextBlob, SourceEncryptionContext = SourceEncryptionContext, SourceKeyId = SourceKeyId, DestinationKeyId = DestinationKeyId, DestinationEncryptionContext = DestinationEncryptionContext, SourceEncryptionAlgorithm = SourceEncryptionAlgorithm, DestinationEncryptionAlgorithm = DestinationEncryptionAlgorithm, GrantTokens = GrantTokens)
  output <- .kms$re_encrypt_output()
  config <- get_config()
  svc <- .kms$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kms$operations$re_encrypt <- kms_re_encrypt

#' Replicates a multi-Region key into the specified Region
#'
#' @description
#' Replicates a multi-Region key into the specified Region. This operation creates a multi-Region replica key based on a multi-Region primary key in a different Region of the same Amazon Web Services partition. You can create multiple replicas of a primary key, but each must be in a different Region. To create a multi-Region primary key, use the [`create_key`][kms_create_key] operation.
#'
#' See [https://paws-r.github.io/docs/kms/replicate_key.html](https://paws-r.github.io/docs/kms/replicate_key.html) for full documentation.
#'
#' @param KeyId &#91;required&#93; Identifies the multi-Region primary key that is being replicated. To
#' determine whether a KMS key is a multi-Region primary key, use the
#' [`describe_key`][kms_describe_key] operation to check the value of the
#' `MultiRegionKeyType` property.
#' 
#' Specify the key ID or key ARN of a multi-Region primary key.
#' 
#' For example:
#' 
#' -   Key ID: `mrk-1234abcd12ab34cd56ef1234567890ab`
#' 
#' -   Key ARN:
#'     `arn:aws:kms:us-east-2:111122223333:key/mrk-1234abcd12ab34cd56ef1234567890ab`
#' 
#' To get the key ID and key ARN for a KMS key, use
#' [`list_keys`][kms_list_keys] or [`describe_key`][kms_describe_key].
#' @param ReplicaRegion &#91;required&#93; The Region ID of the Amazon Web Services Region for this replica key.
#' 
#' Enter the Region ID, such as `us-east-1` or `ap-southeast-2`. For a list
#' of Amazon Web Services Regions in which KMS is supported, see [KMS
#' service
#' endpoints](https://docs.aws.amazon.com/general/latest/gr/kms.html#kms_region)
#' in the *Amazon Web Services General Reference*.
#' 
#' HMAC KMS keys are not supported in all Amazon Web Services Regions. If
#' you try to replicate an HMAC KMS key in an Amazon Web Services Region in
#' which HMAC keys are not supported, the
#' [`replicate_key`][kms_replicate_key] operation returns an
#' `UnsupportedOperationException`. For a list of Regions in which HMAC KMS
#' keys are supported, see [HMAC keys in
#' KMS](https://docs.aws.amazon.com/kms/latest/developerguide/hmac.html) in
#' the *Key Management Service Developer Guide*.
#' 
#' The replica must be in a different Amazon Web Services Region than its
#' primary key and other replicas of that primary key, but in the same
#' Amazon Web Services partition. KMS must be available in the replica
#' Region. If the Region is not enabled by default, the Amazon Web Services
#' account must be enabled in the Region. For information about Amazon Web
#' Services partitions, see [Amazon Resource Names
#' (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
#' in the *Amazon Web Services General Reference*. For information about
#' enabling and disabling Regions, see [Enabling a
#' Region](https://docs.aws.amazon.com/general/latest/gr/rande-manage.html#rande-manage-enable)
#' and [Disabling a
#' Region](https://docs.aws.amazon.com/general/latest/gr/rande-manage.html#rande-manage-disable)
#' in the *Amazon Web Services General Reference*.
#' @param Policy The key policy to attach to the KMS key. This parameter is optional. If
#' you do not provide a key policy, KMS attaches the [default key
#' policy](https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default)
#' to the KMS key.
#' 
#' The key policy is not a shared property of multi-Region keys. You can
#' specify the same key policy or a different key policy for each key in a
#' set of related multi-Region keys. KMS does not synchronize this
#' property.
#' 
#' If you provide a key policy, it must meet the following criteria:
#' 
#' -   If you don't set `BypassPolicyLockoutSafetyCheck` to true, the key
#'     policy must give the caller `kms:PutKeyPolicy` permission on the
#'     replica key. This reduces the risk that the KMS key becomes
#'     unmanageable. For more information, refer to the scenario in the
#'     [Default Key
#'     Policy](https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default-allow-root-enable-iam)
#'     section of the *Key Management Service Developer Guide* .
#' 
#' -   Each statement in the key policy must contain one or more
#'     principals. The principals in the key policy must exist and be
#'     visible to KMS. When you create a new Amazon Web Services principal
#'     (for example, an IAM user or role), you might need to enforce a
#'     delay before including the new principal in a key policy because the
#'     new principal might not be immediately visible to KMS. For more
#'     information, see [Changes that I make are not always immediately
#'     visible](https://docs.aws.amazon.com/IAM/latest/UserGuide/troubleshoot_general.html#troubleshoot_general_eventual-consistency)
#'     in the *Identity and Access Management User Guide* .
#' 
#' A key policy document can include only the following characters:
#' 
#' -   Printable ASCII characters from the space character (``U+0020``)
#'     through the end of the ASCII character range.
#' 
#' -   Printable characters in the Basic Latin and Latin-1 Supplement
#'     character set (through ``U+00FF``).
#' 
#' -   The tab (``U+0009``), line feed (``U+000A``), and carriage return
#'     (``U+000D``) special characters
#' 
#' For information about key policies, see [Key policies in
#' KMS](https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html)
#' in the *Key Management Service Developer Guide*. For help writing and
#' formatting a JSON policy document, see the [IAM JSON Policy
#' Reference](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies.html)
#' in the *Identity and Access Management User Guide* .
#' @param BypassPolicyLockoutSafetyCheck A flag to indicate whether to bypass the key policy lockout safety
#' check.
#' 
#' Setting this value to true increases the risk that the KMS key becomes
#' unmanageable. Do not set this value to true indiscriminately.
#' 
#' For more information, refer to the scenario in the [Default Key
#' Policy](https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default-allow-root-enable-iam)
#' section in the *Key Management Service Developer Guide*.
#' 
#' Use this parameter only when you intend to prevent the principal that is
#' making the request from making a subsequent
#' [`put_key_policy`][kms_put_key_policy] request on the KMS key.
#' 
#' The default value is false.
#' @param Description A description of the KMS key. The default value is an empty string (no
#' description).
#' 
#' The description is not a shared property of multi-Region keys. You can
#' specify the same description or a different description for each key in
#' a set of related multi-Region keys. KMS does not synchronize this
#' property.
#' @param Tags Assigns one or more tags to the replica key. Use this parameter to tag
#' the KMS key when it is created. To tag an existing KMS key, use the
#' [`tag_resource`][kms_tag_resource] operation.
#' 
#' Tagging or untagging a KMS key can allow or deny permission to the KMS
#' key. For details, see [ABAC in
#' KMS](https://docs.aws.amazon.com/kms/latest/developerguide/abac.html) in
#' the *Key Management Service Developer Guide*.
#' 
#' To use this parameter, you must have
#' [kms:TagResource](https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html)
#' permission in an IAM policy.
#' 
#' Tags are not a shared property of multi-Region keys. You can specify the
#' same tags or different tags for each key in a set of related
#' multi-Region keys. KMS does not synchronize this property.
#' 
#' Each tag consists of a tag key and a tag value. Both the tag key and the
#' tag value are required, but the tag value can be an empty (null) string.
#' You cannot have more than one tag on a KMS key with the same tag key. If
#' you specify an existing tag key with a different tag value, KMS replaces
#' the current tag value with the specified one.
#' 
#' When you add tags to an Amazon Web Services resource, Amazon Web
#' Services generates a cost allocation report with usage and costs
#' aggregated by tags. Tags can also be used to control access to a KMS
#' key. For details, see [Tagging
#' Keys](https://docs.aws.amazon.com/kms/latest/developerguide/tagging-keys.html).
#'
#' @keywords internal
#'
#' @rdname kms_replicate_key
kms_replicate_key <- function(KeyId, ReplicaRegion, Policy = NULL, BypassPolicyLockoutSafetyCheck = NULL, Description = NULL, Tags = NULL) {
  op <- new_operation(
    name = "ReplicateKey",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kms$replicate_key_input(KeyId = KeyId, ReplicaRegion = ReplicaRegion, Policy = Policy, BypassPolicyLockoutSafetyCheck = BypassPolicyLockoutSafetyCheck, Description = Description, Tags = Tags)
  output <- .kms$replicate_key_output()
  config <- get_config()
  svc <- .kms$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kms$operations$replicate_key <- kms_replicate_key

#' Deletes a grant
#'
#' @description
#' Deletes a grant. Typically, you retire a grant when you no longer need its permissions. To identify the grant to retire, use a [grant token](https://docs.aws.amazon.com/kms/latest/developerguide/grants.html#grant_token), or both the grant ID and a key identifier (key ID or key ARN) of the KMS key. The [`create_grant`][kms_create_grant] operation returns both values.
#'
#' See [https://paws-r.github.io/docs/kms/retire_grant.html](https://paws-r.github.io/docs/kms/retire_grant.html) for full documentation.
#'
#' @param GrantToken Identifies the grant to be retired. You can use a grant token to
#' identify a new grant even before it has achieved eventual consistency.
#' 
#' Only the [`create_grant`][kms_create_grant] operation returns a grant
#' token. For details, see [Grant
#' token](https://docs.aws.amazon.com/kms/latest/developerguide/grants.html#grant_token)
#' and [Eventual
#' consistency](https://docs.aws.amazon.com/kms/latest/developerguide/grants.html#terms-eventual-consistency)
#' in the *Key Management Service Developer Guide*.
#' @param KeyId The key ARN KMS key associated with the grant. To find the key ARN, use
#' the [`list_keys`][kms_list_keys] operation.
#' 
#' For example:
#' `arn:aws:kms:us-east-2:444455556666:key/1234abcd-12ab-34cd-56ef-1234567890ab`
#' @param GrantId Identifies the grant to retire. To get the grant ID, use
#' [`create_grant`][kms_create_grant], [`list_grants`][kms_list_grants], or
#' [`list_retirable_grants`][kms_list_retirable_grants].
#' 
#' -   Grant ID Example -
#'     0123456789012345678901234567890123456789012345678901234567890123
#'
#' @keywords internal
#'
#' @rdname kms_retire_grant
kms_retire_grant <- function(GrantToken = NULL, KeyId = NULL, GrantId = NULL) {
  op <- new_operation(
    name = "RetireGrant",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kms$retire_grant_input(GrantToken = GrantToken, KeyId = KeyId, GrantId = GrantId)
  output <- .kms$retire_grant_output()
  config <- get_config()
  svc <- .kms$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kms$operations$retire_grant <- kms_retire_grant

#' Deletes the specified grant
#'
#' @description
#' Deletes the specified grant. You revoke a grant to terminate the permissions that the grant allows. For more information, see [Retiring and revoking grants](https://docs.aws.amazon.com/kms/latest/developerguide/#grant-delete) in the *Key Management Service Developer Guide* .
#'
#' See [https://paws-r.github.io/docs/kms/revoke_grant.html](https://paws-r.github.io/docs/kms/revoke_grant.html) for full documentation.
#'
#' @param KeyId &#91;required&#93; A unique identifier for the KMS key associated with the grant. To get
#' the key ID and key ARN for a KMS key, use [`list_keys`][kms_list_keys]
#' or [`describe_key`][kms_describe_key].
#' 
#' Specify the key ID or key ARN of the KMS key. To specify a KMS key in a
#' different Amazon Web Services account, you must use the key ARN.
#' 
#' For example:
#' 
#' -   Key ID: `1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' -   Key ARN:
#'     `arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' To get the key ID and key ARN for a KMS key, use
#' [`list_keys`][kms_list_keys] or [`describe_key`][kms_describe_key].
#' @param GrantId &#91;required&#93; Identifies the grant to revoke. To get the grant ID, use
#' [`create_grant`][kms_create_grant], [`list_grants`][kms_list_grants], or
#' [`list_retirable_grants`][kms_list_retirable_grants].
#'
#' @keywords internal
#'
#' @rdname kms_revoke_grant
kms_revoke_grant <- function(KeyId, GrantId) {
  op <- new_operation(
    name = "RevokeGrant",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kms$revoke_grant_input(KeyId = KeyId, GrantId = GrantId)
  output <- .kms$revoke_grant_output()
  config <- get_config()
  svc <- .kms$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kms$operations$revoke_grant <- kms_revoke_grant

#' Schedules the deletion of a KMS key
#'
#' @description
#' Schedules the deletion of a KMS key. By default, KMS applies a waiting period of 30 days, but you can specify a waiting period of 7-30 days. When this operation is successful, the key state of the KMS key changes to `PendingDeletion` and the key can't be used in any cryptographic operations. It remains in this state for the duration of the waiting period. Before the waiting period ends, you can use [`cancel_key_deletion`][kms_cancel_key_deletion] to cancel the deletion of the KMS key. After the waiting period ends, KMS deletes the KMS key, its key material, and all KMS data associated with it, including all aliases that refer to it.
#'
#' See [https://paws-r.github.io/docs/kms/schedule_key_deletion.html](https://paws-r.github.io/docs/kms/schedule_key_deletion.html) for full documentation.
#'
#' @param KeyId &#91;required&#93; The unique identifier of the KMS key to delete.
#' 
#' Specify the key ID or key ARN of the KMS key.
#' 
#' For example:
#' 
#' -   Key ID: `1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' -   Key ARN:
#'     `arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' To get the key ID and key ARN for a KMS key, use
#' [`list_keys`][kms_list_keys] or [`describe_key`][kms_describe_key].
#' @param PendingWindowInDays The waiting period, specified in number of days. After the waiting
#' period ends, KMS deletes the KMS key.
#' 
#' If the KMS key is a multi-Region primary key with replica keys, the
#' waiting period begins when the last of its replica keys is deleted.
#' Otherwise, the waiting period begins immediately.
#' 
#' This value is optional. If you include a value, it must be between 7 and
#' 30, inclusive. If you do not include a value, it defaults to 30.
#'
#' @keywords internal
#'
#' @rdname kms_schedule_key_deletion
kms_schedule_key_deletion <- function(KeyId, PendingWindowInDays = NULL) {
  op <- new_operation(
    name = "ScheduleKeyDeletion",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kms$schedule_key_deletion_input(KeyId = KeyId, PendingWindowInDays = PendingWindowInDays)
  output <- .kms$schedule_key_deletion_output()
  config <- get_config()
  svc <- .kms$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kms$operations$schedule_key_deletion <- kms_schedule_key_deletion

#' Creates a digital signature for a message or message digest by using the
#' private key in an asymmetric signing KMS key
#'
#' @description
#' Creates a [digital signature](https://en.wikipedia.org/wiki/Digital_signature) for a message or message digest by using the private key in an asymmetric signing KMS key. To verify the signature, use the [`verify`][kms_verify] operation, or use the public key in the same asymmetric KMS key outside of KMS. For information about asymmetric KMS keys, see [Asymmetric KMS keys](https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html) in the *Key Management Service Developer Guide*.
#'
#' See [https://paws-r.github.io/docs/kms/sign.html](https://paws-r.github.io/docs/kms/sign.html) for full documentation.
#'
#' @param KeyId &#91;required&#93; Identifies an asymmetric KMS key. KMS uses the private key in the
#' asymmetric KMS key to sign the message. The `KeyUsage` type of the KMS
#' key must be `SIGN_VERIFY`. To find the `KeyUsage` of a KMS key, use the
#' [`describe_key`][kms_describe_key] operation.
#' 
#' To specify a KMS key, use its key ID, key ARN, alias name, or alias ARN.
#' When using an alias name, prefix it with `"alias/"`. To specify a KMS
#' key in a different Amazon Web Services account, you must use the key ARN
#' or alias ARN.
#' 
#' For example:
#' 
#' -   Key ID: `1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' -   Key ARN:
#'     `arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' -   Alias name: `alias/ExampleAlias`
#' 
#' -   Alias ARN: `arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias`
#' 
#' To get the key ID and key ARN for a KMS key, use
#' [`list_keys`][kms_list_keys] or [`describe_key`][kms_describe_key]. To
#' get the alias name and alias ARN, use
#' [`list_aliases`][kms_list_aliases].
#' @param Message &#91;required&#93; Specifies the message or message digest to sign. Messages can be 0-4096
#' bytes. To sign a larger message, provide the message digest.
#' 
#' If you provide a message, KMS generates a hash digest of the message and
#' then signs it.
#' @param MessageType Tells KMS whether the value of the `Message` parameter is a message or
#' message digest. The default value, RAW, indicates a message. To indicate
#' a message digest, enter `DIGEST`.
#' @param GrantTokens A list of grant tokens.
#' 
#' Use a grant token when your permission to call this operation comes from
#' a new grant that has not yet achieved *eventual consistency*. For more
#' information, see [Grant
#' token](https://docs.aws.amazon.com/kms/latest/developerguide/grants.html#grant_token)
#' and [Using a grant
#' token](https://docs.aws.amazon.com/kms/latest/developerguide/grant-manage.html#using-grant-token)
#' in the *Key Management Service Developer Guide*.
#' @param SigningAlgorithm &#91;required&#93; Specifies the signing algorithm to use when signing the message.
#' 
#' Choose an algorithm that is compatible with the type and size of the
#' specified asymmetric KMS key.
#'
#' @keywords internal
#'
#' @rdname kms_sign
kms_sign <- function(KeyId, Message, MessageType = NULL, GrantTokens = NULL, SigningAlgorithm) {
  op <- new_operation(
    name = "Sign",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kms$sign_input(KeyId = KeyId, Message = Message, MessageType = MessageType, GrantTokens = GrantTokens, SigningAlgorithm = SigningAlgorithm)
  output <- .kms$sign_output()
  config <- get_config()
  svc <- .kms$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kms$operations$sign <- kms_sign

#' Adds or edits tags on a customer managed key
#'
#' @description
#' Adds or edits tags on a [customer managed key](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#customer-cmk).
#'
#' See [https://paws-r.github.io/docs/kms/tag_resource.html](https://paws-r.github.io/docs/kms/tag_resource.html) for full documentation.
#'
#' @param KeyId &#91;required&#93; Identifies a customer managed key in the account and Region.
#' 
#' Specify the key ID or key ARN of the KMS key.
#' 
#' For example:
#' 
#' -   Key ID: `1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' -   Key ARN:
#'     `arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' To get the key ID and key ARN for a KMS key, use
#' [`list_keys`][kms_list_keys] or [`describe_key`][kms_describe_key].
#' @param Tags &#91;required&#93; One or more tags.
#' 
#' Each tag consists of a tag key and a tag value. The tag value can be an
#' empty (null) string.
#' 
#' You cannot have more than one tag on a KMS key with the same tag key. If
#' you specify an existing tag key with a different tag value, KMS replaces
#' the current tag value with the specified one.
#'
#' @keywords internal
#'
#' @rdname kms_tag_resource
kms_tag_resource <- function(KeyId, Tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kms$tag_resource_input(KeyId = KeyId, Tags = Tags)
  output <- .kms$tag_resource_output()
  config <- get_config()
  svc <- .kms$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kms$operations$tag_resource <- kms_tag_resource

#' Deletes tags from a customer managed key
#'
#' @description
#' Deletes tags from a [customer managed key](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#customer-cmk). To delete a tag, specify the tag key and the KMS key.
#'
#' See [https://paws-r.github.io/docs/kms/untag_resource.html](https://paws-r.github.io/docs/kms/untag_resource.html) for full documentation.
#'
#' @param KeyId &#91;required&#93; Identifies the KMS key from which you are removing tags.
#' 
#' Specify the key ID or key ARN of the KMS key.
#' 
#' For example:
#' 
#' -   Key ID: `1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' -   Key ARN:
#'     `arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' To get the key ID and key ARN for a KMS key, use
#' [`list_keys`][kms_list_keys] or [`describe_key`][kms_describe_key].
#' @param TagKeys &#91;required&#93; One or more tag keys. Specify only the tag keys, not the tag values.
#'
#' @keywords internal
#'
#' @rdname kms_untag_resource
kms_untag_resource <- function(KeyId, TagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kms$untag_resource_input(KeyId = KeyId, TagKeys = TagKeys)
  output <- .kms$untag_resource_output()
  config <- get_config()
  svc <- .kms$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kms$operations$untag_resource <- kms_untag_resource

#' Associates an existing KMS alias with a different KMS key
#'
#' @description
#' Associates an existing KMS alias with a different KMS key. Each alias is associated with only one KMS key at a time, although a KMS key can have multiple aliases. The alias and the KMS key must be in the same Amazon Web Services account and Region.
#'
#' See [https://paws-r.github.io/docs/kms/update_alias.html](https://paws-r.github.io/docs/kms/update_alias.html) for full documentation.
#'
#' @param AliasName &#91;required&#93; Identifies the alias that is changing its KMS key. This value must begin
#' with `alias/` followed by the alias name, such as `alias/ExampleAlias`.
#' You cannot use [`update_alias`][kms_update_alias] to change the alias
#' name.
#' @param TargetKeyId &#91;required&#93; Identifies the [customer managed
#' key](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#customer-cmk)
#' to associate with the alias. You don't have permission to associate an
#' alias with an [Amazon Web Services managed
#' key](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#aws-managed-cmk).
#' 
#' The KMS key must be in the same Amazon Web Services account and Region
#' as the alias. Also, the new target KMS key must be the same type as the
#' current target KMS key (both symmetric or both asymmetric) and they must
#' have the same key usage.
#' 
#' Specify the key ID or key ARN of the KMS key.
#' 
#' For example:
#' 
#' -   Key ID: `1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' -   Key ARN:
#'     `arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' To get the key ID and key ARN for a KMS key, use
#' [`list_keys`][kms_list_keys] or [`describe_key`][kms_describe_key].
#' 
#' To verify that the alias is mapped to the correct KMS key, use
#' [`list_aliases`][kms_list_aliases].
#'
#' @keywords internal
#'
#' @rdname kms_update_alias
kms_update_alias <- function(AliasName, TargetKeyId) {
  op <- new_operation(
    name = "UpdateAlias",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kms$update_alias_input(AliasName = AliasName, TargetKeyId = TargetKeyId)
  output <- .kms$update_alias_output()
  config <- get_config()
  svc <- .kms$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kms$operations$update_alias <- kms_update_alias

#' Changes the properties of a custom key store
#'
#' @description
#' Changes the properties of a custom key store. Use the `CustomKeyStoreId` parameter to identify the custom key store you want to edit. Use the remaining parameters to change the properties of the custom key store.
#'
#' See [https://paws-r.github.io/docs/kms/update_custom_key_store.html](https://paws-r.github.io/docs/kms/update_custom_key_store.html) for full documentation.
#'
#' @param CustomKeyStoreId &#91;required&#93; Identifies the custom key store that you want to update. Enter the ID of
#' the custom key store. To find the ID of a custom key store, use the
#' [`describe_custom_key_stores`][kms_describe_custom_key_stores]
#' operation.
#' @param NewCustomKeyStoreName Changes the friendly name of the custom key store to the value that you
#' specify. The custom key store name must be unique in the Amazon Web
#' Services account.
#' @param KeyStorePassword Enter the current password of the `kmsuser` crypto user (CU) in the
#' CloudHSM cluster that is associated with the custom key store.
#' 
#' This parameter tells KMS the current password of the `kmsuser` crypto
#' user (CU). It does not set or change the password of any users in the
#' CloudHSM cluster.
#' @param CloudHsmClusterId Associates the custom key store with a related CloudHSM cluster.
#' 
#' Enter the cluster ID of the cluster that you used to create the custom
#' key store or a cluster that shares a backup history and has the same
#' cluster certificate as the original cluster. You cannot use this
#' parameter to associate a custom key store with an unrelated cluster. In
#' addition, the replacement cluster must [fulfill the
#' requirements](https://docs.aws.amazon.com/kms/latest/developerguide/create-keystore.html#before-keystore)
#' for a cluster associated with a custom key store. To view the cluster
#' certificate of a cluster, use the
#' [DescribeClusters](https://docs.aws.amazon.com/cloudhsm/latest/APIReference/API_DescribeClusters.html)
#' operation.
#'
#' @keywords internal
#'
#' @rdname kms_update_custom_key_store
kms_update_custom_key_store <- function(CustomKeyStoreId, NewCustomKeyStoreName = NULL, KeyStorePassword = NULL, CloudHsmClusterId = NULL) {
  op <- new_operation(
    name = "UpdateCustomKeyStore",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kms$update_custom_key_store_input(CustomKeyStoreId = CustomKeyStoreId, NewCustomKeyStoreName = NewCustomKeyStoreName, KeyStorePassword = KeyStorePassword, CloudHsmClusterId = CloudHsmClusterId)
  output <- .kms$update_custom_key_store_output()
  config <- get_config()
  svc <- .kms$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kms$operations$update_custom_key_store <- kms_update_custom_key_store

#' Updates the description of a KMS key
#'
#' @description
#' Updates the description of a KMS key. To see the description of a KMS key, use [`describe_key`][kms_describe_key].
#'
#' See [https://paws-r.github.io/docs/kms/update_key_description.html](https://paws-r.github.io/docs/kms/update_key_description.html) for full documentation.
#'
#' @param KeyId &#91;required&#93; Updates the description of the specified KMS key.
#' 
#' Specify the key ID or key ARN of the KMS key.
#' 
#' For example:
#' 
#' -   Key ID: `1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' -   Key ARN:
#'     `arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' To get the key ID and key ARN for a KMS key, use
#' [`list_keys`][kms_list_keys] or [`describe_key`][kms_describe_key].
#' @param Description &#91;required&#93; New description for the KMS key.
#'
#' @keywords internal
#'
#' @rdname kms_update_key_description
kms_update_key_description <- function(KeyId, Description) {
  op <- new_operation(
    name = "UpdateKeyDescription",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kms$update_key_description_input(KeyId = KeyId, Description = Description)
  output <- .kms$update_key_description_output()
  config <- get_config()
  svc <- .kms$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kms$operations$update_key_description <- kms_update_key_description

#' Changes the primary key of a multi-Region key
#'
#' @description
#' Changes the primary key of a multi-Region key.
#'
#' See [https://paws-r.github.io/docs/kms/update_primary_region.html](https://paws-r.github.io/docs/kms/update_primary_region.html) for full documentation.
#'
#' @param KeyId &#91;required&#93; Identifies the current primary key. When the operation completes, this
#' KMS key will be a replica key.
#' 
#' Specify the key ID or key ARN of a multi-Region primary key.
#' 
#' For example:
#' 
#' -   Key ID: `mrk-1234abcd12ab34cd56ef1234567890ab`
#' 
#' -   Key ARN:
#'     `arn:aws:kms:us-east-2:111122223333:key/mrk-1234abcd12ab34cd56ef1234567890ab`
#' 
#' To get the key ID and key ARN for a KMS key, use
#' [`list_keys`][kms_list_keys] or [`describe_key`][kms_describe_key].
#' @param PrimaryRegion &#91;required&#93; The Amazon Web Services Region of the new primary key. Enter the Region
#' ID, such as `us-east-1` or `ap-southeast-2`. There must be an existing
#' replica key in this Region.
#' 
#' When the operation completes, the multi-Region key in this Region will
#' be the primary key.
#'
#' @keywords internal
#'
#' @rdname kms_update_primary_region
kms_update_primary_region <- function(KeyId, PrimaryRegion) {
  op <- new_operation(
    name = "UpdatePrimaryRegion",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kms$update_primary_region_input(KeyId = KeyId, PrimaryRegion = PrimaryRegion)
  output <- .kms$update_primary_region_output()
  config <- get_config()
  svc <- .kms$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kms$operations$update_primary_region <- kms_update_primary_region

#' Verifies a digital signature that was generated by the Sign operation
#'
#' @description
#' Verifies a digital signature that was generated by the [`sign`][kms_sign] operation.
#'
#' See [https://paws-r.github.io/docs/kms/verify.html](https://paws-r.github.io/docs/kms/verify.html) for full documentation.
#'
#' @param KeyId &#91;required&#93; Identifies the asymmetric KMS key that will be used to verify the
#' signature. This must be the same KMS key that was used to generate the
#' signature. If you specify a different KMS key, the signature
#' verification fails.
#' 
#' To specify a KMS key, use its key ID, key ARN, alias name, or alias ARN.
#' When using an alias name, prefix it with `"alias/"`. To specify a KMS
#' key in a different Amazon Web Services account, you must use the key ARN
#' or alias ARN.
#' 
#' For example:
#' 
#' -   Key ID: `1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' -   Key ARN:
#'     `arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' -   Alias name: `alias/ExampleAlias`
#' 
#' -   Alias ARN: `arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias`
#' 
#' To get the key ID and key ARN for a KMS key, use
#' [`list_keys`][kms_list_keys] or [`describe_key`][kms_describe_key]. To
#' get the alias name and alias ARN, use
#' [`list_aliases`][kms_list_aliases].
#' @param Message &#91;required&#93; Specifies the message that was signed. You can submit a raw message of
#' up to 4096 bytes, or a hash digest of the message. If you submit a
#' digest, use the `MessageType` parameter with a value of `DIGEST`.
#' 
#' If the message specified here is different from the message that was
#' signed, the signature verification fails. A message and its hash digest
#' are considered to be the same message.
#' @param MessageType Tells KMS whether the value of the `Message` parameter is a message or
#' message digest. The default value, RAW, indicates a message. To indicate
#' a message digest, enter `DIGEST`.
#' 
#' Use the `DIGEST` value only when the value of the `Message` parameter is
#' a message digest. If you use the `DIGEST` value with a raw message, the
#' security of the verification operation can be compromised.
#' @param Signature &#91;required&#93; The signature that the [`sign`][kms_sign] operation generated.
#' @param SigningAlgorithm &#91;required&#93; The signing algorithm that was used to sign the message. If you submit a
#' different algorithm, the signature verification fails.
#' @param GrantTokens A list of grant tokens.
#' 
#' Use a grant token when your permission to call this operation comes from
#' a new grant that has not yet achieved *eventual consistency*. For more
#' information, see [Grant
#' token](https://docs.aws.amazon.com/kms/latest/developerguide/grants.html#grant_token)
#' and [Using a grant
#' token](https://docs.aws.amazon.com/kms/latest/developerguide/grant-manage.html#using-grant-token)
#' in the *Key Management Service Developer Guide*.
#'
#' @keywords internal
#'
#' @rdname kms_verify
kms_verify <- function(KeyId, Message, MessageType = NULL, Signature, SigningAlgorithm, GrantTokens = NULL) {
  op <- new_operation(
    name = "Verify",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kms$verify_input(KeyId = KeyId, Message = Message, MessageType = MessageType, Signature = Signature, SigningAlgorithm = SigningAlgorithm, GrantTokens = GrantTokens)
  output <- .kms$verify_output()
  config <- get_config()
  svc <- .kms$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kms$operations$verify <- kms_verify

#' Verifies the hash-based message authentication code (HMAC) for a
#' specified message, HMAC KMS key, and MAC algorithm
#'
#' @description
#' Verifies the hash-based message authentication code (HMAC) for a specified message, HMAC KMS key, and MAC algorithm. To verify the HMAC, [`verify_mac`][kms_verify_mac] computes an HMAC using the message, HMAC KMS key, and MAC algorithm that you specify, and compares the computed HMAC to the HMAC that you specify. If the HMACs are identical, the verification succeeds; otherwise, it fails.
#'
#' See [https://paws-r.github.io/docs/kms/verify_mac.html](https://paws-r.github.io/docs/kms/verify_mac.html) for full documentation.
#'
#' @param Message &#91;required&#93; The message that will be used in the verification. Enter the same
#' message that was used to generate the HMAC.
#' 
#' [`generate_mac`][kms_generate_mac] and [`verify_mac`][kms_verify_mac] do
#' not provide special handling for message digests. If you generated an
#' HMAC for a hash digest of a message, you must verify the HMAC for the
#' same hash digest.
#' @param KeyId &#91;required&#93; The KMS key that will be used in the verification.
#' 
#' Enter a key ID of the KMS key that was used to generate the HMAC. If you
#' identify a different KMS key, the [`verify_mac`][kms_verify_mac]
#' operation fails.
#' @param MacAlgorithm &#91;required&#93; The MAC algorithm that will be used in the verification. Enter the same
#' MAC algorithm that was used to compute the HMAC. This algorithm must be
#' supported by the HMAC KMS key identified by the `KeyId` parameter.
#' @param Mac &#91;required&#93; The HMAC to verify. Enter the HMAC that was generated by the
#' [`generate_mac`][kms_generate_mac] operation when you specified the same
#' message, HMAC KMS key, and MAC algorithm as the values specified in this
#' request.
#' @param GrantTokens A list of grant tokens.
#' 
#' Use a grant token when your permission to call this operation comes from
#' a new grant that has not yet achieved *eventual consistency*. For more
#' information, see [Grant
#' token](https://docs.aws.amazon.com/kms/latest/developerguide/grants.html#grant_token)
#' and [Using a grant
#' token](https://docs.aws.amazon.com/kms/latest/developerguide/grant-manage.html#using-grant-token)
#' in the *Key Management Service Developer Guide*.
#'
#' @keywords internal
#'
#' @rdname kms_verify_mac
kms_verify_mac <- function(Message, KeyId, MacAlgorithm, Mac, GrantTokens = NULL) {
  op <- new_operation(
    name = "VerifyMac",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kms$verify_mac_input(Message = Message, KeyId = KeyId, MacAlgorithm = MacAlgorithm, Mac = Mac, GrantTokens = GrantTokens)
  output <- .kms$verify_mac_output()
  config <- get_config()
  svc <- .kms$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kms$operations$verify_mac <- kms_verify_mac
