# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include ssooidc_service.R
NULL

#' Creates and returns an access token for the authorized client
#'
#' @description
#' Creates and returns an access token for the authorized client. The access token issued will be used to fetch short-term credentials for the assigned roles in the Amazon Web Services account.
#'
#' See [https://paws-r.github.io/docs/ssooidc/create_token.html](https://paws-r.github.io/docs/ssooidc/create_token.html) for full documentation.
#'
#' @param clientId &#91;required&#93; The unique identifier string for each client. This value should come
#' from the persisted result of the
#' [`register_client`][ssooidc_register_client] API.
#' @param clientSecret &#91;required&#93; A secret string generated for the client. This value should come from
#' the persisted result of the [`register_client`][ssooidc_register_client]
#' API.
#' @param grantType &#91;required&#93; Supports grant types for the authorization code, refresh token, and
#' device code request. For device code requests, specify the following
#' value:
#' 
#' `urn:ietf:params:oauth:grant-type:device_code `
#' 
#' For information about how to obtain the device code, see the
#' [`start_device_authorization`][ssooidc_start_device_authorization]
#' topic.
#' @param deviceCode &#91;required&#93; Used only when calling this API for the device code grant type. This
#' short-term code is used to identify this authentication attempt. This
#' should come from an in-memory reference to the result of the
#' [`start_device_authorization`][ssooidc_start_device_authorization] API.
#' @param code The authorization code received from the authorization service. This
#' parameter is required to perform an authorization grant request to get
#' access to a token.
#' @param refreshToken Currently, `refreshToken` is not yet implemented and is not supported.
#' For more information about the features and limitations of the current
#' Amazon Web Services SSO OIDC implementation, see *Considerations for
#' Using this Guide* in the [Amazon Web Services SSO OIDC API
#' Reference](https://docs.aws.amazon.com/singlesignon/latest/OIDCAPIReference/Welcome.html).
#' 
#' The token used to obtain an access token in the event that the access
#' token is invalid or expired.
#' @param scope The list of scopes that is defined by the client. Upon authorization,
#' this list is used to restrict permissions when granting an access token.
#' @param redirectUri The location of the application that will receive the authorization
#' code. Users authorize the service to send the request to this location.
#'
#' @keywords internal
#'
#' @rdname ssooidc_create_token
ssooidc_create_token <- function(clientId, clientSecret, grantType, deviceCode, code = NULL, refreshToken = NULL, scope = NULL, redirectUri = NULL) {
  op <- new_operation(
    name = "CreateToken",
    http_method = "POST",
    http_path = "/token",
    paginator = list()
  )
  input <- .ssooidc$create_token_input(clientId = clientId, clientSecret = clientSecret, grantType = grantType, deviceCode = deviceCode, code = code, refreshToken = refreshToken, scope = scope, redirectUri = redirectUri)
  output <- .ssooidc$create_token_output()
  config <- get_config()
  svc <- .ssooidc$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssooidc$operations$create_token <- ssooidc_create_token

#' Registers a client with Amazon Web Services SSO
#'
#' @description
#' Registers a client with Amazon Web Services SSO. This allows clients to initiate device authorization. The output should be persisted for reuse through many authentication requests.
#'
#' See [https://paws-r.github.io/docs/ssooidc/register_client.html](https://paws-r.github.io/docs/ssooidc/register_client.html) for full documentation.
#'
#' @param clientName &#91;required&#93; The friendly name of the client.
#' @param clientType &#91;required&#93; The type of client. The service supports only `public` as a client type.
#' Anything other than public will be rejected by the service.
#' @param scopes The list of scopes that are defined by the client. Upon authorization,
#' this list is used to restrict permissions when granting an access token.
#'
#' @keywords internal
#'
#' @rdname ssooidc_register_client
ssooidc_register_client <- function(clientName, clientType, scopes = NULL) {
  op <- new_operation(
    name = "RegisterClient",
    http_method = "POST",
    http_path = "/client/register",
    paginator = list()
  )
  input <- .ssooidc$register_client_input(clientName = clientName, clientType = clientType, scopes = scopes)
  output <- .ssooidc$register_client_output()
  config <- get_config()
  svc <- .ssooidc$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssooidc$operations$register_client <- ssooidc_register_client

#' Initiates device authorization by requesting a pair of verification
#' codes from the authorization service
#'
#' @description
#' Initiates device authorization by requesting a pair of verification codes from the authorization service.
#'
#' See [https://paws-r.github.io/docs/ssooidc/start_device_authorization.html](https://paws-r.github.io/docs/ssooidc/start_device_authorization.html) for full documentation.
#'
#' @param clientId &#91;required&#93; The unique identifier string for the client that is registered with
#' Amazon Web Services SSO. This value should come from the persisted
#' result of the [`register_client`][ssooidc_register_client] API
#' operation.
#' @param clientSecret &#91;required&#93; A secret string that is generated for the client. This value should come
#' from the persisted result of the
#' [`register_client`][ssooidc_register_client] API operation.
#' @param startUrl &#91;required&#93; The URL for the AWS access portal. For more information, see [Using the
#' AWS access
#' portal](https://docs.aws.amazon.com/singlesignon/latest/userguide/using-the-portal.html)
#' in the *Amazon Web Services SSO User Guide*.
#'
#' @keywords internal
#'
#' @rdname ssooidc_start_device_authorization
ssooidc_start_device_authorization <- function(clientId, clientSecret, startUrl) {
  op <- new_operation(
    name = "StartDeviceAuthorization",
    http_method = "POST",
    http_path = "/device_authorization",
    paginator = list()
  )
  input <- .ssooidc$start_device_authorization_input(clientId = clientId, clientSecret = clientSecret, startUrl = startUrl)
  output <- .ssooidc$start_device_authorization_output()
  config <- get_config()
  svc <- .ssooidc$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssooidc$operations$start_device_authorization <- ssooidc_start_device_authorization
