% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/directoryservice_operations.R
\name{directoryservice_connect_directory}
\alias{directoryservice_connect_directory}
\title{Creates an AD Connector to connect to a self-managed directory}
\usage{
directoryservice_connect_directory(
  Name,
  ShortName = NULL,
  Password,
  Description = NULL,
  Size,
  ConnectSettings,
  Tags = NULL
)
}
\arguments{
\item{Name}{[required] The fully qualified name of your self-managed directory, such as
\code{corp.example.com}.}

\item{ShortName}{The NetBIOS name of your self-managed directory, such as \code{CORP}.}

\item{Password}{[required] The password for your self-managed user account.}

\item{Description}{A description for the directory.}

\item{Size}{[required] The size of the directory.}

\item{ConnectSettings}{[required] A DirectoryConnectSettings object that contains additional information
for the operation.}

\item{Tags}{The tags to be assigned to AD Connector.}
}
\description{
Creates an AD Connector to connect to a self-managed directory.

See \url{https://paws-r.github.io/docs/directoryservice/connect_directory.html} for full documentation.
}
\keyword{internal}
