% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kms_operations.R
\name{kms_get_public_key}
\alias{kms_get_public_key}
\title{Returns the public key of an asymmetric KMS key}
\usage{
kms_get_public_key(KeyId, GrantTokens = NULL)
}
\arguments{
\item{KeyId}{[required] Identifies the asymmetric KMS key that includes the public key.

To specify a KMS key, use its key ID, key ARN, alias name, or alias ARN.
When using an alias name, prefix it with \code{"alias/"}. To specify a KMS
key in a different Amazon Web Services account, you must use the key ARN
or alias ARN.

For example:
\itemize{
\item Key ID: \verb{1234abcd-12ab-34cd-56ef-1234567890ab}
\item Key ARN:
\verb{arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab}
\item Alias name: \code{alias/ExampleAlias}
\item Alias ARN: \code{arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias}
}

To get the key ID and key ARN for a KMS key, use
\code{\link[=kms_list_keys]{list_keys}} or \code{\link[=kms_describe_key]{describe_key}}. To
get the alias name and alias ARN, use
\code{\link[=kms_list_aliases]{list_aliases}}.}

\item{GrantTokens}{A list of grant tokens.

Use a grant token when your permission to call this operation comes from
a new grant that has not yet achieved \emph{eventual consistency}. For more
information, see \href{https://docs.aws.amazon.com/kms/latest/developerguide/grants.html#grant_token}{Grant token}
and \href{https://docs.aws.amazon.com/kms/latest/developerguide/grant-manage.html#using-grant-token}{Using a grant token}
in the \emph{Key Management Service Developer Guide}.}
}
\description{
Returns the public key of an asymmetric KMS key. Unlike the private key of a asymmetric KMS key, which never leaves KMS unencrypted, callers with \code{kms:GetPublicKey} permission can download the public key of an asymmetric KMS key. You can share the public key to allow others to encrypt messages and verify signatures outside of KMS. For information about asymmetric KMS keys, see \href{https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html}{Asymmetric KMS keys} in the \emph{Key Management Service Developer Guide}.

See \url{https://www.paws-r-sdk.com/docs/kms_get_public_key/} for full documentation.
}
\keyword{internal}
