# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include shield_service.R
NULL

#' Authorizes the Shield Response Team (SRT) to access the specified Amazon
#' S3 bucket containing log data such as Application Load Balancer access
#' logs, CloudFront logs, or logs from third party sources
#'
#' @description
#' Authorizes the Shield Response Team (SRT) to access the specified Amazon S3 bucket containing log data such as Application Load Balancer access logs, CloudFront logs, or logs from third party sources. You can associate up to 10 Amazon S3 buckets with your subscription.
#'
#' See [https://www.paws-r-sdk.com/docs/shield_associate_drt_log_bucket/](https://www.paws-r-sdk.com/docs/shield_associate_drt_log_bucket/) for full documentation.
#'
#' @param LogBucket &#91;required&#93; The Amazon S3 bucket that contains the logs that you want to share.
#'
#' @keywords internal
#'
#' @rdname shield_associate_drt_log_bucket
shield_associate_drt_log_bucket <- function(LogBucket) {
  op <- new_operation(
    name = "AssociateDRTLogBucket",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .shield$associate_drt_log_bucket_input(LogBucket = LogBucket)
  output <- .shield$associate_drt_log_bucket_output()
  config <- get_config()
  svc <- .shield$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.shield$operations$associate_drt_log_bucket <- shield_associate_drt_log_bucket

#' Authorizes the Shield Response Team (SRT) using the specified role, to
#' access your Amazon Web Services account to assist with DDoS attack
#' mitigation during potential attacks
#'
#' @description
#' Authorizes the Shield Response Team (SRT) using the specified role, to access your Amazon Web Services account to assist with DDoS attack mitigation during potential attacks. This enables the SRT to inspect your WAF configuration and create or update WAF rules and web ACLs.
#'
#' See [https://www.paws-r-sdk.com/docs/shield_associate_drt_role/](https://www.paws-r-sdk.com/docs/shield_associate_drt_role/) for full documentation.
#'
#' @param RoleArn &#91;required&#93; The Amazon Resource Name (ARN) of the role the SRT will use to access
#' your Amazon Web Services account.
#' 
#' Prior to making the [`associate_drt_role`][shield_associate_drt_role]
#' request, you must attach the AWSShieldDRTAccessPolicy managed policy to
#' this role. For more information see Attaching and Detaching IAM
#' Policies.
#'
#' @keywords internal
#'
#' @rdname shield_associate_drt_role
shield_associate_drt_role <- function(RoleArn) {
  op <- new_operation(
    name = "AssociateDRTRole",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .shield$associate_drt_role_input(RoleArn = RoleArn)
  output <- .shield$associate_drt_role_output()
  config <- get_config()
  svc <- .shield$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.shield$operations$associate_drt_role <- shield_associate_drt_role

#' Adds health-based detection to the Shield Advanced protection for a
#' resource
#'
#' @description
#' Adds health-based detection to the Shield Advanced protection for a resource. Shield Advanced health-based detection uses the health of your Amazon Web Services resource to improve responsiveness and accuracy in attack detection and response.
#'
#' See [https://www.paws-r-sdk.com/docs/shield_associate_health_check/](https://www.paws-r-sdk.com/docs/shield_associate_health_check/) for full documentation.
#'
#' @param ProtectionId &#91;required&#93; The unique identifier (ID) for the Protection object to add the health
#' check association to.
#' @param HealthCheckArn &#91;required&#93; The Amazon Resource Name (ARN) of the health check to associate with the
#' protection.
#'
#' @keywords internal
#'
#' @rdname shield_associate_health_check
shield_associate_health_check <- function(ProtectionId, HealthCheckArn) {
  op <- new_operation(
    name = "AssociateHealthCheck",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .shield$associate_health_check_input(ProtectionId = ProtectionId, HealthCheckArn = HealthCheckArn)
  output <- .shield$associate_health_check_output()
  config <- get_config()
  svc <- .shield$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.shield$operations$associate_health_check <- shield_associate_health_check

#' Initializes proactive engagement and sets the list of contacts for the
#' Shield Response Team (SRT) to use
#'
#' @description
#' Initializes proactive engagement and sets the list of contacts for the Shield Response Team (SRT) to use. You must provide at least one phone number in the emergency contact list.
#'
#' See [https://www.paws-r-sdk.com/docs/shield_associate_proactive_engagement_details/](https://www.paws-r-sdk.com/docs/shield_associate_proactive_engagement_details/) for full documentation.
#'
#' @param EmergencyContactList &#91;required&#93; A list of email addresses and phone numbers that the Shield Response
#' Team (SRT) can use to contact you for escalations to the SRT and to
#' initiate proactive customer support.
#' 
#' To enable proactive engagement, the contact list must include at least
#' one phone number.
#' 
#' The contacts that you provide here replace any contacts that were
#' already defined. If you already have contacts defined and want to use
#' them, retrieve the list using
#' [`describe_emergency_contact_settings`][shield_describe_emergency_contact_settings]
#' and then provide it here.
#'
#' @keywords internal
#'
#' @rdname shield_associate_proactive_engagement_details
shield_associate_proactive_engagement_details <- function(EmergencyContactList) {
  op <- new_operation(
    name = "AssociateProactiveEngagementDetails",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .shield$associate_proactive_engagement_details_input(EmergencyContactList = EmergencyContactList)
  output <- .shield$associate_proactive_engagement_details_output()
  config <- get_config()
  svc <- .shield$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.shield$operations$associate_proactive_engagement_details <- shield_associate_proactive_engagement_details

#' Enables Shield Advanced for a specific Amazon Web Services resource
#'
#' @description
#' Enables Shield Advanced for a specific Amazon Web Services resource. The resource can be an Amazon CloudFront distribution, Amazon Route 53 hosted zone, Global Accelerator standard accelerator, Elastic IP Address, Application Load Balancer, or a Classic Load Balancer. You can protect Amazon EC2 instances and Network Load Balancers by association with protected Amazon EC2 Elastic IP addresses.
#'
#' See [https://www.paws-r-sdk.com/docs/shield_create_protection/](https://www.paws-r-sdk.com/docs/shield_create_protection/) for full documentation.
#'
#' @param Name &#91;required&#93; Friendly name for the `Protection` you are creating.
#' @param ResourceArn &#91;required&#93; The ARN (Amazon Resource Name) of the resource to be protected.
#' 
#' The ARN should be in one of the following formats:
#' 
#' -   For an Application Load Balancer:
#'     `arn:aws:elasticloadbalancing:region:account-id:loadbalancer/app/load-balancer-name/load-balancer-id `
#' 
#' -   For an Elastic Load Balancer (Classic Load Balancer):
#'     `arn:aws:elasticloadbalancing:region:account-id:loadbalancer/load-balancer-name `
#' 
#' -   For an Amazon CloudFront distribution:
#'     `arn:aws:cloudfront::account-id:distribution/distribution-id `
#' 
#' -   For an Global Accelerator standard accelerator:
#'     `arn:aws:globalaccelerator::account-id:accelerator/accelerator-id `
#' 
#' -   For Amazon Route 53: `arn:aws:route53:::hostedzone/hosted-zone-id `
#' 
#' -   For an Elastic IP address:
#'     `arn:aws:ec2:region:account-id:eip-allocation/allocation-id `
#' @param Tags One or more tag key-value pairs for the Protection object that is
#' created.
#'
#' @keywords internal
#'
#' @rdname shield_create_protection
shield_create_protection <- function(Name, ResourceArn, Tags = NULL) {
  op <- new_operation(
    name = "CreateProtection",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .shield$create_protection_input(Name = Name, ResourceArn = ResourceArn, Tags = Tags)
  output <- .shield$create_protection_output()
  config <- get_config()
  svc <- .shield$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.shield$operations$create_protection <- shield_create_protection

#' Creates a grouping of protected resources so they can be handled as a
#' collective
#'
#' @description
#' Creates a grouping of protected resources so they can be handled as a collective. This resource grouping improves the accuracy of detection and reduces false positives.
#'
#' See [https://www.paws-r-sdk.com/docs/shield_create_protection_group/](https://www.paws-r-sdk.com/docs/shield_create_protection_group/) for full documentation.
#'
#' @param ProtectionGroupId &#91;required&#93; The name of the protection group. You use this to identify the
#' protection group in lists and to manage the protection group, for
#' example to update, delete, or describe it.
#' @param Aggregation &#91;required&#93; Defines how Shield combines resource data for the group in order to
#' detect, mitigate, and report events.
#' 
#' -   Sum - Use the total traffic across the group. This is a good choice
#'     for most cases. Examples include Elastic IP addresses for EC2
#'     instances that scale manually or automatically.
#' 
#' -   Mean - Use the average of the traffic across the group. This is a
#'     good choice for resources that share traffic uniformly. Examples
#'     include accelerators and load balancers.
#' 
#' -   Max - Use the highest traffic from each resource. This is useful for
#'     resources that don't share traffic and for resources that share that
#'     traffic in a non-uniform way. Examples include Amazon CloudFront and
#'     origin resources for CloudFront distributions.
#' @param Pattern &#91;required&#93; The criteria to use to choose the protected resources for inclusion in
#' the group. You can include all resources that have protections, provide
#' a list of resource Amazon Resource Names (ARNs), or include all
#' resources of a specified resource type.
#' @param ResourceType The resource type to include in the protection group. All protected
#' resources of this type are included in the protection group. Newly
#' protected resources of this type are automatically added to the group.
#' You must set this when you set `Pattern` to `BY_RESOURCE_TYPE` and you
#' must not set it for any other `Pattern` setting.
#' @param Members The Amazon Resource Names (ARNs) of the resources to include in the
#' protection group. You must set this when you set `Pattern` to
#' `ARBITRARY` and you must not set it for any other `Pattern` setting.
#' @param Tags One or more tag key-value pairs for the protection group.
#'
#' @keywords internal
#'
#' @rdname shield_create_protection_group
shield_create_protection_group <- function(ProtectionGroupId, Aggregation, Pattern, ResourceType = NULL, Members = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateProtectionGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .shield$create_protection_group_input(ProtectionGroupId = ProtectionGroupId, Aggregation = Aggregation, Pattern = Pattern, ResourceType = ResourceType, Members = Members, Tags = Tags)
  output <- .shield$create_protection_group_output()
  config <- get_config()
  svc <- .shield$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.shield$operations$create_protection_group <- shield_create_protection_group

#' Activates Shield Advanced for an account
#'
#' @description
#' Activates Shield Advanced for an account.
#'
#' See [https://www.paws-r-sdk.com/docs/shield_create_subscription/](https://www.paws-r-sdk.com/docs/shield_create_subscription/) for full documentation.
#'
#' @keywords internal
#'
#' @rdname shield_create_subscription
shield_create_subscription <- function() {
  op <- new_operation(
    name = "CreateSubscription",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .shield$create_subscription_input()
  output <- .shield$create_subscription_output()
  config <- get_config()
  svc <- .shield$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.shield$operations$create_subscription <- shield_create_subscription

#' Deletes an Shield Advanced Protection
#'
#' @description
#' Deletes an Shield Advanced Protection.
#'
#' See [https://www.paws-r-sdk.com/docs/shield_delete_protection/](https://www.paws-r-sdk.com/docs/shield_delete_protection/) for full documentation.
#'
#' @param ProtectionId &#91;required&#93; The unique identifier (ID) for the Protection object to be deleted.
#'
#' @keywords internal
#'
#' @rdname shield_delete_protection
shield_delete_protection <- function(ProtectionId) {
  op <- new_operation(
    name = "DeleteProtection",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .shield$delete_protection_input(ProtectionId = ProtectionId)
  output <- .shield$delete_protection_output()
  config <- get_config()
  svc <- .shield$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.shield$operations$delete_protection <- shield_delete_protection

#' Removes the specified protection group
#'
#' @description
#' Removes the specified protection group.
#'
#' See [https://www.paws-r-sdk.com/docs/shield_delete_protection_group/](https://www.paws-r-sdk.com/docs/shield_delete_protection_group/) for full documentation.
#'
#' @param ProtectionGroupId &#91;required&#93; The name of the protection group. You use this to identify the
#' protection group in lists and to manage the protection group, for
#' example to update, delete, or describe it.
#'
#' @keywords internal
#'
#' @rdname shield_delete_protection_group
shield_delete_protection_group <- function(ProtectionGroupId) {
  op <- new_operation(
    name = "DeleteProtectionGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .shield$delete_protection_group_input(ProtectionGroupId = ProtectionGroupId)
  output <- .shield$delete_protection_group_output()
  config <- get_config()
  svc <- .shield$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.shield$operations$delete_protection_group <- shield_delete_protection_group

#' Removes Shield Advanced from an account
#'
#' @description
#' Removes Shield Advanced from an account. Shield Advanced requires a 1-year subscription commitment. You cannot delete a subscription prior to the completion of that commitment.
#'
#' See [https://www.paws-r-sdk.com/docs/shield_delete_subscription/](https://www.paws-r-sdk.com/docs/shield_delete_subscription/) for full documentation.
#'
#' @keywords internal
#'
#' @rdname shield_delete_subscription
shield_delete_subscription <- function() {
  op <- new_operation(
    name = "DeleteSubscription",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .shield$delete_subscription_input()
  output <- .shield$delete_subscription_output()
  config <- get_config()
  svc <- .shield$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.shield$operations$delete_subscription <- shield_delete_subscription

#' Describes the details of a DDoS attack
#'
#' @description
#' Describes the details of a DDoS attack.
#'
#' See [https://www.paws-r-sdk.com/docs/shield_describe_attack/](https://www.paws-r-sdk.com/docs/shield_describe_attack/) for full documentation.
#'
#' @param AttackId &#91;required&#93; The unique identifier (ID) for the attack.
#'
#' @keywords internal
#'
#' @rdname shield_describe_attack
shield_describe_attack <- function(AttackId) {
  op <- new_operation(
    name = "DescribeAttack",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .shield$describe_attack_input(AttackId = AttackId)
  output <- .shield$describe_attack_output()
  config <- get_config()
  svc <- .shield$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.shield$operations$describe_attack <- shield_describe_attack

#' Provides information about the number and type of attacks Shield has
#' detected in the last year for all resources that belong to your account,
#' regardless of whether you've defined Shield protections for them
#'
#' @description
#' Provides information about the number and type of attacks Shield has detected in the last year for all resources that belong to your account, regardless of whether you've defined Shield protections for them. This operation is available to Shield customers as well as to Shield Advanced customers.
#'
#' See [https://www.paws-r-sdk.com/docs/shield_describe_attack_statistics/](https://www.paws-r-sdk.com/docs/shield_describe_attack_statistics/) for full documentation.
#'
#' @keywords internal
#'
#' @rdname shield_describe_attack_statistics
shield_describe_attack_statistics <- function() {
  op <- new_operation(
    name = "DescribeAttackStatistics",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .shield$describe_attack_statistics_input()
  output <- .shield$describe_attack_statistics_output()
  config <- get_config()
  svc <- .shield$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.shield$operations$describe_attack_statistics <- shield_describe_attack_statistics

#' Returns the current role and list of Amazon S3 log buckets used by the
#' Shield Response Team (SRT) to access your Amazon Web Services account
#' while assisting with attack mitigation
#'
#' @description
#' Returns the current role and list of Amazon S3 log buckets used by the Shield Response Team (SRT) to access your Amazon Web Services account while assisting with attack mitigation.
#'
#' See [https://www.paws-r-sdk.com/docs/shield_describe_drt_access/](https://www.paws-r-sdk.com/docs/shield_describe_drt_access/) for full documentation.
#'
#' @keywords internal
#'
#' @rdname shield_describe_drt_access
shield_describe_drt_access <- function() {
  op <- new_operation(
    name = "DescribeDRTAccess",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .shield$describe_drt_access_input()
  output <- .shield$describe_drt_access_output()
  config <- get_config()
  svc <- .shield$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.shield$operations$describe_drt_access <- shield_describe_drt_access

#' A list of email addresses and phone numbers that the Shield Response
#' Team (SRT) can use to contact you if you have proactive engagement
#' enabled, for escalations to the SRT and to initiate proactive customer
#' support
#'
#' @description
#' A list of email addresses and phone numbers that the Shield Response Team (SRT) can use to contact you if you have proactive engagement enabled, for escalations to the SRT and to initiate proactive customer support.
#'
#' See [https://www.paws-r-sdk.com/docs/shield_describe_emergency_contact_settings/](https://www.paws-r-sdk.com/docs/shield_describe_emergency_contact_settings/) for full documentation.
#'
#' @keywords internal
#'
#' @rdname shield_describe_emergency_contact_settings
shield_describe_emergency_contact_settings <- function() {
  op <- new_operation(
    name = "DescribeEmergencyContactSettings",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .shield$describe_emergency_contact_settings_input()
  output <- .shield$describe_emergency_contact_settings_output()
  config <- get_config()
  svc <- .shield$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.shield$operations$describe_emergency_contact_settings <- shield_describe_emergency_contact_settings

#' Lists the details of a Protection object
#'
#' @description
#' Lists the details of a Protection object.
#'
#' See [https://www.paws-r-sdk.com/docs/shield_describe_protection/](https://www.paws-r-sdk.com/docs/shield_describe_protection/) for full documentation.
#'
#' @param ProtectionId The unique identifier (ID) for the Protection object to describe. You
#' must provide either the `ResourceArn` of the protected resource or the
#' `ProtectionID` of the protection, but not both.
#' @param ResourceArn The ARN (Amazon Resource Name) of the protected Amazon Web Services
#' resource. You must provide either the `ResourceArn` of the protected
#' resource or the `ProtectionID` of the protection, but not both.
#'
#' @keywords internal
#'
#' @rdname shield_describe_protection
shield_describe_protection <- function(ProtectionId = NULL, ResourceArn = NULL) {
  op <- new_operation(
    name = "DescribeProtection",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .shield$describe_protection_input(ProtectionId = ProtectionId, ResourceArn = ResourceArn)
  output <- .shield$describe_protection_output()
  config <- get_config()
  svc <- .shield$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.shield$operations$describe_protection <- shield_describe_protection

#' Returns the specification for the specified protection group
#'
#' @description
#' Returns the specification for the specified protection group.
#'
#' See [https://www.paws-r-sdk.com/docs/shield_describe_protection_group/](https://www.paws-r-sdk.com/docs/shield_describe_protection_group/) for full documentation.
#'
#' @param ProtectionGroupId &#91;required&#93; The name of the protection group. You use this to identify the
#' protection group in lists and to manage the protection group, for
#' example to update, delete, or describe it.
#'
#' @keywords internal
#'
#' @rdname shield_describe_protection_group
shield_describe_protection_group <- function(ProtectionGroupId) {
  op <- new_operation(
    name = "DescribeProtectionGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .shield$describe_protection_group_input(ProtectionGroupId = ProtectionGroupId)
  output <- .shield$describe_protection_group_output()
  config <- get_config()
  svc <- .shield$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.shield$operations$describe_protection_group <- shield_describe_protection_group

#' Provides details about the Shield Advanced subscription for an account
#'
#' @description
#' Provides details about the Shield Advanced subscription for an account.
#'
#' See [https://www.paws-r-sdk.com/docs/shield_describe_subscription/](https://www.paws-r-sdk.com/docs/shield_describe_subscription/) for full documentation.
#'
#' @keywords internal
#'
#' @rdname shield_describe_subscription
shield_describe_subscription <- function() {
  op <- new_operation(
    name = "DescribeSubscription",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .shield$describe_subscription_input()
  output <- .shield$describe_subscription_output()
  config <- get_config()
  svc <- .shield$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.shield$operations$describe_subscription <- shield_describe_subscription

#' Disable the Shield Advanced automatic application layer DDoS mitigation
#' feature for the protected resource
#'
#' @description
#' Disable the Shield Advanced automatic application layer DDoS mitigation feature for the protected resource. This stops Shield Advanced from creating, verifying, and applying WAF rules for attacks that it detects for the resource.
#'
#' See [https://www.paws-r-sdk.com/docs/shield_disable_application_layer_automatic_response/](https://www.paws-r-sdk.com/docs/shield_disable_application_layer_automatic_response/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The ARN (Amazon Resource Name) of the protected resource.
#'
#' @keywords internal
#'
#' @rdname shield_disable_application_layer_automatic_response
shield_disable_application_layer_automatic_response <- function(ResourceArn) {
  op <- new_operation(
    name = "DisableApplicationLayerAutomaticResponse",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .shield$disable_application_layer_automatic_response_input(ResourceArn = ResourceArn)
  output <- .shield$disable_application_layer_automatic_response_output()
  config <- get_config()
  svc <- .shield$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.shield$operations$disable_application_layer_automatic_response <- shield_disable_application_layer_automatic_response

#' Removes authorization from the Shield Response Team (SRT) to notify
#' contacts about escalations to the SRT and to initiate proactive customer
#' support
#'
#' @description
#' Removes authorization from the Shield Response Team (SRT) to notify contacts about escalations to the SRT and to initiate proactive customer support.
#'
#' See [https://www.paws-r-sdk.com/docs/shield_disable_proactive_engagement/](https://www.paws-r-sdk.com/docs/shield_disable_proactive_engagement/) for full documentation.
#'
#' @keywords internal
#'
#' @rdname shield_disable_proactive_engagement
shield_disable_proactive_engagement <- function() {
  op <- new_operation(
    name = "DisableProactiveEngagement",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .shield$disable_proactive_engagement_input()
  output <- .shield$disable_proactive_engagement_output()
  config <- get_config()
  svc <- .shield$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.shield$operations$disable_proactive_engagement <- shield_disable_proactive_engagement

#' Removes the Shield Response Team's (SRT) access to the specified Amazon
#' S3 bucket containing the logs that you shared previously
#'
#' @description
#' Removes the Shield Response Team's (SRT) access to the specified Amazon S3 bucket containing the logs that you shared previously.
#'
#' See [https://www.paws-r-sdk.com/docs/shield_disassociate_drt_log_bucket/](https://www.paws-r-sdk.com/docs/shield_disassociate_drt_log_bucket/) for full documentation.
#'
#' @param LogBucket &#91;required&#93; The Amazon S3 bucket that contains the logs that you want to share.
#'
#' @keywords internal
#'
#' @rdname shield_disassociate_drt_log_bucket
shield_disassociate_drt_log_bucket <- function(LogBucket) {
  op <- new_operation(
    name = "DisassociateDRTLogBucket",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .shield$disassociate_drt_log_bucket_input(LogBucket = LogBucket)
  output <- .shield$disassociate_drt_log_bucket_output()
  config <- get_config()
  svc <- .shield$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.shield$operations$disassociate_drt_log_bucket <- shield_disassociate_drt_log_bucket

#' Removes the Shield Response Team's (SRT) access to your Amazon Web
#' Services account
#'
#' @description
#' Removes the Shield Response Team's (SRT) access to your Amazon Web Services account.
#'
#' See [https://www.paws-r-sdk.com/docs/shield_disassociate_drt_role/](https://www.paws-r-sdk.com/docs/shield_disassociate_drt_role/) for full documentation.
#'
#' @keywords internal
#'
#' @rdname shield_disassociate_drt_role
shield_disassociate_drt_role <- function() {
  op <- new_operation(
    name = "DisassociateDRTRole",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .shield$disassociate_drt_role_input()
  output <- .shield$disassociate_drt_role_output()
  config <- get_config()
  svc <- .shield$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.shield$operations$disassociate_drt_role <- shield_disassociate_drt_role

#' Removes health-based detection from the Shield Advanced protection for a
#' resource
#'
#' @description
#' Removes health-based detection from the Shield Advanced protection for a resource. Shield Advanced health-based detection uses the health of your Amazon Web Services resource to improve responsiveness and accuracy in attack detection and response.
#'
#' See [https://www.paws-r-sdk.com/docs/shield_disassociate_health_check/](https://www.paws-r-sdk.com/docs/shield_disassociate_health_check/) for full documentation.
#'
#' @param ProtectionId &#91;required&#93; The unique identifier (ID) for the Protection object to remove the
#' health check association from.
#' @param HealthCheckArn &#91;required&#93; The Amazon Resource Name (ARN) of the health check that is associated
#' with the protection.
#'
#' @keywords internal
#'
#' @rdname shield_disassociate_health_check
shield_disassociate_health_check <- function(ProtectionId, HealthCheckArn) {
  op <- new_operation(
    name = "DisassociateHealthCheck",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .shield$disassociate_health_check_input(ProtectionId = ProtectionId, HealthCheckArn = HealthCheckArn)
  output <- .shield$disassociate_health_check_output()
  config <- get_config()
  svc <- .shield$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.shield$operations$disassociate_health_check <- shield_disassociate_health_check

#' Enable the Shield Advanced automatic application layer DDoS mitigation
#' for the protected resource
#'
#' @description
#' Enable the Shield Advanced automatic application layer DDoS mitigation for the protected resource.
#'
#' See [https://www.paws-r-sdk.com/docs/shield_enable_application_layer_automatic_response/](https://www.paws-r-sdk.com/docs/shield_enable_application_layer_automatic_response/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The ARN (Amazon Resource Name) of the protected resource.
#' @param Action &#91;required&#93; Specifies the action setting that Shield Advanced should use in the WAF
#' rules that it creates on behalf of the protected resource in response to
#' DDoS attacks. You specify this as part of the configuration for the
#' automatic application layer DDoS mitigation feature, when you enable or
#' update automatic mitigation. Shield Advanced creates the WAF rules in a
#' Shield Advanced-managed rule group, inside the web ACL that you have
#' associated with the resource.
#'
#' @keywords internal
#'
#' @rdname shield_enable_application_layer_automatic_response
shield_enable_application_layer_automatic_response <- function(ResourceArn, Action) {
  op <- new_operation(
    name = "EnableApplicationLayerAutomaticResponse",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .shield$enable_application_layer_automatic_response_input(ResourceArn = ResourceArn, Action = Action)
  output <- .shield$enable_application_layer_automatic_response_output()
  config <- get_config()
  svc <- .shield$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.shield$operations$enable_application_layer_automatic_response <- shield_enable_application_layer_automatic_response

#' Authorizes the Shield Response Team (SRT) to use email and phone to
#' notify contacts about escalations to the SRT and to initiate proactive
#' customer support
#'
#' @description
#' Authorizes the Shield Response Team (SRT) to use email and phone to notify contacts about escalations to the SRT and to initiate proactive customer support.
#'
#' See [https://www.paws-r-sdk.com/docs/shield_enable_proactive_engagement/](https://www.paws-r-sdk.com/docs/shield_enable_proactive_engagement/) for full documentation.
#'
#' @keywords internal
#'
#' @rdname shield_enable_proactive_engagement
shield_enable_proactive_engagement <- function() {
  op <- new_operation(
    name = "EnableProactiveEngagement",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .shield$enable_proactive_engagement_input()
  output <- .shield$enable_proactive_engagement_output()
  config <- get_config()
  svc <- .shield$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.shield$operations$enable_proactive_engagement <- shield_enable_proactive_engagement

#' Returns the SubscriptionState, either Active or Inactive
#'
#' @description
#' Returns the `SubscriptionState`, either `Active` or `Inactive`.
#'
#' See [https://www.paws-r-sdk.com/docs/shield_get_subscription_state/](https://www.paws-r-sdk.com/docs/shield_get_subscription_state/) for full documentation.
#'
#' @keywords internal
#'
#' @rdname shield_get_subscription_state
shield_get_subscription_state <- function() {
  op <- new_operation(
    name = "GetSubscriptionState",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .shield$get_subscription_state_input()
  output <- .shield$get_subscription_state_output()
  config <- get_config()
  svc <- .shield$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.shield$operations$get_subscription_state <- shield_get_subscription_state

#' Returns all ongoing DDoS attacks or all DDoS attacks during a specified
#' time period
#'
#' @description
#' Returns all ongoing DDoS attacks or all DDoS attacks during a specified time period.
#'
#' See [https://www.paws-r-sdk.com/docs/shield_list_attacks/](https://www.paws-r-sdk.com/docs/shield_list_attacks/) for full documentation.
#'
#' @param ResourceArns The ARNs (Amazon Resource Names) of the resources that were attacked. If
#' you leave this blank, all applicable resources for this account will be
#' included.
#' @param StartTime The start of the time period for the attacks. This is a `timestamp`
#' type. The request syntax listing for this call indicates a `number`
#' type, but you can provide the time in any valid [timestamp
#' format](https://docs.aws.amazon.com/cli/latest/userguide/cli-usage-parameters-types.html#parameter-type-timestamp)
#' setting.
#' @param EndTime The end of the time period for the attacks. This is a `timestamp` type.
#' The request syntax listing for this call indicates a `number` type, but
#' you can provide the time in any valid [timestamp
#' format](https://docs.aws.amazon.com/cli/latest/userguide/cli-usage-parameters-types.html#parameter-type-timestamp)
#' setting.
#' @param NextToken When you request a list of objects from Shield Advanced, if the response
#' does not include all of the remaining available objects, Shield Advanced
#' includes a `NextToken` value in the response. You can retrieve the next
#' batch of objects by requesting the list again and providing the token
#' that was returned by the prior call in your request.
#' 
#' You can indicate the maximum number of objects that you want Shield
#' Advanced to return for a single call with the `MaxResults` setting.
#' Shield Advanced will not return more than `MaxResults` objects, but may
#' return fewer, even if more objects are still available.
#' 
#' Whenever more objects remain that Shield Advanced has not yet returned
#' to you, the response will include a `NextToken` value.
#' 
#' On your first call to a list operation, leave this setting empty.
#' @param MaxResults The greatest number of objects that you want Shield Advanced to return
#' to the list request. Shield Advanced might return fewer objects than you
#' indicate in this setting, even if more objects are available. If there
#' are more objects remaining, Shield Advanced will always also return a
#' `NextToken` value in the response.
#' 
#' The default setting is 20.
#'
#' @keywords internal
#'
#' @rdname shield_list_attacks
shield_list_attacks <- function(ResourceArns = NULL, StartTime = NULL, EndTime = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListAttacks",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "AttackSummaries")
  )
  input <- .shield$list_attacks_input(ResourceArns = ResourceArns, StartTime = StartTime, EndTime = EndTime, NextToken = NextToken, MaxResults = MaxResults)
  output <- .shield$list_attacks_output()
  config <- get_config()
  svc <- .shield$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.shield$operations$list_attacks <- shield_list_attacks

#' Retrieves ProtectionGroup objects for the account
#'
#' @description
#' Retrieves ProtectionGroup objects for the account. You can retrieve all protection groups or you can provide filtering criteria and retrieve just the subset of protection groups that match the criteria.
#'
#' See [https://www.paws-r-sdk.com/docs/shield_list_protection_groups/](https://www.paws-r-sdk.com/docs/shield_list_protection_groups/) for full documentation.
#'
#' @param NextToken When you request a list of objects from Shield Advanced, if the response
#' does not include all of the remaining available objects, Shield Advanced
#' includes a `NextToken` value in the response. You can retrieve the next
#' batch of objects by requesting the list again and providing the token
#' that was returned by the prior call in your request.
#' 
#' You can indicate the maximum number of objects that you want Shield
#' Advanced to return for a single call with the `MaxResults` setting.
#' Shield Advanced will not return more than `MaxResults` objects, but may
#' return fewer, even if more objects are still available.
#' 
#' Whenever more objects remain that Shield Advanced has not yet returned
#' to you, the response will include a `NextToken` value.
#' 
#' On your first call to a list operation, leave this setting empty.
#' @param MaxResults The greatest number of objects that you want Shield Advanced to return
#' to the list request. Shield Advanced might return fewer objects than you
#' indicate in this setting, even if more objects are available. If there
#' are more objects remaining, Shield Advanced will always also return a
#' `NextToken` value in the response.
#' 
#' The default setting is 20.
#' @param InclusionFilters Narrows the set of protection groups that the call retrieves. You can
#' retrieve a single protection group by its name and you can retrieve all
#' protection groups that are configured with specific pattern or
#' aggregation settings. You can provide up to one criteria per filter
#' type. Shield Advanced returns the protection groups that exactly match
#' all of the search criteria that you provide.
#'
#' @keywords internal
#'
#' @rdname shield_list_protection_groups
shield_list_protection_groups <- function(NextToken = NULL, MaxResults = NULL, InclusionFilters = NULL) {
  op <- new_operation(
    name = "ListProtectionGroups",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken")
  )
  input <- .shield$list_protection_groups_input(NextToken = NextToken, MaxResults = MaxResults, InclusionFilters = InclusionFilters)
  output <- .shield$list_protection_groups_output()
  config <- get_config()
  svc <- .shield$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.shield$operations$list_protection_groups <- shield_list_protection_groups

#' Retrieves Protection objects for the account
#'
#' @description
#' Retrieves Protection objects for the account. You can retrieve all protections or you can provide filtering criteria and retrieve just the subset of protections that match the criteria.
#'
#' See [https://www.paws-r-sdk.com/docs/shield_list_protections/](https://www.paws-r-sdk.com/docs/shield_list_protections/) for full documentation.
#'
#' @param NextToken When you request a list of objects from Shield Advanced, if the response
#' does not include all of the remaining available objects, Shield Advanced
#' includes a `NextToken` value in the response. You can retrieve the next
#' batch of objects by requesting the list again and providing the token
#' that was returned by the prior call in your request.
#' 
#' You can indicate the maximum number of objects that you want Shield
#' Advanced to return for a single call with the `MaxResults` setting.
#' Shield Advanced will not return more than `MaxResults` objects, but may
#' return fewer, even if more objects are still available.
#' 
#' Whenever more objects remain that Shield Advanced has not yet returned
#' to you, the response will include a `NextToken` value.
#' 
#' On your first call to a list operation, leave this setting empty.
#' @param MaxResults The greatest number of objects that you want Shield Advanced to return
#' to the list request. Shield Advanced might return fewer objects than you
#' indicate in this setting, even if more objects are available. If there
#' are more objects remaining, Shield Advanced will always also return a
#' `NextToken` value in the response.
#' 
#' The default setting is 20.
#' @param InclusionFilters Narrows the set of protections that the call retrieves. You can retrieve
#' a single protection by providing its name or the ARN (Amazon Resource
#' Name) of its protected resource. You can also retrieve all protections
#' for a specific resource type. You can provide up to one criteria per
#' filter type. Shield Advanced returns protections that exactly match all
#' of the filter criteria that you provide.
#'
#' @keywords internal
#'
#' @rdname shield_list_protections
shield_list_protections <- function(NextToken = NULL, MaxResults = NULL, InclusionFilters = NULL) {
  op <- new_operation(
    name = "ListProtections",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "Protections")
  )
  input <- .shield$list_protections_input(NextToken = NextToken, MaxResults = MaxResults, InclusionFilters = InclusionFilters)
  output <- .shield$list_protections_output()
  config <- get_config()
  svc <- .shield$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.shield$operations$list_protections <- shield_list_protections

#' Retrieves the resources that are included in the protection group
#'
#' @description
#' Retrieves the resources that are included in the protection group.
#'
#' See [https://www.paws-r-sdk.com/docs/shield_list_resources_in_protection_group/](https://www.paws-r-sdk.com/docs/shield_list_resources_in_protection_group/) for full documentation.
#'
#' @param ProtectionGroupId &#91;required&#93; The name of the protection group. You use this to identify the
#' protection group in lists and to manage the protection group, for
#' example to update, delete, or describe it.
#' @param NextToken When you request a list of objects from Shield Advanced, if the response
#' does not include all of the remaining available objects, Shield Advanced
#' includes a `NextToken` value in the response. You can retrieve the next
#' batch of objects by requesting the list again and providing the token
#' that was returned by the prior call in your request.
#' 
#' You can indicate the maximum number of objects that you want Shield
#' Advanced to return for a single call with the `MaxResults` setting.
#' Shield Advanced will not return more than `MaxResults` objects, but may
#' return fewer, even if more objects are still available.
#' 
#' Whenever more objects remain that Shield Advanced has not yet returned
#' to you, the response will include a `NextToken` value.
#' 
#' On your first call to a list operation, leave this setting empty.
#' @param MaxResults The greatest number of objects that you want Shield Advanced to return
#' to the list request. Shield Advanced might return fewer objects than you
#' indicate in this setting, even if more objects are available. If there
#' are more objects remaining, Shield Advanced will always also return a
#' `NextToken` value in the response.
#' 
#' The default setting is 20.
#'
#' @keywords internal
#'
#' @rdname shield_list_resources_in_protection_group
shield_list_resources_in_protection_group <- function(ProtectionGroupId, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListResourcesInProtectionGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken")
  )
  input <- .shield$list_resources_in_protection_group_input(ProtectionGroupId = ProtectionGroupId, NextToken = NextToken, MaxResults = MaxResults)
  output <- .shield$list_resources_in_protection_group_output()
  config <- get_config()
  svc <- .shield$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.shield$operations$list_resources_in_protection_group <- shield_list_resources_in_protection_group

#' Gets information about Amazon Web Services tags for a specified Amazon
#' Resource Name (ARN) in Shield
#'
#' @description
#' Gets information about Amazon Web Services tags for a specified Amazon Resource Name (ARN) in Shield.
#'
#' See [https://www.paws-r-sdk.com/docs/shield_list_tags_for_resource/](https://www.paws-r-sdk.com/docs/shield_list_tags_for_resource/) for full documentation.
#'
#' @param ResourceARN &#91;required&#93; The Amazon Resource Name (ARN) of the resource to get tags for.
#'
#' @keywords internal
#'
#' @rdname shield_list_tags_for_resource
shield_list_tags_for_resource <- function(ResourceARN) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .shield$list_tags_for_resource_input(ResourceARN = ResourceARN)
  output <- .shield$list_tags_for_resource_output()
  config <- get_config()
  svc <- .shield$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.shield$operations$list_tags_for_resource <- shield_list_tags_for_resource

#' Adds or updates tags for a resource in Shield
#'
#' @description
#' Adds or updates tags for a resource in Shield.
#'
#' See [https://www.paws-r-sdk.com/docs/shield_tag_resource/](https://www.paws-r-sdk.com/docs/shield_tag_resource/) for full documentation.
#'
#' @param ResourceARN &#91;required&#93; The Amazon Resource Name (ARN) of the resource that you want to add or
#' update tags for.
#' @param Tags &#91;required&#93; The tags that you want to modify or add to the resource.
#'
#' @keywords internal
#'
#' @rdname shield_tag_resource
shield_tag_resource <- function(ResourceARN, Tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .shield$tag_resource_input(ResourceARN = ResourceARN, Tags = Tags)
  output <- .shield$tag_resource_output()
  config <- get_config()
  svc <- .shield$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.shield$operations$tag_resource <- shield_tag_resource

#' Removes tags from a resource in Shield
#'
#' @description
#' Removes tags from a resource in Shield.
#'
#' See [https://www.paws-r-sdk.com/docs/shield_untag_resource/](https://www.paws-r-sdk.com/docs/shield_untag_resource/) for full documentation.
#'
#' @param ResourceARN &#91;required&#93; The Amazon Resource Name (ARN) of the resource that you want to remove
#' tags from.
#' @param TagKeys &#91;required&#93; The tag key for each tag that you want to remove from the resource.
#'
#' @keywords internal
#'
#' @rdname shield_untag_resource
shield_untag_resource <- function(ResourceARN, TagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .shield$untag_resource_input(ResourceARN = ResourceARN, TagKeys = TagKeys)
  output <- .shield$untag_resource_output()
  config <- get_config()
  svc <- .shield$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.shield$operations$untag_resource <- shield_untag_resource

#' Updates an existing Shield Advanced automatic application layer DDoS
#' mitigation configuration for the specified resource
#'
#' @description
#' Updates an existing Shield Advanced automatic application layer DDoS mitigation configuration for the specified resource.
#'
#' See [https://www.paws-r-sdk.com/docs/shield_update_application_layer_automatic_response/](https://www.paws-r-sdk.com/docs/shield_update_application_layer_automatic_response/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The ARN (Amazon Resource Name) of the resource.
#' @param Action &#91;required&#93; Specifies the action setting that Shield Advanced should use in the WAF
#' rules that it creates on behalf of the protected resource in response to
#' DDoS attacks. You specify this as part of the configuration for the
#' automatic application layer DDoS mitigation feature, when you enable or
#' update automatic mitigation. Shield Advanced creates the WAF rules in a
#' Shield Advanced-managed rule group, inside the web ACL that you have
#' associated with the resource.
#'
#' @keywords internal
#'
#' @rdname shield_update_application_layer_automatic_response
shield_update_application_layer_automatic_response <- function(ResourceArn, Action) {
  op <- new_operation(
    name = "UpdateApplicationLayerAutomaticResponse",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .shield$update_application_layer_automatic_response_input(ResourceArn = ResourceArn, Action = Action)
  output <- .shield$update_application_layer_automatic_response_output()
  config <- get_config()
  svc <- .shield$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.shield$operations$update_application_layer_automatic_response <- shield_update_application_layer_automatic_response

#' Updates the details of the list of email addresses and phone numbers
#' that the Shield Response Team (SRT) can use to contact you if you have
#' proactive engagement enabled, for escalations to the SRT and to initiate
#' proactive customer support
#'
#' @description
#' Updates the details of the list of email addresses and phone numbers that the Shield Response Team (SRT) can use to contact you if you have proactive engagement enabled, for escalations to the SRT and to initiate proactive customer support.
#'
#' See [https://www.paws-r-sdk.com/docs/shield_update_emergency_contact_settings/](https://www.paws-r-sdk.com/docs/shield_update_emergency_contact_settings/) for full documentation.
#'
#' @param EmergencyContactList A list of email addresses and phone numbers that the Shield Response
#' Team (SRT) can use to contact you if you have proactive engagement
#' enabled, for escalations to the SRT and to initiate proactive customer
#' support.
#' 
#' If you have proactive engagement enabled, the contact list must include
#' at least one phone number.
#'
#' @keywords internal
#'
#' @rdname shield_update_emergency_contact_settings
shield_update_emergency_contact_settings <- function(EmergencyContactList = NULL) {
  op <- new_operation(
    name = "UpdateEmergencyContactSettings",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .shield$update_emergency_contact_settings_input(EmergencyContactList = EmergencyContactList)
  output <- .shield$update_emergency_contact_settings_output()
  config <- get_config()
  svc <- .shield$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.shield$operations$update_emergency_contact_settings <- shield_update_emergency_contact_settings

#' Updates an existing protection group
#'
#' @description
#' Updates an existing protection group. A protection group is a grouping of protected resources so they can be handled as a collective. This resource grouping improves the accuracy of detection and reduces false positives.
#'
#' See [https://www.paws-r-sdk.com/docs/shield_update_protection_group/](https://www.paws-r-sdk.com/docs/shield_update_protection_group/) for full documentation.
#'
#' @param ProtectionGroupId &#91;required&#93; The name of the protection group. You use this to identify the
#' protection group in lists and to manage the protection group, for
#' example to update, delete, or describe it.
#' @param Aggregation &#91;required&#93; Defines how Shield combines resource data for the group in order to
#' detect, mitigate, and report events.
#' 
#' -   Sum - Use the total traffic across the group. This is a good choice
#'     for most cases. Examples include Elastic IP addresses for EC2
#'     instances that scale manually or automatically.
#' 
#' -   Mean - Use the average of the traffic across the group. This is a
#'     good choice for resources that share traffic uniformly. Examples
#'     include accelerators and load balancers.
#' 
#' -   Max - Use the highest traffic from each resource. This is useful for
#'     resources that don't share traffic and for resources that share that
#'     traffic in a non-uniform way. Examples include Amazon CloudFront
#'     distributions and origin resources for CloudFront distributions.
#' @param Pattern &#91;required&#93; The criteria to use to choose the protected resources for inclusion in
#' the group. You can include all resources that have protections, provide
#' a list of resource Amazon Resource Names (ARNs), or include all
#' resources of a specified resource type.
#' @param ResourceType The resource type to include in the protection group. All protected
#' resources of this type are included in the protection group. You must
#' set this when you set `Pattern` to `BY_RESOURCE_TYPE` and you must not
#' set it for any other `Pattern` setting.
#' @param Members The Amazon Resource Names (ARNs) of the resources to include in the
#' protection group. You must set this when you set `Pattern` to
#' `ARBITRARY` and you must not set it for any other `Pattern` setting.
#'
#' @keywords internal
#'
#' @rdname shield_update_protection_group
shield_update_protection_group <- function(ProtectionGroupId, Aggregation, Pattern, ResourceType = NULL, Members = NULL) {
  op <- new_operation(
    name = "UpdateProtectionGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .shield$update_protection_group_input(ProtectionGroupId = ProtectionGroupId, Aggregation = Aggregation, Pattern = Pattern, ResourceType = ResourceType, Members = Members)
  output <- .shield$update_protection_group_output()
  config <- get_config()
  svc <- .shield$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.shield$operations$update_protection_group <- shield_update_protection_group

#' Updates the details of an existing subscription
#'
#' @description
#' Updates the details of an existing subscription. Only enter values for parameters you want to change. Empty parameters are not updated.
#'
#' See [https://www.paws-r-sdk.com/docs/shield_update_subscription/](https://www.paws-r-sdk.com/docs/shield_update_subscription/) for full documentation.
#'
#' @param AutoRenew When you initally create a subscription, `AutoRenew` is set to
#' `ENABLED`. If `ENABLED`, the subscription will be automatically renewed
#' at the end of the existing subscription period. You can change this by
#' submitting an [`update_subscription`][shield_update_subscription]
#' request. If the [`update_subscription`][shield_update_subscription]
#' request does not included a value for `AutoRenew`, the existing value
#' for `AutoRenew` remains unchanged.
#'
#' @keywords internal
#'
#' @rdname shield_update_subscription
shield_update_subscription <- function(AutoRenew = NULL) {
  op <- new_operation(
    name = "UpdateSubscription",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .shield$update_subscription_input(AutoRenew = AutoRenew)
  output <- .shield$update_subscription_output()
  config <- get_config()
  svc <- .shield$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.shield$operations$update_subscription <- shield_update_subscription
