% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iam_operations.R
\name{iam_tag_policy}
\alias{iam_tag_policy}
\title{Adds one or more tags to an IAM customer managed policy}
\usage{
iam_tag_policy(PolicyArn, Tags)
}
\arguments{
\item{PolicyArn}{[required] The ARN of the IAM customer managed policy to which you want to add
tags.

This parameter allows (through its \href{https://en.wikipedia.org/wiki/Regex}{regex pattern}) a string of characters
consisting of upper and lowercase alphanumeric characters with no
spaces. You can also include any of the following characters: _+=,.@-}

\item{Tags}{[required] The list of tags that you want to attach to the IAM customer managed
policy. Each tag consists of a key name and an associated value.}
}
\description{
Adds one or more tags to an IAM customer managed policy. If a tag with the same key name already exists, then that tag is overwritten with the new value.

See \url{https://www.paws-r-sdk.com/docs/iam_tag_policy/} for full documentation.
}
\keyword{internal}
