% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shield_operations.R
\name{shield_update_protection_group}
\alias{shield_update_protection_group}
\title{Updates an existing protection group}
\usage{
shield_update_protection_group(
  ProtectionGroupId,
  Aggregation,
  Pattern,
  ResourceType = NULL,
  Members = NULL
)
}
\arguments{
\item{ProtectionGroupId}{[required] The name of the protection group. You use this to identify the
protection group in lists and to manage the protection group, for
example to update, delete, or describe it.}

\item{Aggregation}{[required] Defines how Shield combines resource data for the group in order to
detect, mitigate, and report events.
\itemize{
\item Sum - Use the total traffic across the group. This is a good choice
for most cases. Examples include Elastic IP addresses for EC2
instances that scale manually or automatically.
\item Mean - Use the average of the traffic across the group. This is a
good choice for resources that share traffic uniformly. Examples
include accelerators and load balancers.
\item Max - Use the highest traffic from each resource. This is useful for
resources that don't share traffic and for resources that share that
traffic in a non-uniform way. Examples include Amazon CloudFront
distributions and origin resources for CloudFront distributions.
}}

\item{Pattern}{[required] The criteria to use to choose the protected resources for inclusion in
the group. You can include all resources that have protections, provide
a list of resource Amazon Resource Names (ARNs), or include all
resources of a specified resource type.}

\item{ResourceType}{The resource type to include in the protection group. All protected
resources of this type are included in the protection group. You must
set this when you set \code{Pattern} to \code{BY_RESOURCE_TYPE} and you must not
set it for any other \code{Pattern} setting.}

\item{Members}{The Amazon Resource Names (ARNs) of the resources to include in the
protection group. You must set this when you set \code{Pattern} to
\code{ARBITRARY} and you must not set it for any other \code{Pattern} setting.}
}
\description{
Updates an existing protection group. A protection group is a grouping of protected resources so they can be handled as a collective. This resource grouping improves the accuracy of detection and reduces false positives.

See \url{https://www.paws-r-sdk.com/docs/shield_update_protection_group/} for full documentation.
}
\keyword{internal}
