% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sso_operations.R
\name{sso_list_account_roles}
\alias{sso_list_account_roles}
\title{Lists all roles that are assigned to the user for a given AWS account}
\usage{
sso_list_account_roles(
  nextToken = NULL,
  maxResults = NULL,
  accessToken,
  accountId
)
}
\arguments{
\item{nextToken}{The page token from the previous response output when you request
subsequent pages.}

\item{maxResults}{The number of items that clients can request per page.}

\item{accessToken}{[required] The token issued by the \code{CreateToken} API call. For more information,
see
\href{https://docs.aws.amazon.com/singlesignon/latest/OIDCAPIReference/API_CreateToken.html}{CreateToken}
in the \emph{IAM Identity Center OIDC API Reference Guide}.}

\item{accountId}{[required] The identifier for the AWS account that is assigned to the user.}
}
\description{
Lists all roles that are assigned to the user for a given AWS account.

See \url{https://www.paws-r-sdk.com/docs/sso_list_account_roles/} for full documentation.
}
\keyword{internal}
