% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wafv2_operations.R
\name{wafv2_list_mobile_sdk_releases}
\alias{wafv2_list_mobile_sdk_releases}
\title{Retrieves a list of the available releases for the mobile SDK and the
specified device platform}
\usage{
wafv2_list_mobile_sdk_releases(Platform, NextMarker = NULL, Limit = NULL)
}
\arguments{
\item{Platform}{[required] The device platform to retrieve the list for.}

\item{NextMarker}{When you request a list of objects with a \code{Limit} setting, if the number
of objects that are still available for retrieval exceeds the limit, WAF
returns a \code{NextMarker} value in the response. To retrieve the next batch
of objects, provide the marker from the prior call in your next request.}

\item{Limit}{The maximum number of objects that you want WAF to return for this
request. If more objects are available, in the response, WAF provides a
\code{NextMarker} value that you can use in a subsequent call to get the next
batch of objects.}
}
\description{
Retrieves a list of the available releases for the mobile SDK and the specified device platform.

See \url{https://www.paws-r-sdk.com/docs/wafv2_list_mobile_sdk_releases/} for full documentation.
}
\keyword{internal}
