% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accessanalyzer_operations.R
\name{accessanalyzer_check_no_public_access}
\alias{accessanalyzer_check_no_public_access}
\title{Checks whether a resource policy can grant public access to the
specified resource type}
\usage{
accessanalyzer_check_no_public_access(policyDocument, resourceType)
}
\arguments{
\item{policyDocument}{[required] The JSON policy document to evaluate for public access.}

\item{resourceType}{[required] The type of resource to evaluate for public access. For example, to
check for public access to Amazon S3 buckets, you can choose
\verb{AWS::S3::Bucket} for the resource type.

For resource types not supported as valid values, IAM Access Analyzer
will return an error.}
}
\description{
Checks whether a resource policy can grant public access to the specified resource type.

See \url{https://www.paws-r-sdk.com/docs/accessanalyzer_check_no_public_access/} for full documentation.
}
\keyword{internal}
