% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_operations.R
\name{s3_copy_object}
\alias{s3_copy_object}
\title{Creates a copy of an object that is already stored in Amazon S3}
\usage{
s3_copy_object(ACL, Bucket, CacheControl, ContentDisposition,
  ContentEncoding, ContentLanguage, ContentType, CopySource,
  CopySourceIfMatch, CopySourceIfModifiedSince, CopySourceIfNoneMatch,
  CopySourceIfUnmodifiedSince, Expires, GrantFullControl, GrantRead,
  GrantReadACP, GrantWriteACP, Key, Metadata, MetadataDirective,
  TaggingDirective, ServerSideEncryption, StorageClass,
  WebsiteRedirectLocation, SSECustomerAlgorithm, SSECustomerKey,
  SSECustomerKeyMD5, SSEKMSKeyId, CopySourceSSECustomerAlgorithm,
  CopySourceSSECustomerKey, CopySourceSSECustomerKeyMD5, RequestPayer,
  Tagging, ObjectLockMode, ObjectLockRetainUntilDate,
  ObjectLockLegalHoldStatus)
}
\arguments{
\item{ACL}{The canned ACL to apply to the object.}

\item{Bucket}{[required]}

\item{CacheControl}{Specifies caching behavior along the request/reply chain.}

\item{ContentDisposition}{Specifies presentational information for the object.}

\item{ContentEncoding}{Specifies what content encodings have been applied to the object and
thus what decoding mechanisms must be applied to obtain the media-type
referenced by the Content-Type header field.}

\item{ContentLanguage}{The language the content is in.}

\item{ContentType}{A standard MIME type describing the format of the object data.}

\item{CopySource}{[required] The name of the source bucket and key name of the source object,
separated by a slash (/). Must be URL-encoded.}

\item{CopySourceIfMatch}{Copies the object if its entity tag (ETag) matches the specified tag.}

\item{CopySourceIfModifiedSince}{Copies the object if it has been modified since the specified time.}

\item{CopySourceIfNoneMatch}{Copies the object if its entity tag (ETag) is different than the
specified ETag.}

\item{CopySourceIfUnmodifiedSince}{Copies the object if it hasn't been modified since the specified time.}

\item{Expires}{The date and time at which the object is no longer cacheable.}

\item{GrantFullControl}{Gives the grantee READ, READ\_ACP, and WRITE\_ACP permissions on the
object.}

\item{GrantRead}{Allows grantee to read the object data and its metadata.}

\item{GrantReadACP}{Allows grantee to read the object ACL.}

\item{GrantWriteACP}{Allows grantee to write the ACL for the applicable object.}

\item{Key}{[required]}

\item{Metadata}{A map of metadata to store with the object in S3.}

\item{MetadataDirective}{Specifies whether the metadata is copied from the source object or
replaced with metadata provided in the request.}

\item{TaggingDirective}{Specifies whether the object tag-set are copied from the source object
or replaced with tag-set provided in the request.}

\item{ServerSideEncryption}{The Server-side encryption algorithm used when storing this object in S3
(e.g., AES256, aws:kms).}

\item{StorageClass}{The type of storage to use for the object. Defaults to 'STANDARD'.}

\item{WebsiteRedirectLocation}{If the bucket is configured as a website, redirects requests for this
object to another object in the same bucket or to an external URL.
Amazon S3 stores the value of this header in the object metadata.}

\item{SSECustomerAlgorithm}{Specifies the algorithm to use to when encrypting the object (e.g.,
AES256).}

\item{SSECustomerKey}{Specifies the customer-provided encryption key for Amazon S3 to use in
encrypting data. This value is used to store the object and then it is
discarded; Amazon does not store the encryption key. The key must be
appropriate for use with the algorithm specified in the
x-amz-server-sideâ€‹-encryptionâ€‹-customer-algorithm header.}

\item{SSECustomerKeyMD5}{Specifies the 128-bit MD5 digest of the encryption key according to RFC
1321. Amazon S3 uses this header for a message integrity check to ensure
the encryption key was transmitted without error.}

\item{SSEKMSKeyId}{Specifies the AWS KMS key ID to use for object encryption. All GET and
PUT requests for an object protected by AWS KMS will fail if not made
via SSL or using SigV4. Documentation on configuring any of the
officially supported AWS SDKs and CLI can be found at
http://docs.aws.amazon.com/AmazonS3/latest/dev/UsingAWSSDK.html\#specify-signature-version}

\item{CopySourceSSECustomerAlgorithm}{Specifies the algorithm to use when decrypting the source object (e.g.,
AES256).}

\item{CopySourceSSECustomerKey}{Specifies the customer-provided encryption key for Amazon S3 to use to
decrypt the source object. The encryption key provided in this header
must be one that was used when the source object was created.}

\item{CopySourceSSECustomerKeyMD5}{Specifies the 128-bit MD5 digest of the encryption key according to RFC
1321. Amazon S3 uses this header for a message integrity check to ensure
the encryption key was transmitted without error.}

\item{RequestPayer}{}

\item{Tagging}{The tag-set for the object destination object this value must be used in
conjunction with the TaggingDirective. The tag-set must be encoded as
URL Query parameters}

\item{ObjectLockMode}{The Object Lock mode that you want to apply to the copied object.}

\item{ObjectLockRetainUntilDate}{The date and time when you want the copied object's Object Lock to
expire.}

\item{ObjectLockLegalHoldStatus}{Specifies whether you want to apply a Legal Hold to the copied object.}
}
\description{
Creates a copy of an object that is already stored in Amazon S3.
}
\section{Request syntax}{
\preformatted{svc$copy_object(
  ACL = "private"|"public-read"|"public-read-write"|"authenticated-read"|"aws-exec-read"|"bucket-owner-read"|"bucket-owner-full-control",
  Bucket = "string",
  CacheControl = "string",
  ContentDisposition = "string",
  ContentEncoding = "string",
  ContentLanguage = "string",
  ContentType = "string",
  CopySource = "string",
  CopySourceIfMatch = "string",
  CopySourceIfModifiedSince = as.POSIXct(
    "2015-01-01"
  ),
  CopySourceIfNoneMatch = "string",
  CopySourceIfUnmodifiedSince = as.POSIXct(
    "2015-01-01"
  ),
  Expires = as.POSIXct(
    "2015-01-01"
  ),
  GrantFullControl = "string",
  GrantRead = "string",
  GrantReadACP = "string",
  GrantWriteACP = "string",
  Key = "string",
  Metadata = list(
    "string"
  ),
  MetadataDirective = "COPY"|"REPLACE",
  TaggingDirective = "COPY"|"REPLACE",
  ServerSideEncryption = "AES256"|"aws:kms",
  StorageClass = "STANDARD"|"REDUCED_REDUNDANCY"|"STANDARD_IA"|"ONEZONE_IA"|"INTELLIGENT_TIERING"|"GLACIER"|"DEEP_ARCHIVE",
  WebsiteRedirectLocation = "string",
  SSECustomerAlgorithm = "string",
  SSECustomerKey = raw,
  SSECustomerKeyMD5 = "string",
  SSEKMSKeyId = "string",
  CopySourceSSECustomerAlgorithm = "string",
  CopySourceSSECustomerKey = raw,
  CopySourceSSECustomerKeyMD5 = "string",
  RequestPayer = "requester",
  Tagging = "string",
  ObjectLockMode = "GOVERNANCE"|"COMPLIANCE",
  ObjectLockRetainUntilDate = as.POSIXct(
    "2015-01-01"
  ),
  ObjectLockLegalHoldStatus = "ON"|"OFF"
)
}
}

\examples{
# The following example copies an object from one bucket to another.
\donttest{svc$copy_object(
  Bucket = "destinationbucket",
  CopySource = "/sourcebucket/HappyFacejpg",
  Key = "HappyFaceCopyjpg"
)}

}
\keyword{internal}
