% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_operations.R
\name{s3_get_bucket_analytics_configuration}
\alias{s3_get_bucket_analytics_configuration}
\title{This implementation of the GET operation returns an analytics
configuration (identified by the analytics configuration ID) from the
bucket}
\usage{
s3_get_bucket_analytics_configuration(Bucket, Id, ExpectedBucketOwner)
}
\arguments{
\item{Bucket}{[required] The name of the bucket from which an analytics configuration is
retrieved.}

\item{Id}{[required] The ID that identifies the analytics configuration.}

\item{ExpectedBucketOwner}{The account id of the expected bucket owner. If the bucket is owned by a
different account, the request will fail with an HTTP
\verb{403 (Access Denied)} error.}
}
\value{
A list with the following syntax:\preformatted{list(
  AnalyticsConfiguration = list(
    Id = "string",
    Filter = list(
      Prefix = "string",
      Tag = list(
        Key = "string",
        Value = "string"
      ),
      And = list(
        Prefix = "string",
        Tags = list(
          list(
            Key = "string",
            Value = "string"
          )
        )
      )
    ),
    StorageClassAnalysis = list(
      DataExport = list(
        OutputSchemaVersion = "V_1",
        Destination = list(
          S3BucketDestination = list(
            Format = "CSV",
            BucketAccountId = "string",
            Bucket = "string",
            Prefix = "string"
          )
        )
      )
    )
  )
)
}
}
\description{
This implementation of the GET operation returns an analytics
configuration (identified by the analytics configuration ID) from the
bucket.

To use this operation, you must have permissions to perform the
\code{s3:GetAnalyticsConfiguration} action. The bucket owner has this
permission by default. The bucket owner can grant this permission to
others. For more information about permissions, see \href{https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources}{Permissions Related to Bucket Subresource Operations}
and \href{https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html}{Managing Access Permissions to Your Amazon S3 Resources}
in the \emph{Amazon Simple Storage Service Developer Guide}.

For information about Amazon S3 analytics feature, see \href{https://docs.aws.amazon.com/AmazonS3/latest/userguide/analytics-storage-class.html}{Amazon S3 Analytics – Storage Class Analysis}
in the \emph{Amazon Simple Storage Service Developer Guide}.

\strong{Related Resources}
\itemize{
\item \code{\link[=s3_delete_bucket_analytics_configuration]{delete_bucket_analytics_configuration}}
\item \code{\link[=s3_list_bucket_analytics_configurations]{list_bucket_analytics_configurations}}
\item \code{\link[=s3_put_bucket_analytics_configuration]{put_bucket_analytics_configuration}}
}
}
\section{Request syntax}{
\preformatted{svc$get_bucket_analytics_configuration(
  Bucket = "string",
  Id = "string",
  ExpectedBucketOwner = "string"
)
}
}

\keyword{internal}
