% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_operations.R
\name{s3_get_bucket_location}
\alias{s3_get_bucket_location}
\title{Returns the Region the bucket resides in}
\usage{
s3_get_bucket_location(Bucket, ExpectedBucketOwner)
}
\arguments{
\item{Bucket}{[required] The name of the bucket for which to get the location.}

\item{ExpectedBucketOwner}{The account id of the expected bucket owner. If the bucket is owned by a
different account, the request will fail with an HTTP
\verb{403 (Access Denied)} error.}
}
\value{
A list with the following syntax:\preformatted{list(
  LocationConstraint = "af-south-1"|"ap-east-1"|"ap-northeast-1"|"ap-northeast-2"|"ap-northeast-3"|"ap-south-1"|"ap-southeast-1"|"ap-southeast-2"|"ca-central-1"|"cn-north-1"|"cn-northwest-1"|"EU"|"eu-central-1"|"eu-north-1"|"eu-south-1"|"eu-west-1"|"eu-west-2"|"eu-west-3"|"me-south-1"|"sa-east-1"|"us-east-2"|"us-gov-east-1"|"us-gov-west-1"|"us-west-1"|"us-west-2"
)
}
}
\description{
Returns the Region the bucket resides in. You set the bucket's Region
using the \code{LocationConstraint} request parameter in a
\code{\link[=s3_create_bucket]{create_bucket}} request. For more information, see
\code{\link[=s3_create_bucket]{create_bucket}}.

To use this implementation of the operation, you must be the bucket
owner.

The following operations are related to
\code{\link[=s3_get_bucket_location]{get_bucket_location}}:
\itemize{
\item \code{\link[=s3_get_object]{get_object}}
\item \code{\link[=s3_create_bucket]{create_bucket}}
}
}
\section{Request syntax}{
\preformatted{svc$get_bucket_location(
  Bucket = "string",
  ExpectedBucketOwner = "string"
)
}
}

\examples{
\dontrun{
# The following example returns bucket location.
svc$get_bucket_location(
  Bucket = "examplebucket"
)
}

}
\keyword{internal}
