% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/storagegateway_operations.R
\name{storagegateway_list_automatic_tape_creation_policies}
\alias{storagegateway_list_automatic_tape_creation_policies}
\title{Lists the automatic tape creation policies for a gateway}
\usage{
storagegateway_list_automatic_tape_creation_policies(GatewayARN)
}
\arguments{
\item{GatewayARN}{}
}
\value{
A list with the following syntax:\preformatted{list(
  AutomaticTapeCreationPolicyInfos = list(
    list(
      AutomaticTapeCreationRules = list(
        list(
          TapeBarcodePrefix = "string",
          PoolId = "string",
          TapeSizeInBytes = 123,
          MinimumNumTapes = 123,
          Worm = TRUE|FALSE
        )
      ),
      GatewayARN = "string"
    )
  )
)
}
}
\description{
Lists the automatic tape creation policies for a gateway. If there are
no automatic tape creation policies for the gateway, it returns an empty
list.

This operation is only supported for tape gateways.
}
\section{Request syntax}{
\preformatted{svc$list_automatic_tape_creation_policies(
  GatewayARN = "string"
)
}
}

\keyword{internal}
