% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_operations.R
\name{s3_put_bucket_inventory_configuration}
\alias{s3_put_bucket_inventory_configuration}
\title{Adds an inventory configuration (identified by the inventory ID) from
the bucket}
\usage{
s3_put_bucket_inventory_configuration(Bucket, Id,
  InventoryConfiguration)
}
\arguments{
\item{Bucket}{[required] The name of the bucket where the inventory configuration will be stored.}

\item{Id}{[required] The ID used to identify the inventory configuration.}

\item{InventoryConfiguration}{[required] Specifies the inventory configuration.}
}
\description{
Adds an inventory configuration (identified by the inventory ID) from
the bucket.
}
\section{Request syntax}{
\preformatted{svc$put_bucket_inventory_configuration(
  Bucket = "string",
  Id = "string",
  InventoryConfiguration = list(
    Destination = list(
      S3BucketDestination = list(
        AccountId = "string",
        Bucket = "string",
        Format = "CSV"|"ORC"|"Parquet",
        Prefix = "string",
        Encryption = list(
          SSES3 = list(),
          SSEKMS = list(
            KeyId = "string"
          )
        )
      )
    ),
    IsEnabled = TRUE|FALSE,
    Filter = list(
      Prefix = "string"
    ),
    Id = "string",
    IncludedObjectVersions = "All"|"Current",
    OptionalFields = list(
      "Size"|"LastModifiedDate"|"StorageClass"|"ETag"|"IsMultipartUploaded"|"ReplicationStatus"|"EncryptionStatus"|"ObjectLockRetainUntilDate"|"ObjectLockMode"|"ObjectLockLegalHoldStatus"
    ),
    Schedule = list(
      Frequency = "Daily"|"Weekly"
    )
  )
)
}
}

\keyword{internal}
