# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include storagegateway_service.R
NULL

#' Activates the gateway you previously deployed on your host
#'
#' Activates the gateway you previously deployed on your host. In the
#' activation process, you specify information such as the AWS Region that
#' you want to use for storing snapshots or tapes, the time zone for
#' scheduled snapshots the gateway snapshot schedule window, an activation
#' key, and a name for your gateway. The activation process also associates
#' your gateway with your account; for more information, see
#' UpdateGatewayInformation.
#' 
#' You must turn on the gateway VM before you can activate your gateway.
#'
#' @usage
#' storagegateway_activate_gateway(ActivationKey, GatewayName,
#'   GatewayTimezone, GatewayRegion, GatewayType, TapeDriveType,
#'   MediumChangerType, Tags)
#'
#' @param ActivationKey &#91;required&#93; Your gateway activation key. You can obtain the activation key by
#' sending an HTTP GET request with redirects enabled to the gateway IP
#' address (port 80). The redirect URL returned in the response provides
#' you the activation key for your gateway in the query string parameter
#' `activationKey`. It may also include other activation-related
#' parameters, however, these are merely defaults \\-- the arguments you
#' pass to the `ActivateGateway` API call determine the actual
#' configuration of your gateway.
#' 
#' For more information, see
#' https://docs.aws.amazon.com/storagegateway/latest/userguide/get-activation-key.html
#' in the Storage Gateway User Guide.
#' @param GatewayName &#91;required&#93; The name you configured for your gateway.
#' @param GatewayTimezone &#91;required&#93; A value that indicates the time zone you want to set for the gateway.
#' The time zone is of the format \"GMT-hr:mm\" or \"GMT+hr:mm\". For
#' example, GMT-4:00 indicates the time is 4 hours behind GMT. GMT+2:00
#' indicates the time is 2 hours ahead of GMT. The time zone is used, for
#' example, for scheduling snapshots and your gateway\'s maintenance
#' schedule.
#' @param GatewayRegion &#91;required&#93; A value that indicates the AWS Region where you want to store your data.
#' The gateway AWS Region specified must be the same AWS Region as the AWS
#' Region in your `Host` header in the request. For more information about
#' available AWS Regions and endpoints for AWS Storage Gateway, see
#' [Regions and
#' Endpoints](https://docs.aws.amazon.com/general/latest/gr/rande.html#sg_region)
#' in the *Amazon Web Services Glossary*.
#' 
#' Valid Values: See [AWS Storage Gateway Regions and
#' Endpoints](https://docs.aws.amazon.com/general/latest/gr/rande.html#sg_region)
#' in the AWS General Reference.
#' @param GatewayType A value that defines the type of gateway to activate. The type specified
#' is critical to all later functions of the gateway and cannot be changed
#' after activation. The default value is `CACHED`.
#' 
#' Valid Values: \"STORED\", \"CACHED\", \"VTL\", \"FILE\\_S3\"
#' @param TapeDriveType The value that indicates the type of tape drive to use for tape gateway.
#' This field is optional.
#' 
#' Valid Values: \"IBM-ULT3580-TD5\"
#' @param MediumChangerType The value that indicates the type of medium changer to use for tape
#' gateway. This field is optional.
#' 
#' Valid Values: \"STK-L700\", \"AWS-Gateway-VTL\"
#' @param Tags A list of up to 50 tags that you can assign to the gateway. Each tag is
#' a key-value pair.
#' 
#' Valid characters for key and value are letters, spaces, and numbers that
#' can be represented in UTF-8 format, and the following special
#' characters: + - = . \\_ : / @@. The maximum length of a tag\'s key is 128
#' characters, and the maximum length for a tag\'s value is 256 characters.
#'
#' @section Request syntax:
#' ```
#' svc$activate_gateway(
#'   ActivationKey = "string",
#'   GatewayName = "string",
#'   GatewayTimezone = "string",
#'   GatewayRegion = "string",
#'   GatewayType = "string",
#'   TapeDriveType = "string",
#'   MediumChangerType = "string",
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # Activates the gateway you previously deployed on your host.
#' svc$activate_gateway(
#'   ActivationKey = "29AV1-3OFV9-VVIUB-NKT0I-LRO6V",
#'   GatewayName = "My_Gateway",
#'   GatewayRegion = "us-east-1",
#'   GatewayTimezone = "GMT-12:00",
#'   GatewayType = "STORED",
#'   MediumChangerType = "AWS-Gateway-VTL",
#'   TapeDriveType = "IBM-ULT3580-TD5"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname storagegateway_activate_gateway
storagegateway_activate_gateway <- function(ActivationKey, GatewayName, GatewayTimezone, GatewayRegion, GatewayType = NULL, TapeDriveType = NULL, MediumChangerType = NULL, Tags = NULL) {
  op <- new_operation(
    name = "ActivateGateway",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .storagegateway$activate_gateway_input(ActivationKey = ActivationKey, GatewayName = GatewayName, GatewayTimezone = GatewayTimezone, GatewayRegion = GatewayRegion, GatewayType = GatewayType, TapeDriveType = TapeDriveType, MediumChangerType = MediumChangerType, Tags = Tags)
  output <- .storagegateway$activate_gateway_output()
  config <- get_config()
  svc <- .storagegateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$activate_gateway <- storagegateway_activate_gateway

#' Configures one or more gateway local disks as cache for a gateway
#'
#' Configures one or more gateway local disks as cache for a gateway. This
#' operation is only supported in the cached volume, tape and file gateway
#' type (see [Storage Gateway
#' Concepts](https://docs.aws.amazon.com/storagegateway/latest/userguide/StorageGatewayConcepts.html)).
#' 
#' In the request, you specify the gateway Amazon Resource Name (ARN) to
#' which you want to add cache, and one or more disk IDs that you want to
#' configure as cache.
#'
#' @usage
#' storagegateway_add_cache(GatewayARN, DiskIds)
#'
#' @param GatewayARN &#91;required&#93; 
#' @param DiskIds &#91;required&#93; An array of strings that identify disks that are to be configured as
#' working storage. Each string have a minimum length of 1 and maximum
#' length of 300. You can get the disk IDs from the ListLocalDisks API.
#'
#' @section Request syntax:
#' ```
#' svc$add_cache(
#'   GatewayARN = "string",
#'   DiskIds = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # The following example shows a request that activates a gateway-stored
#' # volume.
#' svc$add_cache(
#'   DiskIds = list(
#'     "pci-0000:03:00.0-scsi-0:0:0:0",
#'     "pci-0000:03:00.0-scsi-0:0:1:0"
#'   ),
#'   GatewayARN = "arn:aws:storagegateway:us-east-1:111122223333:gateway/sgw-12A3456B"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname storagegateway_add_cache
storagegateway_add_cache <- function(GatewayARN, DiskIds) {
  op <- new_operation(
    name = "AddCache",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .storagegateway$add_cache_input(GatewayARN = GatewayARN, DiskIds = DiskIds)
  output <- .storagegateway$add_cache_output()
  config <- get_config()
  svc <- .storagegateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$add_cache <- storagegateway_add_cache

#' Adds one or more tags to the specified resource
#'
#' Adds one or more tags to the specified resource. You use tags to add
#' metadata to resources, which you can use to categorize these resources.
#' For example, you can categorize resources by purpose, owner,
#' environment, or team. Each tag consists of a key and a value, which you
#' define. You can add tags to the following AWS Storage Gateway resources:
#' 
#' -   Storage gateways of all types
#' 
#' -   Storage volumes
#' 
#' -   Virtual tapes
#' 
#' -   NFS and SMB file shares
#' 
#' You can create a maximum of 50 tags for each resource. Virtual tapes and
#' storage volumes that are recovered to a new gateway maintain their tags.
#'
#' @usage
#' storagegateway_add_tags_to_resource(ResourceARN, Tags)
#'
#' @param ResourceARN &#91;required&#93; The Amazon Resource Name (ARN) of the resource you want to add tags to.
#' @param Tags &#91;required&#93; The key-value pair that represents the tag you want to add to the
#' resource. The value can be an empty string.
#' 
#' Valid characters for key and value are letters, spaces, and numbers
#' representable in UTF-8 format, and the following special characters: + -
#' = . \\_ : / @@. The maximum length of a tag\'s key is 128 characters, and
#' the maximum length for a tag\'s value is 256.
#'
#' @section Request syntax:
#' ```
#' svc$add_tags_to_resource(
#'   ResourceARN = "string",
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # Adds one or more tags to the specified resource.
#' svc$add_tags_to_resource(
#'   ResourceARN = "arn:aws:storagegateway:us-east-1:111122223333:gateway/sgw-11A2222B",
#'   Tags = list(
#'     list(
#'       Key = "Dev Gatgeway Region",
#'       Value = "East Coast"
#'     )
#'   )
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname storagegateway_add_tags_to_resource
storagegateway_add_tags_to_resource <- function(ResourceARN, Tags) {
  op <- new_operation(
    name = "AddTagsToResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .storagegateway$add_tags_to_resource_input(ResourceARN = ResourceARN, Tags = Tags)
  output <- .storagegateway$add_tags_to_resource_output()
  config <- get_config()
  svc <- .storagegateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$add_tags_to_resource <- storagegateway_add_tags_to_resource

#' Configures one or more gateway local disks as upload buffer for a
#' specified gateway
#'
#' Configures one or more gateway local disks as upload buffer for a
#' specified gateway. This operation is supported for the stored volume,
#' cached volume and tape gateway types.
#' 
#' In the request, you specify the gateway Amazon Resource Name (ARN) to
#' which you want to add upload buffer, and one or more disk IDs that you
#' want to configure as upload buffer.
#'
#' @usage
#' storagegateway_add_upload_buffer(GatewayARN, DiskIds)
#'
#' @param GatewayARN &#91;required&#93; 
#' @param DiskIds &#91;required&#93; An array of strings that identify disks that are to be configured as
#' working storage. Each string have a minimum length of 1 and maximum
#' length of 300. You can get the disk IDs from the ListLocalDisks API.
#'
#' @section Request syntax:
#' ```
#' svc$add_upload_buffer(
#'   GatewayARN = "string",
#'   DiskIds = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # Configures one or more gateway local disks as upload buffer for a
#' # specified gateway.
#' svc$add_upload_buffer(
#'   DiskIds = list(
#'     "pci-0000:03:00.0-scsi-0:0:0:0",
#'     "pci-0000:03:00.0-scsi-0:0:1:0"
#'   ),
#'   GatewayARN = "arn:aws:storagegateway:us-east-1:111122223333:gateway/sgw-12A3456B"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname storagegateway_add_upload_buffer
storagegateway_add_upload_buffer <- function(GatewayARN, DiskIds) {
  op <- new_operation(
    name = "AddUploadBuffer",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .storagegateway$add_upload_buffer_input(GatewayARN = GatewayARN, DiskIds = DiskIds)
  output <- .storagegateway$add_upload_buffer_output()
  config <- get_config()
  svc <- .storagegateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$add_upload_buffer <- storagegateway_add_upload_buffer

#' Configures one or more gateway local disks as working storage for a
#' gateway
#'
#' Configures one or more gateway local disks as working storage for a
#' gateway. This operation is only supported in the stored volume gateway
#' type. This operation is deprecated in cached volume API version
#' 20120630. Use AddUploadBuffer instead.
#' 
#' Working storage is also referred to as upload buffer. You can also use
#' the AddUploadBuffer operation to add upload buffer to a stored volume
#' gateway.
#' 
#' In the request, you specify the gateway Amazon Resource Name (ARN) to
#' which you want to add working storage, and one or more disk IDs that you
#' want to configure as working storage.
#'
#' @usage
#' storagegateway_add_working_storage(GatewayARN, DiskIds)
#'
#' @param GatewayARN &#91;required&#93; 
#' @param DiskIds &#91;required&#93; An array of strings that identify disks that are to be configured as
#' working storage. Each string have a minimum length of 1 and maximum
#' length of 300. You can get the disk IDs from the ListLocalDisks API.
#'
#' @section Request syntax:
#' ```
#' svc$add_working_storage(
#'   GatewayARN = "string",
#'   DiskIds = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # Configures one or more gateway local disks as working storage for a
#' # gateway. (Working storage is also referred to as upload buffer.)
#' svc$add_working_storage(
#'   DiskIds = list(
#'     "pci-0000:03:00.0-scsi-0:0:0:0",
#'     "pci-0000:03:00.0-scsi-0:0:1:0"
#'   ),
#'   GatewayARN = "arn:aws:storagegateway:us-east-1:111122223333:gateway/sgw-12A3456B"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname storagegateway_add_working_storage
storagegateway_add_working_storage <- function(GatewayARN, DiskIds) {
  op <- new_operation(
    name = "AddWorkingStorage",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .storagegateway$add_working_storage_input(GatewayARN = GatewayARN, DiskIds = DiskIds)
  output <- .storagegateway$add_working_storage_output()
  config <- get_config()
  svc <- .storagegateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$add_working_storage <- storagegateway_add_working_storage

#' Assigns a tape to a tape pool for archiving
#'
#' Assigns a tape to a tape pool for archiving. The tape assigned to a pool
#' is archived in the S3 storage class that is associated with the pool.
#' When you use your backup application to eject the tape, the tape is
#' archived directly into the S3 storage class (Glacier or Deep Archive)
#' that corresponds to the pool.
#' 
#' Valid values: \"GLACIER\", \"DEEP\\_ARCHIVE\"
#'
#' @usage
#' storagegateway_assign_tape_pool(TapeARN, PoolId)
#'
#' @param TapeARN &#91;required&#93; The unique Amazon Resource Name (ARN) of the virtual tape that you want
#' to add to the tape pool.
#' @param PoolId &#91;required&#93; The ID of the pool that you want to add your tape to for archiving. The
#' tape in this pool is archived in the S3 storage class that is associated
#' with the pool. When you use your backup application to eject the tape,
#' the tape is archived directly into the storage class (Glacier or Deep
#' Archive) that corresponds to the pool.
#' 
#' Valid values: \"GLACIER\", \"DEEP\\_ARCHIVE\"
#'
#' @section Request syntax:
#' ```
#' svc$assign_tape_pool(
#'   TapeARN = "string",
#'   PoolId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname storagegateway_assign_tape_pool
storagegateway_assign_tape_pool <- function(TapeARN, PoolId) {
  op <- new_operation(
    name = "AssignTapePool",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .storagegateway$assign_tape_pool_input(TapeARN = TapeARN, PoolId = PoolId)
  output <- .storagegateway$assign_tape_pool_output()
  config <- get_config()
  svc <- .storagegateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$assign_tape_pool <- storagegateway_assign_tape_pool

#' Connects a volume to an iSCSI connection and then attaches the volume to
#' the specified gateway
#'
#' Connects a volume to an iSCSI connection and then attaches the volume to
#' the specified gateway. Detaching and attaching a volume enables you to
#' recover your data from one gateway to a different gateway without
#' creating a snapshot. It also makes it easier to move your volumes from
#' an on-premises gateway to a gateway hosted on an Amazon EC2 instance.
#'
#' @usage
#' storagegateway_attach_volume(GatewayARN, TargetName, VolumeARN,
#'   NetworkInterfaceId, DiskId)
#'
#' @param GatewayARN &#91;required&#93; The Amazon Resource Name (ARN) of the gateway that you want to attach
#' the volume to.
#' @param TargetName The name of the iSCSI target used by an initiator to connect to a volume
#' and used as a suffix for the target ARN. For example, specifying
#' `TargetName` as *myvolume* results in the target ARN of
#' `arn:aws:storagegateway:us-east-2:111122223333:gateway/sgw-12A3456B/target/iqn.1997-05.com.amazon:myvolume`.
#' The target name must be unique across all volumes on a gateway.
#' 
#' If you don\'t specify a value, Storage Gateway uses the value that was
#' previously used for this volume as the new target name.
#' @param VolumeARN &#91;required&#93; The Amazon Resource Name (ARN) of the volume to attach to the specified
#' gateway.
#' @param NetworkInterfaceId &#91;required&#93; The network interface of the gateway on which to expose the iSCSI
#' target. Only IPv4 addresses are accepted. Use DescribeGatewayInformation
#' to get a list of the network interfaces available on a gateway.
#' 
#' Valid Values: A valid IP address.
#' @param DiskId The unique device ID or other distinguishing data that identifies the
#' local disk used to create the volume. This value is only required when
#' you are attaching a stored volume.
#'
#' @section Request syntax:
#' ```
#' svc$attach_volume(
#'   GatewayARN = "string",
#'   TargetName = "string",
#'   VolumeARN = "string",
#'   NetworkInterfaceId = "string",
#'   DiskId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname storagegateway_attach_volume
storagegateway_attach_volume <- function(GatewayARN, TargetName = NULL, VolumeARN, NetworkInterfaceId, DiskId = NULL) {
  op <- new_operation(
    name = "AttachVolume",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .storagegateway$attach_volume_input(GatewayARN = GatewayARN, TargetName = TargetName, VolumeARN = VolumeARN, NetworkInterfaceId = NetworkInterfaceId, DiskId = DiskId)
  output <- .storagegateway$attach_volume_output()
  config <- get_config()
  svc <- .storagegateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$attach_volume <- storagegateway_attach_volume

#' Cancels archiving of a virtual tape to the virtual tape shelf (VTS)
#' after the archiving process is initiated
#'
#' Cancels archiving of a virtual tape to the virtual tape shelf (VTS)
#' after the archiving process is initiated. This operation is only
#' supported in the tape gateway type.
#'
#' @usage
#' storagegateway_cancel_archival(GatewayARN, TapeARN)
#'
#' @param GatewayARN &#91;required&#93; 
#' @param TapeARN &#91;required&#93; The Amazon Resource Name (ARN) of the virtual tape you want to cancel
#' archiving for.
#'
#' @section Request syntax:
#' ```
#' svc$cancel_archival(
#'   GatewayARN = "string",
#'   TapeARN = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # Cancels archiving of a virtual tape to the virtual tape shelf (VTS)
#' # after the archiving process is initiated.
#' svc$cancel_archival(
#'   GatewayARN = "arn:aws:storagegateway:us-east-1:111122223333:gateway/sgw-12A3456B",
#'   TapeARN = "arn:aws:storagegateway:us-east-1:999999999999:tape/AMZN01A2A4"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname storagegateway_cancel_archival
storagegateway_cancel_archival <- function(GatewayARN, TapeARN) {
  op <- new_operation(
    name = "CancelArchival",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .storagegateway$cancel_archival_input(GatewayARN = GatewayARN, TapeARN = TapeARN)
  output <- .storagegateway$cancel_archival_output()
  config <- get_config()
  svc <- .storagegateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$cancel_archival <- storagegateway_cancel_archival

#' Cancels retrieval of a virtual tape from the virtual tape shelf (VTS) to
#' a gateway after the retrieval process is initiated
#'
#' Cancels retrieval of a virtual tape from the virtual tape shelf (VTS) to
#' a gateway after the retrieval process is initiated. The virtual tape is
#' returned to the VTS. This operation is only supported in the tape
#' gateway type.
#'
#' @usage
#' storagegateway_cancel_retrieval(GatewayARN, TapeARN)
#'
#' @param GatewayARN &#91;required&#93; 
#' @param TapeARN &#91;required&#93; The Amazon Resource Name (ARN) of the virtual tape you want to cancel
#' retrieval for.
#'
#' @section Request syntax:
#' ```
#' svc$cancel_retrieval(
#'   GatewayARN = "string",
#'   TapeARN = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # Cancels retrieval of a virtual tape from the virtual tape shelf (VTS) to
#' # a gateway after the retrieval process is initiated.
#' svc$cancel_retrieval(
#'   GatewayARN = "arn:aws:storagegateway:us-east-1:111122223333:gateway/sgw-12A3456B",
#'   TapeARN = "arn:aws:storagegateway:us-east-1:999999999999:tape/AMZN01A2A4"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname storagegateway_cancel_retrieval
storagegateway_cancel_retrieval <- function(GatewayARN, TapeARN) {
  op <- new_operation(
    name = "CancelRetrieval",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .storagegateway$cancel_retrieval_input(GatewayARN = GatewayARN, TapeARN = TapeARN)
  output <- .storagegateway$cancel_retrieval_output()
  config <- get_config()
  svc <- .storagegateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$cancel_retrieval <- storagegateway_cancel_retrieval

#' Creates a cached volume on a specified cached volume gateway
#'
#' Creates a cached volume on a specified cached volume gateway. This
#' operation is only supported in the cached volume gateway type.
#' 
#' Cache storage must be allocated to the gateway before you can create a
#' cached volume. Use the AddCache operation to add cache storage to a
#' gateway.
#' 
#' In the request, you must specify the gateway, size of the volume in
#' bytes, the iSCSI target name, an IP address on which to expose the
#' target, and a unique client token. In response, the gateway creates the
#' volume and returns information about it. This information includes the
#' volume Amazon Resource Name (ARN), its size, and the iSCSI target ARN
#' that initiators can use to connect to the volume target.
#' 
#' Optionally, you can provide the ARN for an existing volume as the
#' `SourceVolumeARN` for this cached volume, which creates an exact copy of
#' the existing volume's latest recovery point. The `VolumeSizeInBytes`
#' value must be equal to or larger than the size of the copied volume, in
#' bytes.
#'
#' @usage
#' storagegateway_create_cachedi_scsi_volume(GatewayARN, VolumeSizeInBytes,
#'   SnapshotId, TargetName, SourceVolumeARN, NetworkInterfaceId,
#'   ClientToken, KMSEncrypted, KMSKey, Tags)
#'
#' @param GatewayARN &#91;required&#93; 
#' @param VolumeSizeInBytes &#91;required&#93; The size of the volume in bytes.
#' @param SnapshotId The snapshot ID (e.g. \"snap-1122aabb\") of the snapshot to restore as
#' the new cached volume. Specify this field if you want to create the
#' iSCSI storage volume from a snapshot otherwise do not include this
#' field. To list snapshots for your account use
#' [DescribeSnapshots](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/ApiReference-query-DescribeSnapshots.html)
#' in the *Amazon Elastic Compute Cloud API Reference*.
#' @param TargetName &#91;required&#93; The name of the iSCSI target used by an initiator to connect to a volume
#' and used as a suffix for the target ARN. For example, specifying
#' `TargetName` as *myvolume* results in the target ARN of
#' `arn:aws:storagegateway:us-east-2:111122223333:gateway/sgw-12A3456B/target/iqn.1997-05.com.amazon:myvolume`.
#' The target name must be unique across all volumes on a gateway.
#' 
#' If you don\'t specify a value, Storage Gateway uses the value that was
#' previously used for this volume as the new target name.
#' @param SourceVolumeARN The ARN for an existing volume. Specifying this ARN makes the new volume
#' into an exact copy of the specified existing volume\'s latest recovery
#' point. The `VolumeSizeInBytes` value for this new volume must be equal
#' to or larger than the size of the existing volume, in bytes.
#' @param NetworkInterfaceId &#91;required&#93; The network interface of the gateway on which to expose the iSCSI
#' target. Only IPv4 addresses are accepted. Use DescribeGatewayInformation
#' to get a list of the network interfaces available on a gateway.
#' 
#' Valid Values: A valid IP address.
#' @param ClientToken &#91;required&#93; A unique identifier that you use to retry a request. If you retry a
#' request, use the same `ClientToken` you specified in the initial
#' request.
#' @param KMSEncrypted True to use Amazon S3 server side encryption with your own AWS KMS key,
#' or false to use a key managed by Amazon S3. Optional.
#' @param KMSKey The Amazon Resource Name (ARN) of the AWS KMS key used for Amazon S3
#' server side encryption. This value can only be set when KMSEncrypted is
#' true. Optional.
#' @param Tags A list of up to 50 tags that you can assign to a cached volume. Each tag
#' is a key-value pair.
#' 
#' Valid characters for key and value are letters, spaces, and numbers that
#' you can represent in UTF-8 format, and the following special characters:
#' + - = . \\_ : / @@. The maximum length of a tag\'s key is 128 characters,
#' and the maximum length for a tag\'s value is 256 characters.
#'
#' @section Request syntax:
#' ```
#' svc$create_cachedi_scsi_volume(
#'   GatewayARN = "string",
#'   VolumeSizeInBytes = 123,
#'   SnapshotId = "string",
#'   TargetName = "string",
#'   SourceVolumeARN = "string",
#'   NetworkInterfaceId = "string",
#'   ClientToken = "string",
#'   KMSEncrypted = TRUE|FALSE,
#'   KMSKey = "string",
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # Creates a cached volume on a specified cached gateway.
#' svc$create_cachedi_scsi_volume(
#'   ClientToken = "cachedvol112233",
#'   GatewayARN = "arn:aws:storagegateway:us-east-1:111122223333:gateway/sgw-12A3456B",
#'   NetworkInterfaceId = "10.1.1.1",
#'   SnapshotId = "snap-f47b7b94",
#'   TargetName = "my-volume",
#'   VolumeSizeInBytes = 536870912000
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname storagegateway_create_cachedi_scsi_volume
storagegateway_create_cachedi_scsi_volume <- function(GatewayARN, VolumeSizeInBytes, SnapshotId = NULL, TargetName, SourceVolumeARN = NULL, NetworkInterfaceId, ClientToken, KMSEncrypted = NULL, KMSKey = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateCachediSCSIVolume",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .storagegateway$create_cachedi_scsi_volume_input(GatewayARN = GatewayARN, VolumeSizeInBytes = VolumeSizeInBytes, SnapshotId = SnapshotId, TargetName = TargetName, SourceVolumeARN = SourceVolumeARN, NetworkInterfaceId = NetworkInterfaceId, ClientToken = ClientToken, KMSEncrypted = KMSEncrypted, KMSKey = KMSKey, Tags = Tags)
  output <- .storagegateway$create_cachedi_scsi_volume_output()
  config <- get_config()
  svc <- .storagegateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$create_cachedi_scsi_volume <- storagegateway_create_cachedi_scsi_volume

#' Creates a Network File System (NFS) file share on an existing file
#' gateway
#'
#' Creates a Network File System (NFS) file share on an existing file
#' gateway. In Storage Gateway, a file share is a file system mount point
#' backed by Amazon S3 cloud storage. Storage Gateway exposes file shares
#' using a NFS interface. This operation is only supported for file
#' gateways.
#' 
#' File gateway requires AWS Security Token Service (AWS STS) to be
#' activated to enable you create a file share. Make sure AWS STS is
#' activated in the AWS Region you are creating your file gateway in. If
#' AWS STS is not activated in the AWS Region, activate it. For information
#' about how to activate AWS STS, see Activating and Deactivating AWS STS
#' in an AWS Region in the AWS Identity and Access Management User Guide.
#' 
#' File gateway does not support creating hard or symbolic links on a file
#' share.
#'
#' @usage
#' storagegateway_create_nfs_file_share(ClientToken, NFSFileShareDefaults,
#'   GatewayARN, KMSEncrypted, KMSKey, Role, LocationARN,
#'   DefaultStorageClass, ObjectACL, ClientList, Squash, ReadOnly,
#'   GuessMIMETypeEnabled, RequesterPays, Tags)
#'
#' @param ClientToken &#91;required&#93; A unique string value that you supply that is used by file gateway to
#' ensure idempotent file share creation.
#' @param NFSFileShareDefaults File share default values. Optional.
#' @param GatewayARN &#91;required&#93; The Amazon Resource Name (ARN) of the file gateway on which you want to
#' create a file share.
#' @param KMSEncrypted True to use Amazon S3 server side encryption with your own AWS KMS key,
#' or false to use a key managed by Amazon S3. Optional.
#' @param KMSKey The Amazon Resource Name (ARN) AWS KMS key used for Amazon S3 server
#' side encryption. This value can only be set when KMSEncrypted is true.
#' Optional.
#' @param Role &#91;required&#93; The ARN of the AWS Identity and Access Management (IAM) role that a file
#' gateway assumes when it accesses the underlying storage.
#' @param LocationARN &#91;required&#93; The ARN of the backed storage used for storing file data.
#' @param DefaultStorageClass The default storage class for objects put into an Amazon S3 bucket by
#' the file gateway. Possible values are `S3_STANDARD`, `S3_STANDARD_IA`,
#' or `S3_ONEZONE_IA`. If this field is not populated, the default value
#' `S3_STANDARD` is used. Optional.
#' @param ObjectACL A value that sets the access control list permission for objects in the
#' S3 bucket that a file gateway puts objects into. The default value is
#' \"private\".
#' @param ClientList The list of clients that are allowed to access the file gateway. The
#' list must contain either valid IP addresses or valid CIDR blocks.
#' @param Squash A value that maps a user to anonymous user. Valid options are the
#' following:
#' 
#' -   `RootSquash` - Only root is mapped to anonymous user.
#' 
#' -   `NoSquash` - No one is mapped to anonymous user
#' 
#' -   `AllSquash` - Everyone is mapped to anonymous user.
#' @param ReadOnly A value that sets the write status of a file share. This value is true
#' if the write status is read-only, and otherwise false.
#' @param GuessMIMETypeEnabled A value that enables guessing of the MIME type for uploaded objects
#' based on file extensions. Set this value to true to enable MIME type
#' guessing, and otherwise to false. The default value is true.
#' @param RequesterPays A value that sets who pays the cost of the request and the cost
#' associated with data download from the S3 bucket. If this value is set
#' to true, the requester pays the costs. Otherwise the S3 bucket owner
#' pays. However, the S3 bucket owner always pays the cost of storing data.
#' 
#' `RequesterPays` is a configuration for the S3 bucket that backs the file
#' share, so make sure that the configuration on the file share is the same
#' as the S3 bucket configuration.
#' @param Tags A list of up to 50 tags that can be assigned to the NFS file share. Each
#' tag is a key-value pair.
#' 
#' Valid characters for key and value are letters, spaces, and numbers
#' representable in UTF-8 format, and the following special characters: + -
#' = . \\_ : / @@. The maximum length of a tag\'s key is 128 characters, and
#' the maximum length for a tag\'s value is 256.
#'
#' @section Request syntax:
#' ```
#' svc$create_nfs_file_share(
#'   ClientToken = "string",
#'   NFSFileShareDefaults = list(
#'     FileMode = "string",
#'     DirectoryMode = "string",
#'     GroupId = 123,
#'     OwnerId = 123
#'   ),
#'   GatewayARN = "string",
#'   KMSEncrypted = TRUE|FALSE,
#'   KMSKey = "string",
#'   Role = "string",
#'   LocationARN = "string",
#'   DefaultStorageClass = "string",
#'   ObjectACL = "private"|"public-read"|"public-read-write"|"authenticated-read"|"bucket-owner-read"|"bucket-owner-full-control"|"aws-exec-read",
#'   ClientList = list(
#'     "string"
#'   ),
#'   Squash = "string",
#'   ReadOnly = TRUE|FALSE,
#'   GuessMIMETypeEnabled = TRUE|FALSE,
#'   RequesterPays = TRUE|FALSE,
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname storagegateway_create_nfs_file_share
storagegateway_create_nfs_file_share <- function(ClientToken, NFSFileShareDefaults = NULL, GatewayARN, KMSEncrypted = NULL, KMSKey = NULL, Role, LocationARN, DefaultStorageClass = NULL, ObjectACL = NULL, ClientList = NULL, Squash = NULL, ReadOnly = NULL, GuessMIMETypeEnabled = NULL, RequesterPays = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateNFSFileShare",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .storagegateway$create_nfs_file_share_input(ClientToken = ClientToken, NFSFileShareDefaults = NFSFileShareDefaults, GatewayARN = GatewayARN, KMSEncrypted = KMSEncrypted, KMSKey = KMSKey, Role = Role, LocationARN = LocationARN, DefaultStorageClass = DefaultStorageClass, ObjectACL = ObjectACL, ClientList = ClientList, Squash = Squash, ReadOnly = ReadOnly, GuessMIMETypeEnabled = GuessMIMETypeEnabled, RequesterPays = RequesterPays, Tags = Tags)
  output <- .storagegateway$create_nfs_file_share_output()
  config <- get_config()
  svc <- .storagegateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$create_nfs_file_share <- storagegateway_create_nfs_file_share

#' Creates a Server Message Block (SMB) file share on an existing file
#' gateway
#'
#' Creates a Server Message Block (SMB) file share on an existing file
#' gateway. In Storage Gateway, a file share is a file system mount point
#' backed by Amazon S3 cloud storage. Storage Gateway expose file shares
#' using a SMB interface. This operation is only supported for file
#' gateways.
#' 
#' File gateways require AWS Security Token Service (AWS STS) to be
#' activated to enable you to create a file share. Make sure that AWS STS
#' is activated in the AWS Region you are creating your file gateway in. If
#' AWS STS is not activated in this AWS Region, activate it. For
#' information about how to activate AWS STS, see [Activating and
#' Deactivating AWS STS in an AWS
#' Region](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_enable-regions.html)
#' in the *AWS Identity and Access Management User Guide.*
#' 
#' File gateways don\'t support creating hard or symbolic links on a file
#' share.
#'
#' @usage
#' storagegateway_create_smb_file_share(ClientToken, GatewayARN,
#'   KMSEncrypted, KMSKey, Role, LocationARN, DefaultStorageClass, ObjectACL,
#'   ReadOnly, GuessMIMETypeEnabled, RequesterPays, SMBACLEnabled,
#'   AdminUserList, ValidUserList, InvalidUserList, Authentication, Tags)
#'
#' @param ClientToken &#91;required&#93; A unique string value that you supply that is used by file gateway to
#' ensure idempotent file share creation.
#' @param GatewayARN &#91;required&#93; The Amazon Resource Name (ARN) of the file gateway on which you want to
#' create a file share.
#' @param KMSEncrypted True to use Amazon S3 server side encryption with your own AWS KMS key,
#' or false to use a key managed by Amazon S3. Optional.
#' @param KMSKey The Amazon Resource Name (ARN) of the AWS KMS key used for Amazon S3
#' server side encryption. This value can only be set when KMSEncrypted is
#' true. Optional.
#' @param Role &#91;required&#93; The ARN of the AWS Identity and Access Management (IAM) role that a file
#' gateway assumes when it accesses the underlying storage.
#' @param LocationARN &#91;required&#93; The ARN of the backed storage used for storing file data.
#' @param DefaultStorageClass The default storage class for objects put into an Amazon S3 bucket by
#' the file gateway. Possible values are `S3_STANDARD`, `S3_STANDARD_IA`,
#' or `S3_ONEZONE_IA`. If this field is not populated, the default value
#' `S3_STANDARD` is used. Optional.
#' @param ObjectACL A value that sets the access control list permission for objects in the
#' S3 bucket that a file gateway puts objects into. The default value is
#' \"private\".
#' @param ReadOnly A value that sets the write status of a file share. This value is true
#' if the write status is read-only, and otherwise false.
#' @param GuessMIMETypeEnabled A value that enables guessing of the MIME type for uploaded objects
#' based on file extensions. Set this value to true to enable MIME type
#' guessing, and otherwise to false. The default value is true.
#' @param RequesterPays A value that sets who pays the cost of the request and the cost
#' associated with data download from the S3 bucket. If this value is set
#' to true, the requester pays the costs. Otherwise the S3 bucket owner
#' pays. However, the S3 bucket owner always pays the cost of storing data.
#' 
#' `RequesterPays` is a configuration for the S3 bucket that backs the file
#' share, so make sure that the configuration on the file share is the same
#' as the S3 bucket configuration.
#' @param SMBACLEnabled Set this value to \"true to enable ACL (access control list) on the SMB
#' file share. Set it to \"false\" to map file and directory permissions to
#' the POSIX permissions.
#' 
#' For more information, see
#' https://docs.aws.amazon.com/storagegateway/latest/userguide/smb-acl.html
#' in the Storage Gateway User Guide.
#' @param AdminUserList A list of users in the Active Directory that will be granted
#' administrator privileges on the file share. These users can do all file
#' operations as the super-user.
#' 
#' Use this option very carefully, because any user in this list can do
#' anything they like on the file share, regardless of file permissions.
#' @param ValidUserList A list of users or groups in the Active Directory that are allowed to
#' access the file share. A group must be prefixed with the @@ character.
#' For example `@@group1`. Can only be set if Authentication is set to
#' `ActiveDirectory`.
#' @param InvalidUserList A list of users or groups in the Active Directory that are not allowed
#' to access the file share. A group must be prefixed with the @@ character.
#' For example `@@group1`. Can only be set if Authentication is set to
#' `ActiveDirectory`.
#' @param Authentication The authentication method that users use to access the file share.
#' 
#' Valid values are `ActiveDirectory` or `GuestAccess`. The default is
#' `ActiveDirectory`.
#' @param Tags A list of up to 50 tags that can be assigned to the NFS file share. Each
#' tag is a key-value pair.
#' 
#' Valid characters for key and value are letters, spaces, and numbers
#' representable in UTF-8 format, and the following special characters: + -
#' = . \\_ : / @@. The maximum length of a tag\'s key is 128 characters, and
#' the maximum length for a tag\'s value is 256.
#'
#' @section Request syntax:
#' ```
#' svc$create_smb_file_share(
#'   ClientToken = "string",
#'   GatewayARN = "string",
#'   KMSEncrypted = TRUE|FALSE,
#'   KMSKey = "string",
#'   Role = "string",
#'   LocationARN = "string",
#'   DefaultStorageClass = "string",
#'   ObjectACL = "private"|"public-read"|"public-read-write"|"authenticated-read"|"bucket-owner-read"|"bucket-owner-full-control"|"aws-exec-read",
#'   ReadOnly = TRUE|FALSE,
#'   GuessMIMETypeEnabled = TRUE|FALSE,
#'   RequesterPays = TRUE|FALSE,
#'   SMBACLEnabled = TRUE|FALSE,
#'   AdminUserList = list(
#'     "string"
#'   ),
#'   ValidUserList = list(
#'     "string"
#'   ),
#'   InvalidUserList = list(
#'     "string"
#'   ),
#'   Authentication = "string",
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname storagegateway_create_smb_file_share
storagegateway_create_smb_file_share <- function(ClientToken, GatewayARN, KMSEncrypted = NULL, KMSKey = NULL, Role, LocationARN, DefaultStorageClass = NULL, ObjectACL = NULL, ReadOnly = NULL, GuessMIMETypeEnabled = NULL, RequesterPays = NULL, SMBACLEnabled = NULL, AdminUserList = NULL, ValidUserList = NULL, InvalidUserList = NULL, Authentication = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateSMBFileShare",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .storagegateway$create_smb_file_share_input(ClientToken = ClientToken, GatewayARN = GatewayARN, KMSEncrypted = KMSEncrypted, KMSKey = KMSKey, Role = Role, LocationARN = LocationARN, DefaultStorageClass = DefaultStorageClass, ObjectACL = ObjectACL, ReadOnly = ReadOnly, GuessMIMETypeEnabled = GuessMIMETypeEnabled, RequesterPays = RequesterPays, SMBACLEnabled = SMBACLEnabled, AdminUserList = AdminUserList, ValidUserList = ValidUserList, InvalidUserList = InvalidUserList, Authentication = Authentication, Tags = Tags)
  output <- .storagegateway$create_smb_file_share_output()
  config <- get_config()
  svc <- .storagegateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$create_smb_file_share <- storagegateway_create_smb_file_share

#' Initiates a snapshot of a volume
#'
#' Initiates a snapshot of a volume.
#' 
#' AWS Storage Gateway provides the ability to back up point-in-time
#' snapshots of your data to Amazon Simple Storage (S3) for durable
#' off-site recovery, as well as import the data to an Amazon Elastic Block
#' Store (EBS) volume in Amazon Elastic Compute Cloud (EC2). You can take
#' snapshots of your gateway volume on a scheduled or ad hoc basis. This
#' API enables you to take ad-hoc snapshot. For more information, see
#' [Editing a Snapshot
#' Schedule](https://docs.aws.amazon.com/storagegateway/latest/userguide/managing-volumes.html#SchedulingSnapshot).
#' 
#' In the CreateSnapshot request you identify the volume by providing its
#' Amazon Resource Name (ARN). You must also provide description for the
#' snapshot. When AWS Storage Gateway takes the snapshot of specified
#' volume, the snapshot and description appears in the AWS Storage Gateway
#' Console. In response, AWS Storage Gateway returns you a snapshot ID. You
#' can use this snapshot ID to check the snapshot progress or later use it
#' when you want to create a volume from a snapshot. This operation is only
#' supported in stored and cached volume gateway type.
#' 
#' To list or delete a snapshot, you must use the Amazon EC2 API. For more
#' information, see DescribeSnapshots or DeleteSnapshot in the [EC2 API
#' reference](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_Operations.html).
#' 
#' Volume and snapshot IDs are changing to a longer length ID format. For
#' more information, see the important note on the
#' [Welcome](https://docs.aws.amazon.com/storagegateway/latest/APIReference/Welcome.html)
#' page.
#'
#' @usage
#' storagegateway_create_snapshot(VolumeARN, SnapshotDescription, Tags)
#'
#' @param VolumeARN &#91;required&#93; The Amazon Resource Name (ARN) of the volume. Use the ListVolumes
#' operation to return a list of gateway volumes.
#' @param SnapshotDescription &#91;required&#93; Textual description of the snapshot that appears in the Amazon EC2
#' console, Elastic Block Store snapshots panel in the **Description**
#' field, and in the AWS Storage Gateway snapshot **Details** pane,
#' **Description** field
#' @param Tags A list of up to 50 tags that can be assigned to a snapshot. Each tag is
#' a key-value pair.
#' 
#' Valid characters for key and value are letters, spaces, and numbers
#' representable in UTF-8 format, and the following special characters: + -
#' = . \\_ : / @@. The maximum length of a tag\'s key is 128 characters, and
#' the maximum length for a tag\'s value is 256.
#'
#' @section Request syntax:
#' ```
#' svc$create_snapshot(
#'   VolumeARN = "string",
#'   SnapshotDescription = "string",
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # Initiates an ad-hoc snapshot of a gateway volume.
#' svc$create_snapshot(
#'   SnapshotDescription = "My root volume snapshot as of 10/03/2017",
#'   VolumeARN = "arn:aws:storagegateway:us-east-1:111122223333:gateway/sgw-12A3456B/volume/vol..."
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname storagegateway_create_snapshot
storagegateway_create_snapshot <- function(VolumeARN, SnapshotDescription, Tags = NULL) {
  op <- new_operation(
    name = "CreateSnapshot",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .storagegateway$create_snapshot_input(VolumeARN = VolumeARN, SnapshotDescription = SnapshotDescription, Tags = Tags)
  output <- .storagegateway$create_snapshot_output()
  config <- get_config()
  svc <- .storagegateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$create_snapshot <- storagegateway_create_snapshot

#' Initiates a snapshot of a gateway from a volume recovery point
#'
#' Initiates a snapshot of a gateway from a volume recovery point. This
#' operation is only supported in the cached volume gateway type.
#' 
#' A volume recovery point is a point in time at which all data of the
#' volume is consistent and from which you can create a snapshot. To get a
#' list of volume recovery point for cached volume gateway, use
#' ListVolumeRecoveryPoints.
#' 
#' In the `CreateSnapshotFromVolumeRecoveryPoint` request, you identify the
#' volume by providing its Amazon Resource Name (ARN). You must also
#' provide a description for the snapshot. When the gateway takes a
#' snapshot of the specified volume, the snapshot and its description
#' appear in the AWS Storage Gateway console. In response, the gateway
#' returns you a snapshot ID. You can use this snapshot ID to check the
#' snapshot progress or later use it when you want to create a volume from
#' a snapshot.
#' 
#' To list or delete a snapshot, you must use the Amazon EC2 API. For more
#' information, in *Amazon Elastic Compute Cloud API Reference*.
#'
#' @usage
#' storagegateway_create_snapshot_from_volume_recovery_point(VolumeARN,
#'   SnapshotDescription, Tags)
#'
#' @param VolumeARN &#91;required&#93; The Amazon Resource Name (ARN) of the iSCSI volume target. Use the
#' DescribeStorediSCSIVolumes operation to return to retrieve the TargetARN
#' for specified VolumeARN.
#' @param SnapshotDescription &#91;required&#93; Textual description of the snapshot that appears in the Amazon EC2
#' console, Elastic Block Store snapshots panel in the **Description**
#' field, and in the AWS Storage Gateway snapshot **Details** pane,
#' **Description** field
#' @param Tags A list of up to 50 tags that can be assigned to a snapshot. Each tag is
#' a key-value pair.
#' 
#' Valid characters for key and value are letters, spaces, and numbers
#' representable in UTF-8 format, and the following special characters: + -
#' = . \\_ : / @@. The maximum length of a tag\'s key is 128 characters, and
#' the maximum length for a tag\'s value is 256.
#'
#' @section Request syntax:
#' ```
#' svc$create_snapshot_from_volume_recovery_point(
#'   VolumeARN = "string",
#'   SnapshotDescription = "string",
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # Initiates a snapshot of a gateway from a volume recovery point.
#' svc$create_snapshot_from_volume_recovery_point(
#'   SnapshotDescription = "My root volume snapshot as of 2017-06-30T10:10:10.000Z",
#'   VolumeARN = "arn:aws:storagegateway:us-east-1:111122223333:gateway/sgw-12A3456B/volume/vol..."
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname storagegateway_create_snapshot_from_volume_recovery_point
storagegateway_create_snapshot_from_volume_recovery_point <- function(VolumeARN, SnapshotDescription, Tags = NULL) {
  op <- new_operation(
    name = "CreateSnapshotFromVolumeRecoveryPoint",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .storagegateway$create_snapshot_from_volume_recovery_point_input(VolumeARN = VolumeARN, SnapshotDescription = SnapshotDescription, Tags = Tags)
  output <- .storagegateway$create_snapshot_from_volume_recovery_point_output()
  config <- get_config()
  svc <- .storagegateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$create_snapshot_from_volume_recovery_point <- storagegateway_create_snapshot_from_volume_recovery_point

#' Creates a volume on a specified gateway
#'
#' Creates a volume on a specified gateway. This operation is only
#' supported in the stored volume gateway type.
#' 
#' The size of the volume to create is inferred from the disk size. You can
#' choose to preserve existing data on the disk, create volume from an
#' existing snapshot, or create an empty volume. If you choose to create an
#' empty gateway volume, then any existing data on the disk is erased.
#' 
#' In the request you must specify the gateway and the disk information on
#' which you are creating the volume. In response, the gateway creates the
#' volume and returns volume information such as the volume Amazon Resource
#' Name (ARN), its size, and the iSCSI target ARN that initiators can use
#' to connect to the volume target.
#'
#' @usage
#' storagegateway_create_storedi_scsi_volume(GatewayARN, DiskId,
#'   SnapshotId, PreserveExistingData, TargetName, NetworkInterfaceId,
#'   KMSEncrypted, KMSKey, Tags)
#'
#' @param GatewayARN &#91;required&#93; 
#' @param DiskId &#91;required&#93; The unique identifier for the gateway local disk that is configured as a
#' stored volume. Use
#' [ListLocalDisks](https://docs.aws.amazon.com/storagegateway/latest/userguide/API_ListLocalDisks.html)
#' to list disk IDs for a gateway.
#' @param SnapshotId The snapshot ID (e.g. \"snap-1122aabb\") of the snapshot to restore as
#' the new stored volume. Specify this field if you want to create the
#' iSCSI storage volume from a snapshot otherwise do not include this
#' field. To list snapshots for your account use
#' [DescribeSnapshots](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/ApiReference-query-DescribeSnapshots.html)
#' in the *Amazon Elastic Compute Cloud API Reference*.
#' @param PreserveExistingData &#91;required&#93; Specify this field as true if you want to preserve the data on the local
#' disk. Otherwise, specifying this field as false creates an empty volume.
#' 
#' Valid Values: true, false
#' @param TargetName &#91;required&#93; The name of the iSCSI target used by an initiator to connect to a volume
#' and used as a suffix for the target ARN. For example, specifying
#' `TargetName` as *myvolume* results in the target ARN of
#' `arn:aws:storagegateway:us-east-2:111122223333:gateway/sgw-12A3456B/target/iqn.1997-05.com.amazon:myvolume`.
#' The target name must be unique across all volumes on a gateway.
#' 
#' If you don\'t specify a value, Storage Gateway uses the value that was
#' previously used for this volume as the new target name.
#' @param NetworkInterfaceId &#91;required&#93; The network interface of the gateway on which to expose the iSCSI
#' target. Only IPv4 addresses are accepted. Use DescribeGatewayInformation
#' to get a list of the network interfaces available on a gateway.
#' 
#' Valid Values: A valid IP address.
#' @param KMSEncrypted True to use Amazon S3 server side encryption with your own AWS KMS key,
#' or false to use a key managed by Amazon S3. Optional.
#' @param KMSKey The Amazon Resource Name (ARN) of the KMS key used for Amazon S3 server
#' side encryption. This value can only be set when KMSEncrypted is true.
#' Optional.
#' @param Tags A list of up to 50 tags that can be assigned to a stored volume. Each
#' tag is a key-value pair.
#' 
#' Valid characters for key and value are letters, spaces, and numbers
#' representable in UTF-8 format, and the following special characters: + -
#' = . \\_ : / @@. The maximum length of a tag\'s key is 128 characters, and
#' the maximum length for a tag\'s value is 256.
#'
#' @section Request syntax:
#' ```
#' svc$create_storedi_scsi_volume(
#'   GatewayARN = "string",
#'   DiskId = "string",
#'   SnapshotId = "string",
#'   PreserveExistingData = TRUE|FALSE,
#'   TargetName = "string",
#'   NetworkInterfaceId = "string",
#'   KMSEncrypted = TRUE|FALSE,
#'   KMSKey = "string",
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # Creates a stored volume on a specified stored gateway.
#' svc$create_storedi_scsi_volume(
#'   DiskId = "pci-0000:03:00.0-scsi-0:0:0:0",
#'   GatewayARN = "arn:aws:storagegateway:us-east-1:111122223333:gateway/sgw-12A3456B",
#'   NetworkInterfaceId = "10.1.1.1",
#'   PreserveExistingData = TRUE,
#'   SnapshotId = "snap-f47b7b94",
#'   TargetName = "my-volume"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname storagegateway_create_storedi_scsi_volume
storagegateway_create_storedi_scsi_volume <- function(GatewayARN, DiskId, SnapshotId = NULL, PreserveExistingData, TargetName, NetworkInterfaceId, KMSEncrypted = NULL, KMSKey = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateStorediSCSIVolume",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .storagegateway$create_storedi_scsi_volume_input(GatewayARN = GatewayARN, DiskId = DiskId, SnapshotId = SnapshotId, PreserveExistingData = PreserveExistingData, TargetName = TargetName, NetworkInterfaceId = NetworkInterfaceId, KMSEncrypted = KMSEncrypted, KMSKey = KMSKey, Tags = Tags)
  output <- .storagegateway$create_storedi_scsi_volume_output()
  config <- get_config()
  svc <- .storagegateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$create_storedi_scsi_volume <- storagegateway_create_storedi_scsi_volume

#' Creates a virtual tape by using your own barcode
#'
#' Creates a virtual tape by using your own barcode. You write data to the
#' virtual tape and then archive the tape. A barcode is unique and can not
#' be reused if it has already been used on a tape . This applies to
#' barcodes used on deleted tapes. This operation is only supported in the
#' tape gateway type.
#' 
#' Cache storage must be allocated to the gateway before you can create a
#' virtual tape. Use the AddCache operation to add cache storage to a
#' gateway.
#'
#' @usage
#' storagegateway_create_tape_with_barcode(GatewayARN, TapeSizeInBytes,
#'   TapeBarcode, KMSEncrypted, KMSKey, PoolId, Tags)
#'
#' @param GatewayARN &#91;required&#93; The unique Amazon Resource Name (ARN) that represents the gateway to
#' associate the virtual tape with. Use the ListGateways operation to
#' return a list of gateways for your account and AWS Region.
#' @param TapeSizeInBytes &#91;required&#93; The size, in bytes, of the virtual tape that you want to create.
#' 
#' The size must be aligned by gigabyte (1024*1024*1024 byte).
#' @param TapeBarcode &#91;required&#93; The barcode that you want to assign to the tape.
#' 
#' Barcodes cannot be reused. This includes barcodes used for tapes that
#' have been deleted.
#' @param KMSEncrypted True to use Amazon S3 server side encryption with your own AWS KMS key,
#' or false to use a key managed by Amazon S3. Optional.
#' @param KMSKey The Amazon Resource Name (ARN) of the AWS KMS Key used for Amazon S3
#' server side encryption. This value can only be set when KMSEncrypted is
#' true. Optional.
#' @param PoolId The ID of the pool that you want to add your tape to for archiving. The
#' tape in this pool is archived in the S3 storage class that is associated
#' with the pool. When you use your backup application to eject the tape,
#' the tape is archived directly into the storage class (Glacier or Deep
#' Archive) that corresponds to the pool.
#' 
#' Valid values: \"GLACIER\", \"DEEP\\_ARCHIVE\"
#' @param Tags A list of up to 50 tags that can be assigned to a virtual tape that has
#' a barcode. Each tag is a key-value pair.
#' 
#' Valid characters for key and value are letters, spaces, and numbers
#' representable in UTF-8 format, and the following special characters: + -
#' = . \\_ : / @@. The maximum length of a tag\'s key is 128 characters, and
#' the maximum length for a tag\'s value is 256.
#'
#' @section Request syntax:
#' ```
#' svc$create_tape_with_barcode(
#'   GatewayARN = "string",
#'   TapeSizeInBytes = 123,
#'   TapeBarcode = "string",
#'   KMSEncrypted = TRUE|FALSE,
#'   KMSKey = "string",
#'   PoolId = "string",
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # Creates a virtual tape by using your own barcode.
#' svc$create_tape_with_barcode(
#'   GatewayARN = "arn:aws:storagegateway:us-east-1:999999999999:gateway/sgw-12A3456B",
#'   TapeBarcode = "TEST12345",
#'   TapeSizeInBytes = 107374182400
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname storagegateway_create_tape_with_barcode
storagegateway_create_tape_with_barcode <- function(GatewayARN, TapeSizeInBytes, TapeBarcode, KMSEncrypted = NULL, KMSKey = NULL, PoolId = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateTapeWithBarcode",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .storagegateway$create_tape_with_barcode_input(GatewayARN = GatewayARN, TapeSizeInBytes = TapeSizeInBytes, TapeBarcode = TapeBarcode, KMSEncrypted = KMSEncrypted, KMSKey = KMSKey, PoolId = PoolId, Tags = Tags)
  output <- .storagegateway$create_tape_with_barcode_output()
  config <- get_config()
  svc <- .storagegateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$create_tape_with_barcode <- storagegateway_create_tape_with_barcode

#' Creates one or more virtual tapes
#'
#' Creates one or more virtual tapes. You write data to the virtual tapes
#' and then archive the tapes. This operation is only supported in the tape
#' gateway type.
#' 
#' Cache storage must be allocated to the gateway before you can create
#' virtual tapes. Use the AddCache operation to add cache storage to a
#' gateway.
#'
#' @usage
#' storagegateway_create_tapes(GatewayARN, TapeSizeInBytes, ClientToken,
#'   NumTapesToCreate, TapeBarcodePrefix, KMSEncrypted, KMSKey, PoolId, Tags)
#'
#' @param GatewayARN &#91;required&#93; The unique Amazon Resource Name (ARN) that represents the gateway to
#' associate the virtual tapes with. Use the ListGateways operation to
#' return a list of gateways for your account and AWS Region.
#' @param TapeSizeInBytes &#91;required&#93; The size, in bytes, of the virtual tapes that you want to create.
#' 
#' The size must be aligned by gigabyte (1024*1024*1024 byte).
#' @param ClientToken &#91;required&#93; A unique identifier that you use to retry a request. If you retry a
#' request, use the same `ClientToken` you specified in the initial
#' request.
#' 
#' Using the same `ClientToken` prevents creating the tape multiple times.
#' @param NumTapesToCreate &#91;required&#93; The number of virtual tapes that you want to create.
#' @param TapeBarcodePrefix &#91;required&#93; A prefix that you append to the barcode of the virtual tape you are
#' creating. This prefix makes the barcode unique.
#' 
#' The prefix must be 1 to 4 characters in length and must be one of the
#' uppercase letters from A to Z.
#' @param KMSEncrypted True to use Amazon S3 server side encryption with your own AWS KMS key,
#' or false to use a key managed by Amazon S3. Optional.
#' @param KMSKey The Amazon Resource Name (ARN) of the AWS KMS key used for Amazon S3
#' server side encryption. This value can only be set when KMSEncrypted is
#' true. Optional.
#' @param PoolId The ID of the pool that you want to add your tape to for archiving. The
#' tape in this pool is archived in the S3 storage class that is associated
#' with the pool. When you use your backup application to eject the tape,
#' the tape is archived directly into the storage class (Glacier or Deep
#' Archive) that corresponds to the pool.
#' 
#' Valid values: \"GLACIER\", \"DEEP\\_ARCHIVE\"
#' @param Tags A list of up to 50 tags that can be assigned to a virtual tape. Each tag
#' is a key-value pair.
#' 
#' Valid characters for key and value are letters, spaces, and numbers
#' representable in UTF-8 format, and the following special characters: + -
#' = . \\_ : / @@. The maximum length of a tag\'s key is 128 characters, and
#' the maximum length for a tag\'s value is 256.
#'
#' @section Request syntax:
#' ```
#' svc$create_tapes(
#'   GatewayARN = "string",
#'   TapeSizeInBytes = 123,
#'   ClientToken = "string",
#'   NumTapesToCreate = 123,
#'   TapeBarcodePrefix = "string",
#'   KMSEncrypted = TRUE|FALSE,
#'   KMSKey = "string",
#'   PoolId = "string",
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # Creates one or more virtual tapes.
#' svc$create_tapes(
#'   ClientToken = "77777",
#'   GatewayARN = "arn:aws:storagegateway:us-east-1:999999999999:gateway/sgw-12A3456B",
#'   NumTapesToCreate = 3L,
#'   TapeBarcodePrefix = "TEST",
#'   TapeSizeInBytes = 107374182400
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname storagegateway_create_tapes
storagegateway_create_tapes <- function(GatewayARN, TapeSizeInBytes, ClientToken, NumTapesToCreate, TapeBarcodePrefix, KMSEncrypted = NULL, KMSKey = NULL, PoolId = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateTapes",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .storagegateway$create_tapes_input(GatewayARN = GatewayARN, TapeSizeInBytes = TapeSizeInBytes, ClientToken = ClientToken, NumTapesToCreate = NumTapesToCreate, TapeBarcodePrefix = TapeBarcodePrefix, KMSEncrypted = KMSEncrypted, KMSKey = KMSKey, PoolId = PoolId, Tags = Tags)
  output <- .storagegateway$create_tapes_output()
  config <- get_config()
  svc <- .storagegateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$create_tapes <- storagegateway_create_tapes

#' Deletes the bandwidth rate limits of a gateway
#'
#' Deletes the bandwidth rate limits of a gateway. You can delete either
#' the upload and download bandwidth rate limit, or you can delete both. If
#' you delete only one of the limits, the other limit remains unchanged. To
#' specify which gateway to work with, use the Amazon Resource Name (ARN)
#' of the gateway in your request. This operation is supported for the
#' stored volume, cached volume and tape gateway types.
#'
#' @usage
#' storagegateway_delete_bandwidth_rate_limit(GatewayARN, BandwidthType)
#'
#' @param GatewayARN &#91;required&#93; 
#' @param BandwidthType &#91;required&#93; One of the BandwidthType values that indicates the gateway bandwidth
#' rate limit to delete.
#' 
#' Valid Values: `Upload`, `Download`, `All`.
#'
#' @section Request syntax:
#' ```
#' svc$delete_bandwidth_rate_limit(
#'   GatewayARN = "string",
#'   BandwidthType = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # Deletes the bandwidth rate limits of a gateway; either the upload or
#' # download limit, or both.
#' svc$delete_bandwidth_rate_limit(
#'   BandwidthType = "All",
#'   GatewayARN = "arn:aws:storagegateway:us-east-1:111122223333:gateway/sgw-12A3456B"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname storagegateway_delete_bandwidth_rate_limit
storagegateway_delete_bandwidth_rate_limit <- function(GatewayARN, BandwidthType) {
  op <- new_operation(
    name = "DeleteBandwidthRateLimit",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .storagegateway$delete_bandwidth_rate_limit_input(GatewayARN = GatewayARN, BandwidthType = BandwidthType)
  output <- .storagegateway$delete_bandwidth_rate_limit_output()
  config <- get_config()
  svc <- .storagegateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$delete_bandwidth_rate_limit <- storagegateway_delete_bandwidth_rate_limit

#' Deletes Challenge-Handshake Authentication Protocol (CHAP) credentials
#' for a specified iSCSI target and initiator pair
#'
#' Deletes Challenge-Handshake Authentication Protocol (CHAP) credentials
#' for a specified iSCSI target and initiator pair. This operation is
#' supported in volume and tape gateway types.
#'
#' @usage
#' storagegateway_delete_chap_credentials(TargetARN, InitiatorName)
#'
#' @param TargetARN &#91;required&#93; The Amazon Resource Name (ARN) of the iSCSI volume target. Use the
#' DescribeStorediSCSIVolumes operation to return to retrieve the TargetARN
#' for specified VolumeARN.
#' @param InitiatorName &#91;required&#93; The iSCSI initiator that connects to the target.
#'
#' @section Request syntax:
#' ```
#' svc$delete_chap_credentials(
#'   TargetARN = "string",
#'   InitiatorName = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # Deletes Challenge-Handshake Authentication Protocol (CHAP) credentials
#' # for a specified iSCSI target and initiator pair.
#' svc$delete_chap_credentials(
#'   InitiatorName = "iqn.1991-05.com.microsoft:computername.domain.example.com",
#'   TargetARN = "arn:aws:storagegateway:us-east-1:111122223333:gateway/sgw-12A3456B/target/iqn..."
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname storagegateway_delete_chap_credentials
storagegateway_delete_chap_credentials <- function(TargetARN, InitiatorName) {
  op <- new_operation(
    name = "DeleteChapCredentials",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .storagegateway$delete_chap_credentials_input(TargetARN = TargetARN, InitiatorName = InitiatorName)
  output <- .storagegateway$delete_chap_credentials_output()
  config <- get_config()
  svc <- .storagegateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$delete_chap_credentials <- storagegateway_delete_chap_credentials

#' Deletes a file share from a file gateway
#'
#' Deletes a file share from a file gateway. This operation is only
#' supported for file gateways.
#'
#' @usage
#' storagegateway_delete_file_share(FileShareARN, ForceDelete)
#'
#' @param FileShareARN &#91;required&#93; The Amazon Resource Name (ARN) of the file share to be deleted.
#' @param ForceDelete If this value is set to true, the operation deletes a file share
#' immediately and aborts all data uploads to AWS. Otherwise, the file
#' share is not deleted until all data is uploaded to AWS. This process
#' aborts the data upload process, and the file share enters the
#' FORCE\\_DELETING status.
#'
#' @section Request syntax:
#' ```
#' svc$delete_file_share(
#'   FileShareARN = "string",
#'   ForceDelete = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname storagegateway_delete_file_share
storagegateway_delete_file_share <- function(FileShareARN, ForceDelete = NULL) {
  op <- new_operation(
    name = "DeleteFileShare",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .storagegateway$delete_file_share_input(FileShareARN = FileShareARN, ForceDelete = ForceDelete)
  output <- .storagegateway$delete_file_share_output()
  config <- get_config()
  svc <- .storagegateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$delete_file_share <- storagegateway_delete_file_share

#' Deletes a gateway
#'
#' Deletes a gateway. To specify which gateway to delete, use the Amazon
#' Resource Name (ARN) of the gateway in your request. The operation
#' deletes the gateway; however, it does not delete the gateway virtual
#' machine (VM) from your host computer.
#' 
#' After you delete a gateway, you cannot reactivate it. Completed
#' snapshots of the gateway volumes are not deleted upon deleting the
#' gateway, however, pending snapshots will not complete. After you delete
#' a gateway, your next step is to remove it from your environment.
#' 
#' You no longer pay software charges after the gateway is deleted;
#' however, your existing Amazon EBS snapshots persist and you will
#' continue to be billed for these snapshots.Â You can choose to remove all
#' remaining Amazon EBS snapshots by canceling your Amazon EC2
#' subscription.Â  If you prefer not to cancel your Amazon EC2 subscription,
#' you can delete your snapshots using the Amazon EC2 console. For more
#' information, see the [AWS Storage Gateway Detail
#' Page](http://aws.amazon.com/storagegateway).
#'
#' @usage
#' storagegateway_delete_gateway(GatewayARN)
#'
#' @param GatewayARN &#91;required&#93; 
#'
#' @section Request syntax:
#' ```
#' svc$delete_gateway(
#'   GatewayARN = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This operation deletes the gateway, but not the gateway's VM from the
#' # host computer.
#' svc$delete_gateway(
#'   GatewayARN = "arn:aws:storagegateway:us-east-1:111122223333:gateway/sgw-12A3456B"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname storagegateway_delete_gateway
storagegateway_delete_gateway <- function(GatewayARN) {
  op <- new_operation(
    name = "DeleteGateway",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .storagegateway$delete_gateway_input(GatewayARN = GatewayARN)
  output <- .storagegateway$delete_gateway_output()
  config <- get_config()
  svc <- .storagegateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$delete_gateway <- storagegateway_delete_gateway

#' Deletes a snapshot of a volume
#'
#' Deletes a snapshot of a volume.
#' 
#' You can take snapshots of your gateway volumes on a scheduled or ad hoc
#' basis. This API action enables you to delete a snapshot schedule for a
#' volume. For more information, see [Working with
#' Snapshots](https://docs.aws.amazon.com/storagegateway/latest/userguide/WorkingWithSnapshots.html).
#' In the `DeleteSnapshotSchedule` request, you identify the volume by
#' providing its Amazon Resource Name (ARN). This operation is only
#' supported in stored and cached volume gateway types.
#' 
#' To list or delete a snapshot, you must use the Amazon EC2 API. in
#' *Amazon Elastic Compute Cloud API Reference*.
#'
#' @usage
#' storagegateway_delete_snapshot_schedule(VolumeARN)
#'
#' @param VolumeARN &#91;required&#93; The volume which snapshot schedule to delete.
#'
#' @section Request syntax:
#' ```
#' svc$delete_snapshot_schedule(
#'   VolumeARN = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This action enables you to delete a snapshot schedule for a volume.
#' svc$delete_snapshot_schedule(
#'   VolumeARN = "arn:aws:storagegateway:us-east-1:111122223333:gateway/sgw-12A3456B/volume/vol..."
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname storagegateway_delete_snapshot_schedule
storagegateway_delete_snapshot_schedule <- function(VolumeARN) {
  op <- new_operation(
    name = "DeleteSnapshotSchedule",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .storagegateway$delete_snapshot_schedule_input(VolumeARN = VolumeARN)
  output <- .storagegateway$delete_snapshot_schedule_output()
  config <- get_config()
  svc <- .storagegateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$delete_snapshot_schedule <- storagegateway_delete_snapshot_schedule

#' Deletes the specified virtual tape
#'
#' Deletes the specified virtual tape. This operation is only supported in
#' the tape gateway type.
#'
#' @usage
#' storagegateway_delete_tape(GatewayARN, TapeARN)
#'
#' @param GatewayARN &#91;required&#93; The unique Amazon Resource Name (ARN) of the gateway that the virtual
#' tape to delete is associated with. Use the ListGateways operation to
#' return a list of gateways for your account and AWS Region.
#' @param TapeARN &#91;required&#93; The Amazon Resource Name (ARN) of the virtual tape to delete.
#'
#' @section Request syntax:
#' ```
#' svc$delete_tape(
#'   GatewayARN = "string",
#'   TapeARN = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example deletes the specified virtual tape.
#' svc$delete_tape(
#'   GatewayARN = "arn:aws:storagegateway:us-east-1:204469490176:gateway/sgw-12A3456B",
#'   TapeARN = "arn:aws:storagegateway:us-east-1:204469490176:tape/TEST05A2A0"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname storagegateway_delete_tape
storagegateway_delete_tape <- function(GatewayARN, TapeARN) {
  op <- new_operation(
    name = "DeleteTape",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .storagegateway$delete_tape_input(GatewayARN = GatewayARN, TapeARN = TapeARN)
  output <- .storagegateway$delete_tape_output()
  config <- get_config()
  svc <- .storagegateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$delete_tape <- storagegateway_delete_tape

#' Deletes the specified virtual tape from the virtual tape shelf (VTS)
#'
#' Deletes the specified virtual tape from the virtual tape shelf (VTS).
#' This operation is only supported in the tape gateway type.
#'
#' @usage
#' storagegateway_delete_tape_archive(TapeARN)
#'
#' @param TapeARN &#91;required&#93; The Amazon Resource Name (ARN) of the virtual tape to delete from the
#' virtual tape shelf (VTS).
#'
#' @section Request syntax:
#' ```
#' svc$delete_tape_archive(
#'   TapeARN = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # Deletes the specified virtual tape from the virtual tape shelf (VTS).
#' svc$delete_tape_archive(
#'   TapeARN = "arn:aws:storagegateway:us-east-1:204469490176:tape/TEST05A2A0"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname storagegateway_delete_tape_archive
storagegateway_delete_tape_archive <- function(TapeARN) {
  op <- new_operation(
    name = "DeleteTapeArchive",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .storagegateway$delete_tape_archive_input(TapeARN = TapeARN)
  output <- .storagegateway$delete_tape_archive_output()
  config <- get_config()
  svc <- .storagegateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$delete_tape_archive <- storagegateway_delete_tape_archive

#' Deletes the specified storage volume that you previously created using
#' the CreateCachediSCSIVolume or CreateStorediSCSIVolume API
#'
#' Deletes the specified storage volume that you previously created using
#' the CreateCachediSCSIVolume or CreateStorediSCSIVolume API. This
#' operation is only supported in the cached volume and stored volume
#' types. For stored volume gateways, the local disk that was configured as
#' the storage volume is not deleted. You can reuse the local disk to
#' create another storage volume.
#' 
#' Before you delete a volume, make sure there are no iSCSI connections to
#' the volume you are deleting. You should also make sure there is no
#' snapshot in progress. You can use the Amazon Elastic Compute Cloud
#' (Amazon EC2) API to query snapshots on the volume you are deleting and
#' check the snapshot status. For more information, go to
#' [DescribeSnapshots](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/ApiReference-query-DescribeSnapshots.html)
#' in the *Amazon Elastic Compute Cloud API Reference*.
#' 
#' In the request, you must provide the Amazon Resource Name (ARN) of the
#' storage volume you want to delete.
#'
#' @usage
#' storagegateway_delete_volume(VolumeARN)
#'
#' @param VolumeARN &#91;required&#93; The Amazon Resource Name (ARN) of the volume. Use the ListVolumes
#' operation to return a list of gateway volumes.
#'
#' @section Request syntax:
#' ```
#' svc$delete_volume(
#'   VolumeARN = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # Deletes the specified gateway volume that you previously created using
#' # the CreateCachediSCSIVolume or CreateStorediSCSIVolume API.
#' svc$delete_volume(
#'   VolumeARN = "arn:aws:storagegateway:us-east-1:111122223333:gateway/sgw-12A3456B/volume/vol..."
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname storagegateway_delete_volume
storagegateway_delete_volume <- function(VolumeARN) {
  op <- new_operation(
    name = "DeleteVolume",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .storagegateway$delete_volume_input(VolumeARN = VolumeARN)
  output <- .storagegateway$delete_volume_output()
  config <- get_config()
  svc <- .storagegateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$delete_volume <- storagegateway_delete_volume

#' Returns information about the most recent High Availability monitoring
#' test that was performed on the host in a cluster
#'
#' Returns information about the most recent High Availability monitoring
#' test that was performed on the host in a cluster. If a test isn\'t
#' performed, the status and start time in the response would be null.
#'
#' @usage
#' storagegateway_describe_availability_monitor_test(GatewayARN)
#'
#' @param GatewayARN &#91;required&#93; 
#'
#' @section Request syntax:
#' ```
#' svc$describe_availability_monitor_test(
#'   GatewayARN = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname storagegateway_describe_availability_monitor_test
storagegateway_describe_availability_monitor_test <- function(GatewayARN) {
  op <- new_operation(
    name = "DescribeAvailabilityMonitorTest",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .storagegateway$describe_availability_monitor_test_input(GatewayARN = GatewayARN)
  output <- .storagegateway$describe_availability_monitor_test_output()
  config <- get_config()
  svc <- .storagegateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$describe_availability_monitor_test <- storagegateway_describe_availability_monitor_test

#' Returns the bandwidth rate limits of a gateway
#'
#' Returns the bandwidth rate limits of a gateway. By default, these limits
#' are not set, which means no bandwidth rate limiting is in effect. This
#' operation is supported for the stored volume, cached volume and tape
#' gateway types.\'
#' 
#' This operation only returns a value for a bandwidth rate limit only if
#' the limit is set. If no limits are set for the gateway, then this
#' operation returns only the gateway ARN in the response body. To specify
#' which gateway to describe, use the Amazon Resource Name (ARN) of the
#' gateway in your request.
#'
#' @usage
#' storagegateway_describe_bandwidth_rate_limit(GatewayARN)
#'
#' @param GatewayARN &#91;required&#93; 
#'
#' @section Request syntax:
#' ```
#' svc$describe_bandwidth_rate_limit(
#'   GatewayARN = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # Returns a value for a bandwidth rate limit if set. If not set, then only
#' # the gateway ARN is returned.
#' svc$describe_bandwidth_rate_limit(
#'   GatewayARN = "arn:aws:storagegateway:us-east-1:111122223333:gateway/sgw-12A3456B"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname storagegateway_describe_bandwidth_rate_limit
storagegateway_describe_bandwidth_rate_limit <- function(GatewayARN) {
  op <- new_operation(
    name = "DescribeBandwidthRateLimit",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .storagegateway$describe_bandwidth_rate_limit_input(GatewayARN = GatewayARN)
  output <- .storagegateway$describe_bandwidth_rate_limit_output()
  config <- get_config()
  svc <- .storagegateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$describe_bandwidth_rate_limit <- storagegateway_describe_bandwidth_rate_limit

#' Returns information about the cache of a gateway
#'
#' Returns information about the cache of a gateway. This operation is only
#' supported in the cached volume, tape and file gateway types.
#' 
#' The response includes disk IDs that are configured as cache, and it
#' includes the amount of cache allocated and used.
#'
#' @usage
#' storagegateway_describe_cache(GatewayARN)
#'
#' @param GatewayARN &#91;required&#93; 
#'
#' @section Request syntax:
#' ```
#' svc$describe_cache(
#'   GatewayARN = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # Returns information about the cache of a gateway.
#' svc$describe_cache(
#'   GatewayARN = "arn:aws:storagegateway:us-east-1:111122223333:gateway/sgw-12A3456B"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname storagegateway_describe_cache
storagegateway_describe_cache <- function(GatewayARN) {
  op <- new_operation(
    name = "DescribeCache",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .storagegateway$describe_cache_input(GatewayARN = GatewayARN)
  output <- .storagegateway$describe_cache_output()
  config <- get_config()
  svc <- .storagegateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$describe_cache <- storagegateway_describe_cache

#' Returns a description of the gateway volumes specified in the request
#'
#' Returns a description of the gateway volumes specified in the request.
#' This operation is only supported in the cached volume gateway types.
#' 
#' The list of gateway volumes in the request must be from one gateway. In
#' the response Amazon Storage Gateway returns volume information sorted by
#' volume Amazon Resource Name (ARN).
#'
#' @usage
#' storagegateway_describe_cachedi_scsi_volumes(VolumeARNs)
#'
#' @param VolumeARNs &#91;required&#93; An array of strings where each string represents the Amazon Resource
#' Name (ARN) of a cached volume. All of the specified cached volumes must
#' from the same gateway. Use ListVolumes to get volume ARNs for a gateway.
#'
#' @section Request syntax:
#' ```
#' svc$describe_cachedi_scsi_volumes(
#'   VolumeARNs = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # Returns a description of the gateway cached iSCSI volumes specified in
#' # the request.
#' svc$describe_cachedi_scsi_volumes(
#'   VolumeARNs = list(
#'     "arn:aws:storagegateway:us-east-1:111122223333:gateway/sgw-12A3456B/volume/vol-1122AABB"
#'   )
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname storagegateway_describe_cachedi_scsi_volumes
storagegateway_describe_cachedi_scsi_volumes <- function(VolumeARNs) {
  op <- new_operation(
    name = "DescribeCachediSCSIVolumes",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .storagegateway$describe_cachedi_scsi_volumes_input(VolumeARNs = VolumeARNs)
  output <- .storagegateway$describe_cachedi_scsi_volumes_output()
  config <- get_config()
  svc <- .storagegateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$describe_cachedi_scsi_volumes <- storagegateway_describe_cachedi_scsi_volumes

#' Returns an array of Challenge-Handshake Authentication Protocol (CHAP)
#' credentials information for a specified iSCSI target, one for each
#' target-initiator pair
#'
#' Returns an array of Challenge-Handshake Authentication Protocol (CHAP)
#' credentials information for a specified iSCSI target, one for each
#' target-initiator pair. This operation is supported in the volume and
#' tape gateway types.
#'
#' @usage
#' storagegateway_describe_chap_credentials(TargetARN)
#'
#' @param TargetARN &#91;required&#93; The Amazon Resource Name (ARN) of the iSCSI volume target. Use the
#' DescribeStorediSCSIVolumes operation to return to retrieve the TargetARN
#' for specified VolumeARN.
#'
#' @section Request syntax:
#' ```
#' svc$describe_chap_credentials(
#'   TargetARN = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # Returns an array of Challenge-Handshake Authentication Protocol (CHAP)
#' # credentials information for a specified iSCSI target, one for each
#' # target-initiator pair.
#' svc$describe_chap_credentials(
#'   TargetARN = "arn:aws:storagegateway:us-east-1:111122223333:gateway/sgw-12A3456B/target/iqn..."
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname storagegateway_describe_chap_credentials
storagegateway_describe_chap_credentials <- function(TargetARN) {
  op <- new_operation(
    name = "DescribeChapCredentials",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .storagegateway$describe_chap_credentials_input(TargetARN = TargetARN)
  output <- .storagegateway$describe_chap_credentials_output()
  config <- get_config()
  svc <- .storagegateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$describe_chap_credentials <- storagegateway_describe_chap_credentials

#' Returns metadata about a gateway such as its name, network interfaces,
#' configured time zone, and the state (whether the gateway is running or
#' not)
#'
#' Returns metadata about a gateway such as its name, network interfaces,
#' configured time zone, and the state (whether the gateway is running or
#' not). To specify which gateway to describe, use the Amazon Resource Name
#' (ARN) of the gateway in your request.
#'
#' @usage
#' storagegateway_describe_gateway_information(GatewayARN)
#'
#' @param GatewayARN &#91;required&#93; 
#'
#' @section Request syntax:
#' ```
#' svc$describe_gateway_information(
#'   GatewayARN = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # Returns metadata about a gateway such as its name, network interfaces,
#' # configured time zone, and the state (whether the gateway is running or
#' # not).
#' svc$describe_gateway_information(
#'   GatewayARN = "arn:aws:storagegateway:us-east-1:111122223333:gateway/sgw-12A3456B"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname storagegateway_describe_gateway_information
storagegateway_describe_gateway_information <- function(GatewayARN) {
  op <- new_operation(
    name = "DescribeGatewayInformation",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .storagegateway$describe_gateway_information_input(GatewayARN = GatewayARN)
  output <- .storagegateway$describe_gateway_information_output()
  config <- get_config()
  svc <- .storagegateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$describe_gateway_information <- storagegateway_describe_gateway_information

#' Returns your gateway's weekly maintenance start time including the day
#' and time of the week
#'
#' Returns your gateway\'s weekly maintenance start time including the day
#' and time of the week. Note that values are in terms of the gateway\'s
#' time zone.
#'
#' @usage
#' storagegateway_describe_maintenance_start_time(GatewayARN)
#'
#' @param GatewayARN &#91;required&#93; 
#'
#' @section Request syntax:
#' ```
#' svc$describe_maintenance_start_time(
#'   GatewayARN = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # Returns your gateway's weekly maintenance start time including the day
#' # and time of the week.
#' svc$describe_maintenance_start_time(
#'   GatewayARN = "arn:aws:storagegateway:us-east-1:111122223333:gateway/sgw-12A3456B"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname storagegateway_describe_maintenance_start_time
storagegateway_describe_maintenance_start_time <- function(GatewayARN) {
  op <- new_operation(
    name = "DescribeMaintenanceStartTime",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .storagegateway$describe_maintenance_start_time_input(GatewayARN = GatewayARN)
  output <- .storagegateway$describe_maintenance_start_time_output()
  config <- get_config()
  svc <- .storagegateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$describe_maintenance_start_time <- storagegateway_describe_maintenance_start_time

#' Gets a description for one or more Network File System (NFS) file shares
#' from a file gateway
#'
#' Gets a description for one or more Network File System (NFS) file shares
#' from a file gateway. This operation is only supported for file gateways.
#'
#' @usage
#' storagegateway_describe_nfs_file_shares(FileShareARNList)
#'
#' @param FileShareARNList &#91;required&#93; An array containing the Amazon Resource Name (ARN) of each file share to
#' be described.
#'
#' @section Request syntax:
#' ```
#' svc$describe_nfs_file_shares(
#'   FileShareARNList = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname storagegateway_describe_nfs_file_shares
storagegateway_describe_nfs_file_shares <- function(FileShareARNList) {
  op <- new_operation(
    name = "DescribeNFSFileShares",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .storagegateway$describe_nfs_file_shares_input(FileShareARNList = FileShareARNList)
  output <- .storagegateway$describe_nfs_file_shares_output()
  config <- get_config()
  svc <- .storagegateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$describe_nfs_file_shares <- storagegateway_describe_nfs_file_shares

#' Gets a description for one or more Server Message Block (SMB) file
#' shares from a file gateway
#'
#' Gets a description for one or more Server Message Block (SMB) file
#' shares from a file gateway. This operation is only supported for file
#' gateways.
#'
#' @usage
#' storagegateway_describe_smb_file_shares(FileShareARNList)
#'
#' @param FileShareARNList &#91;required&#93; An array containing the Amazon Resource Name (ARN) of each file share to
#' be described.
#'
#' @section Request syntax:
#' ```
#' svc$describe_smb_file_shares(
#'   FileShareARNList = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname storagegateway_describe_smb_file_shares
storagegateway_describe_smb_file_shares <- function(FileShareARNList) {
  op <- new_operation(
    name = "DescribeSMBFileShares",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .storagegateway$describe_smb_file_shares_input(FileShareARNList = FileShareARNList)
  output <- .storagegateway$describe_smb_file_shares_output()
  config <- get_config()
  svc <- .storagegateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$describe_smb_file_shares <- storagegateway_describe_smb_file_shares

#' Gets a description of a Server Message Block (SMB) file share settings
#' from a file gateway
#'
#' Gets a description of a Server Message Block (SMB) file share settings
#' from a file gateway. This operation is only supported for file gateways.
#'
#' @usage
#' storagegateway_describe_smb_settings(GatewayARN)
#'
#' @param GatewayARN &#91;required&#93; 
#'
#' @section Request syntax:
#' ```
#' svc$describe_smb_settings(
#'   GatewayARN = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname storagegateway_describe_smb_settings
storagegateway_describe_smb_settings <- function(GatewayARN) {
  op <- new_operation(
    name = "DescribeSMBSettings",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .storagegateway$describe_smb_settings_input(GatewayARN = GatewayARN)
  output <- .storagegateway$describe_smb_settings_output()
  config <- get_config()
  svc <- .storagegateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$describe_smb_settings <- storagegateway_describe_smb_settings

#' Describes the snapshot schedule for the specified gateway volume
#'
#' Describes the snapshot schedule for the specified gateway volume. The
#' snapshot schedule information includes intervals at which snapshots are
#' automatically initiated on the volume. This operation is only supported
#' in the cached volume and stored volume types.
#'
#' @usage
#' storagegateway_describe_snapshot_schedule(VolumeARN)
#'
#' @param VolumeARN &#91;required&#93; The Amazon Resource Name (ARN) of the volume. Use the ListVolumes
#' operation to return a list of gateway volumes.
#'
#' @section Request syntax:
#' ```
#' svc$describe_snapshot_schedule(
#'   VolumeARN = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # Describes the snapshot schedule for the specified gateway volume
#' # including intervals at which snapshots are automatically initiated.
#' svc$describe_snapshot_schedule(
#'   VolumeARN = "arn:aws:storagegateway:us-east-1:111122223333:gateway/sgw-12A3456B/volume/vol..."
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname storagegateway_describe_snapshot_schedule
storagegateway_describe_snapshot_schedule <- function(VolumeARN) {
  op <- new_operation(
    name = "DescribeSnapshotSchedule",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .storagegateway$describe_snapshot_schedule_input(VolumeARN = VolumeARN)
  output <- .storagegateway$describe_snapshot_schedule_output()
  config <- get_config()
  svc <- .storagegateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$describe_snapshot_schedule <- storagegateway_describe_snapshot_schedule

#' Returns the description of the gateway volumes specified in the request
#'
#' Returns the description of the gateway volumes specified in the request.
#' The list of gateway volumes in the request must be from one gateway. In
#' the response Amazon Storage Gateway returns volume information sorted by
#' volume ARNs. This operation is only supported in stored volume gateway
#' type.
#'
#' @usage
#' storagegateway_describe_storedi_scsi_volumes(VolumeARNs)
#'
#' @param VolumeARNs &#91;required&#93; An array of strings where each string represents the Amazon Resource
#' Name (ARN) of a stored volume. All of the specified stored volumes must
#' from the same gateway. Use ListVolumes to get volume ARNs for a gateway.
#'
#' @section Request syntax:
#' ```
#' svc$describe_storedi_scsi_volumes(
#'   VolumeARNs = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # Returns the description of the gateway volumes specified in the request
#' # belonging to the same gateway.
#' svc$describe_storedi_scsi_volumes(
#'   VolumeARNs = list(
#'     "arn:aws:storagegateway:us-east-1:111122223333:gateway/sgw-12A3456B/volume/vol-1122AABB"
#'   )
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname storagegateway_describe_storedi_scsi_volumes
storagegateway_describe_storedi_scsi_volumes <- function(VolumeARNs) {
  op <- new_operation(
    name = "DescribeStorediSCSIVolumes",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .storagegateway$describe_storedi_scsi_volumes_input(VolumeARNs = VolumeARNs)
  output <- .storagegateway$describe_storedi_scsi_volumes_output()
  config <- get_config()
  svc <- .storagegateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$describe_storedi_scsi_volumes <- storagegateway_describe_storedi_scsi_volumes

#' Returns a description of specified virtual tapes in the virtual tape
#' shelf (VTS)
#'
#' Returns a description of specified virtual tapes in the virtual tape
#' shelf (VTS). This operation is only supported in the tape gateway type.
#' 
#' If a specific `TapeARN` is not specified, AWS Storage Gateway returns a
#' description of all virtual tapes found in the VTS associated with your
#' account.
#'
#' @usage
#' storagegateway_describe_tape_archives(TapeARNs, Marker, Limit)
#'
#' @param TapeARNs Specifies one or more unique Amazon Resource Names (ARNs) that represent
#' the virtual tapes you want to describe.
#' @param Marker An opaque string that indicates the position at which to begin
#' describing virtual tapes.
#' @param Limit Specifies that the number of virtual tapes descried be limited to the
#' specified number.
#'
#' @section Request syntax:
#' ```
#' svc$describe_tape_archives(
#'   TapeARNs = list(
#'     "string"
#'   ),
#'   Marker = "string",
#'   Limit = 123
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # Returns a description of specified virtual tapes in the virtual tape
#' # shelf (VTS).
#' svc$describe_tape_archives(
#'   Limit = 123L,
#'   Marker = "1",
#'   TapeARNs = list(
#'     "arn:aws:storagegateway:us-east-1:999999999999:tape/AM08A1AD",
#'     "arn:aws:storagegateway:us-east-1:999999999999:tape/AMZN01A2A4"
#'   )
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname storagegateway_describe_tape_archives
storagegateway_describe_tape_archives <- function(TapeARNs = NULL, Marker = NULL, Limit = NULL) {
  op <- new_operation(
    name = "DescribeTapeArchives",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .storagegateway$describe_tape_archives_input(TapeARNs = TapeARNs, Marker = Marker, Limit = Limit)
  output <- .storagegateway$describe_tape_archives_output()
  config <- get_config()
  svc <- .storagegateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$describe_tape_archives <- storagegateway_describe_tape_archives

#' Returns a list of virtual tape recovery points that are available for
#' the specified tape gateway
#'
#' Returns a list of virtual tape recovery points that are available for
#' the specified tape gateway.
#' 
#' A recovery point is a point-in-time view of a virtual tape at which all
#' the data on the virtual tape is consistent. If your gateway crashes,
#' virtual tapes that have recovery points can be recovered to a new
#' gateway. This operation is only supported in the tape gateway type.
#'
#' @usage
#' storagegateway_describe_tape_recovery_points(GatewayARN, Marker, Limit)
#'
#' @param GatewayARN &#91;required&#93; 
#' @param Marker An opaque string that indicates the position at which to begin
#' describing the virtual tape recovery points.
#' @param Limit Specifies that the number of virtual tape recovery points that are
#' described be limited to the specified number.
#'
#' @section Request syntax:
#' ```
#' svc$describe_tape_recovery_points(
#'   GatewayARN = "string",
#'   Marker = "string",
#'   Limit = 123
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # Returns a list of virtual tape recovery points that are available for
#' # the specified gateway-VTL.
#' svc$describe_tape_recovery_points(
#'   GatewayARN = "arn:aws:storagegateway:us-east-1:111122223333:gateway/sgw-12A3456B",
#'   Limit = 1L,
#'   Marker = "1"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname storagegateway_describe_tape_recovery_points
storagegateway_describe_tape_recovery_points <- function(GatewayARN, Marker = NULL, Limit = NULL) {
  op <- new_operation(
    name = "DescribeTapeRecoveryPoints",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .storagegateway$describe_tape_recovery_points_input(GatewayARN = GatewayARN, Marker = Marker, Limit = Limit)
  output <- .storagegateway$describe_tape_recovery_points_output()
  config <- get_config()
  svc <- .storagegateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$describe_tape_recovery_points <- storagegateway_describe_tape_recovery_points

#' Returns a description of the specified Amazon Resource Name (ARN) of
#' virtual tapes
#'
#' Returns a description of the specified Amazon Resource Name (ARN) of
#' virtual tapes. If a `TapeARN` is not specified, returns a description of
#' all virtual tapes associated with the specified gateway. This operation
#' is only supported in the tape gateway type.
#'
#' @usage
#' storagegateway_describe_tapes(GatewayARN, TapeARNs, Marker, Limit)
#'
#' @param GatewayARN &#91;required&#93; 
#' @param TapeARNs Specifies one or more unique Amazon Resource Names (ARNs) that represent
#' the virtual tapes you want to describe. If this parameter is not
#' specified, Tape gateway returns a description of all virtual tapes
#' associated with the specified gateway.
#' @param Marker A marker value, obtained in a previous call to `DescribeTapes`. This
#' marker indicates which page of results to retrieve.
#' 
#' If not specified, the first page of results is retrieved.
#' @param Limit Specifies that the number of virtual tapes described be limited to the
#' specified number.
#' 
#' Amazon Web Services may impose its own limit, if this field is not set.
#'
#' @section Request syntax:
#' ```
#' svc$describe_tapes(
#'   GatewayARN = "string",
#'   TapeARNs = list(
#'     "string"
#'   ),
#'   Marker = "string",
#'   Limit = 123
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # Returns a description of the specified Amazon Resource Name (ARN) of
#' # virtual tapes. If a TapeARN is not specified, returns a description of
#' # all virtual tapes.
#' svc$describe_tapes(
#'   GatewayARN = "arn:aws:storagegateway:us-east-1:999999999999:gateway/sgw-12A3456B",
#'   Limit = 2L,
#'   Marker = "1",
#'   TapeARNs = list(
#'     "arn:aws:storagegateway:us-east-1:999999999999:tape/TEST04A2A1",
#'     "arn:aws:storagegateway:us-east-1:999999999999:tape/TEST05A2A0"
#'   )
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname storagegateway_describe_tapes
storagegateway_describe_tapes <- function(GatewayARN, TapeARNs = NULL, Marker = NULL, Limit = NULL) {
  op <- new_operation(
    name = "DescribeTapes",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .storagegateway$describe_tapes_input(GatewayARN = GatewayARN, TapeARNs = TapeARNs, Marker = Marker, Limit = Limit)
  output <- .storagegateway$describe_tapes_output()
  config <- get_config()
  svc <- .storagegateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$describe_tapes <- storagegateway_describe_tapes

#' Returns information about the upload buffer of a gateway
#'
#' Returns information about the upload buffer of a gateway. This operation
#' is supported for the stored volume, cached volume and tape gateway
#' types.
#' 
#' The response includes disk IDs that are configured as upload buffer
#' space, and it includes the amount of upload buffer space allocated and
#' used.
#'
#' @usage
#' storagegateway_describe_upload_buffer(GatewayARN)
#'
#' @param GatewayARN &#91;required&#93; 
#'
#' @section Request syntax:
#' ```
#' svc$describe_upload_buffer(
#'   GatewayARN = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # Returns information about the upload buffer of a gateway including disk
#' # IDs and the amount of upload buffer space allocated/used.
#' svc$describe_upload_buffer(
#'   GatewayARN = "arn:aws:storagegateway:us-east-1:111122223333:gateway/sgw-12A3456B"
#' )
#' 
#' # Returns information about the upload buffer of a gateway including disk
#' # IDs and the amount of upload buffer space allocated and used.
#' svc$describe_upload_buffer(
#'   GatewayARN = "arn:aws:storagegateway:us-east-1:111122223333:gateway/sgw-12A3456B"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname storagegateway_describe_upload_buffer
storagegateway_describe_upload_buffer <- function(GatewayARN) {
  op <- new_operation(
    name = "DescribeUploadBuffer",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .storagegateway$describe_upload_buffer_input(GatewayARN = GatewayARN)
  output <- .storagegateway$describe_upload_buffer_output()
  config <- get_config()
  svc <- .storagegateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$describe_upload_buffer <- storagegateway_describe_upload_buffer

#' Returns a description of virtual tape library (VTL) devices for the
#' specified tape gateway
#'
#' Returns a description of virtual tape library (VTL) devices for the
#' specified tape gateway. In the response, AWS Storage Gateway returns VTL
#' device information.
#' 
#' This operation is only supported in the tape gateway type.
#'
#' @usage
#' storagegateway_describe_vtl_devices(GatewayARN, VTLDeviceARNs, Marker,
#'   Limit)
#'
#' @param GatewayARN &#91;required&#93; 
#' @param VTLDeviceARNs An array of strings, where each string represents the Amazon Resource
#' Name (ARN) of a VTL device.
#' 
#' All of the specified VTL devices must be from the same gateway. If no
#' VTL devices are specified, the result will contain all devices on the
#' specified gateway.
#' @param Marker An opaque string that indicates the position at which to begin
#' describing the VTL devices.
#' @param Limit Specifies that the number of VTL devices described be limited to the
#' specified number.
#'
#' @section Request syntax:
#' ```
#' svc$describe_vtl_devices(
#'   GatewayARN = "string",
#'   VTLDeviceARNs = list(
#'     "string"
#'   ),
#'   Marker = "string",
#'   Limit = 123
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # Returns a description of virtual tape library (VTL) devices for the
#' # specified gateway.
#' svc$describe_vtl_devices(
#'   GatewayARN = "arn:aws:storagegateway:us-east-1:999999999999:gateway/sgw-12A3456B",
#'   Limit = 123L,
#'   Marker = "1",
#'   VTLDeviceARNs = list()
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname storagegateway_describe_vtl_devices
storagegateway_describe_vtl_devices <- function(GatewayARN, VTLDeviceARNs = NULL, Marker = NULL, Limit = NULL) {
  op <- new_operation(
    name = "DescribeVTLDevices",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .storagegateway$describe_vtl_devices_input(GatewayARN = GatewayARN, VTLDeviceARNs = VTLDeviceARNs, Marker = Marker, Limit = Limit)
  output <- .storagegateway$describe_vtl_devices_output()
  config <- get_config()
  svc <- .storagegateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$describe_vtl_devices <- storagegateway_describe_vtl_devices

#' Returns information about the working storage of a gateway
#'
#' Returns information about the working storage of a gateway. This
#' operation is only supported in the stored volumes gateway type. This
#' operation is deprecated in cached volumes API version (20120630). Use
#' DescribeUploadBuffer instead.
#' 
#' Working storage is also referred to as upload buffer. You can also use
#' the DescribeUploadBuffer operation to add upload buffer to a stored
#' volume gateway.
#' 
#' The response includes disk IDs that are configured as working storage,
#' and it includes the amount of working storage allocated and used.
#'
#' @usage
#' storagegateway_describe_working_storage(GatewayARN)
#'
#' @param GatewayARN &#91;required&#93; 
#'
#' @section Request syntax:
#' ```
#' svc$describe_working_storage(
#'   GatewayARN = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This operation is supported only for the gateway-stored volume
#' # architecture. This operation is deprecated in cached-volumes API version
#' # (20120630). Use DescribeUploadBuffer instead.
#' svc$describe_working_storage(
#'   GatewayARN = "arn:aws:storagegateway:us-east-1:111122223333:gateway/sgw-12A3456B"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname storagegateway_describe_working_storage
storagegateway_describe_working_storage <- function(GatewayARN) {
  op <- new_operation(
    name = "DescribeWorkingStorage",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .storagegateway$describe_working_storage_input(GatewayARN = GatewayARN)
  output <- .storagegateway$describe_working_storage_output()
  config <- get_config()
  svc <- .storagegateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$describe_working_storage <- storagegateway_describe_working_storage

#' Disconnects a volume from an iSCSI connection and then detaches the
#' volume from the specified gateway
#'
#' Disconnects a volume from an iSCSI connection and then detaches the
#' volume from the specified gateway. Detaching and attaching a volume
#' enables you to recover your data from one gateway to a different gateway
#' without creating a snapshot. It also makes it easier to move your
#' volumes from an on-premises gateway to a gateway hosted on an Amazon EC2
#' instance. This operation is only supported in the volume gateway type.
#'
#' @usage
#' storagegateway_detach_volume(VolumeARN, ForceDetach)
#'
#' @param VolumeARN &#91;required&#93; The Amazon Resource Name (ARN) of the volume to detach from the gateway.
#' @param ForceDetach Set to `true` to forcibly remove the iSCSI connection of the target
#' volume and detach the volume. The default is `false`. If this value is
#' set to `false`, you must manually disconnect the iSCSI connection from
#' the target volume.
#'
#' @section Request syntax:
#' ```
#' svc$detach_volume(
#'   VolumeARN = "string",
#'   ForceDetach = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname storagegateway_detach_volume
storagegateway_detach_volume <- function(VolumeARN, ForceDetach = NULL) {
  op <- new_operation(
    name = "DetachVolume",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .storagegateway$detach_volume_input(VolumeARN = VolumeARN, ForceDetach = ForceDetach)
  output <- .storagegateway$detach_volume_output()
  config <- get_config()
  svc <- .storagegateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$detach_volume <- storagegateway_detach_volume

#' Disables a tape gateway when the gateway is no longer functioning
#'
#' Disables a tape gateway when the gateway is no longer functioning. For
#' example, if your gateway VM is damaged, you can disable the gateway so
#' you can recover virtual tapes.
#' 
#' Use this operation for a tape gateway that is not reachable or not
#' functioning. This operation is only supported in the tape gateway type.
#' 
#' Once a gateway is disabled it cannot be enabled.
#'
#' @usage
#' storagegateway_disable_gateway(GatewayARN)
#'
#' @param GatewayARN &#91;required&#93; 
#'
#' @section Request syntax:
#' ```
#' svc$disable_gateway(
#'   GatewayARN = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # Disables a gateway when the gateway is no longer functioning. Use this
#' # operation for a gateway-VTL that is not reachable or not functioning.
#' svc$disable_gateway(
#'   GatewayARN = "arn:aws:storagegateway:us-east-1:111122223333:gateway/sgw-12A3456B"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname storagegateway_disable_gateway
storagegateway_disable_gateway <- function(GatewayARN) {
  op <- new_operation(
    name = "DisableGateway",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .storagegateway$disable_gateway_input(GatewayARN = GatewayARN)
  output <- .storagegateway$disable_gateway_output()
  config <- get_config()
  svc <- .storagegateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$disable_gateway <- storagegateway_disable_gateway

#' Adds a file gateway to an Active Directory domain
#'
#' Adds a file gateway to an Active Directory domain. This operation is
#' only supported for file gateways that support the SMB file protocol.
#'
#' @usage
#' storagegateway_join_domain(GatewayARN, DomainName, OrganizationalUnit,
#'   DomainControllers, TimeoutInSeconds, UserName, Password)
#'
#' @param GatewayARN &#91;required&#93; The Amazon Resource Name (ARN) of the gateway. Use the `ListGateways`
#' operation to return a list of gateways for your account and AWS Region.
#' @param DomainName &#91;required&#93; The name of the domain that you want the gateway to join.
#' @param OrganizationalUnit The organizational unit (OU) is a container in an Active Directory that
#' can hold users, groups, computers, and other OUs and this parameter
#' specifies the OU that the gateway will join within the AD domain.
#' @param DomainControllers List of IPv4 addresses, NetBIOS names, or host names of your domain
#' server. If you need to specify the port number include it after the
#' colon (":"). For example, `mydc.mydomain.com:389`.
#' @param TimeoutInSeconds Specifies the time in seconds, in which the `JoinDomain` operation must
#' complete. The default is 20 seconds.
#' @param UserName &#91;required&#93; Sets the user name of user who has permission to add the gateway to the
#' Active Directory domain. The domain user account should be enabled to
#' join computers to the domain. For example, you can use the domain
#' administrator account or an account with delegated permissions to join
#' computers to the domain.
#' @param Password &#91;required&#93; Sets the password of the user who has permission to add the gateway to
#' the Active Directory domain.
#'
#' @section Request syntax:
#' ```
#' svc$join_domain(
#'   GatewayARN = "string",
#'   DomainName = "string",
#'   OrganizationalUnit = "string",
#'   DomainControllers = list(
#'     "string"
#'   ),
#'   TimeoutInSeconds = 123,
#'   UserName = "string",
#'   Password = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname storagegateway_join_domain
storagegateway_join_domain <- function(GatewayARN, DomainName, OrganizationalUnit = NULL, DomainControllers = NULL, TimeoutInSeconds = NULL, UserName, Password) {
  op <- new_operation(
    name = "JoinDomain",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .storagegateway$join_domain_input(GatewayARN = GatewayARN, DomainName = DomainName, OrganizationalUnit = OrganizationalUnit, DomainControllers = DomainControllers, TimeoutInSeconds = TimeoutInSeconds, UserName = UserName, Password = Password)
  output <- .storagegateway$join_domain_output()
  config <- get_config()
  svc <- .storagegateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$join_domain <- storagegateway_join_domain

#' Gets a list of the file shares for a specific file gateway, or the list
#' of file shares that belong to the calling user account
#'
#' Gets a list of the file shares for a specific file gateway, or the list
#' of file shares that belong to the calling user account. This operation
#' is only supported for file gateways.
#'
#' @usage
#' storagegateway_list_file_shares(GatewayARN, Limit, Marker)
#'
#' @param GatewayARN The Amazon resource Name (ARN) of the gateway whose file shares you want
#' to list. If this field is not present, all file shares under your
#' account are listed.
#' @param Limit The maximum number of file shares to return in the response. The value
#' must be an integer with a value greater than zero. Optional.
#' @param Marker Opaque pagination token returned from a previous ListFileShares
#' operation. If present, `Marker` specifies where to continue the list
#' from after a previous call to ListFileShares. Optional.
#'
#' @section Request syntax:
#' ```
#' svc$list_file_shares(
#'   GatewayARN = "string",
#'   Limit = 123,
#'   Marker = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname storagegateway_list_file_shares
storagegateway_list_file_shares <- function(GatewayARN = NULL, Limit = NULL, Marker = NULL) {
  op <- new_operation(
    name = "ListFileShares",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .storagegateway$list_file_shares_input(GatewayARN = GatewayARN, Limit = Limit, Marker = Marker)
  output <- .storagegateway$list_file_shares_output()
  config <- get_config()
  svc <- .storagegateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$list_file_shares <- storagegateway_list_file_shares

#' Lists gateways owned by an AWS account in an AWS Region specified in the
#' request
#'
#' Lists gateways owned by an AWS account in an AWS Region specified in the
#' request. The returned list is ordered by gateway Amazon Resource Name
#' (ARN).
#' 
#' By default, the operation returns a maximum of 100 gateways. This
#' operation supports pagination that allows you to optionally reduce the
#' number of gateways returned in a response.
#' 
#' If you have more gateways than are returned in a response (that is, the
#' response returns only a truncated list of your gateways), the response
#' contains a marker that you can specify in your next request to fetch the
#' next page of gateways.
#'
#' @usage
#' storagegateway_list_gateways(Marker, Limit)
#'
#' @param Marker An opaque string that indicates the position at which to begin the
#' returned list of gateways.
#' @param Limit Specifies that the list of gateways returned be limited to the specified
#' number of items.
#'
#' @section Request syntax:
#' ```
#' svc$list_gateways(
#'   Marker = "string",
#'   Limit = 123
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # Lists gateways owned by an AWS account in a specified region as
#' # requested. Results are sorted by gateway ARN up to a maximum of 100
#' # gateways.
#' svc$list_gateways(
#'   Limit = 2L,
#'   Marker = "1"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname storagegateway_list_gateways
storagegateway_list_gateways <- function(Marker = NULL, Limit = NULL) {
  op <- new_operation(
    name = "ListGateways",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .storagegateway$list_gateways_input(Marker = Marker, Limit = Limit)
  output <- .storagegateway$list_gateways_output()
  config <- get_config()
  svc <- .storagegateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$list_gateways <- storagegateway_list_gateways

#' Returns a list of the gateway's local disks
#'
#' Returns a list of the gateway\'s local disks. To specify which gateway
#' to describe, you use the Amazon Resource Name (ARN) of the gateway in
#' the body of the request.
#' 
#' The request returns a list of all disks, specifying which are configured
#' as working storage, cache storage, or stored volume or not configured at
#' all. The response includes a `DiskStatus` field. This field can have a
#' value of present (the disk is available to use), missing (the disk is no
#' longer connected to the gateway), or mismatch (the disk node is occupied
#' by a disk that has incorrect metadata or the disk content is corrupted).
#'
#' @usage
#' storagegateway_list_local_disks(GatewayARN)
#'
#' @param GatewayARN &#91;required&#93; 
#'
#' @section Request syntax:
#' ```
#' svc$list_local_disks(
#'   GatewayARN = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # The request returns a list of all disks, specifying which are configured
#' # as working storage, cache storage, or stored volume or not configured at
#' # all.
#' svc$list_local_disks(
#'   GatewayARN = "arn:aws:storagegateway:us-east-1:111122223333:gateway/sgw-12A3456B"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname storagegateway_list_local_disks
storagegateway_list_local_disks <- function(GatewayARN) {
  op <- new_operation(
    name = "ListLocalDisks",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .storagegateway$list_local_disks_input(GatewayARN = GatewayARN)
  output <- .storagegateway$list_local_disks_output()
  config <- get_config()
  svc <- .storagegateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$list_local_disks <- storagegateway_list_local_disks

#' Lists the tags that have been added to the specified resource
#'
#' Lists the tags that have been added to the specified resource. This
#' operation is supported in storage gateways of all types.
#'
#' @usage
#' storagegateway_list_tags_for_resource(ResourceARN, Marker, Limit)
#'
#' @param ResourceARN &#91;required&#93; The Amazon Resource Name (ARN) of the resource for which you want to
#' list tags.
#' @param Marker An opaque string that indicates the position at which to begin returning
#' the list of tags.
#' @param Limit Specifies that the list of tags returned be limited to the specified
#' number of items.
#'
#' @section Request syntax:
#' ```
#' svc$list_tags_for_resource(
#'   ResourceARN = "string",
#'   Marker = "string",
#'   Limit = 123
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # Lists the tags that have been added to the specified resource.
#' svc$list_tags_for_resource(
#'   Limit = 1L,
#'   Marker = "1",
#'   ResourceARN = "arn:aws:storagegateway:us-east-1:111122223333:gateway/sgw-11A2222B"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname storagegateway_list_tags_for_resource
storagegateway_list_tags_for_resource <- function(ResourceARN, Marker = NULL, Limit = NULL) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .storagegateway$list_tags_for_resource_input(ResourceARN = ResourceARN, Marker = Marker, Limit = Limit)
  output <- .storagegateway$list_tags_for_resource_output()
  config <- get_config()
  svc <- .storagegateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$list_tags_for_resource <- storagegateway_list_tags_for_resource

#' Lists virtual tapes in your virtual tape library (VTL) and your virtual
#' tape shelf (VTS)
#'
#' Lists virtual tapes in your virtual tape library (VTL) and your virtual
#' tape shelf (VTS). You specify the tapes to list by specifying one or
#' more tape Amazon Resource Names (ARNs). If you don\'t specify a tape
#' ARN, the operation lists all virtual tapes in both your VTL and VTS.
#' 
#' This operation supports pagination. By default, the operation returns a
#' maximum of up to 100 tapes. You can optionally specify the `Limit`
#' parameter in the body to limit the number of tapes in the response. If
#' the number of tapes returned in the response is truncated, the response
#' includes a `Marker` element that you can use in your subsequent request
#' to retrieve the next set of tapes. This operation is only supported in
#' the tape gateway type.
#'
#' @usage
#' storagegateway_list_tapes(TapeARNs, Marker, Limit)
#'
#' @param TapeARNs 
#' @param Marker A string that indicates the position at which to begin the returned list
#' of tapes.
#' @param Limit An optional number limit for the tapes in the list returned by this
#' call.
#'
#' @section Request syntax:
#' ```
#' svc$list_tapes(
#'   TapeARNs = list(
#'     "string"
#'   ),
#'   Marker = "string",
#'   Limit = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname storagegateway_list_tapes
storagegateway_list_tapes <- function(TapeARNs = NULL, Marker = NULL, Limit = NULL) {
  op <- new_operation(
    name = "ListTapes",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .storagegateway$list_tapes_input(TapeARNs = TapeARNs, Marker = Marker, Limit = Limit)
  output <- .storagegateway$list_tapes_output()
  config <- get_config()
  svc <- .storagegateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$list_tapes <- storagegateway_list_tapes

#' Lists iSCSI initiators that are connected to a volume
#'
#' Lists iSCSI initiators that are connected to a volume. You can use this
#' operation to determine whether a volume is being used or not. This
#' operation is only supported in the cached volume and stored volume
#' gateway types.
#'
#' @usage
#' storagegateway_list_volume_initiators(VolumeARN)
#'
#' @param VolumeARN &#91;required&#93; The Amazon Resource Name (ARN) of the volume. Use the ListVolumes
#' operation to return a list of gateway volumes for the gateway.
#'
#' @section Request syntax:
#' ```
#' svc$list_volume_initiators(
#'   VolumeARN = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname storagegateway_list_volume_initiators
storagegateway_list_volume_initiators <- function(VolumeARN) {
  op <- new_operation(
    name = "ListVolumeInitiators",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .storagegateway$list_volume_initiators_input(VolumeARN = VolumeARN)
  output <- .storagegateway$list_volume_initiators_output()
  config <- get_config()
  svc <- .storagegateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$list_volume_initiators <- storagegateway_list_volume_initiators

#' Lists the recovery points for a specified gateway
#'
#' Lists the recovery points for a specified gateway. This operation is
#' only supported in the cached volume gateway type.
#' 
#' Each cache volume has one recovery point. A volume recovery point is a
#' point in time at which all data of the volume is consistent and from
#' which you can create a snapshot or clone a new cached volume from a
#' source volume. To create a snapshot from a volume recovery point use the
#' CreateSnapshotFromVolumeRecoveryPoint operation.
#'
#' @usage
#' storagegateway_list_volume_recovery_points(GatewayARN)
#'
#' @param GatewayARN &#91;required&#93; 
#'
#' @section Request syntax:
#' ```
#' svc$list_volume_recovery_points(
#'   GatewayARN = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # Lists the recovery points for a specified gateway in which all data of
#' # the volume is consistent and can be used to create a snapshot.
#' svc$list_volume_recovery_points(
#'   GatewayARN = "arn:aws:storagegateway:us-east-1:111122223333:gateway/sgw-12A3456B"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname storagegateway_list_volume_recovery_points
storagegateway_list_volume_recovery_points <- function(GatewayARN) {
  op <- new_operation(
    name = "ListVolumeRecoveryPoints",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .storagegateway$list_volume_recovery_points_input(GatewayARN = GatewayARN)
  output <- .storagegateway$list_volume_recovery_points_output()
  config <- get_config()
  svc <- .storagegateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$list_volume_recovery_points <- storagegateway_list_volume_recovery_points

#' Lists the iSCSI stored volumes of a gateway
#'
#' Lists the iSCSI stored volumes of a gateway. Results are sorted by
#' volume ARN. The response includes only the volume ARNs. If you want
#' additional volume information, use the DescribeStorediSCSIVolumes or the
#' DescribeCachediSCSIVolumes API.
#' 
#' The operation supports pagination. By default, the operation returns a
#' maximum of up to 100 volumes. You can optionally specify the `Limit`
#' field in the body to limit the number of volumes in the response. If the
#' number of volumes returned in the response is truncated, the response
#' includes a Marker field. You can use this Marker value in your
#' subsequent request to retrieve the next set of volumes. This operation
#' is only supported in the cached volume and stored volume gateway types.
#'
#' @usage
#' storagegateway_list_volumes(GatewayARN, Marker, Limit)
#'
#' @param GatewayARN 
#' @param Marker A string that indicates the position at which to begin the returned list
#' of volumes. Obtain the marker from the response of a previous List iSCSI
#' Volumes request.
#' @param Limit Specifies that the list of volumes returned be limited to the specified
#' number of items.
#'
#' @section Request syntax:
#' ```
#' svc$list_volumes(
#'   GatewayARN = "string",
#'   Marker = "string",
#'   Limit = 123
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # Lists the iSCSI stored volumes of a gateway. Results are sorted by
#' # volume ARN up to a maximum of 100 volumes.
#' svc$list_volumes(
#'   GatewayARN = "arn:aws:storagegateway:us-east-1:111122223333:gateway/sgw-12A3456B",
#'   Limit = 2L,
#'   Marker = "1"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname storagegateway_list_volumes
storagegateway_list_volumes <- function(GatewayARN = NULL, Marker = NULL, Limit = NULL) {
  op <- new_operation(
    name = "ListVolumes",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .storagegateway$list_volumes_input(GatewayARN = GatewayARN, Marker = Marker, Limit = Limit)
  output <- .storagegateway$list_volumes_output()
  config <- get_config()
  svc <- .storagegateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$list_volumes <- storagegateway_list_volumes

#' Sends you notification through CloudWatch Events when all files written
#' to your file share have been uploaded to Amazon S3
#'
#' Sends you notification through CloudWatch Events when all files written
#' to your file share have been uploaded to Amazon S3.
#' 
#' AWS Storage Gateway can send a notification through Amazon CloudWatch
#' Events when all files written to your file share up to that point in
#' time have been uploaded to Amazon S3. These files include files written
#' to the file share up to the time that you make a request for
#' notification. When the upload is done, Storage Gateway sends you
#' notification through an Amazon CloudWatch Event. You can configure
#' CloudWatch Events to send the notification through event targets such as
#' Amazon SNS or AWS Lambda function. This operation is only supported for
#' file gateways.
#' 
#' For more information, see Getting File Upload Notification in the
#' Storage Gateway User Guide
#' (https://docs.aws.amazon.com/storagegateway/latest/userguide/monitoring-file-gateway.html\\#get-upload-notification).
#'
#' @usage
#' storagegateway_notify_when_uploaded(FileShareARN)
#'
#' @param FileShareARN &#91;required&#93; 
#'
#' @section Request syntax:
#' ```
#' svc$notify_when_uploaded(
#'   FileShareARN = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname storagegateway_notify_when_uploaded
storagegateway_notify_when_uploaded <- function(FileShareARN) {
  op <- new_operation(
    name = "NotifyWhenUploaded",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .storagegateway$notify_when_uploaded_input(FileShareARN = FileShareARN)
  output <- .storagegateway$notify_when_uploaded_output()
  config <- get_config()
  svc <- .storagegateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$notify_when_uploaded <- storagegateway_notify_when_uploaded

#' Refreshes the cache for the specified file share
#'
#' Refreshes the cache for the specified file share. This operation finds
#' objects in the Amazon S3 bucket that were added, removed or replaced
#' since the gateway last listed the bucket\'s contents and cached the
#' results. This operation is only supported in the file gateway type. You
#' can subscribe to be notified through an Amazon CloudWatch event when
#' your RefreshCache operation completes. For more information, see
#' [Getting Notified About File
#' Operations](https://docs.aws.amazon.com/storagegateway/latest/userguide/monitoring-file-gateway.html#get-notification).
#' 
#' When this API is called, it only initiates the refresh operation. When
#' the API call completes and returns a success code, it doesn\'t
#' necessarily mean that the file refresh has completed. You should use the
#' refresh-complete notification to determine that the operation has
#' completed before you check for new files on the gateway file share. You
#' can subscribe to be notified through an CloudWatch event when your
#' `RefreshCache` operation completes.
#' 
#' Throttle limit: This API is asynchronous so the gateway will accept no
#' more than two refreshes at any time. We recommend using the
#' refresh-complete CloudWatch event notification before issuing additional
#' requests. For more information, see [Getting Notified About File
#' Operations](https://docs.aws.amazon.com/storagegateway/latest/userguide/monitoring-file-gateway.html#get-notification).
#' 
#' If you invoke the RefreshCache API when two requests are already being
#' processed, any new request will cause an
#' `InvalidGatewayRequestException` error because too many requests were
#' sent to the server.
#' 
#' For more information, see
#' \"https://docs.aws.amazon.com/storagegateway/latest/userguide/monitoring-file-gateway.html\\#get-notification\".
#'
#' @usage
#' storagegateway_refresh_cache(FileShareARN, FolderList, Recursive)
#'
#' @param FileShareARN &#91;required&#93; The Amazon Resource Name (ARN) of the file share you want to refresh.
#' @param FolderList A comma-separated list of the paths of folders to refresh in the cache.
#' The default is \[`"/"`\]. The default refreshes objects and folders at
#' the root of the Amazon S3 bucket. If `Recursive` is set to \"true\", the
#' entire S3 bucket that the file share has access to is refreshed.
#' @param Recursive A value that specifies whether to recursively refresh folders in the
#' cache. The refresh includes folders that were in the cache the last time
#' the gateway listed the folder\'s contents. If this value set to
#' \"true\", each folder that is listed in `FolderList` is recursively
#' updated. Otherwise, subfolders listed in `FolderList` are not refreshed.
#' Only objects that are in folders listed directly under `FolderList` are
#' found and used for the update. The default is \"true\".
#'
#' @section Request syntax:
#' ```
#' svc$refresh_cache(
#'   FileShareARN = "string",
#'   FolderList = list(
#'     "string"
#'   ),
#'   Recursive = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname storagegateway_refresh_cache
storagegateway_refresh_cache <- function(FileShareARN, FolderList = NULL, Recursive = NULL) {
  op <- new_operation(
    name = "RefreshCache",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .storagegateway$refresh_cache_input(FileShareARN = FileShareARN, FolderList = FolderList, Recursive = Recursive)
  output <- .storagegateway$refresh_cache_output()
  config <- get_config()
  svc <- .storagegateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$refresh_cache <- storagegateway_refresh_cache

#' Removes one or more tags from the specified resource
#'
#' Removes one or more tags from the specified resource. This operation is
#' supported in storage gateways of all types.
#'
#' @usage
#' storagegateway_remove_tags_from_resource(ResourceARN, TagKeys)
#'
#' @param ResourceARN &#91;required&#93; The Amazon Resource Name (ARN) of the resource you want to remove the
#' tags from.
#' @param TagKeys &#91;required&#93; The keys of the tags you want to remove from the specified resource. A
#' tag is composed of a key/value pair.
#'
#' @section Request syntax:
#' ```
#' svc$remove_tags_from_resource(
#'   ResourceARN = "string",
#'   TagKeys = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # Lists the iSCSI stored volumes of a gateway. Removes one or more tags
#' # from the specified resource.
#' svc$remove_tags_from_resource(
#'   ResourceARN = "arn:aws:storagegateway:us-east-1:111122223333:gateway/sgw-11A2222B",
#'   TagKeys = list(
#'     "Dev Gatgeway Region",
#'     "East Coast"
#'   )
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname storagegateway_remove_tags_from_resource
storagegateway_remove_tags_from_resource <- function(ResourceARN, TagKeys) {
  op <- new_operation(
    name = "RemoveTagsFromResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .storagegateway$remove_tags_from_resource_input(ResourceARN = ResourceARN, TagKeys = TagKeys)
  output <- .storagegateway$remove_tags_from_resource_output()
  config <- get_config()
  svc <- .storagegateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$remove_tags_from_resource <- storagegateway_remove_tags_from_resource

#' Resets all cache disks that have encountered a error and makes the disks
#' available for reconfiguration as cache storage
#'
#' Resets all cache disks that have encountered a error and makes the disks
#' available for reconfiguration as cache storage. If your cache disk
#' encounters a error, the gateway prevents read and write operations on
#' virtual tapes in the gateway. For example, an error can occur when a
#' disk is corrupted or removed from the gateway. When a cache is reset,
#' the gateway loses its cache storage. At this point you can reconfigure
#' the disks as cache disks. This operation is only supported in the cached
#' volume and tape types.
#' 
#' If the cache disk you are resetting contains data that has not been
#' uploaded to Amazon S3 yet, that data can be lost. After you reset cache
#' disks, there will be no configured cache disks left in the gateway, so
#' you must configure at least one new cache disk for your gateway to
#' function properly.
#'
#' @usage
#' storagegateway_reset_cache(GatewayARN)
#'
#' @param GatewayARN &#91;required&#93; 
#'
#' @section Request syntax:
#' ```
#' svc$reset_cache(
#'   GatewayARN = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # Resets all cache disks that have encountered a error and makes the disks
#' # available for reconfiguration as cache storage.
#' svc$reset_cache(
#'   GatewayARN = "arn:aws:storagegateway:us-east-1:111122223333:gateway/sgw-13B4567C"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname storagegateway_reset_cache
storagegateway_reset_cache <- function(GatewayARN) {
  op <- new_operation(
    name = "ResetCache",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .storagegateway$reset_cache_input(GatewayARN = GatewayARN)
  output <- .storagegateway$reset_cache_output()
  config <- get_config()
  svc <- .storagegateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$reset_cache <- storagegateway_reset_cache

#' Retrieves an archived virtual tape from the virtual tape shelf (VTS) to
#' a tape gateway
#'
#' Retrieves an archived virtual tape from the virtual tape shelf (VTS) to
#' a tape gateway. Virtual tapes archived in the VTS are not associated
#' with any gateway. However after a tape is retrieved, it is associated
#' with a gateway, even though it is also listed in the VTS, that is,
#' archive. This operation is only supported in the tape gateway type.
#' 
#' Once a tape is successfully retrieved to a gateway, it cannot be
#' retrieved again to another gateway. You must archive the tape again
#' before you can retrieve it to another gateway. This operation is only
#' supported in the tape gateway type.
#'
#' @usage
#' storagegateway_retrieve_tape_archive(TapeARN, GatewayARN)
#'
#' @param TapeARN &#91;required&#93; The Amazon Resource Name (ARN) of the virtual tape you want to retrieve
#' from the virtual tape shelf (VTS).
#' @param GatewayARN &#91;required&#93; The Amazon Resource Name (ARN) of the gateway you want to retrieve the
#' virtual tape to. Use the ListGateways operation to return a list of
#' gateways for your account and AWS Region.
#' 
#' You retrieve archived virtual tapes to only one gateway and the gateway
#' must be a tape gateway.
#'
#' @section Request syntax:
#' ```
#' svc$retrieve_tape_archive(
#'   TapeARN = "string",
#'   GatewayARN = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # Retrieves an archived virtual tape from the virtual tape shelf (VTS) to
#' # a gateway-VTL. Virtual tapes archived in the VTS are not associated with
#' # any gateway.
#' svc$retrieve_tape_archive(
#'   GatewayARN = "arn:aws:storagegateway:us-east-1:999999999999:gateway/sgw-12A3456B",
#'   TapeARN = "arn:aws:storagegateway:us-east-1:999999999999:tape/TEST0AA2AF"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname storagegateway_retrieve_tape_archive
storagegateway_retrieve_tape_archive <- function(TapeARN, GatewayARN) {
  op <- new_operation(
    name = "RetrieveTapeArchive",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .storagegateway$retrieve_tape_archive_input(TapeARN = TapeARN, GatewayARN = GatewayARN)
  output <- .storagegateway$retrieve_tape_archive_output()
  config <- get_config()
  svc <- .storagegateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$retrieve_tape_archive <- storagegateway_retrieve_tape_archive

#' Retrieves the recovery point for the specified virtual tape
#'
#' Retrieves the recovery point for the specified virtual tape. This
#' operation is only supported in the tape gateway type.
#' 
#' A recovery point is a point in time view of a virtual tape at which all
#' the data on the tape is consistent. If your gateway crashes, virtual
#' tapes that have recovery points can be recovered to a new gateway.
#' 
#' The virtual tape can be retrieved to only one gateway. The retrieved
#' tape is read-only. The virtual tape can be retrieved to only a tape
#' gateway. There is no charge for retrieving recovery points.
#'
#' @usage
#' storagegateway_retrieve_tape_recovery_point(TapeARN, GatewayARN)
#'
#' @param TapeARN &#91;required&#93; The Amazon Resource Name (ARN) of the virtual tape for which you want to
#' retrieve the recovery point.
#' @param GatewayARN &#91;required&#93; 
#'
#' @section Request syntax:
#' ```
#' svc$retrieve_tape_recovery_point(
#'   TapeARN = "string",
#'   GatewayARN = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # Retrieves the recovery point for the specified virtual tape.
#' svc$retrieve_tape_recovery_point(
#'   GatewayARN = "arn:aws:storagegateway:us-east-1:999999999999:gateway/sgw-12A3456B",
#'   TapeARN = "arn:aws:storagegateway:us-east-1:999999999999:tape/TEST0AA2AF"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname storagegateway_retrieve_tape_recovery_point
storagegateway_retrieve_tape_recovery_point <- function(TapeARN, GatewayARN) {
  op <- new_operation(
    name = "RetrieveTapeRecoveryPoint",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .storagegateway$retrieve_tape_recovery_point_input(TapeARN = TapeARN, GatewayARN = GatewayARN)
  output <- .storagegateway$retrieve_tape_recovery_point_output()
  config <- get_config()
  svc <- .storagegateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$retrieve_tape_recovery_point <- storagegateway_retrieve_tape_recovery_point

#' Sets the password for your VM local console
#'
#' Sets the password for your VM local console. When you log in to the
#' local console for the first time, you log in to the VM with the default
#' credentials. We recommend that you set a new password. You don\'t need
#' to know the default password to set a new password.
#'
#' @usage
#' storagegateway_set_local_console_password(GatewayARN,
#'   LocalConsolePassword)
#'
#' @param GatewayARN &#91;required&#93; 
#' @param LocalConsolePassword &#91;required&#93; The password you want to set for your VM local console.
#'
#' @section Request syntax:
#' ```
#' svc$set_local_console_password(
#'   GatewayARN = "string",
#'   LocalConsolePassword = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # Sets the password for your VM local console.
#' svc$set_local_console_password(
#'   GatewayARN = "arn:aws:storagegateway:us-east-1:999999999999:gateway/sgw-12A3456B",
#'   LocalConsolePassword = "PassWordMustBeAtLeast6Chars."
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname storagegateway_set_local_console_password
storagegateway_set_local_console_password <- function(GatewayARN, LocalConsolePassword) {
  op <- new_operation(
    name = "SetLocalConsolePassword",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .storagegateway$set_local_console_password_input(GatewayARN = GatewayARN, LocalConsolePassword = LocalConsolePassword)
  output <- .storagegateway$set_local_console_password_output()
  config <- get_config()
  svc <- .storagegateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$set_local_console_password <- storagegateway_set_local_console_password

#' Sets the password for the guest user smbguest
#'
#' Sets the password for the guest user `smbguest`. The `smbguest` user is
#' the user when the authentication method for the file share is set to
#' `GuestAccess`.
#'
#' @usage
#' storagegateway_set_smb_guest_password(GatewayARN, Password)
#'
#' @param GatewayARN &#91;required&#93; The Amazon Resource Name (ARN) of the file gateway the SMB file share is
#' associated with.
#' @param Password &#91;required&#93; The password that you want to set for your SMB Server.
#'
#' @section Request syntax:
#' ```
#' svc$set_smb_guest_password(
#'   GatewayARN = "string",
#'   Password = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname storagegateway_set_smb_guest_password
storagegateway_set_smb_guest_password <- function(GatewayARN, Password) {
  op <- new_operation(
    name = "SetSMBGuestPassword",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .storagegateway$set_smb_guest_password_input(GatewayARN = GatewayARN, Password = Password)
  output <- .storagegateway$set_smb_guest_password_output()
  config <- get_config()
  svc <- .storagegateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$set_smb_guest_password <- storagegateway_set_smb_guest_password

#' Shuts down a gateway
#'
#' Shuts down a gateway. To specify which gateway to shut down, use the
#' Amazon Resource Name (ARN) of the gateway in the body of your request.
#' 
#' The operation shuts down the gateway service component running in the
#' gateway\'s virtual machine (VM) and not the host VM.
#' 
#' If you want to shut down the VM, it is recommended that you first shut
#' down the gateway component in the VM to avoid unpredictable conditions.
#' 
#' After the gateway is shutdown, you cannot call any other API except
#' StartGateway, DescribeGatewayInformation, and ListGateways. For more
#' information, see ActivateGateway. Your applications cannot read from or
#' write to the gateway\'s storage volumes, and there are no snapshots
#' taken.
#' 
#' When you make a shutdown request, you will get a `200 OK` success
#' response immediately. However, it might take some time for the gateway
#' to shut down. You can call the DescribeGatewayInformation API to check
#' the status. For more information, see ActivateGateway.
#' 
#' If do not intend to use the gateway again, you must delete the gateway
#' (using DeleteGateway) to no longer pay software charges associated with
#' the gateway.
#'
#' @usage
#' storagegateway_shutdown_gateway(GatewayARN)
#'
#' @param GatewayARN &#91;required&#93; 
#'
#' @section Request syntax:
#' ```
#' svc$shutdown_gateway(
#'   GatewayARN = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This operation shuts down the gateway service component running in the
#' # storage gateway's virtual machine (VM) and not the VM.
#' svc$shutdown_gateway(
#'   GatewayARN = "arn:aws:storagegateway:us-east-1:999999999999:gateway/sgw-12A3456B"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname storagegateway_shutdown_gateway
storagegateway_shutdown_gateway <- function(GatewayARN) {
  op <- new_operation(
    name = "ShutdownGateway",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .storagegateway$shutdown_gateway_input(GatewayARN = GatewayARN)
  output <- .storagegateway$shutdown_gateway_output()
  config <- get_config()
  svc <- .storagegateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$shutdown_gateway <- storagegateway_shutdown_gateway

#' Start a test that verifies that the specified gateway is configured for
#' High Availability monitoring in your host environment
#'
#' Start a test that verifies that the specified gateway is configured for
#' High Availability monitoring in your host environment. This request only
#' initiates the test and that a successful response only indicates that
#' the test was started. It doesn\'t indicate that the test passed. For the
#' status of the test, invoke the `DescribeAvailabilityMonitorTest` API.
#' 
#' Starting this test will cause your gateway to go offline for a brief
#' period.
#'
#' @usage
#' storagegateway_start_availability_monitor_test(GatewayARN)
#'
#' @param GatewayARN &#91;required&#93; 
#'
#' @section Request syntax:
#' ```
#' svc$start_availability_monitor_test(
#'   GatewayARN = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname storagegateway_start_availability_monitor_test
storagegateway_start_availability_monitor_test <- function(GatewayARN) {
  op <- new_operation(
    name = "StartAvailabilityMonitorTest",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .storagegateway$start_availability_monitor_test_input(GatewayARN = GatewayARN)
  output <- .storagegateway$start_availability_monitor_test_output()
  config <- get_config()
  svc <- .storagegateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$start_availability_monitor_test <- storagegateway_start_availability_monitor_test

#' Starts a gateway that you previously shut down (see ShutdownGateway)
#'
#' Starts a gateway that you previously shut down (see ShutdownGateway).
#' After the gateway starts, you can then make other API calls, your
#' applications can read from or write to the gateway\'s storage volumes
#' and you will be able to take snapshot backups.
#' 
#' When you make a request, you will get a 200 OK success response
#' immediately. However, it might take some time for the gateway to be
#' ready. You should call DescribeGatewayInformation and check the status
#' before making any additional API calls. For more information, see
#' ActivateGateway.
#' 
#' To specify which gateway to start, use the Amazon Resource Name (ARN) of
#' the gateway in your request.
#'
#' @usage
#' storagegateway_start_gateway(GatewayARN)
#'
#' @param GatewayARN &#91;required&#93; 
#'
#' @section Request syntax:
#' ```
#' svc$start_gateway(
#'   GatewayARN = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # Starts a gateway service that was previously shut down.
#' svc$start_gateway(
#'   GatewayARN = "arn:aws:storagegateway:us-east-1:999999999999:gateway/sgw-12A3456B"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname storagegateway_start_gateway
storagegateway_start_gateway <- function(GatewayARN) {
  op <- new_operation(
    name = "StartGateway",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .storagegateway$start_gateway_input(GatewayARN = GatewayARN)
  output <- .storagegateway$start_gateway_output()
  config <- get_config()
  svc <- .storagegateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$start_gateway <- storagegateway_start_gateway

#' Updates the bandwidth rate limits of a gateway
#'
#' Updates the bandwidth rate limits of a gateway. You can update both the
#' upload and download bandwidth rate limit or specify only one of the two.
#' If you don\'t set a bandwidth rate limit, the existing rate limit
#' remains. This operation is supported for the stored volume, cached
#' volume and tape gateway types.\'
#' 
#' By default, a gateway\'s bandwidth rate limits are not set. If you
#' don\'t set any limit, the gateway does not have any limitations on its
#' bandwidth usage and could potentially use the maximum available
#' bandwidth.
#' 
#' To specify which gateway to update, use the Amazon Resource Name (ARN)
#' of the gateway in your request.
#'
#' @usage
#' storagegateway_update_bandwidth_rate_limit(GatewayARN,
#'   AverageUploadRateLimitInBitsPerSec,
#'   AverageDownloadRateLimitInBitsPerSec)
#'
#' @param GatewayARN &#91;required&#93; 
#' @param AverageUploadRateLimitInBitsPerSec The average upload bandwidth rate limit in bits per second.
#' @param AverageDownloadRateLimitInBitsPerSec The average download bandwidth rate limit in bits per second.
#'
#' @section Request syntax:
#' ```
#' svc$update_bandwidth_rate_limit(
#'   GatewayARN = "string",
#'   AverageUploadRateLimitInBitsPerSec = 123,
#'   AverageDownloadRateLimitInBitsPerSec = 123
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # Updates the bandwidth rate limits of a gateway. Both the upload and
#' # download bandwidth rate limit can be set, or either one of the two. If a
#' # new limit is not set, the existing rate limit remains.
#' svc$update_bandwidth_rate_limit(
#'   AverageDownloadRateLimitInBitsPerSec = 102400L,
#'   AverageUploadRateLimitInBitsPerSec = 51200L,
#'   GatewayARN = "arn:aws:storagegateway:us-east-1:111122223333:gateway/sgw-12A3456B"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname storagegateway_update_bandwidth_rate_limit
storagegateway_update_bandwidth_rate_limit <- function(GatewayARN, AverageUploadRateLimitInBitsPerSec = NULL, AverageDownloadRateLimitInBitsPerSec = NULL) {
  op <- new_operation(
    name = "UpdateBandwidthRateLimit",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .storagegateway$update_bandwidth_rate_limit_input(GatewayARN = GatewayARN, AverageUploadRateLimitInBitsPerSec = AverageUploadRateLimitInBitsPerSec, AverageDownloadRateLimitInBitsPerSec = AverageDownloadRateLimitInBitsPerSec)
  output <- .storagegateway$update_bandwidth_rate_limit_output()
  config <- get_config()
  svc <- .storagegateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$update_bandwidth_rate_limit <- storagegateway_update_bandwidth_rate_limit

#' Updates the Challenge-Handshake Authentication Protocol (CHAP)
#' credentials for a specified iSCSI target
#'
#' Updates the Challenge-Handshake Authentication Protocol (CHAP)
#' credentials for a specified iSCSI target. By default, a gateway does not
#' have CHAP enabled; however, for added security, you might use it. This
#' operation is supported in the volume and tape gateway types.
#' 
#' When you update CHAP credentials, all existing connections on the target
#' are closed and initiators must reconnect with the new credentials.
#'
#' @usage
#' storagegateway_update_chap_credentials(TargetARN,
#'   SecretToAuthenticateInitiator, InitiatorName,
#'   SecretToAuthenticateTarget)
#'
#' @param TargetARN &#91;required&#93; The Amazon Resource Name (ARN) of the iSCSI volume target. Use the
#' DescribeStorediSCSIVolumes operation to return the TargetARN for
#' specified VolumeARN.
#' @param SecretToAuthenticateInitiator &#91;required&#93; The secret key that the initiator (for example, the Windows client) must
#' provide to participate in mutual CHAP with the target.
#' 
#' The secret key must be between 12 and 16 bytes when encoded in UTF-8.
#' @param InitiatorName &#91;required&#93; The iSCSI initiator that connects to the target.
#' @param SecretToAuthenticateTarget The secret key that the target must provide to participate in mutual
#' CHAP with the initiator (e.g. Windows client).
#' 
#' Byte constraints: Minimum bytes of 12. Maximum bytes of 16.
#' 
#' The secret key must be between 12 and 16 bytes when encoded in UTF-8.
#'
#' @section Request syntax:
#' ```
#' svc$update_chap_credentials(
#'   TargetARN = "string",
#'   SecretToAuthenticateInitiator = "string",
#'   InitiatorName = "string",
#'   SecretToAuthenticateTarget = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # Updates the Challenge-Handshake Authentication Protocol (CHAP)
#' # credentials for a specified iSCSI target.
#' svc$update_chap_credentials(
#'   InitiatorName = "iqn.1991-05.com.microsoft:computername.domain.example.com",
#'   SecretToAuthenticateInitiator = "111111111111",
#'   SecretToAuthenticateTarget = "222222222222",
#'   TargetARN = "arn:aws:storagegateway:us-east-1:111122223333:gateway/sgw-12A3456B/target/iqn..."
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname storagegateway_update_chap_credentials
storagegateway_update_chap_credentials <- function(TargetARN, SecretToAuthenticateInitiator, InitiatorName, SecretToAuthenticateTarget = NULL) {
  op <- new_operation(
    name = "UpdateChapCredentials",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .storagegateway$update_chap_credentials_input(TargetARN = TargetARN, SecretToAuthenticateInitiator = SecretToAuthenticateInitiator, InitiatorName = InitiatorName, SecretToAuthenticateTarget = SecretToAuthenticateTarget)
  output <- .storagegateway$update_chap_credentials_output()
  config <- get_config()
  svc <- .storagegateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$update_chap_credentials <- storagegateway_update_chap_credentials

#' Updates a gateway's metadata, which includes the gateway's name and time
#' zone
#'
#' Updates a gateway\'s metadata, which includes the gateway\'s name and
#' time zone. To specify which gateway to update, use the Amazon Resource
#' Name (ARN) of the gateway in your request.
#' 
#' For Gateways activated after September 2, 2015, the gateway\'s ARN
#' contains the gateway ID rather than the gateway name. However, changing
#' the name of the gateway has no effect on the gateway\'s ARN.
#'
#' @usage
#' storagegateway_update_gateway_information(GatewayARN, GatewayName,
#'   GatewayTimezone, CloudWatchLogGroupARN)
#'
#' @param GatewayARN &#91;required&#93; 
#' @param GatewayName 
#' @param GatewayTimezone A value that indicates the time zone of the gateway.
#' @param CloudWatchLogGroupARN The Amazon Resource Name (ARN) of the Amazon CloudWatch log group that
#' you want to use to monitor and log events in the gateway.
#' 
#' For more information, see [What Is Amazon CloudWatch
#' Logs?](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/WhatIsCloudWatchLogs.html).
#'
#' @section Request syntax:
#' ```
#' svc$update_gateway_information(
#'   GatewayARN = "string",
#'   GatewayName = "string",
#'   GatewayTimezone = "string",
#'   CloudWatchLogGroupARN = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # Updates a gateway's metadata, which includes the gateway's name and time
#' # zone.
#' svc$update_gateway_information(
#'   GatewayARN = "arn:aws:storagegateway:us-east-1:111122223333:gateway/sgw-12A3456B",
#'   GatewayName = "MyGateway2",
#'   GatewayTimezone = "GMT-12:00"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname storagegateway_update_gateway_information
storagegateway_update_gateway_information <- function(GatewayARN, GatewayName = NULL, GatewayTimezone = NULL, CloudWatchLogGroupARN = NULL) {
  op <- new_operation(
    name = "UpdateGatewayInformation",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .storagegateway$update_gateway_information_input(GatewayARN = GatewayARN, GatewayName = GatewayName, GatewayTimezone = GatewayTimezone, CloudWatchLogGroupARN = CloudWatchLogGroupARN)
  output <- .storagegateway$update_gateway_information_output()
  config <- get_config()
  svc <- .storagegateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$update_gateway_information <- storagegateway_update_gateway_information

#' Updates the gateway virtual machine (VM) software
#'
#' Updates the gateway virtual machine (VM) software. The request
#' immediately triggers the software update.
#' 
#' When you make this request, you get a `200 OK` success response
#' immediately. However, it might take some time for the update to
#' complete. You can call DescribeGatewayInformation to verify the gateway
#' is in the `STATE_RUNNING` state.
#' 
#' A software update forces a system restart of your gateway. You can
#' minimize the chance of any disruption to your applications by increasing
#' your iSCSI Initiators\' timeouts. For more information about increasing
#' iSCSI Initiator timeouts for Windows and Linux, see [Customizing Your
#' Windows iSCSI
#' Settings](https://docs.aws.amazon.com/storagegateway/latest/userguide/ConfiguringiSCSIClientInitiatorWindowsClient.html#CustomizeWindowsiSCSISettings)
#' and [Customizing Your Linux iSCSI
#' Settings](https://docs.aws.amazon.com/storagegateway/latest/userguide/ConfiguringiSCSIClientInitiatorRedHatClient.html#CustomizeLinuxiSCSISettings),
#' respectively.
#'
#' @usage
#' storagegateway_update_gateway_software_now(GatewayARN)
#'
#' @param GatewayARN &#91;required&#93; 
#'
#' @section Request syntax:
#' ```
#' svc$update_gateway_software_now(
#'   GatewayARN = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # Updates the gateway virtual machine (VM) software. The request
#' # immediately triggers the software update.
#' svc$update_gateway_software_now(
#'   GatewayARN = "arn:aws:storagegateway:us-east-1:111122223333:gateway/sgw-12A3456B"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname storagegateway_update_gateway_software_now
storagegateway_update_gateway_software_now <- function(GatewayARN) {
  op <- new_operation(
    name = "UpdateGatewaySoftwareNow",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .storagegateway$update_gateway_software_now_input(GatewayARN = GatewayARN)
  output <- .storagegateway$update_gateway_software_now_output()
  config <- get_config()
  svc <- .storagegateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$update_gateway_software_now <- storagegateway_update_gateway_software_now

#' Updates a gateway's weekly maintenance start time information, including
#' day and time of the week
#'
#' Updates a gateway\'s weekly maintenance start time information,
#' including day and time of the week. The maintenance time is the time in
#' your gateway\'s time zone.
#'
#' @usage
#' storagegateway_update_maintenance_start_time(GatewayARN, HourOfDay,
#'   MinuteOfHour, DayOfWeek, DayOfMonth)
#'
#' @param GatewayARN &#91;required&#93; 
#' @param HourOfDay &#91;required&#93; The hour component of the maintenance start time represented as *hh*,
#' where *hh* is the hour (00 to 23). The hour of the day is in the time
#' zone of the gateway.
#' @param MinuteOfHour &#91;required&#93; The minute component of the maintenance start time represented as *mm*,
#' where *mm* is the minute (00 to 59). The minute of the hour is in the
#' time zone of the gateway.
#' @param DayOfWeek The day of the week component of the maintenance start time week
#' represented as an ordinal number from 0 to 6, where 0 represents Sunday
#' and 6 Saturday.
#' @param DayOfMonth The day of the month component of the maintenance start time represented
#' as an ordinal number from 1 to 28, where 1 represents the first day of
#' the month and 28 represents the last day of the month.
#' 
#' This value is only available for tape and volume gateways.
#'
#' @section Request syntax:
#' ```
#' svc$update_maintenance_start_time(
#'   GatewayARN = "string",
#'   HourOfDay = 123,
#'   MinuteOfHour = 123,
#'   DayOfWeek = 123,
#'   DayOfMonth = 123
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # Updates a gateway's weekly maintenance start time information, including
#' # day and time of the week. The maintenance time is in your gateway's time
#' # zone.
#' svc$update_maintenance_start_time(
#'   DayOfWeek = 2L,
#'   GatewayARN = "arn:aws:storagegateway:us-east-1:111122223333:gateway/sgw-12A3456B",
#'   HourOfDay = 0L,
#'   MinuteOfHour = 30L
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname storagegateway_update_maintenance_start_time
storagegateway_update_maintenance_start_time <- function(GatewayARN, HourOfDay, MinuteOfHour, DayOfWeek = NULL, DayOfMonth = NULL) {
  op <- new_operation(
    name = "UpdateMaintenanceStartTime",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .storagegateway$update_maintenance_start_time_input(GatewayARN = GatewayARN, HourOfDay = HourOfDay, MinuteOfHour = MinuteOfHour, DayOfWeek = DayOfWeek, DayOfMonth = DayOfMonth)
  output <- .storagegateway$update_maintenance_start_time_output()
  config <- get_config()
  svc <- .storagegateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$update_maintenance_start_time <- storagegateway_update_maintenance_start_time

#' Updates a Network File System (NFS) file share
#'
#' Updates a Network File System (NFS) file share. This operation is only
#' supported in the file gateway type.
#' 
#' To leave a file share field unchanged, set the corresponding input field
#' to null.
#' 
#' Updates the following file share setting:
#' 
#' -   Default storage class for your S3 bucket
#' 
#' -   Metadata defaults for your S3 bucket
#' 
#' -   Allowed NFS clients for your file share
#' 
#' -   Squash settings
#' 
#' -   Write status of your file share
#' 
#' To leave a file share field unchanged, set the corresponding input field
#' to null. This operation is only supported in file gateways.
#'
#' @usage
#' storagegateway_update_nfs_file_share(FileShareARN, KMSEncrypted, KMSKey,
#'   NFSFileShareDefaults, DefaultStorageClass, ObjectACL, ClientList,
#'   Squash, ReadOnly, GuessMIMETypeEnabled, RequesterPays)
#'
#' @param FileShareARN &#91;required&#93; The Amazon Resource Name (ARN) of the file share to be updated.
#' @param KMSEncrypted True to use Amazon S3 server side encryption with your own AWS KMS key,
#' or false to use a key managed by Amazon S3. Optional.
#' @param KMSKey The Amazon Resource Name (ARN) of the AWS KMS key used for Amazon S3
#' server side encryption. This value can only be set when KMSEncrypted is
#' true. Optional.
#' @param NFSFileShareDefaults The default values for the file share. Optional.
#' @param DefaultStorageClass The default storage class for objects put into an Amazon S3 bucket by
#' the file gateway. Possible values are `S3_STANDARD`, `S3_STANDARD_IA`,
#' or `S3_ONEZONE_IA`. If this field is not populated, the default value
#' `S3_STANDARD` is used. Optional.
#' @param ObjectACL A value that sets the access control list permission for objects in the
#' S3 bucket that a file gateway puts objects into. The default value is
#' \"private\".
#' @param ClientList The list of clients that are allowed to access the file gateway. The
#' list must contain either valid IP addresses or valid CIDR blocks.
#' @param Squash The user mapped to anonymous user. Valid options are the following:
#' 
#' -   `RootSquash` - Only root is mapped to anonymous user.
#' 
#' -   `NoSquash` - No one is mapped to anonymous user
#' 
#' -   `AllSquash` - Everyone is mapped to anonymous user.
#' @param ReadOnly A value that sets the write status of a file share. This value is true
#' if the write status is read-only, and otherwise false.
#' @param GuessMIMETypeEnabled A value that enables guessing of the MIME type for uploaded objects
#' based on file extensions. Set this value to true to enable MIME type
#' guessing, and otherwise to false. The default value is true.
#' @param RequesterPays A value that sets who pays the cost of the request and the cost
#' associated with data download from the S3 bucket. If this value is set
#' to true, the requester pays the costs. Otherwise the S3 bucket owner
#' pays. However, the S3 bucket owner always pays the cost of storing data.
#' 
#' `RequesterPays` is a configuration for the S3 bucket that backs the file
#' share, so make sure that the configuration on the file share is the same
#' as the S3 bucket configuration.
#'
#' @section Request syntax:
#' ```
#' svc$update_nfs_file_share(
#'   FileShareARN = "string",
#'   KMSEncrypted = TRUE|FALSE,
#'   KMSKey = "string",
#'   NFSFileShareDefaults = list(
#'     FileMode = "string",
#'     DirectoryMode = "string",
#'     GroupId = 123,
#'     OwnerId = 123
#'   ),
#'   DefaultStorageClass = "string",
#'   ObjectACL = "private"|"public-read"|"public-read-write"|"authenticated-read"|"bucket-owner-read"|"bucket-owner-full-control"|"aws-exec-read",
#'   ClientList = list(
#'     "string"
#'   ),
#'   Squash = "string",
#'   ReadOnly = TRUE|FALSE,
#'   GuessMIMETypeEnabled = TRUE|FALSE,
#'   RequesterPays = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname storagegateway_update_nfs_file_share
storagegateway_update_nfs_file_share <- function(FileShareARN, KMSEncrypted = NULL, KMSKey = NULL, NFSFileShareDefaults = NULL, DefaultStorageClass = NULL, ObjectACL = NULL, ClientList = NULL, Squash = NULL, ReadOnly = NULL, GuessMIMETypeEnabled = NULL, RequesterPays = NULL) {
  op <- new_operation(
    name = "UpdateNFSFileShare",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .storagegateway$update_nfs_file_share_input(FileShareARN = FileShareARN, KMSEncrypted = KMSEncrypted, KMSKey = KMSKey, NFSFileShareDefaults = NFSFileShareDefaults, DefaultStorageClass = DefaultStorageClass, ObjectACL = ObjectACL, ClientList = ClientList, Squash = Squash, ReadOnly = ReadOnly, GuessMIMETypeEnabled = GuessMIMETypeEnabled, RequesterPays = RequesterPays)
  output <- .storagegateway$update_nfs_file_share_output()
  config <- get_config()
  svc <- .storagegateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$update_nfs_file_share <- storagegateway_update_nfs_file_share

#' Updates a Server Message Block (SMB) file share
#'
#' Updates a Server Message Block (SMB) file share.
#' 
#' To leave a file share field unchanged, set the corresponding input field
#' to null. This operation is only supported for file gateways.
#' 
#' File gateways require AWS Security Token Service (AWS STS) to be
#' activated to enable you to create a file share. Make sure that AWS STS
#' is activated in the AWS Region you are creating your file gateway in. If
#' AWS STS is not activated in this AWS Region, activate it. For
#' information about how to activate AWS STS, see [Activating and
#' Deactivating AWS STS in an AWS
#' Region](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_enable-regions.html)
#' in the *AWS Identity and Access Management User Guide.*
#' 
#' File gateways don\'t support creating hard or symbolic links on a file
#' share.
#'
#' @usage
#' storagegateway_update_smb_file_share(FileShareARN, KMSEncrypted, KMSKey,
#'   DefaultStorageClass, ObjectACL, ReadOnly, GuessMIMETypeEnabled,
#'   RequesterPays, SMBACLEnabled, AdminUserList, ValidUserList,
#'   InvalidUserList)
#'
#' @param FileShareARN &#91;required&#93; The Amazon Resource Name (ARN) of the SMB file share that you want to
#' update.
#' @param KMSEncrypted True to use Amazon S3 server side encryption with your own AWS KMS key,
#' or false to use a key managed by Amazon S3. Optional.
#' @param KMSKey The Amazon Resource Name (ARN) of the AWS KMS key used for Amazon S3
#' server side encryption. This value can only be set when KMSEncrypted is
#' true. Optional.
#' @param DefaultStorageClass The default storage class for objects put into an Amazon S3 bucket by
#' the file gateway. Possible values are `S3_STANDARD`, `S3_STANDARD_IA`,
#' or `S3_ONEZONE_IA`. If this field is not populated, the default value
#' `S3_STANDARD` is used. Optional.
#' @param ObjectACL A value that sets the access control list permission for objects in the
#' S3 bucket that a file gateway puts objects into. The default value is
#' \"private\".
#' @param ReadOnly A value that sets the write status of a file share. This value is true
#' if the write status is read-only, and otherwise false.
#' @param GuessMIMETypeEnabled A value that enables guessing of the MIME type for uploaded objects
#' based on file extensions. Set this value to true to enable MIME type
#' guessing, and otherwise to false. The default value is true.
#' @param RequesterPays A value that sets who pays the cost of the request and the cost
#' associated with data download from the S3 bucket. If this value is set
#' to true, the requester pays the costs. Otherwise the S3 bucket owner
#' pays. However, the S3 bucket owner always pays the cost of storing data.
#' 
#' `RequesterPays` is a configuration for the S3 bucket that backs the file
#' share, so make sure that the configuration on the file share is the same
#' as the S3 bucket configuration.
#' @param SMBACLEnabled Set this value to \"true to enable ACL (access control list) on the SMB
#' file share. Set it to \"false\" to map file and directory permissions to
#' the POSIX permissions.
#' 
#' For more information, see
#' https://docs.aws.amazon.com/storagegateway/latest/userguide/smb-acl.htmlin
#' the Storage Gateway User Guide.
#' @param AdminUserList A list of users in the Active Directory that have administrator rights
#' to the file share. A group must be prefixed with the @@ character. For
#' example `@@group1`. Can only be set if Authentication is set to
#' `ActiveDirectory`.
#' @param ValidUserList A list of users or groups in the Active Directory that are allowed to
#' access the file share. A group must be prefixed with the @@ character.
#' For example `@@group1`. Can only be set if Authentication is set to
#' `ActiveDirectory`.
#' @param InvalidUserList A list of users or groups in the Active Directory that are not allowed
#' to access the file share. A group must be prefixed with the @@ character.
#' For example `@@group1`. Can only be set if Authentication is set to
#' `ActiveDirectory`.
#'
#' @section Request syntax:
#' ```
#' svc$update_smb_file_share(
#'   FileShareARN = "string",
#'   KMSEncrypted = TRUE|FALSE,
#'   KMSKey = "string",
#'   DefaultStorageClass = "string",
#'   ObjectACL = "private"|"public-read"|"public-read-write"|"authenticated-read"|"bucket-owner-read"|"bucket-owner-full-control"|"aws-exec-read",
#'   ReadOnly = TRUE|FALSE,
#'   GuessMIMETypeEnabled = TRUE|FALSE,
#'   RequesterPays = TRUE|FALSE,
#'   SMBACLEnabled = TRUE|FALSE,
#'   AdminUserList = list(
#'     "string"
#'   ),
#'   ValidUserList = list(
#'     "string"
#'   ),
#'   InvalidUserList = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname storagegateway_update_smb_file_share
storagegateway_update_smb_file_share <- function(FileShareARN, KMSEncrypted = NULL, KMSKey = NULL, DefaultStorageClass = NULL, ObjectACL = NULL, ReadOnly = NULL, GuessMIMETypeEnabled = NULL, RequesterPays = NULL, SMBACLEnabled = NULL, AdminUserList = NULL, ValidUserList = NULL, InvalidUserList = NULL) {
  op <- new_operation(
    name = "UpdateSMBFileShare",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .storagegateway$update_smb_file_share_input(FileShareARN = FileShareARN, KMSEncrypted = KMSEncrypted, KMSKey = KMSKey, DefaultStorageClass = DefaultStorageClass, ObjectACL = ObjectACL, ReadOnly = ReadOnly, GuessMIMETypeEnabled = GuessMIMETypeEnabled, RequesterPays = RequesterPays, SMBACLEnabled = SMBACLEnabled, AdminUserList = AdminUserList, ValidUserList = ValidUserList, InvalidUserList = InvalidUserList)
  output <- .storagegateway$update_smb_file_share_output()
  config <- get_config()
  svc <- .storagegateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$update_smb_file_share <- storagegateway_update_smb_file_share

#' Updates the SMB security strategy on a file gateway
#'
#' Updates the SMB security strategy on a file gateway. This action is only
#' supported in file gateways.
#' 
#' This API is called Security level in the User Guide.
#' 
#' A higher security level can affect performance of the gateway.
#'
#' @usage
#' storagegateway_update_smb_security_strategy(GatewayARN,
#'   SMBSecurityStrategy)
#'
#' @param GatewayARN &#91;required&#93; 
#' @param SMBSecurityStrategy &#91;required&#93; Specifies the type of security strategy.
#' 
#' ClientSpecified: if you use this option, requests are established based
#' on what is negotiated by the client. This option is recommended when you
#' want to maximize compatibility across different clients in your
#' environment.
#' 
#' MandatorySigning: if you use this option, file gateway only allows
#' connections from SMBv2 or SMBv3 clients that have signing enabled. This
#' option works with SMB clients on Microsoft Windows Vista, Windows Server
#' 2008 or newer.
#' 
#' MandatoryEncryption: if you use this option, file gateway only allows
#' connections from SMBv3 clients that have encryption enabled. This option
#' is highly recommended for environments that handle sensitive data. This
#' option works with SMB clients on Microsoft Windows 8, Windows Server
#' 2012 or newer.
#'
#' @section Request syntax:
#' ```
#' svc$update_smb_security_strategy(
#'   GatewayARN = "string",
#'   SMBSecurityStrategy = "ClientSpecified"|"MandatorySigning"|"MandatoryEncryption"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname storagegateway_update_smb_security_strategy
storagegateway_update_smb_security_strategy <- function(GatewayARN, SMBSecurityStrategy) {
  op <- new_operation(
    name = "UpdateSMBSecurityStrategy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .storagegateway$update_smb_security_strategy_input(GatewayARN = GatewayARN, SMBSecurityStrategy = SMBSecurityStrategy)
  output <- .storagegateway$update_smb_security_strategy_output()
  config <- get_config()
  svc <- .storagegateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$update_smb_security_strategy <- storagegateway_update_smb_security_strategy

#' Updates a snapshot schedule configured for a gateway volume
#'
#' Updates a snapshot schedule configured for a gateway volume. This
#' operation is only supported in the cached volume and stored volume
#' gateway types.
#' 
#' The default snapshot schedule for volume is once every 24 hours,
#' starting at the creation time of the volume. You can use this API to
#' change the snapshot schedule configured for the volume.
#' 
#' In the request you must identify the gateway volume whose snapshot
#' schedule you want to update, and the schedule information, including
#' when you want the snapshot to begin on a day and the frequency (in
#' hours) of snapshots.
#'
#' @usage
#' storagegateway_update_snapshot_schedule(VolumeARN, StartAt,
#'   RecurrenceInHours, Description, Tags)
#'
#' @param VolumeARN &#91;required&#93; The Amazon Resource Name (ARN) of the volume. Use the ListVolumes
#' operation to return a list of gateway volumes.
#' @param StartAt &#91;required&#93; The hour of the day at which the snapshot schedule begins represented as
#' *hh*, where *hh* is the hour (0 to 23). The hour of the day is in the
#' time zone of the gateway.
#' @param RecurrenceInHours &#91;required&#93; Frequency of snapshots. Specify the number of hours between snapshots.
#' @param Description Optional description of the snapshot that overwrites the existing
#' description.
#' @param Tags A list of up to 50 tags that can be assigned to a snapshot. Each tag is
#' a key-value pair.
#' 
#' Valid characters for key and value are letters, spaces, and numbers
#' representable in UTF-8 format, and the following special characters: + -
#' = . \\_ : / @@. The maximum length of a tag\'s key is 128 characters, and
#' the maximum length for a tag\'s value is 256.
#'
#' @section Request syntax:
#' ```
#' svc$update_snapshot_schedule(
#'   VolumeARN = "string",
#'   StartAt = 123,
#'   RecurrenceInHours = 123,
#'   Description = "string",
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # Updates a snapshot schedule configured for a gateway volume.
#' svc$update_snapshot_schedule(
#'   Description = "Hourly snapshot",
#'   RecurrenceInHours = 1L,
#'   StartAt = 0L,
#'   VolumeARN = "arn:aws:storagegateway:us-east-1:111122223333:gateway/sgw-12A3456B/volume/vol..."
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname storagegateway_update_snapshot_schedule
storagegateway_update_snapshot_schedule <- function(VolumeARN, StartAt, RecurrenceInHours, Description = NULL, Tags = NULL) {
  op <- new_operation(
    name = "UpdateSnapshotSchedule",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .storagegateway$update_snapshot_schedule_input(VolumeARN = VolumeARN, StartAt = StartAt, RecurrenceInHours = RecurrenceInHours, Description = Description, Tags = Tags)
  output <- .storagegateway$update_snapshot_schedule_output()
  config <- get_config()
  svc <- .storagegateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$update_snapshot_schedule <- storagegateway_update_snapshot_schedule

#' Updates the type of medium changer in a tape gateway
#'
#' Updates the type of medium changer in a tape gateway. When you activate
#' a tape gateway, you select a medium changer type for the tape gateway.
#' This operation enables you to select a different type of medium changer
#' after a tape gateway is activated. This operation is only supported in
#' the tape gateway type.
#'
#' @usage
#' storagegateway_update_vtl_device_type(VTLDeviceARN, DeviceType)
#'
#' @param VTLDeviceARN &#91;required&#93; The Amazon Resource Name (ARN) of the medium changer you want to select.
#' @param DeviceType &#91;required&#93; The type of medium changer you want to select.
#' 
#' Valid Values: \"STK-L700\", \"AWS-Gateway-VTL\"
#'
#' @section Request syntax:
#' ```
#' svc$update_vtl_device_type(
#'   VTLDeviceARN = "string",
#'   DeviceType = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # Updates the type of medium changer in a gateway-VTL after a gateway-VTL
#' # is activated.
#' svc$update_vtl_device_type(
#'   DeviceType = "Medium Changer",
#'   VTLDeviceARN = "arn:aws:storagegateway:us-east-1:999999999999:gateway/sgw-12A3456B/device/..."
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname storagegateway_update_vtl_device_type
storagegateway_update_vtl_device_type <- function(VTLDeviceARN, DeviceType) {
  op <- new_operation(
    name = "UpdateVTLDeviceType",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .storagegateway$update_vtl_device_type_input(VTLDeviceARN = VTLDeviceARN, DeviceType = DeviceType)
  output <- .storagegateway$update_vtl_device_type_output()
  config <- get_config()
  svc <- .storagegateway$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$update_vtl_device_type <- storagegateway_update_vtl_device_type
