% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dlm_service.R
\name{dlm}
\alias{dlm}
\title{Amazon Data Lifecycle Manager}
\usage{
dlm(config = list())
}
\arguments{
\item{config}{Optional configuration of credentials, endpoint, and/or region.}
}
\description{
With Amazon Data Lifecycle Manager, you can manage the lifecycle of your
AWS resources. You create lifecycle policies, which are used to automate
operations on the specified resources.

Amazon DLM supports Amazon EBS volumes and snapshots. For information
about using Amazon DLM with Amazon EBS, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/snapshot-lifecycle.html}{Automating the Amazon EBS Snapshot Lifecycle}
in the \emph{Amazon EC2 User Guide}.
}
\section{Service syntax}{
\preformatted{svc <- dlm(
  config = list(
    credentials = list(
      creds = list(
        access_key_id = "string",
        secret_access_key = "string",
        session_token = "string"
      ),
      profile = "string"
    ),
    endpoint = "string",
    region = "string"
  )
)
}
}

\section{Operations}{

\tabular{ll}{
\link[=dlm_create_lifecycle_policy]{create_lifecycle_policy} \tab Creates a policy to manage the lifecycle of the specified AWS resources \cr
\link[=dlm_delete_lifecycle_policy]{delete_lifecycle_policy} \tab Deletes the specified lifecycle policy and halts the automated operations that the policy specified\cr
\link[=dlm_get_lifecycle_policies]{get_lifecycle_policies} \tab Gets summary information about all or the specified data lifecycle policies \cr
\link[=dlm_get_lifecycle_policy]{get_lifecycle_policy} \tab Gets detailed information about the specified lifecycle policy \cr
\link[=dlm_list_tags_for_resource]{list_tags_for_resource} \tab Lists the tags for the specified resource \cr
\link[=dlm_tag_resource]{tag_resource} \tab Adds the specified tags to the specified resource \cr
\link[=dlm_untag_resource]{untag_resource} \tab Removes the specified tags from the specified resource \cr
\link[=dlm_update_lifecycle_policy]{update_lifecycle_policy} \tab Updates the specified lifecycle policy
}
}

\examples{
\dontrun{
svc <- dlm()
svc$create_lifecycle_policy(
  Foo = 123
)
}

}
