% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fsx_operations.R
\name{fsx_update_file_system}
\alias{fsx_update_file_system}
\title{Use this operation to update the configuration of an existing Amazon FSx
file system}
\usage{
fsx_update_file_system(FileSystemId, ClientRequestToken,
  StorageCapacity, WindowsConfiguration, LustreConfiguration)
}
\arguments{
\item{FileSystemId}{[required] Identifies the file system that you are updating.}

\item{ClientRequestToken}{A string of up to 64 ASCII characters that Amazon FSx uses to ensure
idempotent updates. This string is automatically filled on your behalf
when you use the AWS Command Line Interface (AWS CLI) or an AWS SDK.}

\item{StorageCapacity}{Use this parameter to increase the storage capacity of an Amazon FSx for
Windows File Server file system. Specifies the storage capacity target
value, GiB, for the file system you\'re updating. The storage capacity
target value must be at least 10 percent (\%) greater than the current
storage capacity value. In order to increase storage capacity, the file
system needs to have at least 16 MB/s of throughput capacity. You cannot
make a storage capacity increase request if there is an existing storage
capacity increase request in progress. For more information, see
\href{https://docs.aws.amazon.com/fsx/latest/WindowsGuide/managing-storage-capacity.html}{Managing Storage Capacity}.}

\item{WindowsConfiguration}{The configuration updates for an Amazon FSx for Windows File Server file
system.}

\item{LustreConfiguration}{}
}
\description{
Use this operation to update the configuration of an existing Amazon FSx
file system. For an Amazon FSx for Lustre file system, you can update
only the WeeklyMaintenanceStartTime. For an Amazon for Windows File
Server file system, you can update the following properties:
}
\details{
\itemize{
\item AutomaticBackupRetentionDays
\item DailyAutomaticBackupStartTime
\item SelfManagedActiveDirectoryConfiguration
\item StorageCapacity
\item ThroughputCapacity
\item WeeklyMaintenanceStartTime
}

You can update multiple properties in a single request.
}
\section{Request syntax}{
\preformatted{svc$update_file_system(
  FileSystemId = "string",
  ClientRequestToken = "string",
  StorageCapacity = 123,
  WindowsConfiguration = list(
    WeeklyMaintenanceStartTime = "string",
    DailyAutomaticBackupStartTime = "string",
    AutomaticBackupRetentionDays = 123,
    ThroughputCapacity = 123,
    SelfManagedActiveDirectoryConfiguration = list(
      UserName = "string",
      Password = "string",
      DnsIps = list(
        "string"
      )
    )
  ),
  LustreConfiguration = list(
    WeeklyMaintenanceStartTime = "string",
    DailyAutomaticBackupStartTime = "string",
    AutomaticBackupRetentionDays = 123
  )
)
}
}

\examples{
\dontrun{
# This operation updates an existing file system.
svc$update_file_system(
  FileSystemId = "fs-0498eed5fe91001ec",
  WindowsConfiguration = list(
    AutomaticBackupRetentionDays = 10L,
    DailyAutomaticBackupStartTime = "06:00",
    WeeklyMaintenanceStartTime = "3:06:00"
  )
)
}

}
\keyword{internal}
