% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_operations.R
\name{s3_get_bucket_analytics_configuration}
\alias{s3_get_bucket_analytics_configuration}
\title{This implementation of the GET operation returns an analytics
configuration (identified by the analytics configuration ID) from the
bucket}
\usage{
s3_get_bucket_analytics_configuration(Bucket, Id)
}
\arguments{
\item{Bucket}{[required] The name of the bucket from which an analytics configuration is
retrieved.}

\item{Id}{[required] The ID that identifies the analytics configuration.}
}
\description{
This implementation of the GET operation returns an analytics
configuration (identified by the analytics configuration ID) from the
bucket.
}
\details{
To use this operation, you must have permissions to perform the
\code{s3:GetAnalyticsConfiguration} action. The bucket owner has this
permission by default. The bucket owner can grant this permission to
others. For more information about permissions, see \href{https://docs.aws.amazon.com/AmazonS3/latest/dev/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources}{Permissions Related to Bucket Subresource Operations}
and \href{https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-access-control.html}{Managing Access Permissions to Your Amazon S3 Resources}
in the \emph{Amazon Simple Storage Service Developer Guide}.

For information about Amazon S3 analytics feature, see \href{https://docs.aws.amazon.com/AmazonS3/latest/dev/analytics-storage-class.html}{Amazon S3 Analytics -- Storage Class Analysis}
in the \emph{Amazon Simple Storage Service Developer Guide}.

\strong{Related Resources}
}
\section{Request syntax}{
\preformatted{svc$get_bucket_analytics_configuration(
  Bucket = "string",
  Id = "string"
)
}
}

\keyword{internal}
