% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backup_operations.R
\name{backup_create_backup_selection}
\alias{backup_create_backup_selection}
\title{Creates a JSON document that specifies a set of resources to assign to a
backup plan}
\usage{
backup_create_backup_selection(
  BackupPlanId,
  BackupSelection,
  CreatorRequestId = NULL
)
}
\arguments{
\item{BackupPlanId}{[required] Uniquely identifies the backup plan to be associated with the selection
of resources.}

\item{BackupSelection}{[required] Specifies the body of a request to assign a set of resources to a backup
plan.}

\item{CreatorRequestId}{A unique string that identifies the request and allows failed requests
to be retried without the risk of running the operation twice. This
parameter is optional.

If used, this parameter must contain 1 to 50 alphanumeric or '-_.'
characters.}
}
\description{
Creates a JSON document that specifies a set of resources to assign to a backup plan. For examples, see \href{https://docs.aws.amazon.com/aws-backup/latest/devguide/assigning-resources.html#assigning-resources-json}{Assigning resources programmatically}.

See \url{https://paws-r.github.io/docs/backup/create_backup_selection.html} for full documentation.
}
\keyword{internal}
