% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/efs_operations.R
\name{efs_put_lifecycle_configuration}
\alias{efs_put_lifecycle_configuration}
\title{Use this action to manage EFS lifecycle management and intelligent
tiering}
\usage{
efs_put_lifecycle_configuration(FileSystemId, LifecyclePolicies)
}
\arguments{
\item{FileSystemId}{[required] The ID of the file system for which you are creating the
\code{LifecycleConfiguration} object (String).}

\item{LifecyclePolicies}{[required] An array of \code{LifecyclePolicy} objects that define the file system's
\code{LifecycleConfiguration} object. A \code{LifecycleConfiguration} object
informs EFS lifecycle management and EFS Intelligent-Tiering of the
following:
\itemize{
\item When to move files in the file system from primary storage to the IA
storage class.
\item When to move files that are in IA storage to primary storage.
}

When using the \code{put-lifecycle-configuration} CLI command or the
\code{\link[=efs_put_lifecycle_configuration]{put_lifecycle_configuration}} API
action, Amazon EFS requires that each \code{LifecyclePolicy} object have only
a single transition. This means that in a request body,
\code{LifecyclePolicies} must be structured as an array of \code{LifecyclePolicy}
objects, one object for each transition, \code{TransitionToIA},
\code{TransitionToPrimaryStorageClass}. See the example requests in the
following section for more information.}
}
\description{
Use this action to manage EFS lifecycle management and intelligent tiering. A \code{LifecycleConfiguration} consists of one or more \code{LifecyclePolicy} objects that define the following:

See \url{https://paws-r.github.io/docs/efs/put_lifecycle_configuration.html} for full documentation.
}
\keyword{internal}
