% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/finspacedata_operations.R
\name{finspacedata_create_permission_group}
\alias{finspacedata_create_permission_group}
\title{Creates a group of permissions for various actions that a user can
perform in FinSpace}
\usage{
finspacedata_create_permission_group(
  name,
  description = NULL,
  applicationPermissions,
  clientToken = NULL
)
}
\arguments{
\item{name}{[required] The name of the permission group.}

\item{description}{A brief description for the permission group.}

\item{applicationPermissions}{[required] The option to indicate FinSpace application permissions that are granted
to a specific group.

When assigning application permissions, be aware that the permission
\code{ManageUsersAndGroups} allows users to grant themselves or others access
to any functionality in their FinSpace environment's application. It
should only be granted to trusted users.
\itemize{
\item \code{\link[=finspacedata_create_dataset]{create_dataset}} – Group members can
create new datasets.
\item \code{ManageClusters} – Group members can manage Apache Spark clusters
from FinSpace notebooks.
\item \code{ManageUsersAndGroups} – Group members can manage users and
permission groups. This is a privileged permission that allows users
to grant themselves or others access to any functionality in the
application. It should only be granted to trusted users.
\item \code{ManageAttributeSets} – Group members can manage attribute sets.
\item \code{ViewAuditData} – Group members can view audit data.
\item \code{AccessNotebooks} – Group members will have access to FinSpace
notebooks.
\item \code{GetTemporaryCredentials} – Group members can get temporary API
credentials.
}}

\item{clientToken}{A token that ensures idempotency. This token expires in 10 minutes.}
}
\description{
Creates a group of permissions for various actions that a user can perform in FinSpace.

See \url{https://paws-r.github.io/docs/finspacedata/create_permission_group.html} for full documentation.
}
\keyword{internal}
