% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fsx_operations.R
\name{fsx_describe_snapshots}
\alias{fsx_describe_snapshots}
\title{Returns the description of specific Amazon FSx for OpenZFS snapshots, if
a SnapshotIds value is provided}
\usage{
fsx_describe_snapshots(
  SnapshotIds = NULL,
  Filters = NULL,
  MaxResults = NULL,
  NextToken = NULL
)
}
\arguments{
\item{SnapshotIds}{The IDs of the snapshots that you want to retrieve. This parameter value
overrides any filters. If any IDs aren't found, a \code{SnapshotNotFound}
error occurs.}

\item{Filters}{The filters structure. The supported names are \code{file-system-id} or
\code{volume-id}.}

\item{MaxResults}{}

\item{NextToken}{}
}
\description{
Returns the description of specific Amazon FSx for OpenZFS snapshots, if a \code{SnapshotIds} value is provided. Otherwise, this operation returns all snapshots owned by your Amazon Web Services account in the Amazon Web Services Region of the endpoint that you're calling.

See \url{https://paws-r.github.io/docs/fsx/describe_snapshots.html} for full documentation.
}
\keyword{internal}
