% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_operations.R
\name{s3_put_bucket_metrics_configuration}
\alias{s3_put_bucket_metrics_configuration}
\title{Sets a metrics configuration (specified by the metrics configuration ID)
for the bucket}
\usage{
s3_put_bucket_metrics_configuration(
  Bucket,
  Id,
  MetricsConfiguration,
  ExpectedBucketOwner = NULL
)
}
\arguments{
\item{Bucket}{[required] The name of the bucket for which the metrics configuration is set.}

\item{Id}{[required] The ID used to identify the metrics configuration.}

\item{MetricsConfiguration}{[required] Specifies the metrics configuration.}

\item{ExpectedBucketOwner}{The account ID of the expected bucket owner. If the bucket is owned by a
different account, the request fails with the HTTP status code
\verb{403 Forbidden} (access denied).}
}
\description{
Sets a metrics configuration (specified by the metrics configuration ID) for the bucket. You can have up to 1,000 metrics configurations per bucket. If you're updating an existing metrics configuration, note that this is a full replacement of the existing metrics configuration. If you don't include the elements you want to keep, they are erased.

See \url{https://paws-r.github.io/docs/s3/put_bucket_metrics_configuration.html} for full documentation.
}
\keyword{internal}
