% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_operations.R
\name{s3_put_bucket_accelerate_configuration}
\alias{s3_put_bucket_accelerate_configuration}
\title{Sets the accelerate configuration of an existing bucket}
\usage{
s3_put_bucket_accelerate_configuration(
  Bucket,
  AccelerateConfiguration,
  ExpectedBucketOwner = NULL,
  ChecksumAlgorithm = NULL
)
}
\arguments{
\item{Bucket}{[required] The name of the bucket for which the accelerate configuration is set.}

\item{AccelerateConfiguration}{[required] Container for setting the transfer acceleration state.}

\item{ExpectedBucketOwner}{The account ID of the expected bucket owner. If the bucket is owned by a
different account, the request fails with the HTTP status code
\verb{403 Forbidden} (access denied).}

\item{ChecksumAlgorithm}{Indicates the algorithm used to create the checksum for the object when
using the SDK. This header will not provide any additional functionality
if not using the SDK. When sending this header, there must be a
corresponding \code{x-amz-checksum} or \code{x-amz-trailer} header sent.
Otherwise, Amazon S3 fails the request with the HTTP status code
\verb{400 Bad Request}. For more information, see \href{https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html}{Checking object integrity}
in the \emph{Amazon S3 User Guide}.

If you provide an individual checksum, Amazon S3 ignores any provided
\code{ChecksumAlgorithm} parameter.}
}
\description{
Sets the accelerate configuration of an existing bucket. Amazon S3 Transfer Acceleration is a bucket-level feature that enables you to perform faster data transfers to Amazon S3.

See \url{https://www.paws-r-sdk.com/docs/s3_put_bucket_accelerate_configuration/} for full documentation.
}
\keyword{internal}
