% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backup_operations.R
\name{backup_start_copy_job}
\alias{backup_start_copy_job}
\title{Starts a job to create a one-time copy of the specified resource}
\usage{
backup_start_copy_job(
  RecoveryPointArn,
  SourceBackupVaultName,
  DestinationBackupVaultArn,
  IamRoleArn,
  IdempotencyToken = NULL,
  Lifecycle = NULL
)
}
\arguments{
\item{RecoveryPointArn}{[required] An ARN that uniquely identifies a recovery point to use for the copy
job; for example,
arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45.}

\item{SourceBackupVaultName}{[required] The name of a logical source container where backups are stored. Backup
vaults are identified by names that are unique to the account used to
create them and the Amazon Web Services Region where they are created.}

\item{DestinationBackupVaultArn}{[required] An Amazon Resource Name (ARN) that uniquely identifies a destination
backup vault to copy to; for example,
\code{arn:aws:backup:us-east-1:123456789012:backup-vault:aBackupVault}.}

\item{IamRoleArn}{[required] Specifies the IAM role ARN used to copy the target recovery point; for
example, \verb{arn:aws:iam::123456789012:role/S3Access}.}

\item{IdempotencyToken}{A customer-chosen string that you can use to distinguish between
otherwise identical calls to \code{\link[=backup_start_copy_job]{start_copy_job}}.
Retrying a successful request with the same idempotency token results in
a success message with no action taken.}

\item{Lifecycle}{}
}
\description{
Starts a job to create a one-time copy of the specified resource.

See \url{https://www.paws-r-sdk.com/docs/backup_start_copy_job/} for full documentation.
}
\keyword{internal}
