% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paws.R
\name{appregistry}
\alias{appregistry}
\title{AWS Service Catalog App Registry}
\usage{
appregistry(
  config = list(),
  credentials = list(),
  endpoint = NULL,
  region = NULL
)
}
\arguments{
\item{config}{Optional configuration of credentials, endpoint, and/or region.
\itemize{
\item{\strong{credentials}: \itemize{
\item{\strong{creds}: \itemize{
\item{\strong{access_key_id}: AWS access key ID}
\item{\strong{secret_access_key}: AWS secret access key}
\item{\strong{session_token}: AWS temporary session token}
}}
\item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}: Set anonymous credentials.}
}}
\item{\strong{endpoint}: The complete URL to use for the constructed client.}
\item{\strong{region}: The AWS Region used in instantiating the client.}
\item{\strong{close_connection}: Immediately close all HTTP connections.}
\item{\strong{timeout}: The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
\item{\strong{s3_force_path_style}: Set this to \code{true} to force the request to use path-style addressing, i.e. \verb{http://s3.amazonaws.com/BUCKET/KEY}.}
\item{\strong{sts_regional_endpoint}: Set sts regional endpoint resolver to regional or legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}}
}}

\item{credentials}{Optional credentials shorthand for the config parameter
\itemize{
\item{\strong{creds}: \itemize{
\item{\strong{access_key_id}: AWS access key ID}
\item{\strong{secret_access_key}: AWS secret access key}
\item{\strong{session_token}: AWS temporary session token}
}}
\item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}: Set anonymous credentials.}
}}

\item{endpoint}{Optional shorthand for complete URL to use for the constructed client.}

\item{region}{Optional shorthand for AWS Region used in instantiating the client.}
}
\value{
A client for the service. You can call the service's operations using
syntax like \code{svc$operation(...)}, where \code{svc} is the name you've assigned
to the client. The available operations are listed in the
Operations section.
}
\description{
Amazon Web Services Service Catalog AppRegistry enables organizations to
understand the application context of their Amazon Web Services
resources. AppRegistry provides a repository of your applications, their
resources, and the application metadata that you use within your
enterprise.
}
\section{Service syntax}{


\if{html}{\out{<div class="sourceCode">}}\preformatted{svc <- appregistry(
  config = list(
    credentials = list(
      creds = list(
        access_key_id = "string",
        secret_access_key = "string",
        session_token = "string"
      ),
      profile = "string",
      anonymous = "logical"
    ),
    endpoint = "string",
    region = "string",
    close_connection = "logical",
    timeout = "numeric",
    s3_force_path_style = "logical",
    sts_regional_endpoint = "string"
  ),
  credentials = list(
    creds = list(
      access_key_id = "string",
      secret_access_key = "string",
      session_token = "string"
    ),
    profile = "string",
    anonymous = "logical"
  ),
  endpoint = "string",
  region = "string"
)
}\if{html}{\out{</div>}}
}

\section{Operations}{

\tabular{ll}{
\link[paws.management:appregistry_associate_attribute_group]{associate_attribute_group} \tab Associates an attribute group with an application to augment the application's metadata with the group's attributes\cr
\link[paws.management:appregistry_associate_resource]{associate_resource} \tab Associates a resource with an application\cr
\link[paws.management:appregistry_create_application]{create_application} \tab Creates a new application that is the top-level node in a hierarchy of related cloud resource abstractions\cr
\link[paws.management:appregistry_create_attribute_group]{create_attribute_group} \tab Creates a new attribute group as a container for user-defined attributes\cr
\link[paws.management:appregistry_delete_application]{delete_application} \tab Deletes an application that is specified either by its application ID, name, or ARN\cr
\link[paws.management:appregistry_delete_attribute_group]{delete_attribute_group} \tab Deletes an attribute group, specified either by its attribute group ID, name, or ARN\cr
\link[paws.management:appregistry_disassociate_attribute_group]{disassociate_attribute_group} \tab Disassociates an attribute group from an application to remove the extra attributes contained in the attribute group from the application's metadata\cr
\link[paws.management:appregistry_disassociate_resource]{disassociate_resource} \tab Disassociates a resource from application\cr
\link[paws.management:appregistry_get_application]{get_application} \tab Retrieves metadata information about one of your applications\cr
\link[paws.management:appregistry_get_associated_resource]{get_associated_resource} \tab Gets the resource associated with the application\cr
\link[paws.management:appregistry_get_attribute_group]{get_attribute_group} \tab Retrieves an attribute group by its ARN, ID, or name\cr
\link[paws.management:appregistry_get_configuration]{get_configuration} \tab Retrieves a TagKey configuration from an account\cr
\link[paws.management:appregistry_list_applications]{list_applications} \tab Retrieves a list of all of your applications\cr
\link[paws.management:appregistry_list_associated_attribute_groups]{list_associated_attribute_groups} \tab Lists all attribute groups that are associated with specified application\cr
\link[paws.management:appregistry_list_associated_resources]{list_associated_resources} \tab Lists all of the resources that are associated with the specified application\cr
\link[paws.management:appregistry_list_attribute_groups]{list_attribute_groups} \tab Lists all attribute groups which you have access to\cr
\link[paws.management:appregistry_list_attribute_groups_for_application]{list_attribute_groups_for_application} \tab Lists the details of all attribute groups associated with a specific application\cr
\link[paws.management:appregistry_list_tags_for_resource]{list_tags_for_resource} \tab Lists all of the tags on the resource\cr
\link[paws.management:appregistry_put_configuration]{put_configuration} \tab Associates a TagKey configuration to an account\cr
\link[paws.management:appregistry_sync_resource]{sync_resource} \tab Syncs the resource with current AppRegistry records\cr
\link[paws.management:appregistry_tag_resource]{tag_resource} \tab Assigns one or more tags (key-value pairs) to the specified resource\cr
\link[paws.management:appregistry_untag_resource]{untag_resource} \tab Removes tags from a resource\cr
\link[paws.management:appregistry_update_application]{update_application} \tab Updates an existing application with new attributes\cr
\link[paws.management:appregistry_update_attribute_group]{update_attribute_group} \tab Updates an existing attribute group with new details
}
}

\examples{
\dontrun{
svc <- appregistry()
svc$associate_attribute_group(
  Foo = 123
)
}

}
