% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ncvar_2d.r
\name{ncvar}
\alias{demo.ncvar_get_dmat}
\alias{demo.ncvar_get_gbd}
\alias{demo.ncvar_put_dmat}
\alias{demo.ncvar_put_gbd}
\alias{ncvar}
\title{Read and Write Parallel NetCDF4 Files in GBD and ddmatrix Format}
\usage{
demo.ncvar_put_dmat(nc, varid, vals, verbose = FALSE,
  comm = .pbd_env$SPMD.CT$comm)

demo.ncvar_put_gbd(nc, varid, vals, verbose = FALSE,
  comm = .pbd_env$SPMD.CT$comm, gbd.major = .pbd_env$gbd.major)

demo.ncvar_get_dmat(nc, varid, verbose = FALSE, signedbyte = TRUE,
  collapse_degen = TRUE, bldim = .pbd_env$bldim, ICTXT = .pbd_env$ictxt,
  comm = .pbd_env$SPMD.CT$comm)

demo.ncvar_get_gbd(nc, varid, verbose = FALSE, signedbyte = TRUE,
  collapse_degen = TRUE, comm = .pbd_env$SPMD.CT$comm,
  gbd.major = .pbd_env$gbd.major)
}
\arguments{
\item{nc}{an object of class \code{ncdf4} (as returned by either function
\code{nc_open_par} or function \code{nc_create_par}), indicating what file
to read from.}

\item{varid}{See \code{ncvar_get} for details.}

\item{vals}{See \code{ncvar_put} for details.}

\item{verbose}{See \code{ncvar_get} for details.}

\item{comm}{a communicator number.}

\item{gbd.major}{a GBD major, either 1 for row-major or 2 for column-major.}

\item{signedbyte}{See \code{ncvar_get} for details.}

\item{collapse_degen}{See \code{ncvar_get} for details.}

\item{bldim}{the blocking dimension for block-cyclically distributing the
matrix across the process grid.}

\item{ICTXT}{BLACS context number for return.}
}
\value{
\code{demo.ncvar_get_dmat} returns a \code{ddmatrix}, and
\code{demo.ncvar_get_gbd} returns a GBD matrix in either row- or column
major specified by \code{gbd.major}.
}
\description{
These functions write and read NetCDF4 files in GBD and ddmatrix format.
}
\details{
\code{demo.ncvar_get_*} are similar to \code{ncvar_get} of \pkg{pbdNCDF4},
but focus on 2D arrays and return a ddmatrix or GBD matrix.

\code{demo.ncvar_put_*} are also similar to \code{ncvar_put} of
\pkg{pbdNCDF4}, but only dump 2D arrays.
}
\examples{
\dontrun{
### Under command mode, run the demo with 4 processors by
### (Use Rscript.exe for windows system)
mpiexec -np 4 Rscript -e "demo(nc4_serial,'pbdDEMO',ask=F,echo=F)"
mpiexec -np 4 Rscript -e "demo(nc4_parallel,'pbdDEMO',ask=F,echo=F)"
mpiexec -np 4 Rscript -e "demo(nc4_dmat,'pbdDEMO',ask=F,echo=F)"
mpiexec -np 4 Rscript -e "demo(nc4_gbdc,'pbdDEMO',ask=F,echo=F)"
}

}
\keyword{programming}

