% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simDRM.R
\name{simDRM}
\alias{simDRM}
\title{simulate data according to Rasch model}
\usage{
simDRM(itempar, persons = 500, seed = NULL)
}
\arguments{
\item{itempar}{a vector with item difficulty parameters}

\item{persons}{number of persons for the generated data set}

\item{seed}{a seed for the random number generated can optionally be set}
}
\value{
\item{datmat}{simulated data set} \item{true_itempar}{the fixed item
parameters according to the input} \item{true_perspar}{the fixed person
parameters}
}
\description{
With this function data sets according to the dichotomous 
Rasch model (DRM) are simulated
}
\details{
Data are generated with category values 0 and 1.

Person parameters are generated by a standard normal distribution.
}
\examples{

#set item parameters
item_p <- c(-1.5,-0.3,0,0.3,1.5)

#number of persons
pn <- 500

#simulate data set
simdatD <- simDRM(item_p, pn)

}
\references{
Fischer, G. H. (1974). Einfuehrung in die Theorie
psychologischer Tests [Introduction to test theory]. Bern: Huber.
}
\seealso{
\code{\link{simMPRM}}\code{\link{simCRSM}}
}
\author{
Christine Hohensinn
}
