% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCDFunctions.r
\name{IncMatPEtri}
\alias{IncMatPEtri}
\title{Incidence matrix for Proportional Edge Proximity Catch Digraphs (PE-PCDs) - one triangle case}
\usage{
IncMatPEtri(dat, tri, r, M = c(1, 1, 1))
}
\arguments{
\item{dat}{A set of 2D points which constitute the vertices of PE-PCD.}

\item{tri}{Three 2D points, stacked row-wise, each row representing a vertex of the triangle.}

\item{r}{A positive real number which serves as the expansion parameter in PE proximity region;
must be \eqn{\ge 1}.}

\item{M}{A 2D point in Cartesian coordinates or a 3D point in barycentric coordinates
which serves as a center in the interior of the triangle \code{tri} or the circumcenter of \code{tri};
default is \eqn{M=(1,1,1)} i.e. the center of mass of \code{tri}.}
}
\value{
Incidence matrix for the PE-PCD with vertices being 2D data set, \code{dat},
in the triangle \code{tri} with vertex regions based on center \code{M}
}
\description{
Returns the incidence matrix for the PE-PCD whose vertices are the given 2D numerical data set, \code{dat},
in the triangle \eqn{tri=T(v=1,v=2,v=3)}.

PE proximity regions are constructed with respect to triangle \code{tri}
with expansion parameter \eqn{r \ge 1} and vertex regions are based on the center \eqn{M=(m_1,m_2)} in Cartesian coordinates
or \eqn{M=(\alpha,\beta,\gamma)} in barycentric coordinates in the interior of the triangle \code{tri};
default is \eqn{M=(1,1,1)} i.e. the center of mass of \code{tri}.
Loops are allowed, so the diagonal entries are all equal to 1.

See also (\insertCite{ceyhan:Phd-thesis,ceyhan:arc-density-PE,ceyhan:dom-num-NPE-Spat2011;textual}{pcds}).
}
\examples{
A<-c(1,1); B<-c(2,0); C<-c(1.5,2);
Tr<-rbind(A,B,C);
n<-10

set.seed(1)
dat<-runif.tri(n,Tr)$g

M<-as.numeric(runif.tri(1,Tr)$g)  #try also M<-c(1.6,1.0)

IM<-IncMatPEtri(dat,Tr,r=1.25,M)

IM
dom.greedy(IM)
dom.exact(IM)
IndUBdom(IM,2)
IndUBdom(IM,3)

IncMatPEtri(dat,Tr,r=1.5,M)
IncMatPEtri(dat,Tr,r=2,M)

r<-2
IncMatPEtri(dat,Tr,r,M)

dat.fr<-data.frame(a=dat)
IncMatPEtri(dat.fr,Tr,r,M)

dat.fr<-data.frame(a=Tr)
IncMatPEtri(dat,dat.fr,r,M)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{IncMatPEMT}}, \code{\link{IncMatCStri}}, and  \code{\link{IncMatAStri}}
}
