% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCDFunctions.r
\name{plotCSregsTri}
\alias{plotCSregsTri}
\title{The plot of the Central Similarity (CS) Proximity Regions for a 2D data set - one triangle case

Plots the points in and outside of the triangle \code{tri} and also the CS proximity regions which are also
triangular for points inside the triangle \code{tri} with edge regions are based on the center of mass CM.}
\usage{
plotCSregsTri(
  Xp,
  tri,
  t,
  M = c(1, 1, 1),
  asp = NA,
  main = "",
  xlab = "",
  ylab = "",
  xlim = NULL,
  ylim = NULL,
  ...
)
}
\arguments{
\item{Xp}{A set of 2D points for which CS proximity regions are constructed.}

\item{tri}{Three 2D points, stacked row-wise, each row representing a vertex of the triangle.}

\item{t}{A positive real number which serves as the expansion parameter in CS proximity region.}

\item{M}{A 2D point in Cartesian coordinates or a 3D point in barycentric coordinates
which serves as a center in the interior of the triangle \code{tri};
default is \eqn{M=(1,1,1)} i.e. the center of mass of \code{tri}.}

\item{asp}{A numeric value, giving the aspect ratio y/x (default is \code{NA}),
see the official help for \code{asp} by typing "? asp".}

\item{main}{An overall title for the plot (default="").}

\item{xlab, ylab}{Titles for the x and y axes, respectively (default="" for both).}

\item{xlim, ylim}{Numeric vectors of length 2, giving the x- and y-coordinate ranges
(default=\code{NULL} for both).}

\item{\dots}{Additional \code{plot} parameters.}
}
\value{
Plot of the CS proximity regions for points inside the triangle \code{tri}
(and just the points outside \code{tri})
}
\description{
Plots the points in and outside of the triangle \code{tri} and also the CS proximity regions
for points in data set \code{Xp}.

CS proximity regions are defined with respect to the triangle \code{tri}
with expansion parameter \eqn{t>0}, so CS proximity regions are defined only for points inside the
triangle \code{tri}.

Edge regions are based on center \eqn{M=(m_1,m_2)} in Cartesian coordinates
or \eqn{M=(\alpha,\beta,\gamma)} in barycentric coordinates in the interior of the triangle \code{tri};
default is \eqn{M=(1,1,1)} i.e. the center of mass of \code{tri}.

See also (\insertCite{ceyhan:Phd-thesis,ceyhan:arc-density-CS,ceyhan:test2014;textual}{pcds}).
}
\examples{
A<-c(1,1); B<-c(2,0); C<-c(1.5,2);
Tr<-rbind(A,B,C);
n<-10

set.seed(1)
dat<-runif.tri(n,Tr)$g
dat<-matrix(dat,ncol=2)

M<-as.numeric(runif.tri(1,Tr)$g)  #try also M<-c(1.6,1.0)

t<-.5  #try also t<-2

dat<-matrix(dat,ncol=2)
Xlim<-range(Tr[,1],dat[,1])
Ylim<-range(Tr[,2],dat[,2])
xd<-Xlim[2]-Xlim[1]
yd<-Ylim[2]-Ylim[1]

plotCSregsTri(dat[4,],Tr,t,M)
plotCSregsTri(dat,Tr,t,M)

if (dimension(M)==3) {M<-bary2cart(M,Tr)}
#need to run this when M is given in barycentric coordinates
plotCSregsTri(dat,Tr,t,M,main="CS Proximity Regions with t=.5",
xlab="",ylab="",xlim=Xlim+xd*c(-.05,.05),ylim=Ylim+yd*c(-.05,.05))
L<-rbind(M,M,M); R<-Tr
segments(L[,1], L[,2], R[,1], R[,2], lty=2)

txt<-rbind(Tr,M)
xc<-txt[,1]+c(-.02,.03,.03,.03)
yc<-txt[,2]+c(.02,.02,.02,.07)
txt.str<-c("A","B","C","M")
text(xc,yc,txt.str)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{plotCSregsMT}}, \code{\link{plotASregsTri}} and \code{\link{plotPEregsTri}},
}
