% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ArcSliceFunctions.R
\name{funsTbMid2CC}
\alias{funsTbMid2CC}
\alias{lD1CCinTb}
\alias{lD2CCinTb}
\title{Two functions \code{lD1CCinTb} and \code{lD2CCinTb} which are of class \code{"TriLines"} ---
The lines joining the midpoints of edges to the circumcenter (\eqn{CC}) in the standard basic triangle.}
\usage{
lD1CCinTb(x, c1, c2)

lD2CCinTb(x, c1, c2)
}
\arguments{
\item{x}{A single scalar or a \code{vector} of scalars.}

\item{c1, c2}{Positive real numbers which constitute the vertex of the standard basic triangle
adjacent to the shorter edges; \eqn{c_1} must be in \eqn{[0,1/2]}, \eqn{c_2>0} and \eqn{(1-c_1)^2+c_2^2 \le 1}.}
}
\value{
A \code{list} with the elements
\item{txt1}{Longer description of the line.}
\item{txt2}{Shorter description of the line (to be inserted over the line in the plot).}
\item{mtitle}{The \code{"main"} title for the plot of the line.}
\item{cent}{The center chosen inside the standard equilateral triangle.}
\item{cent.name}{The name of the center inside the standard basic triangle.
It is \code{"CC"} for these two functions.}
\item{tri}{The triangle (it is the standard basic triangle for this function).}
\item{x}{The input vector, can be a scalar or a \code{vector} of scalars,
which constitute the \eqn{x}-coordinates of the point(s) of interest on the line.}
\item{y}{The output vector, will be a scalar if \code{x} is a scalar or a \code{vector} of scalars if \code{x} is a \code{vector} of scalar,
constitutes the \eqn{y}-coordinates of the point(s) of interest on the line.}
\item{slope}{Slope of the line.}
\item{intercept}{Intercept of the line.}
\item{equation}{Equation of the line.}
}
\description{
Returns the \code{equation, slope, intercept}, and \eqn{y}-coordinates of the lines
joining \eqn{D_1} and \eqn{CC} and also \eqn{D_2} and \eqn{CC}, in the standard basic triangle \eqn{T_b=T(A=(0,0),B=(1,0),C=(c_1,c_2))}
where \eqn{c_1} is in \eqn{[0,1/2]}, \eqn{c_2>0} and \eqn{(1-c_1)^2+c_2^2 \le 1}
and \eqn{D_1=(B+C)/2} and \eqn{D_2=(A+C)/2} are the midpoints of edges \eqn{BC} and \eqn{AC}.

Any given triangle can be mapped to the standard basic triangle by a combination of rigid body motions
(i.e., translation, rotation and reflection) and scaling, preserving uniformity of the points in the
original triangle. Hence standard basic triangle is useful for simulation
studies under the uniformity hypothesis.
\eqn{x}-coordinates are provided in \code{vector} \code{x}.
}
\examples{
\dontrun{
#Examples for lD1CCinTb
c1<-.4; c2<-.6;
A<-c(0,0); B<-c(1,0); C<-c(c1,c2);  #the vertices of the standard basic triangle Tb

Tb<-rbind(A,B,C)

xfence<-abs(A[1]-B[1])*.25 #how far to go at the lower and upper ends in the x-coordinate
x<-seq(min(A[1],B[1])-xfence,max(A[1],B[1])+xfence,by=.1)  #try also by=.01

lnD1CC<-lD1CCinTb(x,c1,c2)
lnD1CC
summary(lnD1CC)
plot(lnD1CC)

CC<-circ.cent.bas.tri(c1,c2)  #the circumcenter
CC
D1<-(B+C)/2; D2<-(A+C)/2; D3<-(A+B)/2; #midpoints of the edges
Ds<-rbind(D1,D2,D3)

x1<-seq(0,1,by=.1)  #try also by=.01
y1<-lD1CCinTb(x1,c1,c2)$y

Xlim<-range(Tb[,1],x1)
Ylim<-range(Tb[,2],y1)
xd<-Xlim[2]-Xlim[1]
yd<-Ylim[2]-Ylim[1]

plot(A,pch=".",asp=1,xlab="",ylab="",axes=TRUE,xlim=Xlim+xd*c(-.05,.05),ylim=Ylim+yd*c(-.05,.05))
polygon(Tb)
L<-matrix(rep(CC,3),ncol=2,byrow=TRUE); R<-Ds
segments(L[,1], L[,2], R[,1], R[,2], lty=2)

txt<-rbind(Tb,CC,D1,D2,D3)
xc<-txt[,1]+c(-.03,.04,.03,.02,.09,-.08,0)
yc<-txt[,2]+c(.02,.02,.04,.08,.03,.03,-.05)
txt.str<-c("A","B","C","CC","D1","D2","D3")
text(xc,yc,txt.str)

lines(x1,y1,type="l",lty=2)
text(.8,.5,"lD1CCinTb")

c1<-.4; c2<-.6;
x1<-seq(0,1,by=.1)  #try also by=.01
lD1CCinTb(x1,c1,c2)
}

\dontrun{
#Examples for lD2CCinTb
c1<-.4; c2<-.6;
A<-c(0,0); B<-c(1,0); C<-c(c1,c2);  #the vertices of the standard basic triangle Tb

Tb<-rbind(A,B,C)

xfence<-abs(A[1]-B[1])*.25 #how far to go at the lower and upper ends in the x-coordinate
x<-seq(min(A[1],B[1])-xfence,max(A[1],B[1])+xfence,by=.1)  #try also by=.01

lnD2CC<-lD2CCinTb(x,c1,c2)
lnD2CC
summary(lnD2CC)
plot(lnD2CC)

CC<-circ.cent.bas.tri(c1,c2)  #the circumcenter
CC
D1<-(B+C)/2; D2<-(A+C)/2; D3<-(A+B)/2; #midpoints of the edges
Ds<-rbind(D1,D2,D3)

x2<-seq(0,1,by=.1)  #try also by=.01
y2<-lD2CCinTb(x2,c1,c2)$y

Xlim<-range(Tb[,1],x1)
Ylim<-range(Tb[,2],y2)
xd<-Xlim[2]-Xlim[1]
yd<-Ylim[2]-Ylim[1]

plot(A,pch=".",asp=1,xlab="",ylab="",axes=TRUE,xlim=Xlim+xd*c(-.05,.05),ylim=Ylim+yd*c(-.05,.05))
polygon(Tb)
L<-matrix(rep(CC,3),ncol=2,byrow=TRUE); R<-Ds
segments(L[,1], L[,2], R[,1], R[,2], lty=2)

txt<-rbind(Tb,CC,D1,D2,D3)
xc<-txt[,1]+c(-.03,.04,.03,.02,.09,-.08,0)
yc<-txt[,2]+c(.02,.02,.04,.08,.03,.03,-.05)
txt.str<-c("A","B","C","CC","D1","D2","D3")
text(xc,yc,txt.str)

lines(x2,y2,type="l",lty=2)
text(0,.5,"lD2CCinTb")
}

}
\seealso{
\code{\link{lA_CM.Te}}, \code{\link{lB_CM.Te}}, \code{\link{lA_M.Te}}, \code{\link{lB_M.Te}},
and \code{\link{lC_M.Te}}
}
\author{
Elvan Ceyhan
}
