#' pcev: A package for computing principal components of explained variance.
#'
#' PCEV is a statistical tool for the analysis of a mutivariate response vector.
#' It is a dimension-reduction technique, similar to Principal Components
#' Analysis (PCA), which seeks the maximize the proportion of variance (in the
#' response vector) being explained by a set of covariates.
#'
#' @section pcev functions:
#' \code{\link{estimatePcev}}
#' \code{\link{computePCEV}}
#' \code{\link{PcevObj}}
#' \code{\link{permutePval}}
#' \code{\link{wilksPval}}
#' \code{\link{roysPval}}
#'
#' @docType package
#' @name pcev
NULL
