% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uptake.R
\name{uptake_pct_godutch}
\alias{uptake_pct_godutch}
\title{Calculate cycling uptake for UK 'Go Dutch' scenario}
\usage{
uptake_pct_godutch(
  distance,
  gradient,
  alpha = -3.959 + 2.523,
  d1 = -0.5963 - 0.07626,
  d2 = 1.866,
  d3 = 0.00805,
  h1 = -0.271,
  i1 = 0.009394,
  i2 = -0.05135
)
}
\arguments{
\item{distance}{Vector distance numeric values of routes.}

\item{gradient}{Vector gradient numeric values of routes.}

\item{alpha}{The intercept}

\item{d1}{Distance term 1}

\item{d2}{Distance term 2}

\item{d3}{Distance term 3}

\item{h1}{Hilliness term 1}

\item{i1}{Distance-hilliness interaction term 1}

\item{i2}{Distance-hilliness interaction term 2}
}
\description{
This function implements the uptake model described in the original
Propensity to Cycle Tool paper (Lovelace et al. 2017):
https://doi.org/10.5198/jtlu.2016.862
}
\details{
See \code{\link[=uptake_pct_govtarget]{uptake_pct_govtarget()}}.
}
\examples{
# https://www.jtlu.org/index.php/jtlu/article/download/862/1381/4359
# Equation 1B:
distance = 15
gradient = 2
logit = -3.959 + 2.523 +
  ((-0.5963 - 0.07626) * distance) +
  (1.866 * sqrt(distance)) +
  (0.008050 * distance^2) +
  (-0.2710 * gradient) +
  (0.009394 * distance*gradient) +
  (-0.05135 * sqrt(distance) *gradient)
logit
# Result: -3.144098

pcycle = exp(logit) / (1 + exp(logit))
# Result: 0.04132445
boot::inv.logit(logit)
uptake_pct_godutch(distance, gradient, alpha = -3.959 + 2.523, d1 = -0.5963 - 0.07626,
 d2 = 1.866, d3 = 0.008050, h1 = -0.2710, i1 = 0.009394, i2 = -0.05135
)
# these are the default values
uptake_pct_godutch(distance, gradient)
l = routes_fast_leeds
pcycle_scenario = uptake_pct_godutch(l$length, l$av_incline)
plot(l$length, pcycle_scenario)
}
