% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diff_analyse.R
\name{diff_da}
\alias{diff_da}
\title{Difference analysis}
\usage{
diff_da(
  otutab,
  group_df,
  ctrl = NULL,
  method = "deseq2",
  log = TRUE,
  add_mini = NULL,
  ...
)
}
\arguments{
\item{otutab}{otutab}

\item{group_df}{a dataframe with rowname same to dist and one group column}

\item{ctrl}{the control group, one level of groups}

\item{method}{one of "deseq2","edger","limma","t.test","wilcox.test"}

\item{log}{do log transfer for limma?}

\item{add_mini}{add_mini when calculate the logFC. e.g (10+0.1)/(0+0.1), default \code{0.5*min(abundance)}}

\item{...}{other parameters}
}
\value{
a dataframe
}
\description{
Difference analysis
}
\examples{
\donttest{
if (requireNamespace("limma")) {
  data(otutab, package = "pcutils")
  diff_da(otutab, metadata["Group"], method = "limma") -> res
  volcano_p(res)
  volcano_p(res, mode = 2)
}
}
}
