% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotEICFit.R
\name{plotEICFit}
\alias{plotEICFit}
\title{Plot samples raw data and detected feature for a single ROI}
\usage{
plotEICFit(ROIDataPointSampleList, curveFitSampleList = NULL, rtMin = NULL,
  rtMax = NULL, sampling = 250, sampleColour = NULL, verbose = TRUE)
}
\arguments{
\item{ROIDataPointSampleList}{(list) list of \code{data.frame} of raw data points for each sample (retention time "rt", mass "mz" and intensity "int" (as column) of each raw data points (as row)).}

\item{curveFitSampleList}{(list) NULL or a list of \code{peakPantheR_curveFit} (or NA) for each sample}

\item{rtMin}{(float) NULL or vector of detected peak minimum retention time (in sec)}

\item{rtMax}{(float) NULL or vector ofdetected peak maximum retention time (in sec)}

\item{sampling}{(int) Number of points to employ when plotting fittedCurve}

\item{sampleColour}{(str) NULL or vector colour for each sample (same length as \code{ROIDataPointSampleList}, \code{rtMin}, \code{rtMax})}

\item{verbose}{(bool) if TRUE message when NA scans are removed}
}
\value{
Grob (ggplot object)
}
\description{
plot a ROI across multiple samples (x axis is RT, y axis is intensity). If curveFit is provided, the fitted curve for each sample is added.
}
