% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotPeakwidth.R
\name{plotPeakwidth}
\alias{plotPeakwidth}
\title{Plot peak value and peakwidth by acquisition time or in input order}
\usage{
plotPeakwidth(apexValue, widthMin = NULL, widthMax = NULL,
  acquTime = NULL, varName = "variable", sampleColour = NULL,
  rotateAxis = FALSE, verbose = TRUE)
}
\arguments{
\item{apexValue}{(float) vector of apex value}

\item{widthMin}{(float) vector of detected peak minimum peakwidth value or NULL (if NULL no peakwidth)}

\item{widthMax}{(float) vector of detected peak maximum peakwidth value or NULL (uf NULL no peakwidth)}

\item{acquTime}{(POSIXct) vector of sample acquisition time as POSIXct or NULL (if NULL points are plotted in the order values are passed as input with the first on top or left)}

\item{varName}{(str) Name of the variable to plot}

\item{sampleColour}{(str) NULL or vector colour for each sample (same length as \code{apexValue}, \code{widthMin}, \code{widthMax}, \code{acquTime})}

\item{rotateAxis}{(bool) if TRUE x and y axis are reversed}

\item{verbose}{(bool) if TRUE message when NA scans are removed}
}
\value{
Grob (ggplot object)
}
\description{
For a single ROI, plot the peak value and peakwidth (RT, m/z, ...) of detected peaks across multiple samples, by acquisition time or in input order. If \code{rotateAxis=FALSE} x is run order / plot order, y is the \code{apexValue} / \code{widthMin} / \code{widthMax}, if \code{rotateAxis=TRUE} x is the measurement values and y the run order.
}
