% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/marker_accessors.R
\name{marker_getset}
\alias{marker_getset}
\alias{genotype}
\alias{genotype.marker}
\alias{genotype.ped}
\alias{genotype<-}
\alias{genotype<-.marker}
\alias{genotype<-.ped}
\alias{mutmod}
\alias{mutmod.marker}
\alias{mutmod.ped}
\alias{mutmod<-}
\alias{mutmod<-.marker}
\alias{mutmod<-.ped}
\alias{alleles}
\alias{alleles.marker}
\alias{alleles.ped}
\alias{afreq}
\alias{afreq.marker}
\alias{afreq.ped}
\alias{afreq<-}
\alias{afreq<-.marker}
\alias{afreq<-.ped}
\alias{name}
\alias{name.marker}
\alias{name.ped}
\alias{chrom}
\alias{chrom.marker}
\alias{chrom.ped}
\alias{posMb}
\alias{posMb.marker}
\alias{posMb.ped}
\alias{posCm}
\alias{posCm.marker}
\alias{posCm.ped}
\alias{name<-}
\alias{name<-.marker}
\alias{name<-.ped}
\alias{chrom<-}
\alias{chrom<-.marker}
\alias{chrom<-.ped}
\alias{posCm<-}
\alias{posCm<-.marker}
\alias{posCm<-.ped}
\alias{posMb<-}
\alias{posMb<-.marker}
\alias{posMb<-.ped}
\title{Get/set marker attributes}
\usage{
genotype(x, ...)

\method{genotype}{marker}(x, id, ...)

\method{genotype}{ped}(x, markers = NULL, id, ...)

genotype(x, ...) <- value

\method{genotype}{marker}(x, id, ...) <- value

\method{genotype}{ped}(x, marker, id, ...) <- value

mutmod(x, ...)

\method{mutmod}{marker}(x, ...)

\method{mutmod}{ped}(x, marker, ...)

mutmod(x, ...) <- value

\method{mutmod}{marker}(x, ...) <- value

\method{mutmod}{ped}(x, marker, ...) <- value

alleles(x, ...)

\method{alleles}{marker}(x, ...)

\method{alleles}{ped}(x, marker, ...)

afreq(x, ...)

\method{afreq}{marker}(x, ...)

\method{afreq}{ped}(x, marker, ...)

afreq(x, ...) <- value

\method{afreq}{marker}(x, ...) <- value

\method{afreq}{ped}(x, marker, ...) <- value

name(x, ...)

\method{name}{marker}(x, ...)

\method{name}{ped}(x, markers, ...)

chrom(x, ...)

\method{chrom}{marker}(x, ...)

\method{chrom}{ped}(x, markers, ...)

posMb(x, ...)

\method{posMb}{marker}(x, ...)

\method{posMb}{ped}(x, markers, ...)

posCm(x, ...)

\method{posCm}{marker}(x, ...)

\method{posCm}{ped}(x, markers, ...)

name(x, ...) <- value

\method{name}{marker}(x, ...) <- value

\method{name}{ped}(x, markers, ...) <- value

chrom(x, ...) <- value

\method{chrom}{marker}(x, ...) <- value

\method{chrom}{ped}(x, markers, ...) <- value

posCm(x, ...) <- value

\method{posCm}{marker}(x, ...) <- value

\method{posCm}{ped}(x, markers, ...) <- value

posMb(x, ...) <- value

\method{posMb}{marker}(x, ...) <- value

\method{posMb}{ped}(x, markers, ...) <- value
}
\arguments{
\item{x}{A \link{ped} object or a \link{marker} object}

\item{...}{Further arguments, not used in most of these functions}

\item{id}{The ID label of a single pedigree member}

\item{value}{Replacement value(s)}

\item{marker, markers}{The index or name of a marker (or a vector indicating
several markers) attached to \code{ped}. Used if \code{x} is a \code{ped} object}
}
\value{
The getters return the value of the query. The setters perform
in-place modification of the input.
}
\description{
These functions can be used to manipulate a single attribute of one or
several markers. Each getter/setter can be used in two ways: Either directly
on a \code{marker} object, or on a \code{ped} object which has markers attached to it.
}
\examples{
x = nuclearPed(1)
x = setMarkers(x, locusAttributes = list(name = "M", alleles = 1:2))

# Set genotype
genotype(x, marker = "M", id = 1) = 1:2
genotype(x, marker = "M", id = 3) = 1

# Genotypes are returned as a vector of length 2
genotype(x, marker = "M", id = 1)

# Change allele freqs
afreq(x, "M") = c(`1` = 0.1, `2` = 0.9)

# Check the new frequencies
afreq(x, "M")

}
