% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/marker_genomatrix.R
\name{getGenotypes}
\alias{getGenotypes}
\title{Genotype matrix}
\usage{
getGenotypes(x, ids = NULL, markers = NULL, sep = "/", missing = "-")
}
\arguments{
\item{x}{A \code{ped} object or a list of such}

\item{ids}{A vector of ID labels. If NULL (default) all individuals are
included.}

\item{markers}{A vector of indices or names of markers attaches to \code{x}. If
NULL (default) all markers are included.}

\item{sep}{A single string to be used as allele separator in marker
genotypes.}

\item{missing}{A single string to be used for missing alleles.}
}
\value{
\code{getGenotypes()} returns a character matrix with \code{length(ids)} rows
and \code{length(markers)} columns.
}
\description{
Extract the genotypes of multiple individuals/markers in form of a matrix.
}
\examples{
x = nuclearPed(1)
m1 = marker(x, `2` = "1/2", alleles = 1:2, name = "m1")
m2 = marker(x, `3` = "2/2", alleles = 1:2, name = "m2")
x = setMarkers(x, list(m1, m2))

getGenotypes(x)


### A list of pedigrees

s = transferMarkers(x, singleton("s"))
peds = list(x, s)

getGenotypes(peds)

}
\seealso{
\code{\link[=getAlleles]{getAlleles()}}
}
