% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/I2.R
\name{I2}
\alias{I2}
\title{Compute I2}
\usage{
I2(x, ...)
}
\arguments{
\item{x}{An object for which a method exists.}

\item{...}{Arguments passed to other functions.}
}
\value{
Numeric matrix, with rows corresponding to I2 (total heterogeneity),
and optionally I2_w and I2_b (within- and between-cluster heterogeneity).
}
\description{
I2 represents the amount of heterogeneity relative to the total
amount of variance in the observed effect sizes (Higgins & Thompson, 2002).
For three-level meta-analyses, it is additionally broken down into I2_w
(amount of within-cluster heterogeneity) and I2_b (amount of between-cluster
heterogeneity).
}
\examples{
I2(matrix(1:20, ncol = 1))
}
