\name{2.3.2.conditioning.pems.data}
\alias{2.3.2.conditioning.pems.data}
\alias{conditioning.pems.data}
\alias{cutBy}
\alias{cutByRow}


\title{
  Data conditioning for pems data
}

\description{
  Various functions for the conditioning of \code{pems} objects.
}

\usage{

cutBy(ref = NULL, ..., data = NULL, cut.method = NULL, 
        labels = NULL, fun.name = "cutBy")

cutByRow(ref = NULL, n = 4, rows = NULL, ..., data = NULL,  
        fun.name = "cutByRow")

}




\arguments{

  \item{ref}{
  (Data series typically vector) The reference data series to consider when making a vector of subset 
  markers/indices. See Details.
} 

  \item{\dots}{
  (Optional) Other arguments, currently passed on to \code{pems.utils} management functions.
}

  \item{data}{
  (Optional \code{data.frame} or \code{pems} object) The data source if \code{ref} is supplied in either 
  a \code{data.frame} or \code{pems} object.
} 

  \item{cut.method}{
  (Optional function) For \code{cutBy} only, the method to use when cutting \code{ref}. If not supplied, 
  \code{cutByRow} used by default. 
} 

  \item{labels}{
  (Character vector) For \code{cutBy} only, a vector of names to be assigned to the cut regions.
} 

  \item{fun.name}{
  (function managment argument) \code{fun.name} is the name of the parent function, to be used in 
  error messaging. 
}
 
  \item{n, rows}{
  (numerics) \code{n} sets the number of equal intervals to attempt to cut the data into. \code{rows} 
  sets the exact rows at which to cut the data at. If \code{n} is applied and the length of \code{ref} 
  is not exactly divisible by \code{n} a best attempt is made. If both \code{n} and \code{rows} are 
  set, \code{rows} is applied. 
}

   
}


\details{

  \code{cutBy} and \code{cutBy...} functions generate a vector of subset markers or indices based 
  of the type of cut applied and the range/size of the reference, \code{ref}. See Value regarding 
  outputs.

  \code{cutBy} is a wrapper for other \code{cutBy...} functions. It provides additional options for 
  \code{cut.marker} naming.  
   
  \code{cutByRow} assigns cut regions based in row number.   
 
}


\value{

  By default results are returned as \code{\link{pems.element}}s. 

  The \code{cut.marker} vector generated by \code{cutBY} and \code{cutBy...} functions 
  can then be used to condition and subsample data in \code{pems} objects.

}

\references{
  References in preparation.
}
\author{
  Karl Ropkins
}
\note{
  Various other \code{cutBy...} options can be very simply encoded. 
}

\section{Warning }{
  Currently, no warnings.  
}

\seealso{
 
  \code{\link{cut}}, etc. in the main R package.
}
\examples{

###########
##example 1 
###########

#basic usage

#working with a temporary pems

temp <- pems.1

#cut into equal subsets

temp$ref <- cutBy(velocity, n= 5, data=temp)

pemsPlot(local.time, velocity, cond=ref, data=temp, 
             type="l", layout=c(1,5))

#cut at three points

temp <- pems.1
temp$ref <- cutBy(velocity, rows=c(180,410,700), data=temp)

pemsPlot(local.time, velocity, cond=ref, data=temp, 
             type="l", layout=c(1,5))

}

\keyword{ methods }
