% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iceberg.R
\name{plugin_lasso_int}
\alias{plugin_lasso_int}
\title{Iceberg Lasso Implementation (in development)}
\usage{
plugin_lasso_int(
  y,
  x,
  tol = 1e-08,
  glmnettol = 1e-12,
  penweights = NULL,
  colcheck = FALSE,
  K = 50,
  verbose = FALSE,
  lambda = NULL,
  phipost = FALSE
)
}
\arguments{
\item{y}{Dependent variable (a vector).}

\item{x}{Regressor matrix.}

\item{tol}{Tolerance parameter for convergence of the IRLS algorithm.}

\item{glmnettol}{Tolerance parameter to be passed on to \code{glmnet::glmnet}.}

\item{penweights}{Optional: a vector of coefficient-specific penalties to use in plugin lasso.}

\item{colcheck}{Logical. If \code{TRUE}, checks for perfect multicollinearity in \code{x}.}

\item{K}{Maximum number of iterations.}

\item{verbose}{Logical. If \code{TRUE}, prints information to the screen while evaluating.}

\item{lambda}{Penalty parameter (a number).}

\item{phipost}{Logical. If \code{TRUE}, it carries out a post-lasso estimation with just the
selected variables and reports the coefficients from this regression.}
}
\value{
A list with 14 elements, including \code{beta}, which is the only one we use in the wrapper.
For a full list, see \link[glmnet]{glmnet}.
}
\description{
This is the internal function upon which the \code{iceberg} wrapper is built. It performs standard
plugin lasso PPML estimation without fixed effects, relying on \code{glmnet::glmnet}. As the other
internals in the package, it needs a y vector and an x matrix.
}
