#' Job retention data
#'
#' Fictional data on the retention of employees in various fields of employment over a 12 month period
#'
#' @format A dataframe with 3770 rows and 7 variables:
#' \describe{
#' \item{gender}{The gender of the individual studied}
#' \item{field}{The field of employment of the individual at the beginning of the study}
#' \item{level}{The level of the position of the individual in their organization at the beginning of the study - Low, Medium or High}
#' \item{sentiment}{The sentiment score reported by the individual on a scale of 1 to 10 at the beginning of the study, with 1 indicating extremely negative sentiment and 10 indicating extremely positive sentiment}
#' \item{intention}{A score of 1 to 10 reported by the individual at the beginning of the study regarding their intention to leave their job in the next 12 months, where 1 indicates an extremely low intention and 10 indicates an extremely high intention}
#' \item{left}{A binary variable indicating whether or not the individual had left their job as at the last follow-up}
#' \item{month}{The month of the last follow-up}
#' }
#' @examples
#' job_retention
"job_retention"
