% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plotRf}
\alias{plotRf}
\title{Plot recombination frequencies}
\usage{
plotRf(rf, plottype = "dendrogram", method = "single", cex.axis = 1, ...)
}
\arguments{
\item{rf}{Matrix of pairwise recombination frequencies.}

\item{plottype}{Default is "dendrogram". Any other value will plot the recombination frequencies.}

\item{method}{Default is "single", which is used for the hierarchical clustering.}

\item{cex.axis}{Size of axis labels in image plot.}

\item{...}{arguments are forwarded to \code{image}.}
}
\value{
None.
}
\description{
Graphical representation of recombination frequencies to support supervised estimation
of the numbers of clusters
}
\examples{
data(simTetra)
simTetraGen <- bases2genotypes(simTetra, 4)
rfMat <- calcRec(simTetraGen, 4)
plotRf(rfMat)
}

