% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/permChacko.R
\name{permChacko}
\alias{permChacko}
\title{The Chacko test for order-restriction with permutation test}
\usage{
permChacko(x, n_perm = 1000L, verbose = FALSE)
}
\arguments{
\item{x}{vector of numeric values}

\item{n_perm}{number of permutations to calculate the p-value numerically}

\item{verbose}{if \code{TRUE}, prints intermediate messages and output}
}
\value{
A named vector with the following elements:
\describe{
\item{chisq_bar}{the test statistic}
\item{analytic_p-value}{the p-value calculated analytically}
\item{numeric_p-value}{the p-value calculated numerically}
\item{tabular_p-value}{the tabular p-value from Chacko (1963)}
}
}
\description{
The Chacko test for order-restriction with permutation test
}
\examples{
ruxton22_12_07 <- c(6, 8, 4, 7, 3)
chacko66_3 <- c(10L, 16L, 14L, 12L, 18L)
chacko66_5 <- c(12L, 14L, 18L, 16L, 22L, 20L, 18L, 24L, 26L, 30L)

permChacko(ruxton22_12_07)
permChacko(chacko66_3)
permChacko(chacko66_5)
}
\references{
Chacko, V. J. (1963). Testing homogeneity against ordered alternatives. The
Annals of Mathematical Statistics, 945-956.

Chacko, V. J. (1966). Modified chi-square test for ordered alternatives.
Sankhyā: The Indian Journal of Statistics, Series B, 185-190.
}
